#                                               -*- Autoconf -*-
#
#  ot_check_libdl.m4
#
#  (C) Copyright 2005-2012 EDF-EADS-Phimeca
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2.1 of the License.
#
#  This library is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
#  @author: $LastChangedBy: schueller $
#  @date:   $LastChangedDate: 2009-01-14 17:17:38 +0100 (mer, 14 jan 2009) $
#  Id:      $Id: ot_check_libdl.m4 1067 2009-01-14 16:17:38Z souchaud $
#
#
#  This file is intended to be include in the configure.in file
#  of Open TURNS project to check whether the dynamic loader library is 
#  available on the platform.
#
# OT_CHECK_LIBDL
# ------------------------------
#
AC_DEFUN([OT_CHECK_LIBDL],
[
  AC_ARG_ENABLE([libdl], AC_HELP_STRING([--enable-libdl], [add runtime dynamic library support (default is enable).]), [], [enableval=yes])

  WITH_LIBDL=0

  if ! test x${enableval} = xno
  then
    AC_MSG_NOTICE([checking whether libdl is here])

    AC_CHECK_HEADERS([dlfcn.h], [HAVE_DLCFN=1])
    test x${HAVE_DLCFN} = x1 || AC_MSG_ERROR([libdl header file dlfcn.h has not been found])  

    AC_SEARCH_LIBS([dlopen], [dl], [HAVE_LIBDL=1])
    test x${HAVE_LIBDL} = x1 || AC_MSG_ERROR([libdl library has not been found])

    AC_MSG_NOTICE([libdl support is OK])
    WITH_LIBDL=1
    # Propagate test into source files
    AC_DEFINE_UNQUOTED(HAVE_LIBDL, 1, [Support for libdl library])
  else
    AC_MSG_NOTICE([Disable libdl support])
  fi

  # Propagate test into atlocal
  AC_SUBST(WITH_LIBDL)

  # Propagate test into Makefiles...
  AM_CONDITIONAL(WITH_LIBDL, test $WITH_LIBDL = 1)

])
