// SWIG file TestResult.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-11-09 17:38:15 +0100 (lun. 09 nov. 2009) $
// Id : $Id: TestResult.i 1403 2009-11-09 16:38:15Z dutka $

%{
#include "TestResult.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Base::Stat::TestResult>
  {
    typedef _PySequence_ Type;
  };

  template <>
  inline
  OpenTURNS::Base::Stat::TestResult
  convert<_PySequence_,OpenTURNS::Base::Stat::TestResult>(PyObject * pyObj)
  {
    check<_PySequence_>( pyObj );
    if (PySequence_Fast_GET_SIZE( pyObj ) != 4) 
      throw Base::Common::InvalidArgumentException(HERE) << "Sequence passed as argument is not convertible to a TestResult. Expected sequence (String, Bool, NumericalScalar, NumericalScalar)";

    PyObject * item_0 = PySequence_Fast_GET_ITEM( pyObj, 0 ); check<_PyString_>( item_0 );
    PyObject * item_1 = PySequence_Fast_GET_ITEM( pyObj, 1 ); check<_PyBool_>( item_1 );
    PyObject * item_2 = PySequence_Fast_GET_ITEM( pyObj, 2 ); check<_PyFloat_>( item_2 );
    PyObject * item_3 = PySequence_Fast_GET_ITEM( pyObj, 3 ); check<_PyFloat_>( item_3 );

    return OpenTURNS::Base::Stat::TestResult( convert<_PyString_,String>( item_0 ),
                                              convert<_PyBool_,Bool>( item_1 ),
                                              convert<_PyFloat_,NumericalScalar>( item_2 ),
                                              convert<_PyFloat_,NumericalScalar>( item_3 ) );
  }


} /* namespace OpenTURNS */

%}

%include TestResult.hxx
namespace OpenTURNS{ namespace Base { namespace Stat {

%extend TestResult {

TestResult(const TestResult & other) { return new OpenTURNS::Base::Stat::TestResult(other); }

TestResult(PyObject * pyObj)
{
 return new OpenTURNS::Base::Stat::TestResult( OpenTURNS::convert<OpenTURNS::_PySequence_,OpenTURNS::Base::Stat::TestResult>(pyObj) );
}

}
}}}
