// SWIG file OTexceptions.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-10-27 17:42:46 +0100 (mar. 27 oct. 2009) $
// Id : $Id: OTexceptions.i 1382 2009-10-27 16:42:46Z dutka $

%{
#include "Exception.hxx"
%}

namespace std {
  class exception
  {
  public:
    exception() throw() { }
    virtual ~exception() throw();
    /** Returns a C-style character string describing the general cause
     *  of the current error.  */
    virtual const char* what() const throw();
  };
}

%include exception.i

%exception {
  try {
    $action
  }
  catch (OT::Base::Common::InvalidArgumentException & ex) {
    SWIG_exception(SWIG_TypeError,ex.__repr__().c_str());
  }
  catch (OT::Base::Common::OutOfBoundException & ex) {
    SWIG_exception(SWIG_IndexError,ex.__repr__().c_str());
  }
  catch (OT::Base::Common::Exception & ex) {
    SWIG_exception(SWIG_RuntimeError,ex.__repr__().c_str());
  }
  catch (std::out_of_range & ex) {
    SWIG_exception(SWIG_IndexError,ex.what());
  }
  catch (std::exception & ex) {
    SWIG_exception(SWIG_RuntimeError,ex.what());
  }
}


%pythoncode %{
class TestFailed:
  """
  TestFailed is used to raise an uniform exception in tests
  """
  __type = "TestFailed"
  def __init__(self,reason=""):
    self.reason = reason
  def type(self):
    return TestFailed.__type
  def what(self):
    return self.reason
  def __str__(self):
    return TestFailed.__type + ": " + self.reason
  def __lshift__(self,ch):
    self.reason += ch
    return self
%}

