// SWIG file Drawable.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-11-09 17:38:15 +0100 (lun. 09 nov. 2009) $
// Id : $Id: Drawable.i 1403 2009-11-09 16:38:15Z dutka $

%{
#include "Drawable.hxx"

namespace OpenTURNS { 

  template <>
  struct traitsPythonType<OpenTURNS::Base::Graph::Drawable>
  {
    typedef _PyObject_ Type;
  };

  template <>
  inline
  OpenTURNS::Base::Graph::Drawable
  convert<_PyObject_,OpenTURNS::Base::Graph::Drawable>(PyObject * pyObj)
  {
    check<_PyObject_>( pyObj );
    void * ptr = 0;
    if (SWIG_IsOK(SWIG_ConvertPtr( pyObj, &ptr, SWIG_TypeQuery("OpenTURNS::Base::Graph::DrawableImplementation *"), 0 |  0 ))) {
      OpenTURNS::Base::Graph::DrawableImplementation * p_di = reinterpret_cast< OpenTURNS::Base::Graph::DrawableImplementation * >( ptr );
      return *p_di;

    }
  }


} /* namespace OpenTURNS */

%}

%template(DrawableImplementationTypedInterfaceObject)           OpenTURNS::Base::Common::TypedInterfaceObject<OpenTURNS::Base::Graph::DrawableImplementation>;
%include Drawable.hxx
namespace OpenTURNS{ namespace Base { namespace Graph {

%extend Drawable {

Drawable(const Drawable & other) { return new OpenTURNS::Base::Graph::Drawable(other); }

Drawable(PyObject * pyObj)
{
 return new OpenTURNS::Base::Graph::Drawable( OpenTURNS::convert<OpenTURNS::_PyObject_,OpenTURNS::Base::Graph::Drawable>(pyObj) );
}

}
}}}
