//                                               -*- C++ -*-
/**
 *  @file  DiscreteDistribution.hxx
 *  @brief Abstract top-level class for Discrete distributions
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: DiscreteDistribution.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_DISCRETEDISTRIBUTION_HXX
#define OPENTURNS_DISCRETEDISTRIBUTION_HXX

#include "OTprivate.hxx"
#include "UsualDistribution.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {


      /**
       * @class DiscreteDistribution
       *
       * A subclass for Discrete usual distributions.
       */
      class DiscreteDistribution 
	: public UsualDistribution
      {
	CLASSNAME;
      public:

	typedef UsualDistribution::InvalidArgumentException InvalidArgumentException;
	typedef UsualDistribution::NumericalPoint           NumericalPoint;
	typedef UsualDistribution::NumericalSample          xNumericalSample;

	// Tolerance relative to point support (i.e. to absorb round-off errors)
	static const NumericalScalar SupportEpsilon;
	/** Default constructor */
	explicit DiscreteDistribution(const String & name = OT::DefaultName);


	/** Virtual constructor */
	virtual DistributionImplementation * clone() const;

	/** Comparison operator */
	Bool operator ==(const DiscreteDistribution & other) const;

	/** String converter */
	String __repr__() const;

	/* Methods inherited from upper classes */

	/** Tell if the distribution is continuous */
	virtual Bool isContinuous() const;




      protected:
    
 
      private:

      }; /* class DiscreteDistribution */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_DISCRETEDISTRIBUTION_HXX */
