//                                               -*- C++ -*-
/**
 *  @file  OrthonormalizationAlgorithmImplementation.cxx
 *  @brief
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-09-14 14:39:35 +0200 (lun. 14 sept. 2009) $
 *  Id:      $Id: OrthonormalizationAlgorithmImplementation.cxx 1331 2009-09-14 12:39:35Z dutka $
 */
#include "OrthonormalizationAlgorithmImplementation.hxx"
#include "Uniform.hxx"
#include "Exception.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class OrthonormalizationAlgorithmImplementation
       */

      CLASSNAMEINIT(OrthonormalizationAlgorithmImplementation);

      typedef Base::Common::NotYetImplementedException NotYetImplementedException;
      typedef Uncertainty::Distribution::Uniform       Uniform;

      /* Default constructor */
      OrthonormalizationAlgorithmImplementation::OrthonormalizationAlgorithmImplementation()
        : Base::Common::PersistentObject(),
          measure_(Uniform())
      {
        // Nothing to do
      }

      /* Parameters constructor */
      OrthonormalizationAlgorithmImplementation::OrthonormalizationAlgorithmImplementation(const Distribution & measure)
        : Base::Common::PersistentObject(),
          measure_(measure)
      {
        // Nothing to do
      }

      /* Virtual constructor */
      OrthonormalizationAlgorithmImplementation * OrthonormalizationAlgorithmImplementation::clone() const
      {
        return new OrthonormalizationAlgorithmImplementation(*this);
      }

      /* Calculate the coefficients of recurrence a0, a1, a2 such that
         Pn(x) = (a0 * x + a1) * Pn-1(x) + a2 * Pn-2(x) */
      OrthonormalizationAlgorithmImplementation::Coefficients OrthonormalizationAlgorithmImplementation::getRecurrenceCoefficients(const UnsignedLong n) const
      {
        throw NotYetImplementedException(HERE);
      }


      /* Measure accessor */
      void OrthonormalizationAlgorithmImplementation::setMeasure(const Distribution & measure)
      {
        measure_ = measure;
      }

      OrthonormalizationAlgorithmImplementation::Distribution OrthonormalizationAlgorithmImplementation::getMeasure() const
      {
        return measure_;
      }

      /* String converter */
      String OrthonormalizationAlgorithmImplementation::__repr__() const
      {
        OSS oss;
        oss << "class=" << OrthonormalizationAlgorithmImplementation::GetClassName()
            << " measure=" << measure_;
        return oss;
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

