//                                               -*- C++ -*-
/**
 *  @file  MetaModelAlgorithm.hxx
 *  @brief Interface for regression methods
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2008-06-05 12:11:56 +0200 (Thu, 05 Jun 2008) $
 *  Id:      $Id: MetaModelAlgorithm.hxx 846 2008-06-05 10:11:56Z schueller $
 */
#ifndef OPENTURNS_METAMODELALGORITHM_HXX
#define OPENTURNS_METAMODELALGORITHM_HXX

#include "PersistentObject.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "NumericalMathFunction.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {

      /**
       * @class MetaModelAlgorithm
       *
       */

      class MetaModelAlgorithm
	: public Base::Common::PersistentObject
      {
	CLASSNAME;
      public:

	typedef Base::Type::NumericalPoint               NumericalPoint;
	typedef Base::Type::Matrix                       Matrix;
	typedef Base::Func::NumericalMathFunction        NumericalMathFunction;
	typedef Base::Stat::NumericalSample              NumericalSample;
	typedef Base::Common::InvalidArgumentException   InvalidArgumentException;
	typedef Base::Common::NotYetImplementedException NotYetImplementedException;

	/** Constructor with parameters */
	explicit MetaModelAlgorithm(const NumericalSample & dataIn,
				    const NumericalMathFunction & inputFunction,
				    const String & name = OT::DefaultName)
 	  /* throw(InvalidArgumentException) */;

	/** Constructor with parameters */
	explicit MetaModelAlgorithm(const NumericalSample & dataIn,
				    const NumericalSample & dataOut,
				    const String & name = OT::DefaultName)
	  /* throw(InvalidArgumentException) */;

	/** String converter */
	virtual String __repr__() const;

	/** Response surface computation */
	virtual void run();

	/** Input function accessor */
	NumericalMathFunction getInputFunction() const;

	/** Response surface accessor */
	NumericalMathFunction getResponseSurface() const;

	/** Data in accessor */
	NumericalSample getDataIn() const;

	/** Data out accessor */
	void setDataOut(const NumericalSample & dataOut)
	  /* throw(InvalidArgumentException) */;
	NumericalSample getDataOut();

      protected:

	NumericalSample dataIn_;
	NumericalSample dataOut_;
	NumericalMathFunction inputFunction_;
	NumericalMathFunction responseSurface_;

      private:

      }; /* class MetaModelAlgorithm */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_METAMODELALGORITHM_HXX */
