//                                               -*- C++ -*-
/**
 *  @file  SORM.cxx
 *  @brief SORM implements the Second Order Reliability Method
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: SORM.cxx 1473 2010-02-04 15:44:49Z dutka $
 */

#include "SORM.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      CLASSNAMEINIT(SORM);

      /*
       * @brief  Standard constructor: the class is defined by an optimisation algorithm, a failure event and a physical starting point
       */
      SORM::SORM(const NearestPointAlgorithm & nearestPointAlgorithm,
		 const Event & event,
		 const NumericalPoint & physicalStartingPoint):
	Analytical(nearestPointAlgorithm, event, physicalStartingPoint),
	result_()
      {
	// Nothing to do
      }

      /* Virtual constructor */
      SORM * SORM::clone() const
      {
	return new SORM(*this);
      }

      /* Result accessor */
      SORMResult SORM::getResult() const
      {
	return result_;
      }

      /* Result accessor */
      void SORM::setResult(const SORMResult & result)
      {
	result_ = result;
      }

      /* String converter */ 
      String SORM::__repr__() const
      {   
	OSS oss;
	oss << "class=" << SORM::GetClassName()
            << " " << Analytical::__repr__()
            << " result=" << result_;
	return oss;
      }

      /* Function that computes the design point by re-using the Analytical::run() and creates a SORMResult */
      void SORM::run()
      {
	Analytical::run();
	result_ = SORMResult(Analytical::getAnalyticalResult().getStandardSpaceDesignPoint(), Analytical::getAnalyticalResult().getLimitStateVariable(), Analytical::getAnalyticalResult().getIsStandardPointOriginInFailureSpace());
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

