//                                               -*- C++ -*-
/**
 *  @file  Description.cxx
 *  @brief Description is a collection of string for human usage
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: Description.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "Description.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Type
    {

      CLASSNAMEINIT(Description);

      /* Default constructor */
      Description::Description()
	: Common::TypedCollectionInterfaceObject<DescriptionImplementation>(new DescriptionImplementation)
      {
	// Nothing to do
      }


      /* Constructor with size */
      Description::Description(const UnsignedLong size)
	: Common::TypedCollectionInterfaceObject<DescriptionImplementation>(new DescriptionImplementation(size))
      {
	// Nothing to do
      }


      /* Constructor with value */
      Description::Description(const String & value)
	: Common::TypedCollectionInterfaceObject<DescriptionImplementation>(new DescriptionImplementation(value))
      {
	// Nothing to do
      }


      /* Constructor with size and default value */
      Description::Description(const UnsignedLong size,
			       const String & value)
	: Common::TypedCollectionInterfaceObject<DescriptionImplementation>(new DescriptionImplementation(size, value))
      {
	// Nothing to do
      }


      /* Constructor from implementation */
      Description::Description(const DescriptionImplementation & implementation)
	: Common::TypedCollectionInterfaceObject<DescriptionImplementation>(implementation.clone())
      {
	// Nothing to do
      }


      void Description::sort()
      {
        copyOnWrite();
        std::sort(begin(),end());
      }

    } /* namespace Type */
  } /* namespace Base */
} /* namespace OpenTURNS */



