//                                               -*- C++ -*-
/**
 *  @file  OTthread.hxx
 *  @brief The header file that declares thread operators
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-01-16 13:58:07 +0100 (Fri, 16 Jan 2009) $
 *  Id:      $Id: OTtypes.hxx 1068 2009-01-16 12:58:07Z dutka $
 */
#ifndef OPENTURNS_OTTHREAD_HXX
#define OPENTURNS_OTTHREAD_HXX

#include "OTconfig.hxx"

#if HAVE_PTHREAD_H

#include <pthread.h>

// MinGW pthread.h includes windows.h which defines a HUGE number of macros...
#ifdef WIN32
#undef GetClassName
#undef ERROR
#undef IN
#undef OUT
#endif

#endif

#endif /* OPENTURNS_OTTHREAD_HXX */
