//                                               -*- C -*-
/**
 *  @file  OTdebug.h
 *  @brief The header file of Open TURNS for debug level
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: OTdebug.h 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_OTDEBUG_H
#define OPENTURNS_OTDEBUG_H

#ifdef __GNUC__
#define GCC_VERSION (__GNUC__ * 10000		      \
		     + __GNUC_MINOR__ * 100	      \
		     + __GNUC_PATCHLEVEL__)

#if GCC_VERSION <= 30406 /* GCC 3.4.6 and below */
#define REINTERPRET_CAST(T,V) ( (T) (V) )
#else /* GCC after 3.4.6 */
#define REINTERPRET_CAST(T,V) ( reinterpret_cast< T > (V) )
#endif

#define DEPRECATED  __attribute__ ((deprecated))
#define UNUSED      __attribute__ ((unused))

#else
#define GCC_VERSION 0
#define DEPRECATED
#define UNUSED

#endif

#endif /* OPENTURNS_OTDEBUG_H */
