#! /usr/bin/env python
# -*- coding: utf-8 -*-

#   OpenTeacher
#   depends on: python-qt4
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.

from PyQt4 import QtCore

class OpenTeacherError(Exception):
	@property
	def message(self):
		return unicode(self.args[1])

	@property
	def errorNumber(self):
		return int(self.args[0])

	def __str__(self):
		return self.__unicode__().encode("UTF-8")

	def __unicode__(self):
		return unicode(QtCore.QCoreApplication.translate("OpenTeacherError", "Error") + " " + unicode(self.errorNumber) + ": " + unicode(self.message))

class WrtsLoginError(OpenTeacherError):
	def __init__(self):
		OpenTeacherError.__init__(self, 8, QtCore.QCoreApplication.translate("WrtsLoginError", "WRTS didn't accept the login credentials. Are you sure you entered your e-mail and password correctly?"))

class AbortedByUserError(OpenTeacherError):
	def __init__(self):
		OpenTeacherError.__init__(self, 10, QtCore.QCoreApplication.translate("AbortedByUserError", "The user aborted the current action."))

class UnsupportedFileImportError(OpenTeacherError):
	def __init__(self):
		OpenTeacherError.__init__(self, 5, QtCore.QCoreApplication.translate("UnsupportedFileImportError", "File couldn't be opened. Unsupported extension."))

class OpenError(OpenTeacherError):
	def __init__(self):
		OpenTeacherError.__init__(self, 3, QtCore.QCoreApplication.translate("OpenError", "Could not open file. Please check that you have permission to read this file."))

class ContentError(OpenTeacherError):
	def __init__(self):
		OpenTeacherError.__init__(self, 3, QtCore.QCoreApplication.translate("ContentError", "Could not open file because its contents are invalid, or written in a way not supported by OpenTeacher."))

class InputEmptyError(OpenTeacherError):
	def __init__(self):
		OpenTeacherError.__init__(self, 1, QtCore.QCoreApplication.translate("InputEmptyError", "There seems to be no content in the input area"))

class InputFormatError(OpenTeacherError):
	def __init__(self):
		OpenTeacherError.__init__(self, 1, QtCore.QCoreApplication.translate("InputFormatError", "There seems to be something wrong with the default input formatting (question = answer)"))

class UnsupportedFileExportError(OpenTeacherError):
	def __init__(self):
		OpenTeacherError.__init__(self, 3, QtCore.QCoreApplication.translate("UnsupportedFileExportError", "Could not save file. Please specify a valid file extension."))

class SaveError(OpenTeacherError):
	def __init__(self):
		OpenTeacherError.__init__(self, 3, QtCore.QCoreApplication.translate("SaveError", "Could not save file. Please check that the filename is correct and that you have permission to write to the save location."))

class NotEnoughMetadataError(OpenTeacherError):
	def __init__(self):
		OpenTeacherError.__init__(self, 9, QtCore.QCoreApplication.translate("NotEnoughMetadataError", "Please fill in the wordlist title, question language and answer language first. Then try again."))

class NoEqualsSignInInputError(OpenTeacherError):
	def __init__(self):
		OpenTeacherError.__init__(self, 1, QtCore.QCoreApplication.translate("NoEqualsSignInInputError", "One or more lines could not be added (did they contain a = character?)"))

class WrtsConnectionError(OpenTeacherError):
	def __init__(self):
		OpenTeacherError.__init__(self, 8, QtCore.QCoreApplication.translate("WrtsConnectionError", "WRTS didn't accept the connection. Are you sure that your internet connection works and WRTS is online?"))

class NoWordsLeftError(OpenTeacherError):
	def __init__(self):
		OpenTeacherError.__init__(self, 2, QtCore.QCoreApplication.translate("NoWordsLeftError", "After filtering the wordlist, no words where left. Adjust the filter."))

class NoWordsEnteredError(OpenTeacherError):
	def __init__(self):
		OpenTeacherError.__init__(self, 2, QtCore.QCoreApplication.translate("NoWordsEnteredError", "You didn't enter any words! Enter them and try again."))
