#! /usr/bin/python

import re, sys, fileinput

skip_packages = ('openoffice.org-core', 'openoffice.org-report-builder-bin', 'openoffice.org-base-core', 'openoffice.org-dev', 'openoffice.org-dev-doc', 'openoffice.org-dbg', 'openoffice.org-help-sk', 'openoffice.org-nlpsolver', 'openoffice.org-hyphenation-show', 'openoffice.org-script-provider-bsh', 'openoffice.org-hyphenation-bn','openoffice.org-hyphenation-gu', 'openoffice.org-hyphenation-kn', 'openoffice.org-hyphenation-hi', 'openoffice.org-hyphenation-pa', 'openoffice.org-l10n-is','mozilla-openoffice.org')
other_source_packages = ('docvert-openoffice.org', 'openclipart-openoffice.org','openoffice.org-dmaths','openoffice.org-mysql-connector','openoffice.org-pdfimport','openoffice.org-presentation-minimizer','openoffice.org-report-builder', 'openoffice.org-voikko','openoffice.org-writer2latex','openoffice.org-wiki-publisher','openoffice.org-zemberek', 'openoffice.org-presenter-console', 'openoffice.org-writer2xhtml', 'openoffice.org-sdbc-postgresql');

def gen_transitonal_packages():
    skip = True
    copy_fields = ('Section', 'Architecture', 'Priority', 'Description')
    copy_fields = ('Section', 'Priority', 'Description')
    pkgs = {}
    for line in fileinput.input():
        if line == '\n':
            skip = True
        if ':' in line:
            f, v = line.split(':', 1)
            v = v.strip()
            if f == 'Package':
                if v.startswith('libreoffice-') or v.endswith('-libreoffice'):
                    n = v.replace('libreoffice', 'openoffice.org')
                    p =  {'Depends': v}
                    pkgs[n] = p
                    skip = False
                elif v.startswith('mythes-'):
                    n = v.replace('mythes', 'openoffice.org-thesaurus')
                    p =  {'Depends': v}
                    pkgs[n] = p
                    skip = False
                elif v.startswith('hyphen-'):
                    n = v.replace('hyphen', 'openoffice.org-hyphenation')
                    p =  {'Depends': v}
                    pkgs[n] = p
                    skip = False
                else:
                    skip = True
            if not skip and f in copy_fields:
                p[f] = v
                
    for p, attrs in pkgs.iteritems():
        if p in skip_packages:
            continue
        if p.endswith('l10n-nso'):
            p = p.replace('nso', 'ns')
	elif p.endswith('l10n-be'):
            p = p.replace('be', 'be-by')
        print "Package: %s" % p
	if p.endswith('gcj'):
	    print "Architecture: kfreebsd-i386 kfreebsd-amd64"
        else:
            print "Architecture: all"
        for f, v in attrs.items():
            if f in ('Depends', 'Description'):
                continue
	    if f in ('Priority'):
		v = v.replace('optional', 'extra');
            print "%s: %s" % (f, v)
        if not p in other_source_packages and not p.startswith('openoffice.org-thesaurus') and not p.startswith('openoffice.org-hyphenation'):
	     print "Depends: %s (>= 1:3.4.0~)" % attrs['Depends']
	else:
             print "Depends: %s" % attrs['Depends']
        print "Description: %s" % attrs['Description']
        print " This is a transitional package, replacing the OpenOffice.org packaging"
        print " with the LibreOffice packaging."
        print " ."
        print " It can be safely removed after an upgrade."
        print

def main():
    gen_transitonal_packages()

main()
