
#define VIRTUAL

// File		Graphic3d_GraphicDriver_8.cxx
// Created	Mardi 28 janvier 1997
// Author	CAL
// modified:    1/07/97 ; PCT : ajout texture mapping
//		16-09-98 ; BGN : Points d'entree du Triedre (S3819, Phase 1)
//		22-09-98 ; BGN : S3989 (anciennement S3819)
//                               TypeOfTriedron* from Aspect (pas Graphic3d)
//      02.15.100 : JR : Clutter

//-Copyright	MatraDatavision 1997

//-Version	

//-Design	Declaration des variables specifiques aux Drivers

//-Warning	Un driver encapsule les Pex et OpenGl drivers

//-References	

//-Language	C++ 2.0

//-Declarations


//SAV 23/12/02 : Added methods to set background image.

// for the class
#include <Graphic3d_GraphicDriver.jxx>

#include <Aspect_DriverDefinitionError.hxx>

extern "C" {
#include <InterfaceGraphic_Cextern.hxx>
}

#include <stdlib.h>

//-Aliases

//-Global data definitions

//-Methods, in order



#ifdef VIRTUAL
Standard_Integer Graphic3d_GraphicDriver::CreateTexture(const Graphic3d_TypeOfTexture ,const Handle_AlienImage_AlienImage &,const Standard_CString,const Handle(TColStd_HArray1OfReal)& TexUpperBounds ) const
{
	return -1;
#else
Standard_Integer Graphic3d_GraphicDriver::CreateTexture(const Graphic3d_TypeOfTexture Type,const Handle_AlienImage_AlienImage &Image,const Standard_CString FileName,const Handle(TColStd_HArray1OfReal)& TexUpperBounds) const
{
  // transmutation de l'image en un bon tableau RGBA pour la toolkit des textures
  // lamentable d'un point de vue vitesse...
  Handle(Image_Image) MyPic = Image->ToImage();

  unsigned char *MyImageData = (unsigned char *)malloc(MyPic->Width()*MyPic->Height()*4);
  unsigned char *MyData = MyImageData;
  int TexId;
  int i,j;
  Quantity_Color MyColor;

  if (MyImageData == NULL)
    return -1;

  for (j=MyPic->Height()-1; j>=0; j--)
    for (i=0; i<MyPic->Width(); i++)
      {
	MyColor = MyPic->PixelColor(i,j);
	*MyData++ = (int)(255*MyColor.Red());
	*MyData++ = (int)(255*MyColor.Green());
	*MyData++ = (int)(255*MyColor.Blue());
	*MyData++ = 0xFF;
      }



  switch (Type)
    {
    case Graphic3d_TOT_1D:
      TexId = call_togl_create_texture(0, MyPic->Width(), MyPic->Height(), MyImageData, FileName);
      break;

    case Graphic3d_TOT_2D:
      TexId = call_togl_create_texture(1, MyPic->Width(), MyPic->Height(), MyImageData, FileName);
      break;

    case Graphic3d_TOT_2D_MIPMAP:
      TexId = call_togl_create_texture(2, MyPic->Width(), MyPic->Height(), MyImageData, FileName);
      break;

    default:
      TexId = -1;
    }

  free(MyImageData);
  return TexId;

#endif
}



#ifdef VIRTUAL
void Graphic3d_GraphicDriver::DestroyTexture(const Standard_Integer ) const
{
#else
void Graphic3d_GraphicDriver::DestroyTexture(const Standard_Integer TexId) const
{
  call_togl_destroy_texture(TexId);
#endif
}


#ifdef VIRTUAL
void Graphic3d_GraphicDriver::ModifyTexture(const Standard_Integer ,const Graphic3d_CInitTexture& ) const
{
#else
void Graphic3d_GraphicDriver::ModifyTexture(const Standard_Integer TexId,const Graphic3d_CInitTexture& AValue) const
{
  call_togl_modify_texture(TexId, AValue);
#endif
}




#ifdef VIRTUAL
void Graphic3d_GraphicDriver::Environment(const Graphic3d_CView& )
{
#else
void Graphic3d_GraphicDriver::Environment(const Graphic3d_CView& ACView)
{
  call_togl_environment(ACView);
#endif
}


//
// Triedron methods : the Triedron is a non-zoomable object.
//

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::ZBufferTriedronSetup (
				    const Quantity_NameOfColor,
				    const Quantity_NameOfColor,
				    const Quantity_NameOfColor,
				    const Standard_Real,
				    const Standard_Real,
				    const Standard_Integer)
{
#else
void Graphic3d_GraphicDriver::ZBufferTriedronSetup (
				    const Quantity_NameOfColor XColor,
				    const Quantity_NameOfColor YColor,
				    const Quantity_NameOfColor ZColor,
				    const Standard_Real        SizeRatio,
				    const Standard_Real        AxisDiametr,
				    const Standard_Integer     NbFacettes)
{
  float Xrgb[3];
  float Yrgb[3];
  float Zrgb[3];
  Quantity_Color ColorX(XColor);
  Quantity_Color ColorY(XColor);
  Quantity_Color ColorZ(XColor);
  ColorX.Values(Xrgb[0], Xrgb[1], Xrgb[2],Quantity_TOC_RGB);
  ColorY.Values(Yrgb[0], Yrgb[1], Yrgb[2],Quantity_TOC_RGB);
  ColorZ.Values(Zrgb[0], Zrgb[1], Zrgb[2],Quantity_TOC_RGB);

  call_togl_ztriedron_setup(Xrgb, Yrgb, Zrgb, SizeRatio, AxisDiametr, NbFacettes);
#endif
}


#ifdef VIRTUAL
void Graphic3d_GraphicDriver::TriedronDisplay (
	const Graphic3d_CView& ,
	const Aspect_TypeOfTriedronPosition ,
 	const Quantity_NameOfColor , 
	const Standard_Real,
	const Standard_Boolean   )
{
#else
void Graphic3d_GraphicDriver::TriedronDisplay (
	const Graphic3d_CView& ACView,
	const Aspect_TypeOfTriedronPosition APosition,
 	const Quantity_NameOfColor AColor, 
	const Standard_Real AScale,
	const Standard_Boolean AsWireframe )
{
  float r,g,b;
  Quantity_Color Color(AColor);
  Color.Values(r,g,b,Quantity_TOC_RGB);

  call_togl_triedron_display(ACView,(int)APosition, r,g,b, (float)AScale, AsWireframe);
#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::TriedronErase (const Graphic3d_CView& ) 
{
#else
void Graphic3d_GraphicDriver::TriedronErase (const Graphic3d_CView& ACView) 
{
  call_togl_triedron_erase(ACView);
#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::TriedronEcho (const Graphic3d_CView& ,const Aspect_TypeOfTriedronEcho  )
{
#else
void Graphic3d_GraphicDriver::TriedronEcho (const Graphic3d_CView& ACView,const Aspect_TypeOfTriedronEcho AType )
{
  call_togl_triedron_echo( ACView,AType );
#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::BackgroundImage( const Standard_CString /*FileName*/, 
                                               const Graphic3d_CView& /*ACView*/,
                                               const Aspect_FillMethod /*FillStyle*/)
{
#else
void Graphic3d_GraphicDriver::BackgroundImage( const Standard_CString /*FileName*/,
                                               const Graphic3d_CView& /*ACView*/,
                                               const Aspect_FillMethod /*FillStyle*/)
{
#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::SetBgImageStyle( const Graphic3d_CView& /*ACView*/,
                                               const Aspect_FillMethod /*FillStyle*/)
{
#else
void Graphic3d_GraphicDriver::SetBgImageStyle( const Graphic3d_CView& /*ACView*/,
                                               const Aspect_FillMethod /*FillStyle*/)
{
#endif
}


