// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Voxel_DS_HeaderFile
#define _Voxel_DS_HeaderFile

#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! A base class for all voxel data structures. <br>
class Voxel_DS  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! An empty constructor. <br>
Standard_EXPORT Voxel_DS();

//! A constructor initializing the voxel model. <br>
//!          (x, y, z) - the start point of the box. <br>
//!          (x_len, y_len, z_len) - lengths in x, y and z directions along axes of a co-ordinate system. <br>
//!          (nb_x, nb_y, nb_z) - number of splits (voxels) along x, y and z directions. <br>
Standard_EXPORT Voxel_DS(const Standard_Real x,const Standard_Real y,const Standard_Real z,const Standard_Real x_len,const Standard_Real y_len,const Standard_Real z_len,const Standard_Integer nb_x,const Standard_Integer nb_y,const Standard_Integer nb_z);

//! Initialization of the voxel model. <br>
//!          (x, y, z) - the start point of the box. <br>
//!          (x_len, y_len, z_len) - lengths in x, y and z directions along axes of a co-ordinate system. <br>
//!          (nb_x, nb_y, nb_z) - number of splits (voxels) along x, y and z directions. <br>//! The methods below return initial data of the voxel model. <br>
Standard_EXPORT virtual  void Init(const Standard_Real x,const Standard_Real y,const Standard_Real z,const Standard_Real x_len,const Standard_Real y_len,const Standard_Real z_len,const Standard_Integer nb_x,const Standard_Integer nb_y,const Standard_Integer nb_z) ;


Standard_EXPORT   Standard_Real GetX() const;


Standard_EXPORT   Standard_Real GetY() const;


Standard_EXPORT   Standard_Real GetZ() const;


Standard_EXPORT   Standard_Real GetXLen() const;


Standard_EXPORT   Standard_Real GetYLen() const;


Standard_EXPORT   Standard_Real GetZLen() const;


Standard_EXPORT   Standard_Integer GetNbX() const;


Standard_EXPORT   Standard_Integer GetNbY() const;


Standard_EXPORT   Standard_Integer GetNbZ() const;

//! Returns the center point of a voxel with co-ordinates (ix, iy, iz). <br>
Standard_EXPORT   void GetCenter(const Standard_Integer ix,const Standard_Integer iy,const Standard_Integer iz,Standard_Real& xc,Standard_Real& yc,Standard_Real& zc) const;

//! Finds a voxel corresponding to a 3D point. <br>
//!          Returns true if it is found. <br>
Standard_EXPORT   Standard_Boolean GetVoxel(const Standard_Real x,const Standard_Real y,const Standard_Real z,Standard_Integer& ix,Standard_Integer& iy,Standard_Integer& iz) const;

//! Returns x-index of a voxel corresponding to x-coordinate. <br>
Standard_EXPORT   Standard_Boolean GetVoxelX(const Standard_Real x,Standard_Integer& ix) const;

//! Returns y-index of a voxel corresponding to y-coordinate. <br>
Standard_EXPORT   Standard_Boolean GetVoxelY(const Standard_Real y,Standard_Integer& iy) const;

//! Returns z-index of a voxel corresponding to z-coordinate. <br>
Standard_EXPORT   Standard_Boolean GetVoxelZ(const Standard_Real z,Standard_Integer& iz) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Standard_Address myData;
Standard_Real myX;
Standard_Real myY;
Standard_Real myZ;
Standard_Real myXLen;
Standard_Real myYLen;
Standard_Real myZLen;
Standard_Integer myNbX;
Standard_Integer myNbY;
Standard_Integer myNbZ;
Standard_Integer myNbXY;
Standard_Real myDX;
Standard_Real myDY;
Standard_Real myDZ;
Standard_Real myHalfDX;
Standard_Real myHalfDY;
Standard_Real myHalfDZ;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
