// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESData_SpecificModule_HeaderFile
#define _IGESData_SpecificModule_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESData_SpecificModule_HeaderFile
#include <Handle_IGESData_SpecificModule.hxx>
#endif

#ifndef _Standard_Transient_HeaderFile
#include <Standard_Transient.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_IGESData_IGESEntity_HeaderFile
#include <Handle_IGESData_IGESEntity.hxx>
#endif
#ifndef _Handle_Message_Messenger_HeaderFile
#include <Handle_Message_Messenger.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class IGESData_IGESEntity;
class IGESData_IGESDumper;
class Message_Messenger;


//! This class defines some Services which are specifically <br>
//!           attached to IGES Entities : Dump <br>
class IGESData_SpecificModule : public Standard_Transient {

public:
 // Methods PUBLIC
 // 

//! Specific Dump for each type of IGES Entity : it concerns only <br>
//!           own parameters, the general data (Directory Part, Lists) are <br>
//!           taken into account by the IGESDumper <br>
//!           See class IGESDumper for the rules to follow for <own> and <br>
//!           <attached> level <br>
Standard_EXPORT virtual  void OwnDump(const Standard_Integer CN,const Handle(IGESData_IGESEntity)& ent,const IGESData_IGESDumper& dumper,const Handle(Message_Messenger)& S,const Standard_Integer own) const = 0;

//! Specific Automatic Correction on own Parameters of an Entity. <br>
//!           It works by setting in accordance redundant data, if there are <br>
//!           when there is no ambiguity (else, it does nothing). <br>
//!           Remark that classic Corrections on Directory Entry (to set <br>
//!           void data) are taken into account alsewhere. <br>
//! <br>
//!           For instance, many "Associativity Entities" have a Number of <br>
//!           Properties which must have a fixed value. <br>
//!           Or, a ConicalArc has its Form Number which records the kind of <br>
//!           Conic, also determined from its coefficients <br>
//!           But, a CircularArc of which Distances (Center-Start) and <br>
//!           (Center-End) are not equal cannot be corrected ... <br>
//! <br>
//!           Returns True if something has been corrected in <ent> <br>
//!           By default, does nothing. If at least one of the Types <br>
//!           processed by a sub-class of SpecificModule has a Correct <br>
//!           procedure attached, this method can be redefined <br>
Standard_EXPORT virtual  Standard_Boolean OwnCorrect(const Standard_Integer CN,const Handle(IGESData_IGESEntity)& ent) const;
//Standard_EXPORT ~IGESData_SpecificModule();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
