// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GC_MakeArcOfCircle_HeaderFile
#define _GC_MakeArcOfCircle_HeaderFile

#ifndef _Handle_Geom_TrimmedCurve_HeaderFile
#include <Handle_Geom_TrimmedCurve.hxx>
#endif
#ifndef _GC_Root_HeaderFile
#include <GC_Root.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Geom_TrimmedCurve;
class StdFail_NotDone;
class gp_Circ;
class gp_Pnt;
class gp_Vec;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Implements construction algorithms for an <br>
//! arc of circle in 3D space. The result is a Geom_TrimmedCurve curve. <br>
//! A MakeArcOfCircle object provides a framework for: <br>
//! -   defining the construction of the arc of circle, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the results. In particular, the <br>
//!   Value function returns the constructed arc of circle. <br>
class GC_MakeArcOfCircle  : public GC_Root {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Make an arc of circle (TrimmedCurve from Geom) from <br>
//!          a circle between two angles Alpha1 and Alpha2 <br>
//!          given in radiians. <br>
Standard_EXPORT GC_MakeArcOfCircle(const gp_Circ& Circ,const Standard_Real Alpha1,const Standard_Real Alpha2,const Standard_Boolean Sense);

//! Make an arc of circle (TrimmedCurve from Geom) from <br>
//!          a circle between point <P> and the angle Alpha <br>
//!          given in radians. <br>
Standard_EXPORT GC_MakeArcOfCircle(const gp_Circ& Circ,const gp_Pnt& P,const Standard_Real Alpha,const Standard_Boolean Sense);

//! Make an arc of circle (TrimmedCurve from Geom) from <br>
//!          a circle between two points P1 and P2. <br>
Standard_EXPORT GC_MakeArcOfCircle(const gp_Circ& Circ,const gp_Pnt& P1,const gp_Pnt& P2,const Standard_Boolean Sense);

//! Make an arc of circle (TrimmedCurve from Geom) from <br>
//!          three points P1,P2,P3 between two points P1 and P2. <br>
Standard_EXPORT GC_MakeArcOfCircle(const gp_Pnt& P1,const gp_Pnt& P2,const gp_Pnt& P3);

//! Make an arc of circle (TrimmedCurve from Geom) from <br>
//!          two points P1,P2 and the tangente to the solution at <br>
//!          the point P1. <br>
//! The orientation of the arc is: <br>
//! -   the sense determined by the order of the points P1, P3 and P2; <br>
//! -   the sense defined by the vector V; or <br>
//! -   for other syntaxes: <br>
//!   -   the sense of Circ if Sense is true, or <br>
//!   -   the opposite sense if Sense is false. <br>
//! Note: Alpha1, Alpha2 and Alpha are angle values, given in radians. <br>
//! Warning <br>
//! If an error occurs (that is, when IsDone returns <br>
//! false), the Status function returns: <br>
//! -   gce_ConfusedPoints if: <br>
//!   -   any 2 of the 3 points P1, P2 and P3 are coincident, or <br>
//!   -   P1 and P2 are coincident; or <br>
//! -   gce_IntersectionError if: <br>
//!   -   P1, P2 and P3 are collinear and not coincident, or <br>
//!   -   the vector defined by the points P1 and <br>
//!    P2 is collinear with the vector V. <br>
Standard_EXPORT GC_MakeArcOfCircle(const gp_Pnt& P1,const gp_Vec& V,const gp_Pnt& P2);

//! Returns the constructed arc of circle. <br>
//! Exceptions StdFail_NotDone if no arc of circle is constructed. <br>
Standard_EXPORT  const Handle_Geom_TrimmedCurve& Value() const;


Standard_EXPORT  const Handle_Geom_TrimmedCurve& Operator() const;
Standard_EXPORT operator Handle_Geom_TrimmedCurve() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Geom_TrimmedCurve TheArc;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
