// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Convert_CompBezierCurves2dToBSplineCurve2d_HeaderFile
#define _Convert_CompBezierCurves2dToBSplineCurve2d_HeaderFile

#ifndef _Convert_SequenceOfArray1OfPoles2d_HeaderFile
#include <Convert_SequenceOfArray1OfPoles2d.hxx>
#endif
#ifndef _TColgp_SequenceOfPnt2d_HeaderFile
#include <TColgp_SequenceOfPnt2d.hxx>
#endif
#ifndef _TColStd_SequenceOfReal_HeaderFile
#include <TColStd_SequenceOfReal.hxx>
#endif
#ifndef _TColStd_SequenceOfInteger_HeaderFile
#include <TColStd_SequenceOfInteger.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_ConstructionError;
class TColgp_Array1OfPnt2d;
class TColStd_Array1OfReal;
class TColStd_Array1OfInteger;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Converts a list  of connecting Bezier Curves 2d to  a <br>
//!          BSplineCurve 2d. <br>
//!          if possible, the continuity of the BSpline will be <br>
//!          increased to more than C0. <br>
class Convert_CompBezierCurves2dToBSplineCurve2d  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs a framework for converting a sequence of <br>
//! adjacent non-rational Bezier curves into a BSpline curve. <br>
//! Knots will be created on the computed BSpline curve at <br>
//! each junction point of two consecutive Bezier curves. The <br>
//! degree of continuity of the BSpline curve will be increased at <br>
//! the junction point of two consecutive Bezier curves if their <br>
//! tangent vectors at this point are parallel. AngularTolerance <br>
//! (given in radians, and defaulted to 1.0 e-4) will be used <br>
//! to check the parallelism of the two tangent vectors. <br>
//! Use the following functions: <br>
//! -   AddCurve to define in sequence the adjacent Bezier <br>
//!  curves to be converted, <br>
//! -   Perform to compute the data needed to build the BSpline curve, <br>
//! -   and the available consultation functions to access the <br>
//!  computed data. This data may be used to construct the BSpline curve. <br>
Standard_EXPORT Convert_CompBezierCurves2dToBSplineCurve2d(const Standard_Real AngularTolerance = 1.0e-4);

//! Adds the Bezier curve defined by the table of poles Poles, to <br>
//!  the sequence (still contained in this framework) of adjacent <br>
//! Bezier curves to be converted into a BSpline curve. <br>
//! Only polynomial (i.e. non-rational) Bezier curves are <br>
//! converted using this framework. <br>
//! If this is not the first call to the function (i.e. if this framework <br>
//! still contains data in its sequence of Bezier curves), the <br>
//! degree of continuity of the BSpline curve will be increased at <br>
//! the time of computation at the first point of the added Bezier <br>
//! curve (i.e. the first point of the Poles table). This will be the <br>
//! case if the tangent vector of the curve at this point is <br>
//! parallel to the tangent vector at the end point of the <br>
//! preceding Bezier curve in the sequence of Bezier curves still <br>
//! contained in this framework. An angular tolerance given at <br>
//! the time of construction of this framework, will be used to <br>
//! check the parallelism of the two tangent vectors. This <br>
//! checking procedure, and all the relative computations will be <br>
//! performed by the function Perform. <br>
//! When the sequence of adjacent Bezier curves is complete, <br>
//! use the following functions: <br>
//! -   Perform to compute the data needed to build the BSpline curve, <br>
//! -   and the available consultation functions to access the <br>
//!  computed data. This data may be used to construct the BSpline curve. <br>
//!  Warning <br>
//! The sequence of Bezier curves treated by this framework is <br>
//! automatically initialized with the first Bezier curve when the <br>
//! function is first called. During subsequent use of this function, <br>
//! ensure that the first point of the added Bezier curve (i.e. the <br>
//! first point of the Poles table) is coincident with the last point <br>
//! of the sequence (i.e. the last point of the preceding Bezier <br>
//! curve in the sequence) of Bezier curves still contained in <br>
//! this framework. An error may occur at the time of <br>
//! computation if this condition is not satisfied. Particular care <br>
//! must be taken with respect to the above, as this condition is <br>
//! not checked either when defining the sequence of Bezier <br>
//! curves or at the time of computation. <br>
Standard_EXPORT   void AddCurve(const TColgp_Array1OfPnt2d& Poles) ;

//! Computes all the data needed to build a BSpline curve <br>
//! equivalent to the sequence of adjacent Bezier curves still <br>
//! contained in this framework. <br>
//! A knot is inserted on the computed BSpline curve at the <br>
//! junction point of two consecutive Bezier curves. The <br>
//! degree of continuity of the BSpline curve will be increased <br>
//! at the junction point of two consecutive Bezier curves if <br>
//! their tangent vectors at this point are parallel. An angular <br>
//! tolerance given at the time of construction of this <br>
//! framework is used to check the parallelism of the two <br>
//! tangent vectors. <br>
//! Use the available consultation functions to access the <br>
//! computed data. This data may then be used to construct <br>
//! the BSpline curve. <br>
//! Warning <br>
//! Ensure that the curves in the sequence of Bezier curves <br>
//! contained in this framework are adjacent. An error may <br>
//! occur at the time of computation if this condition is not <br>
//! satisfied. Particular care must be taken with respect to the <br>
//! above as this condition is not checked, either when <br>
//! defining the Bezier curve sequence or at the time of computation. <br>
Standard_EXPORT   void Perform() ;

//! Returns the degree of the BSpline curve whose data is <br>
//! computed in this framework. <br>
//! Warning <br>
//! Take particular care not to use this function before the <br>
//! computation is performed (Perform function), as this <br>
//! condition is not checked and an error may therefore occur. <br>
Standard_EXPORT   Standard_Integer Degree() const;

//! Returns the number of poles of the BSpline curve whose <br>
//! data is computed in this framework. <br>
//! Warning <br>
//! Take particular care not to use this function before the <br>
//! computation is performed (Perform function), as this <br>
//! condition is not checked and an error may therefore occur. <br>
Standard_EXPORT   Standard_Integer NbPoles() const;

//! Loads the Poles table with the poles of the BSpline curve <br>
//! whose data is computed in this framework. <br>
//! Warning <br>
//! -   Do not use this function before the computation is <br>
//!  performed (Perform function). <br>
//! -   The length of the Poles array must be equal to the <br>
//!  number of poles of the BSpline curve whose data is <br>
//!  computed in this framework. <br>
//! Particular care must be taken with respect to the above, as <br>
//! these conditions are not checked, and an error may occur. <br>
Standard_EXPORT   void Poles(TColgp_Array1OfPnt2d& Poles) const;

//! Returns the number of knots of the BSpline curve whose <br>
//! data is computed in this framework. <br>
//! Warning <br>
//! Take particular care not to use this function before the <br>
//! computation is performed (Perform function), as this <br>
//! condition is not checked and an error may therefore occur. <br>
Standard_EXPORT   Standard_Integer NbKnots() const;

//! Loads the Knots table with the knots <br>
//! and the Mults table with the corresponding multiplicities <br>
//! of the BSpline curve whose data is computed in this framework. <br>
//! Warning <br>
//! -   Do not use this function before the computation is <br>
//!  performed (Perform function). <br>
//! -   The length of the Knots and Mults arrays must be equal <br>
//!  to the number of knots in the BSpline curve whose data is <br>
//!  computed in this framework. <br>
//! Particular care must be taken with respect to the above as <br>
//! these conditions are not checked, and an error may occur. <br>
Standard_EXPORT   void KnotsAndMults(TColStd_Array1OfReal& Knots,TColStd_Array1OfInteger& Mults) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Convert_SequenceOfArray1OfPoles2d mySequence;
TColgp_SequenceOfPnt2d CurvePoles;
TColStd_SequenceOfReal CurveKnots;
TColStd_SequenceOfInteger KnotsMultiplicities;
Standard_Integer myDegree;
Standard_Real myAngular;
Standard_Boolean myDone;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
