// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Bisector_Bisec_HeaderFile
#define _Bisector_Bisec_HeaderFile

#ifndef _Handle_Geom2d_TrimmedCurve_HeaderFile
#include <Handle_Geom2d_TrimmedCurve.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom2d_Point_HeaderFile
#include <Handle_Geom2d_Point.hxx>
#endif
class Geom2d_TrimmedCurve;
class Geom2d_Curve;
class gp_Pnt2d;
class gp_Vec2d;
class Geom2d_Point;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Bisec  provides the bisecting line between two  elements <br>
//!  This line is trimed by a point <P> and it's contained in the domain <br>
//!  defined by the two vectors <V1>, <V2> and <Sense>. <br>
//! <br>
//!  Definition of  the domain: <br>
//!  if <Sense>  is  true the bisecting line is contained in the sector <br>
//!  defined by <-V1> and <-V2> in the sense indirect. <br>
//!  if <Sense>  is  false the bisecting line is contained in the sector <br>
//!  defined by <-V1> and <-V2> in the sense direct. <br>
class Bisector_Bisec  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Bisector_Bisec();

//! Performs  the bisecting line  between the  curves <br>
//!            <Cu1> and <Cu2>. <br>
//!            <oncurve> is True if the point <P> is common to <Cu1> <br>
//!            and <Cu2>. <br>
Standard_EXPORT   void Perform(const Handle(Geom2d_Curve)& Cu1,const Handle(Geom2d_Curve)& Cu2,const gp_Pnt2d& P,const gp_Vec2d& V1,const gp_Vec2d& V2,const Standard_Real Sense,const Standard_Real Tolerance,const Standard_Boolean oncurve = Standard_True) ;

//! Performs  the bisecting line  between the  curve <br>
//!            <Cu1> and the point <Pnt>. <br>
//!            <oncurve> is True if the point <P> is the point <Pnt>. <br>
Standard_EXPORT   void Perform(const Handle(Geom2d_Curve)& Cu,const Handle(Geom2d_Point)& Pnt,const gp_Pnt2d& P,const gp_Vec2d& V1,const gp_Vec2d& V2,const Standard_Real Sense,const Standard_Real Tolerance,const Standard_Boolean oncurve = Standard_True) ;

//! Performs  the bisecting line  between the  curve <br>
//!            <Cu> and the point <Pnt>. <br>
//!            <oncurve> is True if the point <P> is the point <Pnt>. <br>
Standard_EXPORT   void Perform(const Handle(Geom2d_Point)& Pnt,const Handle(Geom2d_Curve)& Cu,const gp_Pnt2d& P,const gp_Vec2d& V1,const gp_Vec2d& V2,const Standard_Real Sense,const Standard_Real Tolerance,const Standard_Boolean oncurve = Standard_True) ;

//! Performs  the bisecting line  between the two points <br>
//!            <Pnt1>  and <Pnt2>. <br>
Standard_EXPORT   void Perform(const Handle(Geom2d_Point)& Pnt1,const Handle(Geom2d_Point)& Pnt2,const gp_Pnt2d& P,const gp_Vec2d& V1,const gp_Vec2d& V2,const Standard_Real Sense,const Standard_Real Tolerance = 0.0,const Standard_Boolean oncurve = Standard_True) ;

//! Returns the Curve of <me>. <br>
Standard_EXPORT  const Handle_Geom2d_TrimmedCurve& Value() const;

//! Returns the Curve of <me>. <br>
//! <br>
Standard_EXPORT  const Handle_Geom2d_TrimmedCurve& ChangeValue() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Geom2d_TrimmedCurve thebisector;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
