// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_CheckResult_HeaderFile
#define _BOP_CheckResult_HeaderFile

#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _BOP_CheckStatus_HeaderFile
#include <BOP_CheckStatus.hxx>
#endif
#ifndef _TopTools_ListOfShape_HeaderFile
#include <TopTools_ListOfShape.hxx>
#endif
class TopoDS_Shape;
class TopTools_ListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! contains information about faulty shapes and faulty types <br>
//!         can't be processed by Boolean Operations <br>
class BOP_CheckResult  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! empty constructor <br>
Standard_EXPORT BOP_CheckResult();

//! sets ancestor shape (object) for faulty sub-shapes <br>
Standard_EXPORT   void SetShape1(const TopoDS_Shape& TheShape) ;

//! adds faulty sub-shapes from object to a list <br>
Standard_EXPORT   void AddFaultyShape1(const TopoDS_Shape& TheShape) ;

//! sets ancestor shape (tool) for faulty sub-shapes <br>
Standard_EXPORT   void SetShape2(const TopoDS_Shape& TheShape) ;

//! adds faulty sub-shapes from tool to a list <br>
Standard_EXPORT   void AddFaultyShape2(const TopoDS_Shape& TheShape) ;

//! returns ancestor shape (object) for faulties <br>
Standard_EXPORT  const TopoDS_Shape& GetShape1() const;

//! returns ancestor shape (tool) for faulties <br>
Standard_EXPORT  const TopoDS_Shape& GetShape2() const;

//! returns list of faulty shapes for object <br>
Standard_EXPORT  const TopTools_ListOfShape& GetFaultyShapes1() const;

//! returns list of faulty shapes for tool <br>
Standard_EXPORT  const TopTools_ListOfShape& GetFaultyShapes2() const;

//! set status of faulty <br>
Standard_EXPORT   void SetCheckStatus(const BOP_CheckStatus TheStatus) ;

//! gets status of faulty <br>
Standard_EXPORT   BOP_CheckStatus GetCheckStatus() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Shape myShape1;
TopoDS_Shape myShape2;
BOP_CheckStatus myStatus;
TopTools_ListOfShape myFaulty1;
TopTools_ListOfShape myFaulty2;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
