//
// C++ Interface: cmdlineextractor
//
// Description:
//
//
// Author: Yorn <yorn@gmx.net>, (C) 2009
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef CMDLINEEXTRACTOR_H
#define CMDLINEEXTRACTOR_H

#include <deque>
#include <vector>
#include <string>

#include "definition.h"
#include "oggComment.h"
#include "blendElement.h"

const std::string validChars ( "0123456789,x" );
const std::string
validTextChars ( "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 /\\.,=;:-_" );

/**
	@author Yorn <yorn@gmx.net>
*/
class CmdlineExtractor {
public:
  CmdlineExtractor();

  ~CmdlineExtractor();

  static void extractCommentPairs ( std::vector<OggComment>& list,
                                    const std::string& _argument, char tokenSeparator, char commentSeparator );

  static void extractUint32 ( std::deque<uint32>& list, const std::string& _argument,
                              char seperator );

  static void extractBlend ( std::vector<BlendElement>& list, const std::string& _argument,
                             char tokenSeparator, char valueSeparator );
};

#endif
