# -*- makefile -*-
# octave-pkg.mk: CDBS-based debian/rules scrap for building/installing
#                octave-forge pkg add-ons
# This file is part of the octave-pkg-dev Debian package

# Copyright (c) 2008  Olafur Jens Sigurðsson <ojsbug@gmail.com>
# Copyright (c) 2008, 2009, 2012  Rafael Laboissiere <rafael@laboissiere.net>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

include /usr/share/cdbs/1/rules/debhelper.mk

package = $(shell awk '/^Package:/ {print $$2; exit 0}' debian/control)
debpkg = debian/$(package)
shrpkg = /usr/share/octave/debian
# The directories below are versioned.  We only support the packages for the
# stable version of Octave
mpath = usr/share/octave/packages
bpath = usr/lib/$(shell dpkg-architecture -qDEB_HOST_MULTIARCH)/octave/packages
hosttype = $(shell octave-config -p CANONICAL_HOST_TYPE)
version = $(shell octave-config -p VERSION | sed 's/-rc/~rc/')
apiversion = $(shell octave-config -p API_VERSION)
octave = /usr/bin/octave
octave_options = --no-history --silent --no-init-file --no-window-system
global_list = global-list
local_list = local-list

# The following variable can be overriden in debian/rules to alter the
# behavior of the tests.  Possible values are 'quiet', 'normal', and
# 'verbose'.  Users must set its value after inclusion of octave-pkg.mk.
OCTPKG_TEST_OPT =

# The following variable can be overriden in debian/rules to alter the the
# way the tests are run.  Its is value is prepended to the octave command.
# A sensible value for it would be 'xvfb-run', but environment variables
# can be also set.  Users must set its value after inclusion of
# octave-pkg.mk.
OCTPKG_TEST_ENV =

export OCTAVE_HISTFILE=/dev/null
# even with '--no-history', Octave creates an empty .octave_hist at startup,
# resulting in 'permission denied errors on the buildds

# Export buildflags to the environment, they will be picked up by mkoctfile.
# Link with --as-needed since that drastically reduces the number of linked
# libraries.
DEB_LDFLAGS_MAINT_APPEND=-Wl,--as-needed
DPKG_EXPORT_BUILDFLAGS = 1
include /usr/share/dpkg/buildflags.mk
# Oct-files ldflags are taken from the following variable
export OCT_LINK_OPTS=$(LDFLAGS)

install/$(package)::	\
	check-version	\
	create-dirs	\
	install-pkg	\
	clean-files	\
	install-docs	\
	check-pkg	\
	remove-dirs

.PHONY: check-version
check-version:
	@echo -n "Checking the Octave version... "
	@dep=$$(grep Depends DESCRIPTION				\
          | perl -ne 'if (/octave\s+\(>=\s*([.\d]+)\)/) {print $$1}') ;	\
	if [ "$$dep" != "" ] ; then					\
		dpkg --compare-versions $(version) ge $$dep		\
			|| (echo ;					\
			    echo "Octave version mismatch:"		\
				 "Needs >= $$dep, but version"		\
				 "$(version) is installed" 1>&2 ;	\
			    false) ;					\
	fi ;								\
	echo ok

.PHONY: create-dirs
create-dirs:
	mkdir -p $(CURDIR)/$(debpkg)/$(mpath)	\
		 $(CURDIR)/$(debpkg)/$(bpath)

.PHONY: install-pkgs
install-pkg:
	-[ -e PKG_ADD ] && mv PKG_ADD PKG_ADD.bak
	$(octave) $(octave_options) --eval				\
		 "pkg ('prefix', [pwd(),'/$(debpkg)/$(mpath)'],		\
		      [pwd(),'/$(debpkg)/$(bpath)']);			\
		 pkg ('local_list', [pwd(),'/$(local_list)']);		\
		 pkg ('global_list', [pwd(),'/$(global_list)']);	\
		 if (exist ('PKG_ADD.bak') == 2),			\
		     movefile ('PKG_ADD.bak', 'PKG_ADD');		\
		 endif;							\
		 pkg -verbose -nodeps install ."
	$(shrpkg)/dh/octave-pkg-helper
	dh_install --package=$(package)

.PHONY: clean-files
clean-files::
	( cd  $(shell find . -name packinfo) ; rm -f COPYING ChangeLog )

.PHONY: install-docs
install-docs:
	if [ -d doc ] ; then				\
		dh_installdocs -p$(package);		\
		rm -rf $(debpkg)/$(mpath)/*/doc ;	\
	fi

.PHONY: check-pkg
ifeq (,$(findstring nocheck,$(DEB_BUILD_OPTIONS)))
check-pkg:
	-[ -e PKG_ADD ] && mv PKG_ADD PKG_ADD.bak

	@echo Checking package...

# Extract tests from installed m files
	@echo Checking m files ...
	@tmp=$$(tempfile) ;					\
	echo "addpath (genpath ([pwd(),'/debian']));" > $$tmp ;	\
	find debian/ -name \*.m					\
		| grep -v /private/				\
		| xargs grep -l '^%!\(assert\|test\)'		\
		| perl -pe 's:[^@]*/(.*)\.m::;			\
		 print "disp (\"[$$1]\")\ntest $$1 $(OCTPKG_TEST_OPT)"'	\
		>> $$tmp ;					\
	$(OCTPKG_TEST_ENV) $(octave) $(octave_options) $$tmp ;	\
	rm -f $$tmp

# Extract tests from .cc files - these are not installed, but the
# compiled .oct files are.
# We search for the tests in the .cc files, but invoke the .oct files;
# this means we must add generate a loadpath starting at the current
# directory and source PKG_ADD files (they might add autoload()
# directives)

# We deactivate the warning about relative paths used for the PKG_ADD file.
	@echo Checking CC files ...
	@tmp=$$(tempfile) ;					\
	echo "addpath (genpath ([pwd()], '.pc'));" >> $$tmp ;	\
	echo "warning ('off', 'Octave:autoload-relative-file-name');" >> $$tmp ;	\
	if [ -f PKG_ADD ] ; then				\
		echo "source('PKG_ADD');" >> $$tmp ; 		\
	fi ;							\
	if [ -f PKG_ADD.bak ] ; then				\
		echo "source('PKG_ADD.bak');" >> $$tmp ;	\
	fi ;							\
	if [ -d src ] ; then					\
		find src/ -name \*.cc				\
			| xargs grep -l '^%!\(assert\|test\)'	\
			| perl -pe 's:.*/(.*)\.cc::;		\
				print "disp (\"[$$1]\")\ntest $$1 $(OCTPKG_TEST_OPT)"'	\
			>> $$tmp ;				\
	fi ;							\
	octave $(octave_options) $$tmp ;			\
	rm -f $$tmp

	@if [ -f debian/check.m ] ; then				\
		$(OCTPKG_TEST_ENV) $(octave) $(octave_options) --eval	\
			"addpath (genpath ([pwd(),'/debian']));		\
			 source ('debian/check.m');" ;			\
	fi

	-[ -e PKG_ADD.bak ] && mv PKG_ADD.bak PKG_ADD
else
check-pkg:
endif

.PHONY: remove-dirs
remove-dirs:
	rmdir --ignore-fail-on-non-empty -p	\
		 $(CURDIR)/$(debpkg)/$(mpath)	\
		 $(CURDIR)/$(debpkg)/$(bpath)


DEB_MAKE_CLEAN_TARGET = -C src clean

clean::
ifneq ($(DEB_MAKE_CLEAN_TARGET),)
	-$(MAKE) -k $(DEB_MAKE_CLEAN_TARGET)
endif
	rm -rf inst/$(hosttype)-$(apiversion) $(global_list) $(local_list)
