// Copyright 2006-2008 Deutsches Forschungszentrum fuer Kuenstliche Intelligenz 
// or its licensors, as applicable.
// 
// You may not use this file except under the terms of the accompanying license.
// 
// Licensed under the Apache License, Version 2.0 (the "License"); you
// may not use this file except in compliance with the License. You may
// obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// 
// Project: OCRopus
// File: ocr-binarize-sauvola.h
// Purpose: An efficient implementation of the Sauvola's document binarization 
//          algorithm based on integral images as described in
//          F. Shafait, D. Keysers, T.M. Breuel. "Efficient Implementation of 
//          Local Adaptive Thresholding Techniques Using Integral Images".
//          Document Recognition and Retrieval XV, San Jose.
//
// Responsible: Faisal Shafait (faisal.shafait@dfki.de)
// Reviewer: 
// Primary Repository: 
// Web Sites: www.iupr.org, www.dfki.de

/// \file ocr-binarize-sauvola.h
/// \brief An efficient implementation of the Sauvola's binarization algorithm.
///
///  An efficient implementation of the Sauvola's document binarization 
///  algorithm based on integral images as described in
///  F. Shafait, D. Keysers, T.M. Breuel. "Efficient Implementation of 
///  Local Adaptive Thresholding Techniques Using Integral Images".
///  Document Recognition and Retrieval XV, San Jose.

#ifndef h_ocr_binarize_savuola_
#define h_ocr_binarize_savuola_

#include "ocrinterfaces.h"

namespace ocropus {
    /// Create an implementation of Sauvola's binarization algorithm.
    colib::IBinarize *make_BinarizeBySauvola();
}

#endif
