// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IntAna_Quadric_HeaderFile
#define _IntAna_Quadric_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class gp_Pln;
class gp_Sphere;
class gp_Cylinder;
class gp_Cone;
class gp_Ax3;


//! This class provides a description of Quadrics by their <br>
//!          Coefficients in natural coordinate system. <br>
class IntAna_Quadric  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Empty Constructor <br>
  Standard_EXPORT   IntAna_Quadric();
  //! Creates a Quadric from a Pln <br>
  Standard_EXPORT   IntAna_Quadric(const gp_Pln& P);
  //!  Creates a Quadric from a Sphere <br>
  Standard_EXPORT   IntAna_Quadric(const gp_Sphere& Sph);
  //!  Creates a Quadric from a Cylinder <br>
  Standard_EXPORT   IntAna_Quadric(const gp_Cylinder& Cyl);
  //!  Creates a Quadric from a Cone <br>
  Standard_EXPORT   IntAna_Quadric(const gp_Cone& Cone);
  //! Initializes the quadric with a Pln <br>
  Standard_EXPORT     void SetQuadric(const gp_Pln& P) ;
  //! Initialize the quadric with a Sphere <br>
  Standard_EXPORT     void SetQuadric(const gp_Sphere& Sph) ;
  //! Initializes the quadric with a Cone <br>
  Standard_EXPORT     void SetQuadric(const gp_Cone& Con) ;
  //! Initializes the quadric with a Cylinder <br>
  Standard_EXPORT     void SetQuadric(const gp_Cylinder& Cyl) ;
  //! Returns the coefficients of the polynomial equation <br>
//!          which define the quadric: <br>
//!          xCXX x**2 + xCYY y**2 + xCZZ z**2 <br>
//!          + 2 ( xCXY x y  + xCXZ x z  + xCYZ y z  ) <br>
//!          + 2 ( xCX x + xCY y + xCZ z ) <br>
//!          + xCCte <br>
  Standard_EXPORT     void Coefficients(Standard_Real& xCXX,Standard_Real& xCYY,Standard_Real& xCZZ,Standard_Real& xCXY,Standard_Real& xCXZ,Standard_Real& xCYZ,Standard_Real& xCX,Standard_Real& xCY,Standard_Real& xCZ,Standard_Real& xCCte) const;
  //! Returns the coefficients of the polynomial equation <br>
//!          ( written in the natural coordinates system ) <br>
//!          in the local coordinates system defined by Axis <br>
  Standard_EXPORT     void NewCoefficients(Standard_Real& xCXX,Standard_Real& xCYY,Standard_Real& xCZZ,Standard_Real& xCXY,Standard_Real& xCXZ,Standard_Real& xCYZ,Standard_Real& xCX,Standard_Real& xCY,Standard_Real& xCZ,Standard_Real& xCCte,const gp_Ax3& Axis) const;





protected:





private:



Standard_Real CXX;
Standard_Real CYY;
Standard_Real CZZ;
Standard_Real CXY;
Standard_Real CXZ;
Standard_Real CYZ;
Standard_Real CX;
Standard_Real CY;
Standard_Real CZ;
Standard_Real CCte;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
