// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IFSelect_Dispatch_HeaderFile
#define _IFSelect_Dispatch_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_IFSelect_Dispatch_HeaderFile
#include <Handle_IFSelect_Dispatch.hxx>
#endif

#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Handle_IFSelect_Selection_HeaderFile
#include <Handle_IFSelect_Selection.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TCollection_HAsciiString;
class IFSelect_Selection;
class Interface_InterfaceError;
class IFSelect_SelectionIterator;
class TCollection_AsciiString;
class Interface_EntityIterator;
class Interface_Graph;
class IFGraph_SubPartsIterator;


//! This class allows to describe how a set of Entities has to be <br>
//!           dispatched into resulting Packets : a Packet is a sub-set of <br>
//!           the initial set of entities. <br>
//! <br>
//!           Thus, it can generate zero, one, or more Packets according <br>
//!           input set and criterium of dispatching. And it can let apart <br>
//!           some entities : it is the Remainder, which can be recovered <br>
//!           by a specific Selection (RemainderFromDispatch). <br>
//! <br>
//!           Depending of sub-classes, a Dispatch can potentially generate <br>
//!           a limited or not count of packet, and a remainder or none. <br>
//! <br>
//!           The input set is read from a specified Selection, attached to <br>
//!           the Dispatch : the Final Selection of the Dispatch. The input <br>
//!           is the Unique Root Entities list of the Final Selection <br>
class IFSelect_Dispatch : public MMgt_TShared {

public:

  //! Sets a Root Name as an HAsciiString <br>
//!           To reset it, give a Null Handle (then, a ShareOut will have <br>
//!           to define the Default Root Name) <br>
  Standard_EXPORT     void SetRootName(const Handle(TCollection_HAsciiString)& name) ;
  //! Returns True if a specific Root Name has been set <br>
//!           (else, the Default Root Name has to be used) <br>
  Standard_EXPORT     Standard_Boolean HasRootName() const;
  //! Returns the Root Name for files produced by this dispatch <br>
//!           It is empty if it has not been set or if it has been reset <br>
  Standard_EXPORT    const Handle_TCollection_HAsciiString& RootName() const;
  //! Stores (or Changes) the Final Selection for a Dispatch <br>
  Standard_EXPORT     void SetFinalSelection(const Handle(IFSelect_Selection)& sel) ;
  //! Returns the Final Selection of a Dispatch <br>
//! we 'd like : C++ : return const & <br>
  Standard_EXPORT     Handle_IFSelect_Selection FinalSelection() const;
  //! Returns the complete list of source Selections (starting <br>
//!           from FinalSelection) <br>
  Standard_EXPORT     IFSelect_SelectionIterator Selections() const;
  //! Returns True if a Dispatch can have a Remainder, i.e. if its <br>
//!           criterium can let entities apart. It is a potential answer, <br>
//!           remainder can be empty at run-time even if answer is True. <br>
//!           (to attach a RemainderFromDispatch Selection is not allowed if <br>
//!           answer is True). <br>
//!           Default answer given here is False (can be redefined) <br>
  Standard_EXPORT   virtual  Standard_Boolean CanHaveRemainder() const;
  //! Returns True if a Dispatch generates a count of Packets always <br>
//!           less than or equal to a maximum value : it can be computed <br>
//!           from the total count of Entities to be dispatched : <nbent>. <br>
//!           If answer is False, no limited maximum is expected for account <br>
//!           If answer is True, expected maximum is given in argument <max> <br>
//!           Default answer given here is False (can be redefined) <br>
  Standard_EXPORT   virtual  Standard_Boolean LimitedMax(const Standard_Integer nbent,Standard_Integer& max) const;
  //! Returns a text which defines the way a Dispatch produces <br>
//!           packets (which will become files) from its Input <br>
  Standard_EXPORT   virtual  TCollection_AsciiString Label() const = 0;
  //! Gets Unique Root Entities from the Final Selection, given an <br>
//!           input Graph <br>
//!           This the starting step for an Evaluation (Packets - Remainder) <br>
  Standard_EXPORT     Interface_EntityIterator GetEntities(const Interface_Graph& G) const;
  //! Returns True if Count of Packets is actually known, and the <br>
//!           value of the count in argument "count". Returns False if <br>
//!           this count is unknown. Input is given as a Graph. <br>
//!           This method is intended to be quick (used for file names) <br>
//!           hence if this count is long to compute (that is, as a result <br>
//!           of complete evaluation made by method Packets), it is <br>
//!           preferable to answer "unknown" by returning False <br>
//!           Default answer if False. Can be redefined. <br>
  Standard_EXPORT   virtual  Standard_Boolean PacketsCount(const Interface_Graph& G,Standard_Integer& count) const;
  //! Returns the list of produced Packets into argument <pack>. <br>
//!           Each Packet corresponds to a Part, the Entities listed are the <br>
//!           Roots given by the Selection. Input is given as a Graph. <br>
//!           Thus, to create a file from a packet, it suffices to take the <br>
//!           entities listed in a Part of Packets (that is, a Packet) <br>
//!           without worrying about Shared entities <br>
//!           This method can raise an Exception if data are not coherent <br>
  Standard_EXPORT   virtual  void Packets(const Interface_Graph& G,IFGraph_SubPartsIterator& packs) const = 0;
  //! Returns the list of all Input Entities (see GetEntities) which <br>
//!           are put in a Packet. That is, Entities listed in GetEntities <br>
//!           but not in Remainder (see below). Input is given as a Graph. <br>
  Standard_EXPORT     Interface_EntityIterator Packeted(const Interface_Graph& G) const;
  //! Returns Remainder which is a set of Entities. Can be empty. <br>
//!           Default evaluation is empty (has to be redefined if <br>
//!           CanHaveRemainder is redefined to return True). <br>
  Standard_EXPORT   virtual  Interface_EntityIterator Remainder(const Interface_Graph& G) const;




  DEFINE_STANDARD_RTTI(IFSelect_Dispatch)

protected:




private: 


Handle_TCollection_HAsciiString thename;
Handle_IFSelect_Selection thefinal;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
