// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GeomAPI_ExtremaCurveCurve_HeaderFile
#define _GeomAPI_ExtremaCurveCurve_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Extrema_ExtCC_HeaderFile
#include <Extrema_ExtCC.hxx>
#endif
#ifndef _GeomAdaptor_Curve_HeaderFile
#include <GeomAdaptor_Curve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Quantity_Parameter_HeaderFile
#include <Quantity_Parameter.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
class Standard_OutOfRange;
class StdFail_NotDone;
class Geom_Curve;
class gp_Pnt;
class Extrema_ExtCC;


//! Describes functions for computing all the extrema <br>
//! between two 3D curves. <br>
//! An ExtremaCurveCurve algorithm minimizes or <br>
//! maximizes the distance between a point on the first <br>
//! curve and a point on the second curve. Thus, it <br>
//! computes start and end points of perpendiculars <br>
//! common to the two curves (an intersection point is <br>
//! not an extremum unless the two curves are tangential at this point). <br>
//! Solutions consist of pairs of points, and an extremum <br>
//! is considered to be a segment joining the two points of a solution. <br>
//! An ExtremaCurveCurve object provides a framework for: <br>
//! -   defining the construction of the extrema, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the results. <br>
//! Warning <br>
//! In some cases, the nearest points between two <br>
//! curves do not correspond to one of the computed <br>
//! extrema. Instead, they may be given by: <br>
//! -   a limit point of one curve and one of the following: <br>
//!   -   its orthogonal projection on the other curve, <br>
//!   -   a limit point of the other curve; or <br>
//!   -   an intersection point between the two curves. <br>
class GeomAPI_ExtremaCurveCurve  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Constructs an empty algorithm for computing <br>
//! extrema between two curves. Use an Init function <br>
//! to define the curves on which it is going to work. <br>
  Standard_EXPORT   GeomAPI_ExtremaCurveCurve();
  //! Computes the extrema between the curves C1 and C2. <br>
  Standard_EXPORT   GeomAPI_ExtremaCurveCurve(const Handle(Geom_Curve)& C1,const Handle(Geom_Curve)& C2);
  //! Computes   the portion of the curve C1 limited by the two <br>
//!    points of parameter (U1min,U1max), and <br>
//!  -   the portion of the curve C2 limited by the two <br>
//!   points of parameter (U2min,U2max). <br>
//!        Warning <br>
//! Use the function NbExtrema to obtain the number <br>
//! of solutions. If this algorithm fails, NbExtrema returns 0. <br>
  Standard_EXPORT   GeomAPI_ExtremaCurveCurve(const Handle(Geom_Curve)& C1,const Handle(Geom_Curve)& C2,const Quantity_Parameter U1min,const Quantity_Parameter U1max,const Quantity_Parameter U2min,const Quantity_Parameter U2max);
  //! Initializes this algorithm with the given arguments <br>
//! and computes the extrema between the curves C1 and C2 <br>
  Standard_EXPORT     void Init(const Handle(Geom_Curve)& C1,const Handle(Geom_Curve)& C2) ;
  //! Initializes this algorithm with the given arguments <br>
//! and computes the extrema between : <br>
//!   -   the portion of the curve C1 limited by the two <br>
//!    points of parameter (U1min,U1max), and <br>
//!   -   the portion of the curve C2 limited by the two <br>
//!    points of parameter (U2min,U2max). <br>
//!        Warning <br>
//! Use the function NbExtrema to obtain the number <br>
//! of solutions. If this algorithm fails, NbExtrema returns 0. <br>
  Standard_EXPORT     void Init(const Handle(Geom_Curve)& C1,const Handle(Geom_Curve)& C2,const Quantity_Parameter U1min,const Quantity_Parameter U1max,const Quantity_Parameter U2min,const Quantity_Parameter U2max) ;
  //! Returns the number of extrema computed by this algorithm. <br>
//! Note: if this algorithm fails, NbExtrema returns 0. <br>
  Standard_EXPORT     Standard_Integer NbExtrema() const;
Standard_EXPORT operator Standard_Integer() const;
  //! Returns the points P1 on the first curve and P2 on <br>
//! the second curve, which are the ends of the <br>
//! extremum of index Index computed by this algorithm. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is not in the range [ <br>
//! 1,NbExtrema ], where NbExtrema is the <br>
//! number of extrema computed by this algorithm. <br>
  Standard_EXPORT     void Points(const Standard_Integer Index,gp_Pnt& P1,gp_Pnt& P2) const;
  //! Returns the parameters U1 of the point on the first <br>
//! curve and U2 of the point on the second curve, which <br>
//! are the ends of the extremum of index Index computed by this algorithm. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is not in the range [ <br>
//! 1,NbExtrema ], where NbExtrema is the <br>
//! number of extrema computed by this algorithm. <br>
  Standard_EXPORT     void Parameters(const Standard_Integer Index,Quantity_Parameter& U1,Quantity_Parameter& U2) const;
  //! Computes the distance between the end points of the <br>
//! extremum of index Index computed by this algorithm. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is not in the range [ <br>
//! 1,NbExtrema ], where NbExtrema is the <br>
//! number of extrema computed by this algorithm. <br>
  Standard_EXPORT     Quantity_Length Distance(const Standard_Integer Index) const;
  //! Returns the points P1 on the first curve and P2 on <br>
//! the second curve, which are the ends of the shortest <br>
//! extremum computed by this algorithm. <br>
//! Exceptions StdFail_NotDone if this algorithm fails. <br>
  Standard_EXPORT     void NearestPoints(gp_Pnt& P1,gp_Pnt& P2) const;
  //! Returns the parameters U1 of the point on the first <br>
//! curve and U2 of the point on the second curve, which <br>
//! are the ends of the shortest extremum computed by this algorithm. <br>
//! Exceptions StdFail_NotDone if this algorithm fails. <br>
  Standard_EXPORT     void LowerDistanceParameters(Quantity_Parameter& U1,Quantity_Parameter& U2) const;
  //! Computes the distance between the end points of the <br>
//! shortest extremum computed by this algorithm. <br>
//! Exceptions StdFail_NotDone if this algorithm fails. <br>
  Standard_EXPORT     Quantity_Length LowerDistance() const;
Standard_EXPORT operator Standard_Real() const;
  //! return the algorithmic object from Extrema <br>
       const Extrema_ExtCC& Extrema() const;
  //! set  in  <P1>  and <P2> the couple solution points <br>
//!          such a the distance [P1,P2] is the minimum. taking  in  account <br>
//!          extremity  points  of  curves. <br>
  Standard_EXPORT     Standard_Boolean TotalNearestPoints(gp_Pnt& P1,gp_Pnt& P2) ;
  //! set  in <U1> and <U2> the parameters of the couple <br>
//!          solution   points  which  represents  the  total  nearest <br>
//!          solution. <br>
  Standard_EXPORT     Standard_Boolean TotalLowerDistanceParameters(Quantity_Parameter& U1,Quantity_Parameter& U2) ;
  //! return the distance of the total  nearest couple solution <br>
//!          point. <br>//! if <myExtCC> is not done <br>
  Standard_EXPORT     Quantity_Length TotalLowerDistance() ;





protected:





private:

  
  Standard_EXPORT     void TotalPerform() ;


Standard_Boolean myIsDone;
Standard_Integer myIndex;
Extrema_ExtCC myExtCC;
GeomAdaptor_Curve myC1;
GeomAdaptor_Curve myC2;
Standard_Boolean myTotalExt;
Standard_Boolean myIsInfinite;
Standard_Real myTotalDist;
gp_Pnt myTotalPoints[2];
Standard_Real myTotalPars[2];


};


#include <GeomAPI_ExtremaCurveCurve.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
