// This file is generated by kconfig_compiler from ipv4.kcfg.
// All changes you do to this file will be lost.

#include "ipv4persistence.h"

using namespace Knm;

Ipv4Persistence::Ipv4Persistence(Ipv4Setting * setting, KSharedConfig::Ptr config, SettingPersistence::SecretStorageMode mode) : SettingPersistence(setting, config, mode)
{
}

Ipv4Persistence::~Ipv4Persistence()
{
}

void Ipv4Persistence::load()
{
  Ipv4Setting * setting = static_cast<Ipv4Setting *>(m_setting);
  {
    QString contents = m_config->readEntry("method", "Automatic");
    if (contents == "Automatic")
      setting->setMethod(Ipv4Setting::EnumMethod::Automatic);
    else     if (contents == "LinkLocal")
      setting->setMethod(Ipv4Setting::EnumMethod::LinkLocal);
    else     if (contents == "Manual")
      setting->setMethod(Ipv4Setting::EnumMethod::Manual);
    else     if (contents == "Shared")
      setting->setMethod(Ipv4Setting::EnumMethod::Shared);
    else     if (contents == "Disabled")
      setting->setMethod(Ipv4Setting::EnumMethod::Disabled);

  }

  // dns
  QList<QHostAddress> dnsServers;
  QStringList rawDnsServers = m_config->readEntry("dns", QStringList());
  foreach (const QString &server, rawDnsServers) {
      dnsServers.append(QHostAddress(server));
  }
  setting->setDns(dnsServers);

  setting->setDnssearch(m_config->readEntry("dnssearch", QStringList()));

  // addresses
  QList<Solid::Control::IPv4AddressNm09> addresses;
  QStringList rawAddresses = m_config->readEntry("addresses", QStringList());
  foreach (const QString &rawAddress, rawAddresses) {
      QStringList parts = rawAddress.split(';');
      if (parts.count() != 3) { // sanity check
          continue;
      }
      QHostAddress ip(parts[0]);
      QHostAddress gateway(parts[2]);
      Solid::Control::IPv4AddressNm09 addr(ip.toIPv4Address(), parts[1].toUInt(), gateway.toIPv4Address());
      addresses.append(addr);
  }
  setting->setAddresses(addresses);

  // routes
  QList<Solid::Control::IPv4RouteNm09> routes;
  QStringList rawRoutes = m_config->readEntry("routes", QStringList());
  foreach (const QString &rawRoute, rawRoutes) {
      QStringList parts = rawRoute.split(';');
      if (parts.count() != 4) { // sanity check
          continue;
      }
      QHostAddress address(parts[0]);
      quint32 prefix = parts[1].toUInt();
      QHostAddress nextHop(parts[2]);
      quint32 metric = parts[3].toUInt();
      Solid::Control::IPv4RouteNm09 route(address.toIPv4Address(), prefix, nextHop.toIPv4Address(), metric);
      routes.append(route);
  }
  setting->setRoutes(routes);
  setting->setIgnoredhcpdns(m_config->readEntry("ignoredhcpdns", false));
  setting->setIgnoreautoroute(m_config->readEntry("ignoreautoroute", false));
  setting->setNeverdefault(m_config->readEntry("neverdefault", false));
  setting->setDhcpclientid(m_config->readEntry("dhcpclientid", ""));
  setting->setDhcphostname(m_config->readEntry("dhcphostname", ""));
  setting->setMayfail(m_config->readEntry("mayfail", true));
}
