--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------

--  wsdl2aws SOAP Generator v2.0
--
--  AWS 2.2.0 - SOAP 1.4.0
--  This file was generated on Wednesday 06 February 2008 at 10:05:06
--
--  $ wsdl2aws -spec narval_aws_interface -f
--  -main aws_interface_main -cb narval_aws.wsdl

with Ada.Exceptions;

with SOAP.Message.Response.Error;
pragma Elaborate_All (SOAP);
pragma Elaborate_All (SOAP.Message);
pragma Elaborate_All (SOAP.Message.Response);
pragma Elaborate_All (SOAP.Message.Response.Error);
with SOAP.Parameters;
pragma Elaborate_All (SOAP.Parameters);
with SOAP.Utils;
pragma Elaborate_All (SOAP.Utils);

package body narval_aws_Service.Server is

   use Ada.Exceptions;

   use SOAP.Types;
   use type SOAP.Parameters.List;

   pragma Warnings (Off);
   --  Suppress wrong warnings generated by GNAT (fixed in 3.17)

   pragma Style_Checks (Off);

   ---------------------
   -- Send_Command_CB --
   ---------------------

   function Send_Command_CB
     (SOAPAction : in String;
      Payload    : in SOAP.Message.Payload.Object;
      Request    : in AWS.Status.Data)
      return AWS.Response.Data
   is
      Proc_Name : constant String
        := SOAP.Message.Payload.Procedure_Name (Payload);
      Params    : constant SOAP.Parameters.List
        := SOAP.Message.Parameters (Payload);
      Response  : SOAP.Message.Response.Object;
      R_Params  : SOAP.Parameters.List;
   begin
      if SOAPAction /= "Send_Command" then
         return SOAP.Message.Response.Build
           (SOAP.Message.Response.Error.Build
              (SOAP.Message.Response.Error.Client,
               "SOAPAction " & SOAPAction & " in Send_Command, "
                 & "Send_Command expected."));
      end if;

      if Proc_Name /= "Send_Command" then
         return SOAP.Message.Response.Build
           (SOAP.Message.Response.Error.Build
              (SOAP.Message.Response.Error.Client,
               "Found procedure " & Proc_Name & " in Send_Command, "
                 & "Send_Command expected."));
      end if;

      Response := SOAP.Message.Response.From (Payload);

      declare
         Command : constant String
           := SOAP.Parameters.Get (Params, "Command");
         Result : constant String
           := Send_Command
                (Command);
      begin
         R_Params :=
           +SOAP.Types.S (Result, "Result");
      end;

      SOAP.Message.Set_Parameters (Response, R_Params);
      return SOAP.Message.Response.Build (Response);
   exception
      when E : SOAP.Types.Data_Error =>
         --  Here we have a problem with some parameters, return a SOAP error
         return SOAP.Message.Response.Build
           (SOAP.Message.Response.Error.Build
              (SOAP.Message.Response.Error.Client,
               "Parameter error in Send_Command ("
                 & Exception_Message (E) & ")"));
      when O : others =>
         --  Here we have a problem with user's callback, return a SOAP error
         return SOAP.Message.Response.Build
           (SOAP.Message.Response.Error.Build
              (SOAP.Message.Response.Error.Client,
               "Error in Send_Command ("
                 & Exception_Message (O) & ")"));
   end Send_Command_CB;

   ------------------------------------
   -- Send_Command_With_Arguments_CB --
   ------------------------------------

   function Send_Command_With_Arguments_CB
     (SOAPAction : in String;
      Payload    : in SOAP.Message.Payload.Object;
      Request    : in AWS.Status.Data)
      return AWS.Response.Data
   is
      Proc_Name : constant String
        := SOAP.Message.Payload.Procedure_Name (Payload);
      Params    : constant SOAP.Parameters.List
        := SOAP.Message.Parameters (Payload);
      Response  : SOAP.Message.Response.Object;
      R_Params  : SOAP.Parameters.List;
   begin
      if SOAPAction /= "Send_Command_With_Arguments" then
         return SOAP.Message.Response.Build
           (SOAP.Message.Response.Error.Build
              (SOAP.Message.Response.Error.Client,
               "SOAPAction " & SOAPAction & " in Send_Command_With_Arguments, "
                 & "Send_Command_With_Arguments expected."));
      end if;

      if Proc_Name /= "Send_Command_With_Arguments" then
         return SOAP.Message.Response.Build
           (SOAP.Message.Response.Error.Build
              (SOAP.Message.Response.Error.Client,
               "Found procedure " & Proc_Name & " in Send_Command_With_Arguments, "
                 & "Send_Command_With_Arguments expected."));
      end if;

      Response := SOAP.Message.Response.From (Payload);

      declare
         Command   : constant String
           := SOAP.Parameters.Get (Params, "Command");
         Arguments_String_Array_Array : constant SOAP.Types.SOAP_Array
           := SOAP.Parameters.Get (Params, "Arguments");
         Arguments : constant String_Array_Type
           := To_String_Array_Type (V (Arguments_String_Array_Array));
         Result : constant String
           := Send_Command_With_Arguments
                (Command,
                 Arguments);
      begin
         R_Params :=
           +SOAP.Types.S (Result, "Result");
      end;

      SOAP.Message.Set_Parameters (Response, R_Params);
      return SOAP.Message.Response.Build (Response);
   exception
      when E : SOAP.Types.Data_Error =>
         --  Here we have a problem with some parameters, return a SOAP error
         return SOAP.Message.Response.Build
           (SOAP.Message.Response.Error.Build
              (SOAP.Message.Response.Error.Client,
               "Parameter error in Send_Command_With_Arguments ("
                 & Exception_Message (E) & ")"));
      when O : others =>
         --  Here we have a problem with user's callback, return a SOAP error
         return SOAP.Message.Response.Build
           (SOAP.Message.Response.Error.Build
              (SOAP.Message.Response.Error.Client,
               "Error in Send_Command_With_Arguments ("
                 & Exception_Message (O) & ")"));
   end Send_Command_With_Arguments_CB;

end narval_aws_Service.Server;
