system_variable_list=[ ('audit_log_buffer_size', 'The size of the audit log buffer', False, []),
  ('audit_log_file', 'The name of the audit log file', False, []),
  ('audit_log_format', 'The audit log file format', False, []),
  ('audit_log_flush', 'Close and reopen the audit log file', True, []),
  ('audit_log_policy', 'The audit logging policy', True, []),
  ( 'audit_log_rotate_on_size',
    'Close and reopen the audit log file at a certain size',
    True,
    []),
  ('audit_log_strategy', 'The audit logging strategy', False, []),
  ( 'binlog_row_image',
    'Use full or minimal images when logging row changes. Allowed values are full, minimal, and noblob.',
    True,
    ['Logging/Binlog Options']),
  ( 'binlog_rows_query_log_events',
    'When TRUE, enables logging of rows query log events in row-based logging mode. FALSE by default. Do not enable when producing logs for pre-5.6.2 replication slaves or other readers.',
    True,
    []),
  ( 'rand_seed1',
    'Used to support replication of the RAND() function',
    True,
    []),
  ( 'rand_seed2',
    'Used to support replication of the RAND() function',
    True,
    []),
  ( 'slave_exec_mode',
    'Allows for switching between idempotent mode (key and some other errors suppressed) and strict mode; strict mode is the default, except for MySQL Cluster, where idempotent is always used',
    True,
    ['Replication/Slave']),
  ( 'auto_increment_increment',
    'AUTO_INCREMENT columns are incremented by this value',
    True,
    ['General/General', 'Replication/Master']),
  ( 'auto_increment_offset',
    'Offset added to AUTO_INCREMENT columns',
    True,
    ['General/General', 'Replication/Master']),
  ('autocommit', 'Sets the autocommit mode', True, ['General/Transactions']),
  ( 'automatic_sp_privileges',
    'Creating and dropping stored procedures alters ACLs',
    True,
    []),
  ( 'backup_elevation',
    'Enable or disable BACKUP DATABASE privilege elevation',
    False,
    ['General/Backup']),
  ( 'backup_history_log',
    'Enable or disable MySQL Backup history log',
    True,
    ['General/Backup']),
  ( 'backup_history_log_file',
    'Name of the MySQL Backup history log file',
    True,
    ['General/Backup']),
  ( 'backup_progress_log',
    'Enable or disable MySQL Backup progress log',
    True,
    ['General/Backup']),
  ( 'backup_progress_log_file',
    'Name of the MySQL Backup progress log file',
    True,
    ['General/Backup']),
  ( 'back_log',
    'The number of outstanding connection requests MySQL can have',
    False,
    ['Networking/General']),
  ( 'backup_wait_timeout',
    'Number of seconds DDL statements wait for BACKUP DATABASE or RESTORE before aborting',
    True,
    []),
  ( 'backupdir',
    'Default backup image file directory',
    True,
    ['General/Backup']),
  ( 'basedir',
    'Path to installation directory',
    False,
    ['General/Directories']),
  ('bdb-home', 'Berkeley DB home directory', False, []),
  ('bdb-lock-detect', 'Berkeley DB lock detect', False, []),
  ('bdb-logdir', 'Berkeley DB log file directory', False, []),
  ('bdb-shared-data', 'Start Berkeley DB in multi-process mode', False, []),
  ('bdb-tmpdir', 'Berkeley DB tempfile name', False, []),
  ( 'bdb_cache_size',
    'The buffer that is allocated to cache index and rows for BDB tables',
    False,
    []),
  ( 'bdb_max_lock',
    'The maximum number of locks that can be active for a BDB table',
    False,
    []),
  ( 'bdb_log_buffer_size',
    'The buffer that is allocated to cache index and rows for BDB tables',
    False,
    []),
  ( 'big-tables',
    'Allow big result sets by saving all temporary sets on file',
    True,
    []),
  ('bind-address', 'IP address or host name to bind to', False, []),
  ('binlog_checksum', 'Enable/disable binary log checksums', True, []),
  ( 'binlog_impossible_mode',
    'Controls what happens when the server cannot write to the binary log. Can assume one of two values: IGNORE_ERROR (default) means that the server logs the error but continues to process updates. ABORT_SERVER causes the server to shut down when the binary log is not writeable.',
    True,
    ['Logging/Binlog Options']),
  ( 'binlog_cache_size',
    'The size of the cache to hold the SQL statements for the binary log during a transaction',
    True,
    ['Logging/Binlog Options']),
  ( 'binlog_max_flush_queue_time',
    'How long to read transactions before flushing to binary log',
    True,
    []),
  ( 'binlog_order_commits',
    'Whether to commit in same order as writes to binary log',
    True,
    []),
  ( 'binlog_stmt_cache_size',
    'The size of the cache to hold nontransactional statements for the binary log during a transaction',
    True,
    ['Logging/Binlog Options']),
  ('binlog-format', 'Specifies the format of the binary log', True, []),
  ( 'binlog_direct_non_transactional_updates',
    'Causes updates using statement format to nontransactional engines to be written directly to binary log. See documentation before using.',
    True,
    ['Logging/Binlog Options']),
  ( 'block_encryption_mode',
    'Mode for block-based encryption algorithms',
    True,
    ['Security/Security']),
  ( 'bulk_insert_buffer_size',
    'Size of tree cache used in bulk insert optimization',
    True,
    ['Advanced/Various']),
  ('character-set-filesystem', 'Set the file system character set', True, []),
  ('character-set-server', 'Set the default character set', True, []),
  ('character-sets-dir', 'Directory where character sets are', False, []),
  ('character_set_client', 'Current client character set', True, []),
  ('character_set_connection', 'Current connection character set', True, []),
  ( 'character_set_database',
    'The character set used by the default database',
    True,
    []),
  ( 'character_set_system',
    'The character set used by the server for storing identifiers',
    False,
    []),
  ('character_set_results', 'Current result character set', True, []),
  ('collation-server', 'Set the default collation', True, []),
  ('collation_connection', 'The collation of the connection', True, []),
  ( 'collation_database',
    'The collation used by the default database',
    True,
    []),
  ( 'completion_type',
    'Default completion type',
    True,
    ['Advanced/Transactions']),
  ( 'concurrent_insert',
    'Use concurrent insert with MyISAM',
    True,
    ['MyISAM/General']),
  ( 'connect_timeout',
    "The number of seconds the mysqld server waits for a connect packet before responding with 'Bad handshake'",
    True,
    ['Networking/Timeout Settings']),
  ('core_file', 'Write core file on server crashes', False, []),
  ('daemon_memcached_enable_binlog', '', False, ['Other/Memcached']),
  ( 'daemon_memcached_engine_lib_name',
    'Specifies the shared library that implements the InnoDB memcached plugin',
    False,
    ['Other/Memcached']),
  ( 'daemon_memcached_engine_lib_path',
    'The path of the directory containing the shared library that implements the InnoDB memcached plugin',
    False,
    ['Other/Memcached']),
  ( 'daemon_memcached_option',
    'Space-separated options that are passed to the underlying memcached daemon on startup',
    False,
    ['Other/Memcached']),
  ( 'daemon_memcached_r_batch_size',
    'Specifies how many memcached read operations to perform before doing a COMMIT to start a new transaction',
    False,
    ['Other/Memcached']),
  ( 'daemon_memcached_w_batch_size',
    'Specifies how many memcached write operations to perform before doing a COMMIT to start a new transaction',
    False,
    ['Other/Memcached']),
  ('datadir', 'Path to the database root', False, ['General/Directories']),
  ('date_format', 'The DATE format (unused)', False, []),
  ('datetime_format', 'The DATETIME/TIMESTAMP format (unused)', False, []),
  ('character_set', 'The default character set', False, []),
  ('debug_sync', 'Interface to Debug Sync facility', True, []),
  ( 'default_authentication_plugin',
    'The default authentication plugin',
    False,
    ['Security/Authentication']),
  ( 'default_password_lifetime',
    'Age in days when passwords effectively expire',
    True,
    ['Security/Authentication']),
  ( 'default-storage-engine',
    'The default storage engine (table type) for tables',
    True,
    []),
  ( 'default_tmp_storage_engine',
    'The default storage engine (table type) for TEMPORARY tables',
    True,
    ['General/General']),
  ( 'default_week_format',
    'The default week format used by WEEK() functions',
    True,
    ['General/International']),
  ('delay-key-write', 'Type of DELAY_KEY_WRITE', True, []),
  ( 'delayed_insert_limit',
    'After inserting delayed_insert_limit rows, the INSERT DELAYED handler will check if there are any SELECT statements pending. If so, it allows these to execute before continuing',
    True,
    ['Advanced/Insert delayed settings']),
  ( 'delayed_insert_timeout',
    'How many seconds an INSERT DELAYED thread should wait for INSERT statements before terminating',
    True,
    ['Advanced/Insert delayed settings']),
  ( 'delayed_queue_size',
    'What size queue (in rows) should be allocated for handling INSERT DELAYED',
    True,
    ['Advanced/Insert delayed settings']),
  ( 'disable-gtid-unsafe-statements',
    'Obsolete: Replaced by --enforce-gtid-consistency in MySQL 5.6.9.',
    False,
    ['Replication/General']),
  ( 'disable_gtid_unsafe_statements',
    'Obsolete: Replaced by enforce_gtid_consistency in MySQL 5.6.9.',
    False,
    ['Replication/General']),
  ( 'disconnect_on_expired_password',
    'Whether the server disconnects clients with expired passwords if clients cannot handle such accounts',
    False,
    ['Security/Authentication']),
  ( 'div_precision_increment',
    "Scale of the result of '/' operator will be increased by this many digits",
    True,
    ['Advanced/General']),
  ( 'end_markers_in_json',
    'Whether optimizer JSON output should add end markers',
    True,
    []),
  ( 'enforce-gtid-consistency',
    'Prevents execution of statements that cannot be logged in a transactionally safe manner. These include CREATE TEMPORARY TABLE inside transactions and CREATE TABLE ... SELECT, as well as transactions or statements that update both transactional and nontransactional tables.',
    False,
    ['Replication/General']),
  ( 'enforce_gtid_consistency',
    'When true, execution of statements that cannot be logged in a transactionally safe manner is not permitted. Such statements include CREATE TEMPORARY TABLE inside transactions and CREATE TABLE ... SELECT, as well as transactions or statements that update both transactional and nontransactional tables. Read-only; set using --disable-gtid-unsafe-statements when starting the server.',
    False,
    ['Replication/General']),
  ( 'engine-condition-pushdown',
    'Push supported query conditions to the storage engine',
    True,
    []),
  ( 'eq_range_index_dive_limit',
    'The cutoff for switching from index dives to index statistics',
    True,
    ['Advanced/General']),
  ('error_count', 'Number of errors', False, []),
  ( 'event-scheduler',
    'Enable/disable and start/stop the event scheduler. Note that this variable underwent significant changes in behavior and permitted values in MySQL 5.1.11 and 5.1.12',
    True,
    []),
  ( 'executed_gtids_compression_period',
    'Compress gtid_executed table each time this many transactions have occurred. 0 means never compress this table. Applies only when binary logging is disabled.',
    True,
    []),
  ( 'expire_logs_days',
    'If nonzero, binary logs will be purged after expire_logs_days days; possible purges happen at startup and at binary log rotation',
    True,
    ['Logging/Advanced log options']),
  ( 'explicit_defaults_for_timestamp',
    'Whether TIMESTAMP columns are nullable and have DEFAULT NULL',
    False,
    ['General/SQL']),
  ('external_user', 'The external proxy user', False, []),
  ( 'flush',
    'Flush tables to disk between SQL statements',
    True,
    ['Advanced/General']),
  ( 'flush_time',
    'A dedicated thread is created to flush all tables at the given interval',
    True,
    ['Advanced/General']),
  ( 'foreign_key_checks',
    'If set to 1 (the default), foreign key constraints for InnoDB tables are checked.',
    True,
    []),
  ( 'ft_boolean_syntax',
    'List of operators for MATCH ... AGAINST ( ... IN BOOLEAN MODE)',
    True,
    ['MyISAM/Fulltext search']),
  ( 'ft_max_word_len',
    'The maximum length of the word to be included in a FULLTEXT index. Note: FULLTEXT indexes must be rebuilt after changing this variable',
    False,
    ['MyISAM/Fulltext search']),
  ( 'ft_min_word_len',
    'The minimum length of the word to be included in a FULLTEXT index. Note: FULLTEXT indexes must be rebuilt after changing this variable',
    False,
    ['MyISAM/Fulltext search']),
  ( 'ft_query_expansion_limit',
    'Number of best matches to use for query expansion',
    False,
    ['MyISAM/Fulltext search']),
  ( 'ft_stopword_file',
    'Use stopwords from this file instead of built-in list',
    False,
    ['MyISAM/Fulltext search']),
  ('general-log', 'Enable|disable general log', True, []),
  ( 'general_log_file',
    'Name of the general query log file',
    True,
    ['Logging/General']),
  ( 'group_concat_max_len',
    'The maximum length of the result of function group_concat',
    True,
    ['Advanced/Various']),
  ( 'gtid_done',
    'Obsolete: Replaced by gtid_executed in MySQL 5.6.9.',
    False,
    []),
  ( 'gtid_executed',
    'Global: All GTIDs in the binary log (global) or current transaction (session). Read-only.',
    False,
    []),
  ( 'gtid_lost',
    'Obsolete: Replaced by gtid_purged in MySQL 5.6.9.',
    False,
    []),
  ( 'gtid-mode',
    'ON enables GTIDs; OFF disables them. UPGRADE_STEP_1 and UPGRADE_STEP_2 are currently unsupported.',
    False,
    []),
  ('gtid_mode', 'Shows whether GTIDs are enabled. Read-only.', False, []),
  ( 'gtid_next',
    'Specifies the GTID for the next statement to execute. See documentation for details.',
    True,
    []),
  ( 'gtid_owned',
    'The set of GTIDs owned by this client (session), or by all clients, together with the thread ID of the owner (global). Read-only.',
    False,
    []),
  ( 'gtid_purged',
    'The set of all groups that have been purged from the binary log.',
    True,
    []),
  ( 'identity',
    'This variable is a synonym for the LAST_INSERT_ID variable. It exists for compatibility with other database systems',
    True,
    []),
  ('hostname', 'The name of the server host', False, []),
  ( 'host_cache_size',
    'The size of the host cache',
    True,
    ['General/Memory usage', 'Networking/Data / Memory size']),
  ('ignore-builtin-innodb', 'Ignore the built-in InnoDB', False, []),
  ( 'ignore_db_dirs',
    'Directories treated as nondatabase directories',
    False,
    []),
  ( 'init_connect',
    'Statements that are executed for each new connection',
    True,
    ['Advanced/General']),
  ('init-file', 'Read SQL statements from this file at startup', False, []),
  ( 'init_slave',
    'Command(s) that are executed when a slave connects to a master',
    True,
    ['Advanced/General', 'Replication/Slave']),
  ( 'innodb_adaptive_flushing',
    'Control InnoDB adaptive flushing of dirty pages',
    True,
    ['InnoDB/General']),
  ( 'innodb_adaptive_flushing_lwm',
    'Low water mark representing percentage of redo log capacity at which adaptive flushing is enabled.',
    True,
    ['InnoDB/General']),
  ( 'innodb_adaptive_hash_index',
    'Enable or disable InnoDB adaptive hash indexes',
    False,
    ['InnoDB/General']),
  ( 'innodb_adaptive_max_sleep_delay',
    'Allows InnoDB to automatically adjust the value of innodb_thread_sleep_delay up or down according to the current workload',
    True,
    ['InnoDB/General']),
  ( 'innodb_additional_mem_pool_size',
    'Size of a memory pool InnoDB uses to store data dictionary information and other internal data structures',
    False,
    ['InnoDB/Memory']),
  ( 'innodb_api_bk_commit_interval',
    'How often to auto-commit idle connections that use the InnoDB memcached interface, in seconds.',
    True,
    ['InnoDB/General']),
  ('innodb_api_disable_rowlock', '', False, ['InnoDB/General']),
  ( 'innodb_api_enable_binlog',
    'Lets you use the InnoDB memcached plugin with the MySQL binary log',
    False,
    ['InnoDB/General']),
  ( 'innodb_api_enable_mdl',
    'Locks the table used by the InnoDB memcached plugin, so that it cannot be dropped or altered by DDL through the SQL interface',
    False,
    ['InnoDB/General']),
  ( 'innodb_api_trx_level',
    'Lets you control the transaction isolation level on queries processed by the memcached interface',
    True,
    ['InnoDB/General']),
  ( 'innodb_autoextend_increment',
    'Data file autoextend increment in megabytes',
    True,
    ['InnoDB/General']),
  ( 'innodb_autoinc_lock_mode',
    'Set InnoDB auto-increment lock mode',
    False,
    ['InnoDB/General']),
  ( 'innodb_buffer_pool_awe_mem_mb',
    'If Windows AWE is used, the size in Megabytes of InnoDB buffer pool allocated from the AWE memory',
    False,
    ['InnoDB/Buffer pool']),
  ( 'innodb_buffer_pool_dump_at_shutdown',
    'Specifies whether to record the pages cached in the InnoDB buffer pool when the MySQL server is shut down, to shorten the warmup process at the next restart',
    True,
    ['InnoDB/Buffer pool']),
  ( 'innodb_buffer_pool_dump_now',
    'Immediately records the pages cached in the InnoDB buffer pool',
    True,
    ['InnoDB/Buffer pool']),
  ( 'innodb_buffer_pool_dump_pct',
    'Specifies the percentage of the most recently used pages for each buffer pool to read out and dump.',
    True,
    ['InnoDB/General']),
  ( 'innodb_buffer_pool_filename',
    'Specifies the file that holds the list of page numbers produced by innodb_buffer_pool_dump_at_shutdown or innodb_buffer_pool_dump_now',
    True,
    ['InnoDB/Buffer pool']),
  ( 'innodb_buffer_pool_load_abort',
    'Interrupts the process of restoring InnoDB buffer pool contents triggered by innodb_buffer_pool_load_at_startup or innodb_buffer_pool_load_now',
    True,
    ['InnoDB/Buffer pool']),
  ( 'innodb_buffer_pool_load_at_startup',
    'Specifies that, on MySQL server startup, the InnoDB buffer pool is automatically "warmed up" by loading the same pages it held at an earlier time',
    False,
    ['InnoDB/Buffer pool']),
  ( 'innodb_buffer_pool_load_now',
    'Immediately "warms up" the InnoDB buffer pool by loading a set of data pages, without waiting for a server restart',
    True,
    ['InnoDB/Buffer pool']),
  ( 'innodb_buffer_pool_instances',
    'Specifies how many parts the InnoDB buffer pool is divided into',
    False,
    ['InnoDB/Buffer pool', 'InnoDB/Memory']),
  ( 'innodb_buffer_pool_size',
    'The size of the memory buffer InnoDB uses to cache data and indexes of its tables',
    False,
    ['InnoDB/Buffer pool', 'InnoDB/Memory']),
  ( 'innodb_change_buffer_max_size',
    'Maximum size for the InnoDB change buffer, as a percentage of the total size of the buffer pool',
    True,
    ['InnoDB/General']),
  ( 'innodb_change_buffering',
    'Whether InnoDB performs insert buffering.',
    True,
    ['InnoDB/General']),
  ( 'innodb_checksum_algorithm',
    'Specifies how to generate and verify the checksum stored in each disk block of each InnoDB tablespace',
    True,
    ['InnoDB/General']),
  ( 'innodb_checksums',
    'Enable InnoDB checksums validation',
    False,
    ['InnoDB/General']),
  ( 'innodb_cmp_per_index_enabled',
    'Enables per-index compression-related statistics in the INFORMATION_SCHEMA.INNODB_CMP_PER_INDEX table',
    True,
    ['InnoDB/General']),
  ( 'innodb_commit_concurrency',
    'Helps in performance tuning in heavily concurrent environments',
    True,
    ['InnoDB/General']),
  ( 'innodb_compression_failure_threshold_pct',
    'Sets the cutoff point at which MySQL begins adding padding within compressed pages to avoid expensive compression failures',
    True,
    ['InnoDB/General']),
  ( 'innodb_compression_level',
    'Specifies the level of zlib compression to use for InnoDB compressed tables and indexes',
    True,
    ['InnoDB/General']),
  ( 'innodb_compression_pad_pct_max',
    'Specifies the maximum percentage that can be reserved as free space within each compressed page, to avoid compression failures when tightly packed data is recompressed',
    True,
    ['InnoDB/General']),
  ( 'innodb_concurrency_tickets',
    'Number of times a thread is allowed to enter InnoDB within the same SQL query after it has once got the ticket',
    True,
    ['InnoDB/General']),
  ( 'innodb_data_file_path',
    'Path to individual files and their sizes',
    False,
    ['InnoDB/Datafiles']),
  ( 'innodb_data_home_dir',
    'The common part for InnoDB table spaces',
    False,
    ['InnoDB/Datafiles']),
  ( 'innodb_disable_sort_file_cache',
    'Disable OS file system cache for merge-sort temporary files',
    True,
    ['InnoDB/General']),
  ( 'innodb_doublewrite',
    'Enable InnoDB doublewrite buffer',
    False,
    ['InnoDB/General']),
  ( 'innodb_extra_dirty_writes',
    'Whether to flush dirty buffer pages when the percentage of dirty pages is less than the maximum dirty percent',
    False,
    ['InnoDB/General']),
  ( 'innodb_fast_shutdown',
    'Speeds up the shutdown process of the InnoDB storage engine',
    True,
    ['InnoDB/Various']),
  ( 'innodb_file_format',
    'The format for new InnoDB tables',
    True,
    ['InnoDB/Datafiles']),
  ( 'innodb_file_format_check',
    'Whether InnoDB performs file format compatibility checking',
    True,
    ['InnoDB/Datafiles']),
  ( 'innodb_file_format_max',
    'The file format tag in the shared tablespace',
    True,
    ['InnoDB/Datafiles']),
  ( 'innodb_file_io_threads',
    'Number of file I/O threads in InnoDB',
    False,
    ['InnoDB/General']),
  ( 'innodb_file_per_table',
    'Stores each InnoDB table and its indexes in a separate .ibd file in the database directory',
    False,
    ['InnoDB/General']),
  ( 'innodb_flush_log_at_timeout',
    'Write and flush logs every N seconds',
    True,
    []),
  ( 'innodb_flush_log_at_trx_commit',
    'Set to 0 (write and flush once per second), 1 (write and flush at each commit) or 2 (write at commit, flush once per second)',
    True,
    ['InnoDB/Logfiles']),
  ( 'innodb_flush_method',
    'Specifies to flush data',
    False,
    ['InnoDB/Logfiles']),
  ( 'innodb_flush_neighbors',
    'Specifies whether flushing a page from the InnoDB buffer pool also flushes other dirty pages in the same extent',
    True,
    ['InnoDB/Logfiles']),
  ( 'innodb_flushing_avg_loops',
    'Number of iterations for which InnoDB keeps the previously calculated snapshot of the flushing state, controlling how quickly adaptive flushing responds to changing workloads',
    True,
    ['InnoDB/General']),
  ( 'innodb_force_load_corrupted',
    'Lets InnoDB load tables at startup that are marked as corrupted; use only during troubleshooting',
    False,
    ['InnoDB/General']),
  ( 'innodb_force_recovery',
    'Helps to save your data in case the disk image of the database becomes corrupt',
    False,
    ['InnoDB/General']),
  ( 'innodb_io_capacity',
    'The limit on the maximum number of I/O operations per second',
    False,
    ['InnoDB/General']),
  ( 'innodb_io_capacity_max',
    'The limit up to which InnoDB is allowed to extend the innodb_io_capacity setting in case of emergency',
    True,
    ['InnoDB/General']),
  ( 'innodb_large_prefix',
    'Enables longer keys for column prefix indexes',
    True,
    ['InnoDB/General']),
  ( 'innodb_lock_wait_timeout',
    'Timeout in seconds an InnoDB transaction may wait for a lock before a rollback occurs',
    False,
    ['InnoDB/General']),
  ( 'innodb_locks_unsafe_for_binlog',
    'Force InnoDB not to use next-key locking. Instead use only row-level locking',
    False,
    ['InnoDB/General']),
  ( 'innodb_log_arch_dir',
    'Where full logs should be archived',
    False,
    ['InnoDB/Logfiles']),
  ('innodb_log_archive', 'Unused', False, ['InnoDB/Logfiles']),
  ( 'innodb_log_buffer_size',
    'The size of the buffer which InnoDB uses to write log to the log files on disk',
    False,
    ['InnoDB/Logfiles']),
  ( 'innodb_log_compressed_pages',
    'Specifies whether images of re-compressed pages are stored in InnoDB redo logs',
    True,
    ['InnoDB/Logfiles']),
  ( 'innodb_log_file_size',
    'Size of each log file in a log group',
    False,
    ['InnoDB/Logfiles']),
  ( 'innodb_log_files_in_group',
    'Number of InnoDB log files in the log group',
    False,
    ['InnoDB/Logfiles']),
  ( 'innodb_log_group_home_dir',
    'Path to InnoDB log files',
    False,
    ['InnoDB/Logfiles']),
  ( 'innodb_lru_scan_depth',
    'Influences the algorithms and heuristics for the flush operation for the InnoDB buffer pool',
    True,
    ['InnoDB/General']),
  ( 'innodb_max_dirty_pages_pct',
    'Percentage of dirty pages allowed in bufferpool',
    True,
    ['InnoDB/General']),
  ( 'innodb_max_dirty_pages_pct_lwm',
    'Low water mark representing percentage of dirty pages where preflushing is enabled to control the dirty page ratio',
    True,
    ['InnoDB/General']),
  ( 'innodb_max_merged_io',
    'The maximum number of background I/O requests to merge to issue a larger I/O request',
    False,
    ['InnoDB/General']),
  ( 'innodb_max_purge_lag',
    'Desired maximum length of the purge queue (0 = no limit)',
    True,
    ['InnoDB/General']),
  ( 'innodb_max_purge_lag_delay',
    'Specifies the maximum delay in milliseconds for the formula calculated using the innodb_max_purge_lag configuration option',
    True,
    ['InnoDB/General']),
  ( 'innodb_ft_aux_table',
    'Specifies which InnoDB table with a FULLTEXT index to examine by querying several innodb_ft_* tables in the information_schema',
    True,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_enable_diag_print',
    'Whether to enable additional full-text search diagnostic output',
    True,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_enable_stopword',
    'During creation of an InnoDB FULLTEXT index, omits stopwords from the search index',
    True,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_num_word_optimize',
    'Number of words to process during each OPTIMIZE TABLE operation on an InnoDB FULLTEXT index',
    True,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_result_cache_limit',
    'The InnoDB FULLTEXT search query result cache limit.',
    True,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_server_stopword_table',
    'Specifies a table holding a list of stopwords for InnoDB FULLTEXT indexes, which overrides the default stopword list and can be overridden by innodb_ft_user_stopword_table',
    True,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_user_stopword_table',
    'Specifies a table holding a list of stopwords for InnoDB FULLTEXT indexes, which overrides the default stopword list and also innodb_ft_server_stopword_table',
    True,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_max_token_size',
    'Maximum length of words that are stored in an InnoDB FULLTEXT index',
    False,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_min_token_size',
    'Minimum length of words that are stored in an InnoDB FULLTEXT index',
    False,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_cache_size',
    'Size of the cache that holds a parsed document in memory while creating an InnoDB FULLTEXT index',
    False,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_sort_pll_degree',
    'Number of threads used to create an InnoDB FULLTEXT index in parallel, when building a search index for a large table',
    False,
    ['InnoDB/Fulltext search']),
  ( 'innodb_ft_total_cache_size',
    'The total memory allocated for the InnoDB FULLTEXT search index cache.',
    False,
    ['InnoDB/Fulltext search']),
  ( 'innodb_mirrored_log_groups',
    'Obsolete setting; do not use',
    False,
    ['InnoDB/Logfiles']),
  ( 'innodb_monitor_disable',
    'Turns off one or more counters in the information_schema.innodb_metrics table',
    True,
    ['InnoDB/General']),
  ( 'innodb_monitor_enable',
    'Turns on one or more counters in the information_schema.innodb_metrics table',
    True,
    ['InnoDB/General']),
  ( 'innodb_monitor_reset',
    'Resets to zero the count value for one or more counters in the information_schema.innodb_metrics table',
    True,
    ['InnoDB/General']),
  ( 'innodb_monitor_reset_all',
    'Resets all values (minimum, maximum, and so on) for one or more counters in the information_schema.innodb_metrics table',
    True,
    ['InnoDB/General']),
  ( 'innodb_old_blocks_pct',
    'Percentage of the InnoDB buffer pool to reserve for old blocks',
    True,
    ['InnoDB/General']),
  ( 'innodb_old_blocks_time',
    'How long (in ms) blocks must remain in old end of InnoDB buffer pool before moving to new end',
    True,
    ['InnoDB/General']),
  ( 'innodb_online_alter_log_max_size',
    'Specifies an upper limit on the size of the temporary log files used during online DDL operations for InnoDB tables.',
    True,
    ['InnoDB/General', 'InnoDB/Logfiles']),
  ( 'innodb_open_files',
    'The maximum number of files that InnoDB keeps open at the same time',
    False,
    ['InnoDB/General']),
  ( 'innodb_page_cleaners',
    'The number of page cleaner threads.',
    False,
    ['InnoDB/Memory']),
  ( 'innodb_page_size',
    'Specifies the page size for all InnoDB tablespaces in an instance',
    False,
    ['InnoDB/Memory']),
  ( 'innodb_print_all_deadlocks',
    'During shutdown, prints information about all InnoDB deadlocks to the server error log',
    True,
    ['InnoDB/General']),
  ( 'innodb_purge_batch_size',
    'Specifies the number of InnoDB redo logs that trigger a purge operation.',
    True,
    ['InnoDB/General']),
  ( 'innodb_purge_threads',
    'Specifies whether the InnoDB purge operation should be performed in one or more separate threads. By default, this operation is part of the InnoDB master thread.',
    False,
    ['InnoDB/General']),
  ( 'innodb_random_read_ahead',
    'Enables the random read-ahead technique for optimizing InnoDB I/O',
    True,
    ['InnoDB/General']),
  ( 'innodb_read_ahead_threshold',
    'The sensitivity of InnoDB linear read-ahead',
    True,
    ['InnoDB/General']),
  ( 'innodb_read_io_threads',
    'The number of background I/O threads for read prefetch requests',
    False,
    ['InnoDB/General']),
  ( 'innodb_read_only',
    'Starts the server in read-only mode',
    False,
    ['InnoDB/General']),
  ( 'innodb_replication_delay',
    'The slave server replication thread delay',
    True,
    ['InnoDB/General']),
  ( 'innodb_rollback_on_timeout',
    'Roll back entire transaction on transaction timeout, not just last statement',
    False,
    ['InnoDB/General']),
  ( 'innodb_rollback_segments',
    'Defines how many of the rollback segments in the system tablespace that InnoDB uses within a transaction',
    True,
    ['InnoDB/General']),
  ( 'innodb_stats_auto_recalc',
    'Causes InnoDB to automatically recalculate persistent statistics after the data in a table is changed substantially',
    True,
    ['InnoDB/General']),
  ( 'innodb_stats_method',
    'Specifies how InnoDB index statistics collection code should treat NULLs',
    True,
    ['InnoDB/General']),
  ( 'innodb_stats_on_metadata',
    'Enable or disable InnoDB table statistics updates for metadata statements',
    False,
    ['InnoDB/General']),
  ( 'innodb_stats_persistent',
    'Turns on the InnoDB persistent statistics feature',
    True,
    ['InnoDB/General']),
  ( 'innodb_stats_persistent_sample_pages',
    'The number of pages to sample in each InnoDB index, when the persistent statistics feature is also enabled',
    True,
    ['InnoDB/General']),
  ( 'innodb_stats_transient_sample_pages',
    'The number of pages to sample in each InnoDB index, when the persistent statistics feature is turned off (the default setting)',
    True,
    ['InnoDB/General']),
  ( 'innodb_status_output',
    'Used to enable or disable periodic output for the standard InnoDB Monitor. Also used in combination with innodb_status_output_locks to enable and disable periodic output for the InnoDB Lock Monitor.',
    True,
    ['InnoDB/General']),
  ( 'innodb_status_output_locks',
    'Used to enable or disable periodic output for the standard InnoDB Lock Monitor. innodb_status_output must also be enabled to produce periodic output for the InnoDB Lock Monitor.',
    True,
    ['InnoDB/General']),
  ( 'innodb_support_xa',
    'Enable InnoDB support for the XA two-phase commit',
    True,
    ['InnoDB/General']),
  ( 'innodb_sync_array_size',
    'Splits an internal data structure used to coordinate threads, for higher concurrency in workloads with large numbers of waiting threads',
    False,
    ['InnoDB/General']),
  ( 'innodb_sync_spin_loops',
    'Count of spin-loop rounds in InnoDB mutexes',
    True,
    ['InnoDB/General']),
  ( 'innodb_sort_buffer_size',
    'Specifies the size of a buffer used for sorting data during creation of an InnoDB index',
    False,
    ['InnoDB/General', 'InnoDB/Memory']),
  ( 'innodb_spin_wait_delay',
    'The maximum delay between polls for a spin lock',
    True,
    ['InnoDB/General']),
  ( 'innodb_stats_sample_pages',
    'The number of index pages to sample for index distribution statistics',
    True,
    ['InnoDB/General']),
  ( 'innodb_strict_mode',
    'Whether InnoDB returns errors rather than warnings for exceptional conditions',
    True,
    ['InnoDB/General']),
  ( 'innodb_table_locks',
    'Enable InnoDB locking in LOCK TABLES',
    True,
    ['InnoDB/General']),
  ( 'innodb_temp_data_file_path',
    'Defines the path to temporary tablespace data files and their sizes.',
    False,
    ['InnoDB/General']),
  ( 'innodb_thread_concurrency',
    'Sets the maximum number of threads allowed inside InnoDB. Value 0 will disable the thread throttling',
    True,
    ['InnoDB/General']),
  ( 'innodb_thread_concurrency_timer_based',
    'Whether to use the lock-free method of handling thread concurrency',
    False,
    ['InnoDB/General']),
  ( 'innodb_thread_sleep_delay',
    'Time, in microseconds, that an InnoDB thread sleeps before joining InnoDB queue. Value 0 disables the sleep behavior',
    True,
    ['InnoDB/General']),
  ( 'innodb_undo_directory',
    'The relative or absolute directory path where InnoDB creates separate tablespaces for the undo logs; typically used to place those logs on a different storage device',
    False,
    ['InnoDB/General', 'InnoDB/Logfiles']),
  ( 'innodb_undo_logs',
    'Defines how many of the rollback segments in the system tablespace that InnoDB uses within a transaction; replaces the innodb_rollback_segments setting',
    True,
    ['InnoDB/General', 'InnoDB/Logfiles']),
  ( 'innodb_undo_tablespaces',
    'The number of undo logs to place in each tablespace created by a non-zero innodb_undo_logs setting',
    False,
    ['InnoDB/General']),
  ( 'innodb_use_legacy_cardinality_algorithm',
    'Whether to use legacy InnoDB index cardinality calculation algorithm',
    True,
    ['InnoDB/General']),
  ( 'innodb_use_native_aio',
    'Specifies whether to use the Linux asynchronous I/O subsystem',
    False,
    ['InnoDB/General']),
  ( 'innodb_use_sys_malloc',
    'Whether InnoDB uses the OS or its own memory allocator',
    False,
    ['InnoDB/General']),
  ('innodb_version', 'The version of InnoDB', False, []),
  ( 'innodb_write_io_threads',
    'The number of background I/O threads for writing dirty pages from the buffer cache to disk',
    False,
    ['InnoDB/General']),
  ( 'insert_id',
    'Set the value to be used by the following INSERT or ALTER TABLE statement when inserting an AUTO_INCREMENT value',
    True,
    []),
  ( 'interactive_timeout',
    'The number of seconds the server waits for activity on an interactive connection before closing it',
    True,
    ['Networking/Timeout Settings']),
  ( 'join_buffer_size',
    'The size of the buffer that is used for full joins',
    True,
    ['General/Memory usage']),
  ( 'join_cache_level',
    'How join buffers are used',
    True,
    ['General/Memory usage']),
  ( 'keep_files_on_create',
    'Do not overwrite existing .MYD/.MYI files in default database directory',
    True,
    ['MyISAM/General']),
  ( 'key_buffer_size',
    'The size of the buffer used for index blocks for MyISAM tables',
    True,
    ['MyISAM/General']),
  ( 'key_cache_age_threshold',
    'This characterizes the number of hits a hot block has to be untouched until it is considered aged enough to be downgraded to a warm block. This specifies the percentage ratio of that number of hits to the total number of blocks in key cache',
    True,
    ['MyISAM/General']),
  ( 'key_cache_block_size',
    'The default size of key cache blocks',
    True,
    ['Advanced/Various']),
  ( 'key_cache_division_limit',
    'The minimum percentage of warm blocks in key cache',
    True,
    ['Advanced/Various']),
  ( 'language',
    'Client error messages in given language. May be given as a full path',
    False,
    ['General/International']),
  ('large-pages', 'Enable support for large pages', False, []),
  ( 'large_page_size',
    'The size of memory pages when large page support is enabled',
    False,
    []),
  ('large_files_support', 'Whether large files are supported', False, []),
  ('last_insert_id', 'The most recent AUTO_INCREMENT value', True, []),
  ('lc-messages', 'The locale for error messages', True, []),
  ( 'lc-messages-dir',
    'The directory where error messages are located',
    False,
    []),
  ( 'lc_time_names',
    'The locale that controls the language used to display day and month names',
    True,
    []),
  ( 'local_infile',
    'Whether LOCAL is supported for LOAD DATA INFILE statements',
    True,
    []),
  ( 'lock_wait_timeout',
    'Timeout for metadata locks',
    True,
    ['General/General']),
  ('log', 'Log connections and queries to file', False, ['Logging/General']),
  ( 'log-backup-output',
    'The destination for MySQL Backup history and progress log output. Syntax: log-backup-output[=value[,value...]], where "value" could be TABLE, FILE, or NONE',
    True,
    []),
  ('log-bin', 'Specifies binary log file name', False, []),
  ('log_bin', 'Whether the binary log is enabled', False, []),
  ( 'log_bin_basename',
    'Complete path to the binary log, including the filename',
    False,
    []),
  ( 'log_bin_index',
    'File that holds the names for last binary log files',
    False,
    []),
  ( 'log-bin-trust-function-creators',
    'If equal to 0 (the default), then when --log-bin is used, creation of a stored function is allowed only to users having the SUPER privilege and only if the function created does not break binary logging',
    True,
    []),
  ( 'log-bin-trust-routine-creators',
    '(deprecated) Use log-bin-trust-function-creators',
    True,
    []),
  ( 'log-bin-use-v1-row-events',
    'Use version 1 binary log row events',
    False,
    ['Logging/Binlog Options']),
  ( 'log_bin_use_v1_row_events',
    'Shows whether server is using version 1 binary log row events',
    False,
    ['Logging/Binlog Options']),
  ('log-error', 'Error log file', False, []),
  ( 'log-output',
    'The destination for general query log and slow query log output',
    True,
    []),
  ( 'log-queries-not-using-indexes',
    'Log queries that are executed without benefit of any index to the slow query log if it is open',
    True,
    []),
  ( 'log_error_verbosity',
    'Error logging verbosity level',
    True,
    ['Logging/General']),
  ('log_timestamps', 'Log timestamp format', True, ['Logging/General']),
  ( 'log_throttle_queries_not_using_indexes',
    'Throttle write rate to slow log for queries not using indexes slow query log if it is open',
    True,
    []),
  ( 'log-slave-updates',
    'This option tells the slave to log the updates performed by its SQL thread to its own binary log',
    False,
    ['Logging/General']),
  ( 'log_slave_updates',
    'Tells whether the slave should log the updates performed by its SQL thread to its own binary log. Read-only; set using the --log-slave-updates server option.',
    False,
    ['Logging/General']),
  ( 'log_slow_admin_statements',
    'Log slow OPTIMIZE, ANALYZE, ALTER and other administrative statements to the slow query log if it is open',
    True,
    []),
  ( 'log-slow-queries',
    'Whether to log slow queries. Logging defaults to hostname-slow.log file. Must be enabled to activate other slow query log options',
    False,
    []),
  ( 'log_slow_slave_statements',
    'Cause slow statements as executed by the slave to be written to the slow query log',
    True,
    []),
  ('log-warnings', 'Log some noncritical warnings to the log file', True, []),
  ( 'long_query_time',
    'Log all queries that have taken more than long_query_time seconds to execute to file',
    True,
    ['Logging/Slow query log options']),
  ( 'low-priority-updates',
    'INSERT/DELETE/UPDATE has lower priority than selects',
    True,
    []),
  ( 'lower_case_table_names',
    'If set to 1, table names are stored in lowercase on disk and table names will be case insensitive. Should be set to 2 if you are using a case-insensitive file system.',
    False,
    ['General/System']),
  ( 'master_info_repository',
    "Whether to write master status information and replication I/O thread location in the master's binary logs to a file or table.",
    True,
    ['Replication/Master']),
  ( 'master_verify_checksum',
    'Cause master to read checksums from binary log.',
    True,
    []),
  ( 'max_allowed_packet',
    'Max packet length to send to/receive from server',
    True,
    ['Networking/Data / Memory size']),
  ( 'max_binlog_cache_size',
    'Can be used to restrict the total size used to cache a multi-statement transaction',
    True,
    ['Logging/Binlog Options']),
  ( 'max_binlog_size',
    'Binary log will be rotated automatically when the size exceeds this value',
    True,
    ['Logging/Binlog Options']),
  ( 'max_binlog_stmt_cache_size',
    'Can be used to restrict the total size used to cache all nontransactional statements during a transaction',
    True,
    ['Logging/Binlog Options']),
  ( 'max_connect_errors',
    'Number of interrupted connections from a host before this host is blocked from further connections',
    True,
    ['Networking/Advanced']),
  ( 'max_connections',
    'The number of simultaneous clients allowed',
    True,
    ['Networking/Advanced']),
  ( 'max_delayed_threads',
    "Don't start more than this number of threads to handle INSERT DELAYED statements. If set to zero, which means INSERT DELAYED is not used",
    True,
    ['Advanced/Insert delayed settings']),
  ( 'max_error_count',
    'Max number of errors/warnings to store for a statement',
    True,
    ['Advanced/General']),
  ( 'max_heap_table_size',
    "Don't allow creation of heap tables bigger than this",
    True,
    ['Advanced/Various']),
  ( 'max_insert_delayed_threads',
    'This variable is a synonym for max_delayed_threads',
    True,
    []),
  ( 'max_join_size',
    'Joins that are probably going to read more than max_join_size records return an error',
    True,
    ['Advanced/Various']),
  ( 'max_length_for_sort_data',
    'Max number of bytes in sorted records',
    True,
    ['Advanced/Various']),
  ( 'max_long_data_size',
    'Max size of parameter values that mysql_stmt_send_long_data() can send',
    False,
    ['General/General']),
  ( 'max_prepared_stmt_count',
    'Maximum number of prepared statements in the server',
    True,
    ['Advanced/General']),
  ( 'max_relay_log_size',
    'If nonzero, relay log is rotated automatically when its size exceeds this value. If zero, the size at which rotation occurs is determined by the value of max_binlog_size.',
    True,
    ['Replication/Relay Log']),
  ( 'max_seeks_for_key',
    'Limit assumed max number of seeks when looking up rows based on a key',
    True,
    ['Advanced/Various']),
  ( 'max_sort_length',
    'The number of bytes to use when sorting data values',
    True,
    ['Advanced/Various']),
  ( 'max_sp_recursion_depth',
    'Maximum stored procedure recursion depth',
    True,
    ['Advanced/General']),
  ('max_statement_time', 'Statement timeout value', True, ['General/General']),
  ( 'max_user_connections',
    'The maximum number of active connections for a single user (0 = no limit)',
    True,
    ['Networking/Advanced']),
  ( 'max_write_lock_count',
    'After this many write locks, allow some read locks to run in between',
    True,
    ['Advanced/Various']),
  ( 'memlock',
    'Lock the mysqld process in memory',
    False,
    ['Advanced/General']),
  ('metadata_locks_cache_size', 'Size of the metadata locks cache', False, []),
  ( 'metadata_locks_hash_instances',
    'Number of metadata lock hashes',
    False,
    []),
  ('locked_in_memory', 'Whether mysqld is locked in memory', False, []),
  ('license', 'Type of license for the server', False, []),
  ( 'min-examined-row-limit',
    'Queries examining fewer than this number of rows are not logged to slow query log',
    True,
    []),
  ( 'myisam_recover_options',
    'The value of the --myisam-recover option',
    False,
    []),
  ( 'multi_range_count',
    'The maximum number of ranges to send to a table handler at once during range selects',
    True,
    ['Advanced/Various']),
  ( 'myisam_data_pointer_size',
    'Default pointer size to be used for MyISAM tables',
    True,
    ['MyISAM/Advanced Settings']),
  ( 'myisam_max_extra_sort_file_size',
    'Deprecated option',
    False,
    ['MyISAM/Advanced Settings']),
  ( 'myisam_max_sort_file_size',
    "Don't use the fast sort index method to create index if the temporary file would get bigger than this",
    True,
    ['MyISAM/Advanced Settings']),
  ( 'myisam_mmap_size',
    'The maximum amount of memory to use for memory mapping compressed MyISAM files.',
    False,
    ['MyISAM/Advanced Settings']),
  ( 'myisam_repair_threads',
    'Number of threads to use when repairing MyISAM tables. The value of 1 disables parallel repair',
    True,
    ['MyISAM/Advanced Settings']),
  ( 'myisam_sort_buffer_size',
    'The buffer that is allocated when sorting the index when doing a REPAIR or when creating indexes with CREATE INDEX or ALTER TABLE',
    True,
    ['MyISAM/Advanced Settings']),
  ( 'myisam_stats_method',
    'Specifies how MyISAM index statistics collection code should treat NULLs',
    True,
    ['MyISAM/Advanced Settings']),
  ( 'myisam_use_mmap',
    'Use memory mapping for reading and writing MyISAM tables',
    True,
    ['MyISAM/Advanced Settings']),
  ( 'ndb_optimization_delay',
    'Sets the number of milliseconds to wait between processing sets of rows by OPTIMIZE TABLE on NDB tables.',
    True,
    []),
  ( 'ndb_table_temporary',
    'NDB tables are not persistent on disk: no schema files are created and the tables are not logged',
    True,
    []),
  ( 'ndb_table_no_logging',
    'NDB tables created when this setting is enabled are not checkpointed to disk (although table schema files are created). The setting in effect when the table is created with or altered to use NDBCLUSTER persists for the lifetime of the table.',
    True,
    []),
  ( 'ndb_autoincrement_prefetch_sz',
    'NDB auto-increment prefetch size',
    True,
    ['Other/NDB']),
  ( 'ndb-batch-size',
    'The size (in bytes) to use for NDB transaction batches',
    False,
    []),
  ( 'ndb-blob-read-batch-bytes',
    'Specifies the size in bytes that large BLOB reads should be batched into. 0 = no limit.',
    True,
    []),
  ( 'ndb-blob-write-batch-bytes',
    'Specifies the size in bytes that large BLOB writes should be batched into. 0 = no limit.',
    True,
    []),
  ( 'ndb_cache_check_time',
    'The number of milliseconds between checks of cluster SQL nodes made by the MySQL query cache',
    True,
    ['Other/NDB']),
  ( 'ndb-cluster-connection-pool',
    'The number of connections to the cluster used by MySQL',
    False,
    []),
  ( 'ndb_use_copying_alter_table',
    'Use copying ALTER TABLE operations in MySQL Cluster',
    False,
    []),
  ( 'ndb_join_pushdown',
    'Enables pushing down of joins to data nodes',
    False,
    []),
  ( 'ndb_extra_logging',
    'Controls logging of MySQL Cluster schema, connection, and data distribution events in the MySQL error log',
    True,
    ['Other/NDB']),
  ( 'ndb_force_send',
    'Forces sending of buffers to NDB immediately, without waiting for other threads',
    True,
    ['Other/NDB']),
  ( 'ndb_use_exact_count',
    'Use exact row count when planning queries',
    True,
    []),
  ( 'ndb-log-apply-status',
    'Cause a MySQL server acting as a slave to log mysql.ndb_apply_status updates received from its immediate master in its own binary log, using its own server ID. Effective only if the server is started with the --ndbcluster option.',
    False,
    []),
  ( 'ndb_log_bin',
    'Write updates to NDB tables in the binary log. Effective only if binary logging is enabled with --log-bin.',
    True,
    []),
  ( 'ndb_log_binlog_index',
    'Insert mapping between epochs and binary log positions into the ndb_binlog_index table. Defaults to ON. Effective only if binary logging is enabled on the server.',
    True,
    []),
  ( 'ndb-log-orig',
    'Log originating server id and epoch in mysql.ndb_binlog_index table.',
    False,
    []),
  ( 'ndb-log-transaction-id',
    'Write NDB transaction IDs in the binary log. Requires --log-bin-v1-events=OFF.',
    False,
    []),
  ( 'ndb_log_transaction_id',
    'Whether NDB transaction IDs are written into the binary log. (Read-only.)',
    False,
    []),
  ( 'ndb_log_updated_only',
    'Log complete rows (ON) or updates only (OFF)',
    True,
    ['Other/NDB']),
  ( 'ndb-log-update-as-write',
    'Toggles logging of updates on the master between updates (OFF) and writes (ON)',
    True,
    []),
  ( 'ndb-log-empty-epochs',
    'When enabled, causes epochs in which there were no changes to be written to the ndb_apply_status and ndb_binlog_index tables, even when --log-slave-updates is enabled.',
    True,
    ['Other/NDB']),
  ( 'ndb_log_empty_epochs',
    'When enabled, epochs in which there were no changes are written to the ndb_apply_status and ndb_binlog_index tables, even when log_slave_updates is enabled.',
    True,
    ['Other/NDB']),
  ( 'ndb_recv_thread_cpu_mask',
    'CPU mask for locking receiver threads to specific CPUs; specified as hexadecimal. See documentation for details.',
    True,
    []),
  ( 'ndb-wait-connected',
    'Time (in seconds) for the MySQL server to wait for connection to cluster management and data nodes before accepting MySQL client connections.',
    False,
    []),
  ( 'ndb-wait-setup',
    'Time (in seconds) for the MySQL server to wait for NDB engine setup to complete.',
    False,
    []),
  ( 'ndbinfo_database',
    'The name used for the NDB information database; read only.',
    False,
    []),
  ('ndbinfo_max_bytes', 'Used for debugging only.', True, []),
  ('ndbinfo_max_rows', 'Used for debugging only.', True, []),
  ( 'ndbinfo_offline',
    'Put the ndbinfo database into offline mode, in which no rows are returned from tables or views.',
    True,
    []),
  ( 'ndbinfo_show_hidden',
    'Whether to show ndbinfo internal base tables in the mysql client. The default is OFF.',
    True,
    []),
  ( 'ndbinfo_table_prefix',
    "The prefix to use for naming ndbinfo internal base tables. Defaults to 'ndb$'.",
    True,
    []),
  ( 'ndbinfo_version',
    'The version of the ndbinfo engine; read only.',
    False,
    []),
  ( 'net_buffer_length',
    'Buffer length for TCP/IP and socket communication',
    True,
    ['Networking/Data / Memory size']),
  ( 'net_read_timeout',
    'Number of seconds to wait for more data from a connection before aborting the read',
    True,
    ['Networking/Timeout Settings']),
  ( 'net_retry_count',
    'Number of times to retry an interrupted read or write on a communication port before giving up',
    True,
    ['Networking/Advanced']),
  ( 'net_write_timeout',
    'Number of seconds to wait for a block to be written to a connection before aborting the write',
    True,
    ['Networking/Timeout Settings']),
  ( 'new',
    "Use very new, possibly 'unsafe' functions",
    True,
    ['Advanced/Various']),
  ('old-alter-table', 'Use old, nonoptimized alter table', True, []),
  ( 'old_passwords',
    'Type of password encryption method',
    True,
    ['Security/Authentication']),
  ( 'open-files-limit',
    'If this is not 0, then mysqld will use this value to reserve file descriptors to use with setrlimit()',
    False,
    []),
  ( 'optimizer_join_cache_level',
    'How join buffers are used',
    True,
    ['Performance/Optimizer']),
  ( 'optimizer_prune_level',
    'Controls the heuristic(s) applied during query optimization to prune less-promising partial plans from the optimizer search space',
    True,
    ['Performance/Optimizer']),
  ( 'optimizer_search_depth',
    'Maximum depth of search performed by the query optimizer',
    True,
    ['Performance/Optimizer']),
  ( 'optimizer_switch',
    'Enable control over which optimizations to use',
    True,
    ['Performance/Optimizer']),
  ('optimizer_trace', 'Control optimizer tracing', True, []),
  ('optimizer_trace_features', 'Control optimizer tracing', True, []),
  ('optimizer_trace_limit', 'Control optimizer tracing', True, []),
  ('optimizer_trace_max_mem_size', 'Control optimizer tracing', True, []),
  ('optimizer_trace_offset', 'Control optimizer tracing', True, []),
  ( 'optimizer_use_mrr',
    'How the optimizer reads multiple ranges of index tuples',
    True,
    []),
  ( 'performance_schema',
    'Whether Performance Schema is enabled',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_accounts_size',
    'The number of rows in the accounts table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_digests_size',
    'The number of rows in the events_statements_summary_by_digest table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_events_stages_history_long_size',
    'The number of rows in the events_stages_history_long table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_events_stages_history_size',
    'The number of rows per thread in the events_stages_history table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_events_statements_history_long_size',
    'The number of rows in the events_statements_history_long table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_events_statements_history_size',
    'The number of rows per thread in the events_statements_history table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_events_transactions_history_long_size',
    'The number of rows in the events_transactions_history_long table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_events_transactions_history_size',
    'The number of rows per thread in the events_transactions_history table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_events_waits_history_long_size',
    'The number of rows in the events_waits_history_long table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_events_waits_history_size',
    'The number of rows per thread in the events_waits_history table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_hosts_size',
    'The number of rows in the hosts table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_cond_classes',
    'The maximum number of condition instruments',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_cond_instances',
    'The maximum number of instrumented condition objects',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_file_classes',
    'The maximum number of file instruments',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_file_handles',
    'The maximum number of opened file objects',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_file_instances',
    'The maximum number of instrumented file objects',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_memory_classes',
    'The maximum number of memory instruments',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_metadata_locks',
    'The maximum number of metadata locks to track',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_mutex_classes',
    'The maximum number of mutex instruments',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_mutex_instances',
    'The maximum number of instrumented mutex objects',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_prepared_statements_instances',
    'The number of rows in the prepared_statements_instances table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_program_instances',
    'The maximum number of stored programs for statistics',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_rwlock_classes',
    'The maximum number of rwlock instruments',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_rwlock_instances',
    'The maximum number of instrumented rwlock objects',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_stage_classes',
    'The maximum number of stage instruments',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_socket_classes',
    'The maximum number of socket instruments',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_socket_instances',
    'The maximum number of instrumented socket objects',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_statement_classes',
    'The maximum number of statement instruments',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_statement_stack',
    'The maximum stored program nesting for statistics',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_table_handles',
    'The maximum number of opened table objects',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_table_instances',
    'The maximum number of instrumented table objects',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_thread_classes',
    'The maximum number of thread instruments',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_max_thread_instances',
    'The maximum number of instrumented thread objects',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_session_connect_attrs_size',
    'The size of the connection attribute strings buffer per thread',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_setup_actors_size',
    'The number of rows in the setup_actors table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_setup_objects_size',
    'The number of rows in the setup_objects table',
    False,
    ['Performance/Performance Schema']),
  ( 'performance_schema_users_size',
    'The number of rows in the users table',
    False,
    ['Performance/Performance Schema']),
  ('pid-file', 'Process ID file used by mysqld_safe', False, []),
  ('plugin_dir', 'Directory for plugins', False, ['General/Directories']),
  ('port', 'Port number to use for connection', False, ['Networking/General']),
  ( 'preload_buffer_size',
    'The size of the buffer that is allocated when preloading indexes',
    True,
    ['Advanced/Various']),
  ('profiling', 'Enable or disable statement profiling', True, []),
  ( 'profiling_history_size',
    'How many statements to maintain profiling information for',
    True,
    ['General/Features', 'Performance/General']),
  ('proxy_user', 'The user proxied by the external proxy user', False, []),
  ('pseudo_slave_mode', 'For internal server use', True, []),
  ('pseudo_thread_id', 'For internal server use', True, []),
  ( 'query_alloc_block_size',
    'Allocation block size for query parsing and execution',
    True,
    ['Advanced/Various', 'General/Memory usage']),
  ( 'query_cache_limit',
    "Don't cache results that are bigger than this",
    True,
    ['Performance/Query cache']),
  ( 'query_cache_min_res_unit',
    'Minimal size of unit in which space for results is allocated (last unit will be trimmed after writing all result data)',
    True,
    ['Performance/Query cache']),
  ( 'query_cache_size',
    'The memory allocated to store results from old queries',
    True,
    ['Performance/Query cache']),
  ('query_cache_type', 'Query cache type', True, ['Performance/Query cache']),
  ( 'query_cache_wlock_invalidate',
    'Invalidate queries in query cache on LOCK for write',
    True,
    ['Performance/Query cache']),
  ( 'query_prealloc_size',
    'Persistent buffer for query parsing and execution',
    True,
    ['Advanced/Various']),
  ( 'range_alloc_block_size',
    'Allocation block size for storing ranges during optimization',
    True,
    ['Advanced/Various']),
  ( 'read_buffer_size',
    'Each thread that does a sequential scan for a MyISAM table allocates a buffer of this size for each table it scans',
    True,
    ['Advanced/Various']),
  ( 'read_only',
    'Make all nontemporary tables read only',
    True,
    ['Security/Security']),
  ( 'read_rnd_buffer_size',
    'When reading rows from a MyISAM table in sorted order after a sort, the rows are read through this buffer to avoid a disk seeks. If not set, then it is set to the value of record_buffer.',
    True,
    ['Advanced/Various']),
  ('relay-log', 'The location and base name to use for relay logs', False, []),
  ( 'relay_log_basename',
    'Complete path to the relay log, including the filename',
    False,
    []),
  ( 'relay-log-index',
    'The location and name to use for the file that keeps a list of the last relay logs',
    False,
    ['Replication/Relay Log']),
  ( 'relay_log_info_file',
    'The name of the file in which the slave records information about the relay logs.',
    False,
    ['Replication/Relay Log']),
  ( 'relay_log_info_repository',
    "Whether to write the replication SQL thread's location in the relay logs to a file or a table.",
    True,
    []),
  ( 'relay_log_index',
    'The name of the relay log index file.',
    False,
    ['Replication/Relay Log']),
  ( 'relay_log_purge',
    'Determines whether relay logs are purged',
    True,
    ['Replication/Relay Log']),
  ( 'relay_log_recovery',
    'Whether automatic recovery of relay log files from master at startup is enabled; must be enabled for a crash-proof slave.',
    True,
    ['Replication/Relay Log']),
  ( 'relay_log_space_limit',
    'Maximum space to use for all relay logs',
    False,
    ['Replication/Relay Log']),
  ( 'report-host',
    'Host name or IP of the slave to be reported to the master during slave registration',
    False,
    []),
  ( 'report-password',
    'An arbitrary password that the slave server should report to the master. Not the same as the password for the MySQL replication user account',
    False,
    []),
  ( 'report-port',
    'Port for connecting to slave reported to the master during slave registration',
    False,
    []),
  ( 'report-user',
    'An arbitrary user name that a slave server should report to the master. Not the same as the name used with the MySQL replication user account.',
    False,
    []),
  ( 'restore_disables_events',
    'Whether RESTORE disables restored events',
    True,
    ['Advanced/General']),
  ( 'restore_elevation',
    'Enable or disable RESTORE privilege elevation',
    False,
    ['Advanced/General']),
  ( 'restore_precheck',
    'Whether RESTORE performs privilege checking before restoring',
    True,
    ['Advanced/General']),
  ('rpl_recovery_rank', 'Not used; removed in later versions', True, []),
  ( 'rpl_semi_sync_master_enabled',
    'Whether semisynchronous replication is enabled on master',
    True,
    []),
  ('rpl_semi_sync_master_reply_log_file_pos', 'Internal use', True, []),
  ( 'rpl_semi_sync_master_timeout',
    'Number of milliseconds to wait for slave acknowledgment',
    True,
    []),
  ( 'rpl_semi_sync_master_trace_level',
    'The semisynchronous replication debug trace level on the master',
    True,
    []),
  ( 'rpl_semi_sync_master_wait_for_slave_count',
    'How many slave acknowledgments the master must receive per transaction before proceeding',
    True,
    []),
  ( 'rpl_semi_sync_master_wait_no_slave',
    'Whether master waits for timeout even with no slaves',
    True,
    []),
  ( 'rpl_semi_sync_master_wait_point',
    'The wait point for slave transaction receipt acknowledgment',
    True,
    []),
  ( 'rpl_semi_sync_slave_enabled',
    'Whether semisynchronous replication is enabled on slave',
    True,
    []),
  ( 'rpl_semi_sync_slave_trace_level',
    'The semisynchronous replication debug trace level on the slave',
    True,
    []),
  ( 'rpl_stop_slave_timeout',
    'Set the number of seconds that STOP SLAVE waits before timing out.',
    True,
    ['Replication/Slave']),
  ( 'safe-show-database',
    'Deprecated option; use GRANT SHOW DATABASES instead',
    True,
    []),
  ( 'secure-auth',
    'Disallow authentication for accounts that have old (pre-4.1) passwords',
    True,
    []),
  ( 'secure-backup-file-priv',
    'Limit BACKUP DATABASE and RESTORE to files in a single directory',
    False,
    []),
  ( 'secure-file-priv',
    'Limit LOAD_FILE(), LOAD DATA, and SELECT ... INTO OUTFILE to files in specified directory',
    False,
    []),
  ( 'server-id',
    'Uniquely identifies the server instance in the community of replication partners. Must be set to a value greater than 0 to enable replication.',
    True,
    []),
  ( 'server-id-bits',
    'Sets the number of least significant bits in the server_id actually used for identifying the server, permitting NDB API applications to store application data in the most significant bits. server_id must be less than 2 to the power of this value.',
    False,
    []),
  ( 'server_uuid',
    "The server's globally unique ID, automatically (re)generated at server start",
    False,
    []),
  ( 'session_track_state_change',
    'Whether to track session state changes',
    True,
    ['General/General']),
  ( 'session_track_schema',
    'Whether to track schema changes',
    True,
    ['General/General']),
  ( 'session_track_system_variables',
    'Session variables to track changes for',
    True,
    ['General/General']),
  ( 'sha256_password_private_key_path',
    'The SHA2 password plugin private key path name',
    False,
    []),
  ( 'sha256_password_public_key_path',
    'The SHA2 password plugin public key path name',
    False,
    []),
  ( 'skip_external_locking',
    'Skip system (external) locking',
    False,
    ['General/System']),
  ( 'skip-name-resolve',
    "Don't resolve host names. All host names are IPs or 'localhost'",
    False,
    []),
  ('skip-networking', "Don't allow connection with TCP/IP", False, []),
  ('skip-show-database', 'Do not allow SHOW DATABASE statements', False, []),
  ('skip-sync-bdb-logs', 'Disables synchronous BDB log flushes', False, []),
  ( 'slave_allow_batching',
    'Turns update batching on and off for a replication slave',
    True,
    ['Replication/Slave']),
  ( 'slave-load-tmpdir',
    'The location where the slave should put its temporary files when replicating a LOAD DATA INFILE statement',
    False,
    []),
  ( 'slave-skip-errors',
    'Tells the slave thread to continue replication when a query returns an error from the provided list',
    False,
    []),
  ( 'slave_checkpoint_group',
    'Maximum number of transactions processed by a multi-threaded slave before a checkpoint operation is called to update progress status.',
    True,
    ['Replication/Slave']),
  ( 'slave_checkpoint_period',
    'Update progress status of multi-threaded slave and flush relay log info to disk after this number of milliseconds.',
    True,
    ['Replication/Slave']),
  ( 'slave_compressed_protocol',
    'Use compression on master/slave protocol',
    True,
    ['Replication/Slave']),
  ( 'slave_max_allowed_packet',
    'Maximum size, in bytes, of a packet that can be sent from a replication master to a slave; overrides max_allowed_packet.',
    True,
    []),
  ( 'slave-net-timeout',
    'Number of seconds to wait for more data from a master/slave connection before aborting the read',
    True,
    []),
  ( 'slave_parallel_type',
    'Tells the slave to use database partioning (DATABASE) or information (LOGICAL_CLOCK) from master to parallelize transactions. The default is DATABASE.',
    True,
    []),
  ( 'slave_parallel_workers',
    'Number of worker threads for executing events in parallel. Set to 0 (the default) to disable slave multi-threading.',
    True,
    []),
  ( 'slave_pending_jobs_size_max',
    'Maximum size of slave worker queues holding events not yet applied.',
    True,
    []),
  ( 'slave_rows_search_algorithms',
    'Determines search algorithms used for slave update batching. Any 2 or 3 from the list INDEX_SEARCH, TABLE_SCAN, HASH_SCAN; the default is TABLE_SCAN,INDEX_SCAN.',
    True,
    []),
  ( 'slave_sql_verify_checksum',
    'Cause slave to examine checksums when reading from relay log.',
    True,
    []),
  ( 'slave_transaction_retries',
    'Number of times the slave SQL thread will retry a transaction in case it failed with a deadlock or elapsed lock wait timeout, before giving up and stopping',
    True,
    ['Replication/Slave']),
  ( 'slave_type_conversions',
    'Controls type conversion mode on replication slave. Value is a list of zero or more elements from the list: ALL_LOSSY, ALL_NON_LOSSY. Set to an empty string to disallow type conversions between master and slave.',
    False,
    ['Replication/Slave']),
  ('slow-query-log', 'Enable|disable slow query log', True, []),
  ( 'slow_query_log_file',
    'Name of the slow query log file',
    True,
    ['Logging/Slow query log options']),
  ( 'slow_launch_time',
    'If creating the thread takes longer than this value (in seconds), the Slow_launch_threads counter will be incremented',
    True,
    ['Advanced/Thread specific settings']),
  ( 'socket',
    'Socket file to use for connection',
    False,
    ['Networking/General']),
  ( 'sort_buffer_size',
    'Each thread that needs to do a sort allocates a buffer of this size',
    True,
    ['General/Memory usage']),
  ('sql-mode', 'Set the SQL server mode', True, []),
  ( 'sql_auto_is_null',
    'If set to 1, you can find the last inserted row for a table that contains an AUTO_INCREMENT column by using the following construct: WHERE auto_increment_column IS NULL',
    True,
    []),
  ( 'sql_big_selects',
    'If set to 0, MySQL aborts SELECT statements that are likely to take a very long time to execute',
    True,
    []),
  ( 'sql_big_tables',
    'This variable is deprecated, and is mapped to big_tables',
    True,
    []),
  ( 'sql_buffer_result',
    'Forces the result to be put into a temporary table',
    True,
    []),
  ('sql_log_bin', 'Toggle binary logging', True, []),
  ( 'sql_log_off',
    'If set to 1, no logging is done to the general query log for this client',
    True,
    []),
  ( 'sql_log_update',
    'This variable is deprecated, and is mapped to SQL_LOG_BIN',
    True,
    []),
  ( 'sql_low_priority_updates',
    'This variable is deprecated, and is mapped to low_priority_updates',
    True,
    []),
  ( 'sql_max_join_size',
    'This variable is deprecated, and is mapped to max_join_size',
    True,
    []),
  ('sql_notes', 'If set to 1, warnings of Note level are recorded', True, []),
  ( 'sql_quote_show_create',
    'If set to 1 the server quotes identifiers for SHOW CREATE TABLE and SHOW CREATE DATABASE statements',
    True,
    []),
  ( 'sql_safe_updates',
    'If set to 1, MySQL aborts UPDATE or DELETE statements that do not use a key in the WHERE clause or a LIMIT clause',
    True,
    []),
  ( 'sql_select_limit',
    'The maximum number of rows to return from SELECT statements',
    True,
    []),
  ( 'sql_slave_skip_counter',
    'The number of events from the master that a slave server should skip. Not compatible with GTID replication.',
    True,
    []),
  ( 'sql_warnings',
    'This variable controls whether single-row INSERT statements produce an information string if warnings occur',
    True,
    []),
  ( 'ssl-ca',
    'The path to a file that contains a list of trusted SSL CAs',
    False,
    []),
  ( 'ssl-capath',
    'The path to a directory that contains trusted SSL CA certificates in PEM format',
    False,
    []),
  ('ssl-cert', 'X509 cert in PEM format (implies --ssl)', False, []),
  ('ssl-cipher', 'SSL cipher to use (implies --ssl)', False, []),
  ( 'ssl-crl',
    'The path to a file that contains certificate revocation lists',
    False,
    []),
  ( 'ssl-crlpath',
    'The path to a directory that contains certificate revocation list files',
    False,
    []),
  ('ssl-key', 'X509 key in PEM format (implies --ssl)', False, []),
  ('storage_engine', 'The default storage engine', True, []),
  ( 'stored_program_cache',
    'Sets a "soft" upper limit for number of cached stored routines per connection. Stored procedures and stored functions are cached separately; this variable sets the size for both of these.',
    True,
    ['General/General']),
  ( 'sync-bdb-logs',
    'Synchronously flush Berkeley DB logs. Enabled by default',
    False,
    []),
  ( 'sync_binlog',
    'Synchronously flush binary log to disk after every #th event',
    True,
    ['Logging/Binlog Options']),
  ( 'sync_frm',
    'Sync .frm to disk on create. Enabled by default',
    True,
    ['Advanced/General']),
  ( 'sync_master_info',
    'Synchronize master.info to disk after every #th event.',
    True,
    ['Replication/Master']),
  ( 'sync_relay_log',
    'Synchronize relay log to disk after every #th event.',
    True,
    ['Replication/Relay Log']),
  ( 'sync_relay_log_info',
    'Synchronize relay.info file to disk after every #th event.',
    True,
    ['Replication/Relay Log']),
  ('system_time_zone', 'The server system time zone', False, []),
  ('table_cache', 'The number of open tables for all threads', True, []),
  ( 'table_definition_cache',
    'The number of table definitions that can be stored in the definition cache.',
    True,
    ['Performance/General']),
  ('table_lock_wait_timeout', 'Currently unused', True, []),
  ( 'table_open_cache',
    'The number of open tables for all threads',
    True,
    ['Performance/General']),
  ( 'table_open_cache_instances',
    'The number of open tables cache instances',
    False,
    ['Performance/General']),
  ('table_type', 'A synonym for storage_engine', True, []),
  ( 'thread_cache_size',
    'How many threads we should keep in a cache for reuse',
    True,
    ['Advanced/Thread specific settings']),
  ( 'thread_concurrency',
    'Permits the application to give the threads system a hint for the desired number of threads that should be run at the same time',
    False,
    ['Advanced/Thread specific settings']),
  ( 'thread_handling',
    'The thread-handling model',
    False,
    ['Advanced/Thread specific settings']),
  ( 'thread_pool_size',
    'The number of thread groups in the thread pool',
    False,
    ['Advanced/Thread specific settings']),
  ( 'thread_stack',
    'The stack size for each thread',
    False,
    ['Advanced/Thread specific settings']),
  ( 'thread_pool_algorithm',
    'The thread pool algorithm',
    False,
    ['Advanced/Thread specific settings']),
  ( 'thread_pool_high_priority_connection',
    'Whether the current session is high priority',
    True,
    ['Advanced/Thread specific settings']),
  ( 'thread_pool_max_unused_threads',
    'The maximum permitted number of unused threads',
    True,
    ['Advanced/Thread specific settings']),
  ( 'thread_pool_prio_kickup_timer',
    'How long before a statement is moved to high-priority execution',
    True,
    ['Advanced/Thread specific settings']),
  ( 'thread_pool_stall_limit',
    'How long before a statement is defined as stalled',
    True,
    ['Advanced/Thread specific settings']),
  ('time_format', 'The TIME format (unused)', False, []),
  ( 'timed_mutexes',
    'Specify whether to time mutexes (only InnoDB mutexes are currently supported)',
    True,
    ['InnoDB/General']),
  ('timestamp', 'Change the value returned by NOW()', True, []),
  ( 'tmp_table_size',
    'If an in-memory temporary table exceeds this size, MySQL will automatically convert it to an on-disk MyISAM table',
    True,
    ['Advanced/Various']),
  ('tmpdir', 'Path for temporary files', False, ['General/Directories']),
  ( 'transaction_alloc_block_size',
    'Allocation block size for transactions to be stored in binary log',
    True,
    ['Advanced/Transactions']),
  ( 'transaction_allow_batching',
    'Allows batching of statements within a transaction. Disable AUTOCOMMIT to use.',
    True,
    []),
  ( 'transaction_prealloc_size',
    'Persistent buffer for transactions to be stored in binary log',
    True,
    ['Advanced/Transactions']),
  ('tx_isolation', 'The default transaction isolation level', True, []),
  ('tx_read_only', 'Default transaction access mode', True, []),
  ( 'unique_checks',
    'If set to 1 (the default), uniqueness checks for secondary indexes in InnoDB tables are performed',
    True,
    []),
  ( 'updatable_views_with_limit',
    'This variable controls whether updates to a view can be made when the view does not contain all columns of the primary key',
    True,
    ['Advanced/General']),
  ( 'validate_password_dictionary_file',
    'validate_password dictionary file',
    False,
    ['Security/Validate password']),
  ( 'validate_password_length',
    'validate_password required password length',
    True,
    ['Security/Validate password']),
  ( 'validate_password_mixed_case_count',
    'validate_password required number of uppercase/lowercase characters',
    True,
    ['Security/Validate password']),
  ( 'validate_password_number_count',
    'validate_password required number of digit characters',
    True,
    ['Security/Validate password']),
  ('validate_password_policy', 'validate_password password policy', True, []),
  ( 'validate_password_special_char_count',
    'validate_password required number of special characters',
    True,
    ['Security/Validate password']),
  ( 'validate_user_plugins',
    'Whether to perform additional validation of user plugins',
    False,
    []),
  ('version', 'Output version information and exit', False, []),
  ( 'wait_timeout',
    'The number of seconds the server waits for activity on a connection before closing it',
    True,
    ['Networking/Timeout Settings']),
  ('warning_count', 'The number of warnings', False, []),
  ('debug', 'Output debug log', True, ['Advanced/General']),
  ( 'prepared_stmt_count',
    'The current number of prepared statements',
    False,
    []),
  ( 'version_comment',
    'This variable contains the value of the --with-comment option specified when building MySQL',
    False,
    []),
  ( 'version_compile_machine',
    'The type of machine or architecture on which MySQL was built',
    False,
    []),
  ( 'version_compile_os',
    'The type of operating system on which MySQL was built',
    False,
    []),
  ('bdb-data-direct', 'bdb-data-direct', False, []),
  ('bdb-log-direct', 'bdb-log-direct', False, []),
  ('have_archive', 'Whether mysqld supports archive tables', False, []),
  ('have_bdb', 'Is Berkeley DB supported', False, []),
  ( 'have_blackhole_engine',
    'Whether mysqld supports BLACKHOLE tables',
    False,
    []),
  ( 'have_community_features',
    'Whether statement profiling capability is available',
    False,
    []),
  ('have_compress', 'Availability of the zlib compression library', False, []),
  ('have_crypt', 'Availability of the crypt() system call', False, []),
  ('have_csv', 'Whether mysqld supports csv tables', False, []),
  ( 'have_dynamic_loading',
    'Whether mysqld supports dynamic loading of plugins',
    False,
    []),
  ('have_example_engine', 'Whether mysqld supports EXAMPLE tables', False, []),
  ( 'have_federated_engine',
    'Whether mysqld supports FEDERATED tables',
    False,
    []),
  ('have_geometry', 'Whether mysqld supports spatial data types', False, []),
  ('have_innodb', 'Whether mysqld supports InnoDB tables', False, []),
  ('have_isam', 'Whether mysqld supports isam tables', False, []),
  ('have_merge_engine', 'Whether mysqld supports merge tables', False, []),
  ( 'have_ndbcluster',
    'Whether mysqld supports NDB Cluster tables (set by --ndbcluster option)',
    False,
    []),
  ('have_openssl', 'Whether mysqld supports SSL connections', False, []),
  ('have_partitioning', 'Whether mysqld supports partitioning', False, []),
  ('have_partition_engine', 'Whether mysqld supports partitioning', False, []),
  ( 'have_profiling',
    'Whether statement profiling capability is available',
    False,
    []),
  ('have_query_cache', 'Whether mysqld supports query cache', False, []),
  ('have_raid', 'Whether mysqld supports the raid option', False, []),
  ( 'have_row_based_replication',
    'Shows whether row-based replication is supported',
    False,
    []),
  ( 'have_rtree_keys',
    'YES if RTREE indexes are available, NO if not. (These are used for spatial indexes in MyISAM tables.)',
    False,
    []),
  ('have_ssl', 'Whether mysqld supports SSL connections', False, []),
  ('have_symlink', 'Is symbolic link support enabled', False, []),
  ( 'named_pipe',
    'Whether the server supports connections over named pipes',
    False,
    []),
  ( 'ndb-deferred-constraints',
    'Specifies that constraint checks on unique indexes (where these are supported) should be deferred until commit time. Not normally needed or used; for testing purposes only.',
    True,
    ['Other/NDB']),
  ( 'ndb_deferred_constraints',
    'Specifies that constraint checks should be deferred (where these are supported). Not normally needed or used; for testing purposes only.',
    True,
    ['Other/NDB']),
  ( 'ndb-distribution',
    'Default distribution for new tables in NDBCLUSTER (KEYHASH or LINHASH, default is KEYHASH)',
    True,
    ['Other/NDB']),
  ( 'ndb_distribution',
    'Default distribution for new tables in NDBCLUSTER (KEYHASH or LINHASH, default is KEYHASH)',
    True,
    ['Other/NDB']),
  ( 'ndb_use_transactions',
    'Forces NDB to use a count of records during SELECT COUNT(*) query planning to speed up this type of query',
    True,
    ['Other/NDB']),
  ( 'shared_memory',
    'Whether the server allows shared-memory connections',
    False,
    []),
  ( 'shared_memory_base_name',
    'The name of shared memory to use for shared-memory connections',
    False,
    []),
  ( 'innodb_log_write_ahead_size',
    'The write-ahead block size for the redo log.',
    True,
    ['InnoDB/Logfiles']),
  ( 'innodb_optimize_fulltext_only',
    'Makes the OPTIMIZE TABLE statement for an InnoDB table process the newly added, deleted, and updated token data for a FULLTEXT index, rather than reorganizing the data in the clustered index of the table',
    True,
    ['InnoDB/Fulltext search', 'InnoDB/General']),
  ( 'old',
    'Cause the server to revert to certain behaviors present in older versions',
    False,
    ['General/General']),
  ( 'protocol_version',
    'The version of the client/server protocol used by the MySQL server',
    False,
    []),
  ( 'lower_case_file_system',
    'This variable describes the case sensitivity of file names on the file system',
    False,
    ['General/System']),
  ('time_zone', 'The current time zone.', True, ['General/International']),
  ( 'falcon_checkpoint_schedule',
    'Sets the frequency that in-memory structures are synchronized to disk',
    True,
    []),
  ( 'falcon_debug_mask',
    'Sets the log information written to the standard output by the Falcon engine in the event of an error',
    True,
    []),
  ( 'falcon_debug_server',
    'Specifies whether the debug server should be enabled.',
    False,
    []),
  ('falcon_disable_fsync', 'Disables the periodic fsync operation.', True, []),
  ('falcon_checksums', 'Enable Falcon checksum validation', True, []),
  ( 'falcon_index_chill_threshold',
    'Number of megabytes of pending index data that should be stored until the data is flushed to the serial log',
    True,
    []),
  ( 'falcon_initial_allocation',
    'Initial size of a Falcon tablespace file when created',
    True,
    []),
  ( 'falcon_max_transaction_backlog',
    'falcon_max_transaction_backlog',
    True,
    []),
  ( 'falcon_page_cache_size',
    'Size of the memory cache (in bytes) for pages from the tablespace file',
    False,
    []),
  ( 'falcon_page_size',
    'Size of the pages (in bytes) used to store information within the tablespace',
    False,
    []),
  ( 'falcon_record_chill_threshold',
    'Number of megabytes of pending record data stored before flushing the records to the serial log',
    True,
    []),
  ( 'falcon_record_memory_max',
    'Maximum amount of memory (in bytes) that will be allocated for caching record data',
    True,
    []),
  ( 'falcon_record_scavenge_floor',
    'Percentage of falcon_record_scavenge_threshold that will be retained in the record cache after a scavenge',
    True,
    []),
  ( 'falcon_record_scavenge_threshold',
    'Percentage of falcon_record_memory_max that will cause the scavenger thread to start removing old generations of records from the record cache',
    True,
    []),
  ('falcon_scavenge_schedule', 'Record scavenging threshold', False, []),
  ( 'falcon_serial_log_buffers',
    'Memory windows (1MB each) allocated for the Falcon serial log',
    False,
    []),
  ( 'falcon_serial_log_dir',
    'Location for the Falcon serial log files',
    False,
    []),
  ( 'falcon_use_sectorcache',
    'Use the sector cache for reading blocks from disk',
    False,
    []),
  ('falcon_use_supernodes', 'Use index supernodes', False, []),
  ( 'falcon_use_deferred_index_hash',
    'Use a deferred index hash lookup',
    False,
    []),
  ( 'falcon_consistent_read',
    'Sets the repeatable read isolation mode',
    True,
    []),
  ('falcon_gopher_threads', 'Sets the number of gopher threads', False, []),
  ('falcon_io_threads', 'Number of asynchronous I/O threads', True, []),
  ( 'falcon_large_blob_threshold',
    'Blobs smaller than this value are stored in data pages not blob pages',
    False,
    []),
  ( 'falcon_lock_wait_timeout',
    'Number of seconds Falcon will force one transaction to wait on another',
    True,
    []),
  ( 'falcon_serial_log_priority',
    'Set the priority for writing the Falcon serial log',
    True,
    []),
  ('maria-block-size', 'Sets the block size for Maria tables', False, []),
  ( 'maria-checkpoint-interval',
    'Sets the interval between automatic checkpoints',
    True,
    []),
  ( 'maria-log-file-size',
    'Sets the size of each of the Maria log files',
    True,
    []),
  ( 'maria-log-purge-type',
    'Sets the mode for purging Maria log files',
    True,
    []),
  ( 'maria-max-sort-file-size',
    'The maximum size of an external sort file',
    True,
    []),
  ( 'maria-page-checksum',
    'Sets the default mode for page checksums',
    True,
    []),
  ('maria-pagecache-age-threshold', 'Sets the pagecache age', True, []),
  ( 'maria-pagecache-buffer-size',
    'Sets the buffer size for data and index pages',
    False,
    []),
  ( 'maria-pagecache-division-limit',
    'The minimum percentage of warm blocks in the page cache',
    True,
    []),
  ( 'maria-repair-threads',
    'Number of threads to be used when repairing tables',
    True,
    []),
  ( 'maria-sort-buffer-size',
    'Sets the sort buffer size for indexes',
    True,
    []),
  ('maria-stats-method', 'Sets the statistics collection method', True, []),
  ( 'maria-sync-log-dir',
    'Controls the synchronization of the directory after a log file has been extended or created',
    True,
    []),
  ( 'maria-recover',
    'Force recovery of Maria tables without the log file',
    True,
    []),
  ( 'falcon_support_xa',
    'Enables two-phase commit for Falcon tables',
    False,
    [])]



status_variable_list=[ ( 'Aborted_connects',
    'The number of failed attempts to connect to the MySQL server',
    False,
    ['Networking/Stats']),
  ( 'Binlog_cache_disk_use',
    'The number of transactions that used a temporary file instead of the binary log cache',
    False,
    ['Binlog']),
  ( 'Binlog_stmt_cache_disk_use',
    'The number of nontransactional statements that used a temporary file instead of the binary log statement cache',
    False,
    ['Binlog']),
  ( 'Binlog_cache_use',
    'The number of transactions that used the temporary binary log cache',
    False,
    ['Binlog']),
  ( 'Binlog_stmt_cache_use',
    'The number of statements that used the temporary binary log statement cache',
    False,
    ['Binlog']),
  ( 'Bytes_received',
    'The number of bytes received from all clients',
    False,
    ['Networking/Stats']),
  ( 'Bytes_sent',
    'The number of bytes sent to all clients',
    False,
    ['Networking/Stats']),
  ( 'Com_admin_commands',
    'Count of admin statements',
    False,
    ['Commands/Admin']),
  ( 'Com_alter_db',
    'Count of ALTER DATABASE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_alter_db_upgrade',
    'Count of ALTER DATABASE ... UPGRADE DATA DIRECTORY NAMEstatements',
    False,
    ['Commands/DDL']),
  ( 'Com_alter_event',
    'Count for ALTER EVENT statements',
    False,
    ['Commands/DDL']),
  ( 'Com_alter_function',
    'Count of ALTER FUNCTION statements',
    False,
    ['Commands/DDL']),
  ( 'Com_alter_procedure',
    'Count of ALTER PROCEDURE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_alter_server',
    'Count of ALTER SERVER statements',
    False,
    ['Commands/DDL']),
  ( 'Com_alter_table',
    'Count of ALTER TABLE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_alter_tablespace',
    'Count of ALTER TABLESPACE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_alter_user',
    'Count of ALTER USER statements',
    False,
    ['Commands/Admin']),
  ('Com_analyze', 'Count of ANALYZE statements', False, ['Commands/General']),
  ( 'Com_assign_to_keycache',
    'Count of CACHE INDEX statements',
    False,
    ['Commands/General']),
  ('Com_backup', 'Count of BACKUP DATABASE statements', False, []),
  ('Com_backup_table', 'Count of BACKUP TABLE statements', False, []),
  ('Com_begin', 'Count of BEGIN statements', False, ['Commands/Transaction']),
  ( 'Com_binlog',
    'Count of BINLOG statements',
    False,
    ['Binlog', 'Commands/General']),
  ( 'Com_call_procedure',
    'Number of calls to stored procedures',
    False,
    ['Commands/DML']),
  ( 'Com_change_db',
    'Count of CHANGE DATABASE statements',
    False,
    ['Commands/General']),
  ( 'Com_change_master',
    'Count of CHANGE MASTER statements',
    False,
    ['Commands/Admin']),
  ('Com_check', 'Count of CHECK statements', False, ['Commands/Admin']),
  ( 'Com_checksum',
    'Count of CHECKSUM statements',
    False,
    ['Commands/General']),
  ('Com_commit', 'Count of COMMIT statements', False, ['Commands/General']),
  ( 'Com_create_db',
    'Count of CREATE DATABASE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_create_event',
    'Count of CREATE EVENT statements',
    False,
    ['Commands/DDL']),
  ( 'Com_create_function',
    'Count of CREATE FUNCTION statements',
    False,
    ['Commands/DDL']),
  ( 'Com_create_index',
    'Count of CREATE INDEX statements',
    False,
    ['Commands/DDL']),
  ( 'Com_create_procedure',
    'Count of CREATE PROCEDURE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_create_server',
    'Count of CREATE SERVER statements',
    False,
    ['Commands/DDL']),
  ( 'Com_create_table',
    'Count of CREATE TABLE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_create_trigger',
    'Count of CREATE TRIGGER statements',
    False,
    ['Commands/DDL']),
  ( 'Com_create_udf',
    'Count of CREATE FUNCTION (UDF) statements',
    False,
    ['Commands/Admin']),
  ( 'Com_create_view',
    'Count of CREATE VIEW statements',
    False,
    ['Commands/DDL']),
  ( 'Com_change_repl_filter',
    'Count of CHANGE REPLICATION FILTER statements',
    False,
    []),
  ( 'Com_dealloc_sql',
    'Count of DEALLOCATE PREPARE statements',
    False,
    ['Commands/DML']),
  ('Com_delete', 'Count of DELETE statements', False, ['Commands/DML']),
  ( 'Com_delete_multi',
    'Count of multiple table DELETE statements',
    False,
    ['Commands/DML']),
  ('Com_do', 'Count of DO statements', False, ['Commands/DML']),
  ( 'Com_drop_db',
    'Count of DROP DATABASE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_drop_event',
    'Count of DROP EVENT statements',
    False,
    ['Commands/DDL']),
  ( 'Com_drop_function',
    'Count of DROP FUNCTION statements',
    False,
    ['Commands/DDL']),
  ( 'Com_drop_index',
    'Count of DROP INDEX statements',
    False,
    ['Commands/DDL']),
  ( 'Com_drop_procedure',
    'Count of DROP PROCEDURE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_drop_server',
    'Count of DROP SERVER statements',
    False,
    ['Commands/DDL']),
  ( 'Com_drop_table',
    'Count of DROP TABLE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_drop_trigger',
    'Count of DROP TRIGGER statements',
    False,
    ['Commands/DDL']),
  ('Com_drop_user', 'Count of DROP USER statements', False, ['Commands/DDL']),
  ('Com_drop_view', 'Count of DROP_VIEW statements', False, ['Commands/DDL']),
  ( 'Com_empty_query',
    'Count of empty statements',
    False,
    ['Commands/General']),
  ( 'Com_execute_sql',
    'Count of EXECUTE statements',
    False,
    ['Commands/General']),
  ('Com_flush', 'Count of FLUSH statements', False, ['Commands/General']),
  ( 'Com_get_diagnostics',
    'Count of GET DIAGNOSTICS statements',
    False,
    ['Commands/Admin']),
  ('Com_grant', 'Count of GRANT statements', False, ['Commands/Admin']),
  ( 'Com_ha_close',
    'Count of HANDLER CLOSE statements',
    False,
    ['Commands/Admin']),
  ( 'Com_ha_open',
    'Count of HANDLER OPEN statements',
    False,
    ['Commands/Admin']),
  ( 'Com_ha_read',
    'Count of HANDLER READ statements',
    False,
    ['Commands/Admin']),
  ('Com_help', 'Count of HELP statements', False, ['Commands/General']),
  ('Com_insert', 'Count of INSERT statements', False, ['Commands/DML']),
  ( 'Com_insert_select',
    'Count of INSERT SELECT statements',
    False,
    ['Commands/DML']),
  ( 'Com_install_plugin',
    'Count of INSTALL PLUGIN statements',
    False,
    ['Commands/Admin']),
  ('Com_kill', 'Count of KILL statements', False, ['Commands/Admin']),
  ('Com_load', 'Count of LOAD statements', False, ['Commands/Admin']),
  ('Com_load_master_data', 'Count of LOAD MASTER DATA statements', False, []),
  ( 'Com_load_master_table',
    'Count of LOAD MASTER TABLE statements',
    False,
    []),
  ( 'Com_lock_tables',
    'Count of LOCK TABLES statements',
    False,
    ['Commands/General']),
  ('Com_optimize', 'Count of OPTIMIZE statements', False, ['Commands/Admin']),
  ( 'Com_preload_keys',
    'Count of PRELOAD KEYS statements',
    False,
    ['Commands/Admin']),
  ('Com_prepare_sql', 'Count of PREPARE statements', False, ['Commands/DML']),
  ('Com_purge', 'Count of PURGE statements', False, ['Commands/Admin']),
  ( 'Com_purge_before_date',
    'Count of PURGE BEFORE DATE statements',
    False,
    ['Commands/Admin']),
  ('Com_purge_bup_log', 'Count of PURGE BACKUP LOG statements', False, []),
  ( 'Com_release_savepoint',
    'Count of RELEASE SAVEPOINT statements',
    False,
    ['Commands/Admin']),
  ( 'Com_rename_table',
    'Count of RENAME TABLE statements',
    False,
    ['Commands/DDL']),
  ( 'Com_rename_user',
    'Count of RENAME USER statements',
    False,
    ['Commands/Admin']),
  ('Com_repair', 'Count of REPAIR statements', False, ['Commands/Admin']),
  ('Com_replace', 'Count of REPLACE statements', False, ['Commands/DML']),
  ( 'Com_replace_select',
    'Count of REPLACE SELECT statements',
    False,
    ['Commands/DML']),
  ('Com_reset', 'Count of RESET statements', False, ['Commands/Admin']),
  ('Com_resignal', 'Count of RESIGNAL statements', False, ['Commands/Admin']),
  ('Com_restore', 'Count of RESTORE DATABASE statements', False, []),
  ('Com_restore_table', 'Count of RESTORE TABLE statements', False, []),
  ('Com_revoke', 'Count of REVOKE statements', False, ['Commands/Admin']),
  ( 'Com_revoke_all',
    'Count of REVOKE ALL statements',
    False,
    ['Commands/Admin']),
  ( 'Com_rollback',
    'Count of ROLLBACK statements',
    False,
    ['Commands/Transaction']),
  ( 'Com_rollback_to_savepoint',
    'Count of ROLLBACK TO SAVEPOINT statements',
    False,
    ['Commands/Transaction']),
  ( 'Com_savepoint',
    'Count of SAVEPOINT statements',
    False,
    ['Commands/Transaction']),
  ('Com_select', 'Count of SELECT statements', False, ['Commands/General']),
  ( 'Com_set_option',
    'Count of SET OPTION statements',
    False,
    ['Commands/General']),
  ( 'Com_show_authors',
    'Count of SHOW AUTHORS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_binlog_events',
    'Count of SHOW BINLOG EVENTS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_binlogs',
    'Count of SHOW BINLOGS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_charsets',
    'Count of SHOW CHARSET statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_collations',
    'Count of SHOW COLLATION statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_column_types',
    'Count of SHOW COLUMN TYPES statements',
    False,
    []),
  ( 'Com_show_contributors',
    'Count of SHOW CONTRIBUTORS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_create_db',
    'Count of SHOW CREATE DATABASE statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_create_event',
    'Count of SHOW CREATE EVENT statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_create_func',
    'Count of SHOW CREATE FUNCTION statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_create_proc',
    'Count of SHOW CREATE PROCEDURE statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_create_table',
    'Count of SHOW CREATE TABLE statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_create_trigger',
    'Count of SHOW CREATE TRIGGER statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_databases',
    'Count of SHOW DATABASES statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_engine_logs',
    'Count of SHOW ENGINE LOGS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_engine_mutex',
    'Count of SHOW ENGINE MUTEX statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_engine_status',
    'Count of SHOW ENGINE STATUS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_errors',
    'Count of SHOW ERRORS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_events',
    'Count of SHOW EVENTS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_fields',
    'Count of SHOW FIELDS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_function_code',
    'Count of SHOW FUNCTION CODE statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_function_status',
    'Count of SHOW FUNCTION STATUS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_grants',
    'Count of SHOW GRANTS statements',
    False,
    ['Commands/Show']),
  ('Com_show_keys', 'Count of SHOW KEYS statements', False, ['Commands/Show']),
  ( 'Com_show_master_status',
    'Count of SHOW MASTER STATUS statements',
    False,
    ['Commands/Show']),
  ('Com_show_new_master', 'Count of SHOW NEW MASTER statements', False, []),
  ( 'Com_show_open_tables',
    'Count of SHOW OPEN TABLES statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_procedure_code',
    'Count of SHOW PROCEDURE CODE statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_procedure_status',
    'Count of SHOW PROCEDURE STATUS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_profile',
    'Count of SHOW PROFILE statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_profiles',
    'Count of SHOW PROFILES statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_plugins',
    'Count of SHOW PLUGINS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_privileges',
    'Count of SHOW PRIVILEGES statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_processlist',
    'Count of SHOW PROCESSLIST statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_relaylog_events',
    'Count of SHOW RELAYLOG EVENTS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_slave_hosts',
    'Count of SHOW SLAVE HOSTS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_slave_status',
    'Count of SHOW SLAVE STATUS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_status',
    'Count of SHOW STATUS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_storage_engines',
    'Count of SHOW STORAGE ENGINES statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_table_status',
    'Count of SHOW TABLE STATUS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_tables',
    'Count of SHOW TABLES statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_triggers',
    'Count of SHOW TRIGGERS statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_variables',
    'Count of SHOW VARIABLES statements',
    False,
    ['Commands/Show']),
  ( 'Com_show_warnings',
    'Count of SHOW WARNINGS statements',
    False,
    ['Commands/Show']),
  ('Com_signal', 'Count of SIGNAL statements', False, ['Commands/Admin']),
  ( 'Com_slave_start',
    'Count of START SLAVE statements',
    False,
    ['Commands/Replication']),
  ( 'Com_slave_stop',
    'Count of STOP SLAVE statements',
    False,
    ['Commands/Replication']),
  ( 'Com_stmt_close',
    'Count of STATEMENT CLOSE statements',
    False,
    ['Commands/Prepared Statement']),
  ( 'Com_stmt_execute',
    'Count of STATEMENT EXECUTE statements',
    False,
    ['Commands/Prepared Statement']),
  ( 'Com_stmt_fetch',
    'Count of STATEMENT FETCH statements',
    False,
    ['Commands/Prepared Statement']),
  ( 'Com_stmt_prepare',
    'Count of STATEMENT PREPARE statements',
    False,
    ['Commands/Prepared Statement']),
  ( 'Com_stmt_reprepare',
    'Count of automatic repreparations of prepared statements',
    False,
    ['Commands/Prepared Statement']),
  ( 'Com_stmt_reset',
    'Count of STATEMENT RESET statements',
    False,
    ['Commands/Prepared Statement']),
  ( 'Com_stmt_send_long_data',
    'Count of STATEMENT SEND LONG DATA statements',
    False,
    ['Commands/Prepared Statement']),
  ('Com_truncate', 'Count of TRUNCATE statements', False, ['Commands/DML']),
  ( 'Com_uninstall_plugin',
    'Count of UNINSTALL PLUGIN statements',
    False,
    ['Commands/Admin']),
  ( 'Com_unlock_tables',
    'Count of UNLOCK TABLES statements',
    False,
    ['Commands/Admin']),
  ('Com_update', 'Count of UPDATE statements', False, ['Commands/DML']),
  ( 'Com_update_multi',
    'Count of multiple UPDATE statements',
    False,
    ['Commands/DML']),
  ( 'Com_xa_commit',
    'Count of XA COMMIT statements',
    False,
    ['Commands/Transaction']),
  ( 'Com_xa_end',
    'Count of XA END statements',
    False,
    ['Commands/Transaction']),
  ( 'Com_xa_prepare',
    'Count of XA PREPARE statements',
    False,
    ['Commands/Transaction']),
  ( 'Com_xa_recover',
    'Count of XA RECOVER statements',
    False,
    ['Commands/Transaction']),
  ( 'Com_xa_rollback',
    'Count of XA ROLLBACK statements',
    False,
    ['Commands/Transaction']),
  ( 'Com_xa_start',
    'Count of XA START statements',
    False,
    ['Commands/Transaction']),
  ( 'Compression',
    'Whether the client connection uses compression in the client/server protocol',
    False,
    ['General']),
  ( 'Connections',
    'The number of connection attempts',
    False,
    ['Networking/Stats']),
  ( 'Connection_errors_accept',
    'The number of errors calling accept on the listening port',
    False,
    ['Networking/Errors']),
  ( 'Connection_errors_internal',
    'The number of connections refused due to internal errors',
    False,
    ['Networking/Errors']),
  ( 'Connection_errors_max_connections',
    'The number of connections refused due to the max_connections limit',
    False,
    ['Networking/Errors']),
  ( 'Connection_errors_peer_addr',
    'The number of errors searching for connection client IP addresses',
    False,
    []),
  ( 'Connection_errors_select',
    'The number of errors calling select/poll on the listening port',
    False,
    ['Networking/Errors']),
  ( 'Connection_errors_tcpwrap',
    'The number of connections refused by libwrap',
    False,
    ['Networking/Errors']),
  ( 'Created_tmp_disk_tables',
    'The number of temporary tables on disk created automatically by the server while executing statements',
    False,
    ['General']),
  ( 'Created_tmp_files',
    'How many temporary files mysqld has created',
    False,
    ['General']),
  ( 'Created_tmp_tables',
    'How many temporary tables mysqld has created',
    False,
    ['General']),
  ( 'Delayed_errors',
    'The number of rows written with INSERT DELAYED for which some error occurred',
    False,
    ['General']),
  ( 'Delayed_insert_threads',
    'The number of INSERT DELAYED thread handlers in use',
    False,
    ['General']),
  ( 'Delayed_writes',
    'The number of INSERT DELAYED rows written',
    False,
    ['General']),
  ( 'Flush_commands',
    'The number of FLUSH statements executed',
    False,
    ['General']),
  ( 'Handler_commit',
    'The number of internal COMMIT statements',
    False,
    ['Handler']),
  ( 'Handler_delete',
    'The number of times that rows have been deleted from tables',
    False,
    ['Handler']),
  ( 'Handler_discover',
    'The number of times that tables have been discovered',
    False,
    ['Handler']),
  ( 'Handler_external_lock',
    'The number of locks started while a statement executed.',
    False,
    ['Handler']),
  ( 'Handler_mrr_init',
    'The number of times storage engine MRR implementation is used for table access',
    False,
    ['Handler']),
  ( 'Handler_prepare',
    'A counter for the prepare phase of two-phase commit operations',
    False,
    ['Handler']),
  ( 'Handler_read_first',
    'The number of times the first entry in an index was read',
    False,
    ['Handler']),
  ( 'Handler_read_key',
    'The number of requests to read a row based on a key',
    False,
    ['Handler']),
  ( 'Handler_read_last',
    'The number of requests to read the last index entry',
    False,
    ['Handler']),
  ( 'Handler_read_next',
    'The number of requests to read the next row in key order',
    False,
    ['Handler']),
  ( 'Handler_read_prev',
    'The number of requests to read the previous row in key order',
    False,
    ['Handler']),
  ( 'Handler_read_rnd',
    'The number of requests to read a row based on a fixed position',
    False,
    ['Handler']),
  ( 'Handler_read_rnd_next',
    'The number of requests to read the next row in the data file',
    False,
    ['Handler']),
  ( 'Handler_rollback',
    'The number of requests for a storage engine to perform a rollback operation',
    False,
    ['Handler']),
  ( 'Handler_savepoint',
    'The number of requests for a storage engine to place a savepoint',
    False,
    ['Handler']),
  ( 'Handler_savepoint_rollback',
    'The number of requests for a storage engine to roll back to a savepoint',
    False,
    ['Handler']),
  ( 'Handler_update',
    'The number of requests to update a row in a table',
    False,
    ['Handler']),
  ( 'Handler_write',
    'The number of requests to insert a row in a table',
    False,
    ['Handler']),
  ( 'Key_blocks_not_flushed',
    'The number of key blocks in the key cache that have changed but have not yet been flushed to disk',
    False,
    ['Keycache']),
  ( 'Key_blocks_unused',
    'The number of unused blocks in the key cache',
    False,
    ['Keycache']),
  ( 'Key_blocks_used',
    'The number of used blocks in the key cache',
    False,
    ['Keycache']),
  ( 'Key_read_requests',
    'The number of requests to read a key block from the cache',
    False,
    ['Keycache']),
  ( 'Key_reads',
    'The number of physical reads of a key block from disk',
    False,
    ['Keycache']),
  ( 'Key_write_requests',
    'The number of requests to write a key block to the cache',
    False,
    ['Keycache']),
  ( 'Key_writes',
    'The number of physical writes of a key block from disk',
    False,
    ['Keycache']),
  ( 'Last_query_cost',
    'The total cost of the last compiled query as computed by the query optimizer',
    False,
    ['Performance']),
  ( 'Last_query_partial_plans',
    'The number of iterations in execution plan construction for the previous statement.',
    False,
    ['Performance']),
  ( 'Max_used_connections',
    'The maximum number of connections that have been in use simultaneously since the server started',
    False,
    ['Networking/Stats']),
  ( 'Max_used_connections_time',
    'The time at which Max_used_connections reached its current value',
    False,
    []),
  ( 'Ndb_api_wait_exec_complete_count_session',
    'Number of times thread has been blocked while waiting for execution of an operation to complete in this client session.',
    False,
    []),
  ( 'Ndb_api_wait_exec_complete_count_slave',
    'Number of times thread has been blocked while waiting for execution of an operation to complete by this slave.',
    False,
    []),
  ( 'Ndb_api_wait_exec_complete_count',
    'Number of times thread has been blocked while waiting for execution of an operation to complete by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_wait_scan_result_count_session',
    'Number of times thread has been blocked while waiting for a scan-based signal in this client session.',
    False,
    []),
  ( 'Ndb_api_wait_scan_result_count_slave',
    'Number of times thread has been blocked while waiting for a scan-based signal by this slave.',
    False,
    []),
  ( 'Ndb_api_wait_scan_result_count',
    'Number of times thread has been blocked while waiting for a scan-based signal by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_wait_meta_request_count_session',
    'Number of times thread has been blocked waiting for a metadata-based signal in this client session.',
    False,
    []),
  ( 'Ndb_api_wait_meta_request_count_slave',
    'Number of times thread has been blocked waiting for a metadata-based signal by this slave.',
    False,
    []),
  ( 'Ndb_api_wait_meta_request_count',
    'Number of times thread has been blocked waiting for a metadata-based signal by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_wait_nanos_count_session',
    'Total time (in nanoseconds) spent waiting for some type of signal from the data nodes in this client session.',
    False,
    []),
  ( 'Ndb_api_wait_nanos_count_slave',
    'Total time (in nanoseconds) spent waiting for some type of signal from the data nodes by this slave.',
    False,
    []),
  ( 'Ndb_api_wait_nanos_count',
    'Total time (in nanoseconds) spent waiting for some type of signal from the data nodes by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_bytes_sent_count_session',
    'Amount of data (in bytes) sent to the data nodes in this client session.',
    False,
    []),
  ( 'Ndb_api_bytes_sent_count_slave',
    'Amount of data (in bytes) sent to the data nodes by this slave.',
    False,
    []),
  ( 'Ndb_api_bytes_sent_count',
    'Amount of data (in bytes) sent to the data nodes by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_bytes_received_count_session',
    'Amount of data (in bytes) received from the data nodes in this client session.',
    False,
    []),
  ( 'Ndb_api_bytes_received_count_slave',
    'Amount of data (in bytes) received from the data nodes by this slave.',
    False,
    []),
  ( 'Ndb_api_bytes_received_count',
    'Amount of data (in bytes) received from the data nodes by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_trans_start_count_session',
    'Number of transactions started in this client session.',
    False,
    []),
  ( 'Ndb_api_trans_start_count_slave',
    'Number of transactions started by this slave.',
    False,
    []),
  ( 'Ndb_api_trans_start_count',
    'Number of transactions started by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_trans_commit_count_session',
    'Number of transactions committed in this client session.',
    False,
    []),
  ( 'Ndb_api_trans_commit_count_slave',
    'Number of transactions committed by this slave.',
    False,
    []),
  ( 'Ndb_api_trans_commit_count',
    'Number of transactions committed by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_trans_abort_count_session',
    'Number of transactions aborted in this client session.',
    False,
    []),
  ( 'Ndb_api_trans_abort_count_slave',
    'Number of transactions aborted by this slave.',
    False,
    []),
  ( 'Ndb_api_trans_abort_count',
    'Number of transactions aborted by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_trans_close_count_session',
    'Number of transactions aborted (may be greater than the sum of TransCommitCount and TransAbortCount) in this client session.',
    False,
    []),
  ( 'Ndb_api_trans_close_count_slave',
    'Number of transactions aborted (may be greater than the sum of TransCommitCount and TransAbortCount) by this slave.',
    False,
    []),
  ( 'Ndb_api_trans_close_count',
    'Number of transactions aborted (may be greater than the sum of TransCommitCount and TransAbortCount) by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_pk_op_count_session',
    'Number of operations based on or using primary keys in this client session.',
    False,
    []),
  ( 'Ndb_api_pk_op_count_slave',
    'Number of operations based on or using primary keys by this slave.',
    False,
    []),
  ( 'Ndb_api_pk_op_count',
    'Number of operations based on or using primary keys by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_uk_op_count_session',
    'Number of operations based on or using unique keys in this client session.',
    False,
    []),
  ( 'Ndb_api_uk_op_count_slave',
    'Number of operations based on or using unique keys by this slave.',
    False,
    []),
  ( 'Ndb_api_uk_op_count',
    'Number of operations based on or using unique keys by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_table_scan_count_session',
    'Number of table scans that have been started, including scans of internal tables, in this client session.',
    False,
    []),
  ( 'Ndb_api_table_scan_count_slave',
    'Number of table scans that have been started, including scans of internal tables, by this slave.',
    False,
    []),
  ( 'Ndb_api_table_scan_count',
    'Number of table scans that have been started, including scans of internal tables, by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_range_scan_count_session',
    'Number of range scans that have been started in this client session.',
    False,
    []),
  ( 'Ndb_api_range_scan_count_slave',
    'Number of range scans that have been started by this slave.',
    False,
    []),
  ( 'Ndb_api_range_scan_count',
    'Number of range scans that have been started by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_pruned_scan_count_session',
    'Number of scans that have been pruned to a single partition in this client session.',
    False,
    []),
  ( 'Ndb_api_pruned_scan_count_slave',
    'Number of scans that have been pruned to a single partition by this slave.',
    False,
    []),
  ( 'Ndb_api_pruned_scan_count',
    'Number of scans that have been pruned to a single partition by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_scan_batch_count_session',
    'Number of batches of rows received in this client session.',
    False,
    []),
  ( 'Ndb_api_scan_batch_count_slave',
    'Number of batches of rows received by this slave.',
    False,
    []),
  ( 'Ndb_api_scan_batch_count',
    'Number of batches of rows received by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_read_row_count_session',
    'Total number of rows that have been read in this client session.',
    False,
    []),
  ( 'Ndb_api_read_row_count_slave',
    'Total number of rows that have been read by this slave.',
    False,
    []),
  ( 'Ndb_api_read_row_count',
    'Total number of rows that have been read by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_trans_local_read_row_count_session',
    'Total number of rows that have been read in this client session.',
    False,
    []),
  ( 'Ndb_api_trans_local_read_row_count_slave',
    'Total number of rows that have been read by this slave.',
    False,
    []),
  ( 'Ndb_api_trans_local_read_row_count',
    'Total number of rows that have been read by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_event_data_count_injector',
    'Number of row change events received by the NDB binlog injector thread.',
    False,
    []),
  ( 'Ndb_api_event_data_count',
    'Number of row change events received by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_event_nondata_count_injector',
    'Number of events received, other than row change events, by the NDB binlog injector thread.',
    False,
    []),
  ( 'Ndb_api_event_nondata_count',
    'Number of events received, other than row change events, by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_api_event_bytes_count_injector',
    'Number of bytes of events received by the NDB binlog injector thread.',
    False,
    []),
  ( 'Ndb_api_event_bytes_count',
    'Number of bytes of events received by this MySQL Server (SQL node).',
    False,
    []),
  ( 'Ndb_number_of_data_nodes',
    'If the server is part of a MySQL Cluster, the value of this variable is the number of data nodes in the cluster',
    False,
    []),
  ( 'Ndb_conflict_fn_max',
    'If the server is part of a MySQL Cluster involved in cluster replication, the value of this variable indicates the number of times that conflict resolution based on "greater timestamp wins" has been applied',
    False,
    []),
  ( 'Ndb_conflict_fn_old',
    'If the server is part of a MySQL Cluster involved in cluster replication, the value of this variable indicates the number of times that "same timestamp wins" conflict resolution has been applied',
    False,
    []),
  ( 'Ndb_conflict_fn_epoch',
    'Number of rows that have been found in conflict by the NDB$EPOCH() conflict detection function',
    False,
    []),
  ( 'Ndb_conflict_fn_epoch_trans',
    'Number of rows that have been found in conflict by the NDB$EPOCH_TRANS() conflict detection function',
    False,
    []),
  ( 'Ndb_conflict_trans_row_conflict_count',
    'Number of rows found to be in conflict by a transactional conflict function',
    False,
    []),
  ( 'Ndb_conflict_trans_row_reject_count',
    'Total number of rows realigned after being found in conflict by a transactional conflict function. Includes Ndb_conflict_trans_row_conflict_count and any rows included in or dependent on conflicting transactions.',
    False,
    []),
  ( 'Ndb_conflict_trans_reject_count',
    'Number of transactions rejected after being found in conflict by a transactional conflict function.',
    False,
    []),
  ( 'Ndb_conflict_trans_detect_iter_count',
    'The number of internal iterations required to commit an epoch transaction. Should be (slightly) greater than or equal to Ndb_conflict_trans_conflict_commit_count.',
    False,
    []),
  ( 'Ndb_conflict_trans_conflict_commit_count',
    'The number of epoch transactions committed after requiring transactional conflict handling.',
    False,
    []),
  ( 'Not_flushed_delayed_rows',
    'The number of rows waiting to be written in INSERT DELAY queues',
    False,
    ['General']),
  ('Open_files', 'The number of files that are open', False, ['General']),
  ( 'Open_streams',
    'The number of streams that are open (used mainly for logging)',
    False,
    ['General']),
  ( 'Open_table_definitions',
    'The number of .frm files in the table cache',
    False,
    ['General']),
  ( 'Opened_table_definitions',
    'The number of .frm files that have been cached',
    False,
    ['General']),
  ('Open_tables', 'The number of tables that are open', False, ['General']),
  ( 'Opened_files',
    'The number of files that have been opened using my_open()',
    False,
    ['General']),
  ( 'Opened_tables',
    'The number of tables that have been opened',
    False,
    ['General']),
  ( 'Qcache_free_blocks',
    'The number of free memory blocks in the query cache',
    False,
    ['Query cache']),
  ( 'Qcache_free_memory',
    'The amount of free memory for the query cache',
    False,
    ['Query cache']),
  ('Qcache_hits', 'The number of query cache hits', False, ['Query cache']),
  ( 'Qcache_inserts',
    'The number of query cache inserts',
    False,
    ['Query cache']),
  ( 'Qcache_lowmem_prunes',
    'The number of queries that were deleted from the query cache due to lack of free memory in the cache',
    False,
    ['Query cache']),
  ( 'Qcache_not_cached',
    'The number of noncached queries (not cacheable, or not cached due to the query_cache_type setting)',
    False,
    ['Query cache']),
  ( 'Qcache_queries_in_cache',
    'The number of queries registered in the query cache',
    False,
    ['Query cache']),
  ( 'Qcache_total_blocks',
    'The total number of blocks in the query cache',
    False,
    ['Query cache']),
  ( 'Queries',
    'The number of statements executed by the server',
    False,
    ['General']),
  ( 'Questions',
    'The number of statements that clients have sent to the server',
    False,
    ['General']),
  ( 'Rpl_semi_sync_master_clients',
    'The number of semisynchronous slaves',
    False,
    []),
  ( 'Rpl_semi_sync_master_net_avg_wait_time',
    'The average time the master waited for a slave reply',
    False,
    []),
  ( 'Rpl_semi_sync_master_net_wait_time',
    'The total time the master waited for slave replies',
    False,
    []),
  ( 'Rpl_semi_sync_master_net_waits',
    'The total number of times the master waited for slave replies',
    False,
    []),
  ( 'Rpl_semi_sync_master_no_times',
    'The number of times the master turned off semisynchronous replication',
    False,
    []),
  ( 'Rpl_semi_sync_master_no_tx',
    'The number of commits not acknowledged successfully',
    False,
    []),
  ( 'Rpl_semi_sync_master_status',
    'Whether semisynchronous replication is operational on master',
    False,
    []),
  ( 'Rpl_semi_sync_master_timefunc_failures',
    'The number of times the master failed when calling time functions',
    False,
    []),
  ( 'Rpl_semi_sync_master_tx_avg_wait_time',
    'The average time the master waited for each transaction',
    False,
    []),
  ( 'Rpl_semi_sync_master_tx_wait_time',
    'The total time the master waited for transactions',
    False,
    []),
  ( 'Rpl_semi_sync_master_tx_waits',
    'The total number of times the master waited for transactions',
    False,
    []),
  ( 'Rpl_semi_sync_master_wait_pos_backtraverse',
    'The total number of times the master waited for an event with binary coordinates lower than events waited for previously',
    False,
    []),
  ( 'Rpl_semi_sync_master_wait_sessions',
    'The number of sessions currently waiting for slave replies',
    False,
    []),
  ( 'Rpl_semi_sync_master_yes_tx',
    'The number of commits acknowledged successfully',
    False,
    []),
  ( 'Rpl_semi_sync_slave_status',
    'Whether semisynchronous replication is operational on slave',
    False,
    []),
  ( 'Rpl_status',
    'The status of fail-safe replication (not implemented)',
    False,
    []),
  ( 'Select_full_join',
    'The number of joins that perform table scans because they do not use indexes',
    False,
    ['General']),
  ( 'Select_full_range_join',
    'The number of joins that used a range search on a reference table',
    False,
    ['General']),
  ( 'Select_range',
    'The number of joins that used ranges on the first table',
    False,
    ['General']),
  ( 'Select_range_check',
    'The number of joins without keys that check for key usage after each row',
    False,
    ['General']),
  ( 'Select_scan',
    'The number of joins that did a full scan of the first table',
    False,
    ['General']),
  ( 'Slave_heartbeat_period',
    "The slave's replication heartbeat interval, in seconds",
    False,
    ['Replication']),
  ( 'Slave_last_heartbeat',
    'Shows when the latest heartbeat signal was received, in TIMESTAMP format.',
    False,
    ['Replication']),
  ( 'Slave_received_heartbeats',
    'Number of heartbeats received by a replication slave since previous reset',
    False,
    ['Replication']),
  ( 'Slave_open_temp_tables',
    'The number of temporary tables that the slave SQL thread currently has open',
    False,
    ['Replication']),
  ( 'Slave_retried_transactions',
    'The total number of times since startup that the replication slave SQL thread has retried transactions',
    False,
    ['Replication']),
  ( 'Slave_running',
    'The state of this server as a replication slave (slave I/O thread status)',
    False,
    ['Replication']),
  ( 'Slow_launch_threads',
    'The number of threads that have taken more than slow_launch_time seconds to create',
    False,
    ['Threading']),
  ( 'Slow_queries',
    'The number of queries that have taken more than long_query_time seconds',
    False,
    ['General']),
  ( 'Sort_merge_passes',
    'The number of merge passes that the sort algorithm has had to do',
    False,
    ['General']),
  ( 'Sort_range',
    'The number of sorts that were done using ranges',
    False,
    ['General']),
  ('Sort_rows', 'The number of sorted rows', False, ['General']),
  ( 'Sort_scan',
    'The number of sorts that were done by scanning the table',
    False,
    ['General']),
  ( 'Ssl_accept_renegotiates',
    'The number of negotiates needed to establish the connection',
    False,
    ['SSL']),
  ('Ssl_accepts', 'The number of accepted SSL connections', False, ['SSL']),
  ( 'Ssl_callback_cache_hits',
    'The number of callback cache hits',
    False,
    ['SSL']),
  ('Ssl_cipher', 'The current SSL cipher', False, ['SSL']),
  ('Ssl_cipher_list', 'The list of possible SSL ciphers', False, ['SSL']),
  ( 'Ssl_client_connects',
    'The number of SSL connection attempts to an SSL-enabled master',
    False,
    ['SSL']),
  ( 'Ssl_connect_renegotiates',
    'The number of negotiates needed to establish the connection to an SSL-enabled master',
    False,
    ['SSL']),
  ( 'Ssl_ctx_verify_depth',
    'The SSL context verification depth (how many certificates in the chain are tested)',
    False,
    ['SSL']),
  ('Ssl_ctx_verify_mode', 'The SSL context verification mode', False, ['SSL']),
  ('Ssl_default_timeout', 'The default SSL timeout', False, ['SSL']),
  ( 'Ssl_finished_accepts',
    'The number of successful SSL connections to the server',
    False,
    ['SSL']),
  ( 'Ssl_finished_connects',
    'The number of successful slave connections to an SSL-enabled master',
    False,
    ['SSL']),
  ('Ssl_server_not_after', 'SSL certificate last valid date', False, ['SSL']),
  ( 'Ssl_server_not_before',
    'SSL certificate first valid date',
    False,
    ['SSL']),
  ( 'Ssl_session_cache_hits',
    'The number of SSL session cache hits',
    False,
    ['SSL']),
  ( 'Ssl_session_cache_misses',
    'The number of SSL session cache misses',
    False,
    ['SSL']),
  ('Ssl_session_cache_mode', 'The SSL session cache mode', False, ['SSL']),
  ( 'Ssl_session_cache_overflows',
    'The number of SSL session cache overflows',
    False,
    ['SSL']),
  ('Ssl_session_cache_size', 'The SSL session cache size', False, ['SSL']),
  ( 'Ssl_session_cache_timeouts',
    'The number of SSL session cache timeouts',
    False,
    ['SSL']),
  ( 'Ssl_sessions_reused',
    'How many SSL connections were reused from the cache',
    False,
    ['SSL']),
  ( 'Ssl_used_session_cache_entries',
    'How many SSL session cache entries were used',
    False,
    ['SSL']),
  ( 'Ssl_verify_depth',
    'The verification depth for replication SSL connections',
    False,
    ['SSL']),
  ( 'Ssl_verify_mode',
    'The verification mode for replication SSL connections',
    False,
    ['SSL']),
  ('Ssl_version', 'The SSL version number', False, ['SSL']),
  ( 'Table_locks_immediate',
    'The number of times that a table lock was acquired immediately',
    False,
    ['General']),
  ( 'Table_locks_waited',
    'The number of times that a table lock could not be acquired immediately and a wait was needed',
    False,
    ['General']),
  ( 'Table_open_cache_hits',
    'The number of hits for open tables cache lookups',
    False,
    ['General']),
  ( 'Table_open_cache_misses',
    'The number of misses for open tables cache lookups',
    False,
    ['General']),
  ( 'Table_open_cache_overflows',
    'The number of overflows for the open tables cache',
    False,
    ['General']),
  ( 'Tc_log_max_pages_used',
    'When the memory-mapped implementation of the log that is used by mysqld acts as the transaction coordinator for recovery of internal XA transactions,this variable indicates the largest number of pages used for the log since the server started',
    False,
    ['General']),
  ( 'Tc_log_page_size',
    'The page size used for the memory-mapped implementation of the XA recovery log',
    False,
    ['General']),
  ( 'Tc_log_page_waits',
    'For the memory-mapped implementation of the recovery log, this variable increments each time the server was not able to commit a transaction and had to wait for a free page in the log',
    False,
    ['General']),
  ( 'Threads_cached',
    'The number of threads in the thread cache',
    False,
    ['Threading']),
  ( 'Threads_connected',
    'The number of currently open connections',
    False,
    ['Threading']),
  ( 'Threads_created',
    'The number of threads created to handle connections',
    False,
    ['Threading']),
  ( 'Threads_running',
    'The number of threads that are not sleeping',
    False,
    ['Threading']),
  ( 'Uptime',
    'The number of seconds the server has been up',
    False,
    ['General']),
  ( 'Uptime_since_flush_status',
    'The number of seconds since the most recent FLUSH STATUS',
    False,
    ['General']),
  ( 'Innodb_available_undo_logs',
    'Displays the total number of InnoDB rollback segments; different from innodb_undo_logs, which displays the number of active rollback segments',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_buffer_pool_dump_status',
    'Displays the status of the buffer pool recording operation triggered by innodb_buffer_pool_dump_at_shutdown or innodb_buffer_pool_dump_now',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_load_status',
    'Displays the status of the buffer pool warmup operation triggered by innodb_buffer_pool_load_at_startup or innodb_buffer_pool_load_now',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Max_statement_time_exceeded',
    'Number of statements that exceeded the execution timeout value',
    False,
    []),
  ( 'Max_statement_time_set',
    'Number of statements for which timeout was set',
    False,
    []),
  ( 'Max_statement_time_set_failed',
    'Number of statements for which timeout setting failed',
    False,
    []),
  ( 'ndb_execute_count',
    'Provides the number of round trips to the NDB kernel made by operations',
    False,
    []),
  ( 'ndb_scan_count',
    'The total number of scans executed by NDB since the cluster was last started',
    False,
    []),
  ( 'ndb_pruned_scan_count',
    'The number of scans executed by NDB since the cluster was last started where partition pruning could be used',
    False,
    []),
  ( 'ndb_pushed_reads',
    'Number of reads executed on the data nodes by pushed-down joins',
    False,
    []),
  ( 'Ndb_pushed_queries_defined',
    'Number of joins that API nodes have attempted to push down to the data nodes',
    False,
    []),
  ( 'Ndb_pushed_queries_dropped',
    'Number of joins that API nodes have tried to push down, but failed',
    False,
    []),
  ( 'Ndb_pushed_queries_executed',
    'Number of joins successfully pushed down and executed on the data nodes',
    False,
    []),
  ('ndb-nodeid', 'MySQL Cluster node ID for this MySQL server', False, []),
  ( 'ndb_recv_thread_activation_threshold',
    'Activation threshold when receive thread takes over the polling of the cluster connection (measured in concurrently active threads)',
    False,
    []),
  ( 'Performance_schema_digest_lost',
    'How many digests could not be instrumented',
    False,
    ['Performance schema']),
  ( 'Performance_schema_accounts_lost',
    'How many accounts table rows could not be added',
    False,
    ['Performance schema']),
  ( 'Performance_schema_cond_classes_lost',
    'How many condition instruments could not be loaded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_cond_instances_lost',
    'How many condition instrument instances could not be created',
    False,
    ['Performance schema']),
  ( 'Performance_schema_file_classes_lost',
    'How many file instruments could not be loaded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_file_handles_lost',
    'How many file instrument instances could not be opened',
    False,
    ['Performance schema']),
  ( 'Performance_schema_file_instances_lost',
    'How many file instrument instances could not be created',
    False,
    ['Performance schema']),
  ( 'Performance_schema_hosts_lost',
    'How many hosts table rows could not be added',
    False,
    ['Performance schema']),
  ( 'Performance_schema_locker_lost',
    'How many events are lost or not recorded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_memory_classes_lost',
    'How many memory instruments could not be loaded',
    False,
    []),
  ( 'Performance_schema_metadata_lock_lost',
    'The number of metadata locks that could not be recorded',
    False,
    []),
  ( 'Performance_schema_mutex_classes_lost',
    'How many mutex instruments could not be loaded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_mutex_instances_lost',
    'How many mutex instrument instances could not be created',
    False,
    ['Performance schema']),
  ( 'Performance_schema_nested_statement_lost',
    'The number of stored program statements for which statistics were lost',
    False,
    []),
  ( 'Performance_schema_prepared_statements_lost',
    'The number of prepared statements that could not be instrumented',
    False,
    []),
  ( 'Performance_schema_program_lost',
    'The number of stored programs for which statistics were lost',
    False,
    []),
  ( 'Performance_schema_rwlock_classes_lost',
    'How many rwlock instruments could not be loaded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_rwlock_instances_lost',
    'How many rwlock instrument instances could not be created',
    False,
    ['Performance schema']),
  ( 'Performance_schema_session_connect_attrs_lost',
    'How many connection attribute strings could not be created',
    False,
    ['Performance schema']),
  ( 'Performance_schema_socket_classes_lost',
    'How many socket instruments could not be loaded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_socket_instances_lost',
    'How many socket instrument instances could not be created',
    False,
    ['Performance schema']),
  ( 'Performance_schema_stage_classes_lost',
    'How many stage instruments could not be loaded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_statement_classes_lost',
    'How many statement instruments could not be loaded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_table_handles_lost',
    'How many table instrument instances could not be opened',
    False,
    ['Performance schema']),
  ( 'Performance_schema_table_instances_lost',
    'How many table instrument instances could not be created',
    False,
    ['Performance schema']),
  ( 'Performance_schema_thread_classes_lost',
    'How many thread instruments could not be loaded',
    False,
    ['Performance schema']),
  ( 'Performance_schema_thread_instances_lost',
    'How many thread instrument instances could not be created',
    False,
    ['Performance schema']),
  ( 'Performance_schema_users_lost',
    'How many users table rows could not be added',
    False,
    ['Performance schema']),
  ('Rsa_public_key', 'The RSA public key value', False, []),
  ( 'Aborted_clients',
    'The number of connections aborted because the client died without closing the connection properly',
    False,
    ['Networking/Stats']),
  ( 'Prepared_stmt_count',
    'The current number of prepared statements',
    False,
    ['General']),
  ( 'Com_create_user',
    'Count of CREATE USER statements',
    False,
    ['Commands/Admin']),
  ( 'Innodb_buffer_pool_bytes_data',
    'The number of bytes containing data (dirty or clean) in the buffer pool',
    False,
    []),
  ( 'Innodb_buffer_pool_pages_data',
    'The number of pages containing data (dirty or clean) in the buffer pool',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_bytes_dirty',
    'The number of bytes currently dirty in the buffer pool',
    False,
    []),
  ( 'Innodb_buffer_pool_pages_dirty',
    'The number of pages currently dirty in the buffer pool',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_pages_flushed',
    'The number of buffer pool page-flush requests',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_pages_free',
    'The number of buffer pool pages free',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_pages_latched',
    'The number of latched pages in InnoDB buffer pool',
    False,
    []),
  ( 'Innodb_buffer_pool_pages_misc',
    'The number of pages that are busy because they have been allocated for administrative overhead',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_pages_total',
    'The total size of the buffer pool, in pages',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_read_ahead',
    'The number of pages read by the InnoDB read-ahead thread',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_read_ahead_evicted',
    'The number of read-ahead pages evicted without being accessed',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_read_ahead_rnd',
    'The number of random read-aheads initiated by InnoDB',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_read_ahead_seq',
    'The number of sequential read-aheads initiated by InnoDB',
    False,
    []),
  ( 'Innodb_buffer_pool_read_requests',
    'The number of logical read requests InnoDB has done',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_reads',
    'The number of logical reads that InnoDB could not satisfy from the buffer pool and had to do a single-page read',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_wait_free',
    'Counts number of waits for pages to be flushed',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_buffer_pool_write_requests',
    'The number of writes done to the buffer pool',
    False,
    ['InnoDB/Buffer pool']),
  ( 'Innodb_data_fsyncs',
    'The number of fsync() operations so far',
    False,
    ['InnoDB/Data']),
  ( 'Innodb_data_pending_reads',
    'The current number of pending reads',
    False,
    ['InnoDB/Data']),
  ( 'Innodb_data_pending_writes',
    'The number of pending writes',
    False,
    ['InnoDB/Data']),
  ( 'Innodb_data_read',
    'The amount of data read so far, in bytes',
    False,
    ['InnoDB/Data', 'InnoDB/Stats']),
  ( 'Innodb_data_reads',
    'The total number of data reads',
    False,
    ['InnoDB/Data', 'InnoDB/Stats']),
  ( 'Innodb_data_pending_fsyncs',
    'The current number of pending fsync() operations',
    False,
    ['InnoDB/Data']),
  ( 'Innodb_data_writes',
    'The total number of data writes',
    False,
    ['InnoDB/Data', 'InnoDB/Stats']),
  ( 'Innodb_data_written',
    'The amount of data written in bytes',
    False,
    ['InnoDB/Data', 'InnoDB/Stats']),
  ( 'Innodb_dblwr_writes',
    'The number of doublewrite operations that have been performed',
    False,
    ['InnoDB/General']),
  ( 'Innodb_dblwr_pages_written',
    'The number of doublewrite pages that have been written',
    False,
    ['InnoDB/General']),
  ( 'Innodb_have_sync_atomic',
    'Whether atomic instructions are available',
    False,
    []),
  ( 'Innodb_have_atomic_builtins',
    'Whether atomic instructions are available',
    False,
    ['InnoDB/General']),
  ( 'Innodb_heap_enabled',
    'Whether the InnoDB memory heap is enabled',
    False,
    []),
  ( 'Innodb_log_waits',
    'The number of times that the log buffer was too small and a wait was required for it to be flushed before continuing',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_log_write_requests',
    'The number of log write requests',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_log_writes',
    'The number of physical writes to the log',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_num_open_files',
    'The number of physical files currently opened by InnoDB',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_os_log_fsyncs',
    'The number of fsync() writes done to the log file',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_os_log_pending_fsyncs',
    'The number of pending log file fsync() operations',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_os_log_pending_writes',
    'The number of pending log file writes',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_os_log_written',
    'The number of bytes written to the log file',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_page_size',
    'The compiled-in InnoDB page size',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_pages_created',
    'The number of pages created',
    False,
    ['InnoDB/Stats']),
  ('Innodb_pages_read', 'The number of pages read', False, ['InnoDB/Stats']),
  ( 'Innodb_pages_written',
    'The number of pages written',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_row_lock_current_waits',
    'The number of row locks currently being waited for',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_row_lock_time',
    'The total time spent in acquiring row locks, in milliseconds',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_row_lock_time_avg',
    'The average time to acquire a row lock, in milliseconds',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_row_lock_time_max',
    'The maximum time to acquire a row lock, in milliseconds',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_row_lock_waits',
    'The number of times a row lock had to be waited for',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_rows_deleted',
    'The number of rows deleted from InnoDB tables',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_rows_inserted',
    'The number of rows inserted into InnoDB tables',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_rows_read',
    'The number of rows read from InnoDB tables',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_rows_updated',
    'The number of rows updated in InnoDB tables',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_truncated_status_writes',
    'The number of times output from the SHOW ENGINE INNODB STATUS statement has been truncated',
    False,
    ['InnoDB/Stats']),
  ( 'Innodb_wake_ups',
    'The number of wakeups that should not occur',
    False,
    []),
  ( 'Ndb_cluster_node_id',
    'If the server is acting as a MySQL Cluster node, then the value of this variable its node ID in the cluster',
    False,
    []),
  ( 'Ndb_config_from_host',
    'The host name or IP address of the Cluster management server. Formerly Ndb_connected_host',
    False,
    []),
  ( 'Ndb_config_from_port',
    'The port for connecting to the Cluster management server. Formerly Ndb_connected_port',
    False,
    []),
  ('Com_show_logs', 'Count of SHOW LOGS statements', False, []),
  ('Com_show_ndb_status', 'Count of SHOW NDB STATUS statements', False, []),
  ( 'Com_show_innodb_status',
    'Count of SHOW INNODB STATUS statements',
    False,
    [])]
