/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_APPVIEW_H_
#define _WF_APPVIEW_H_

#include "mforms/appview.h"
#include "wf_box.h"

#pragma make_public(mforms::AppView)

using namespace MySQL::Controls;

namespace MySQL {
  namespace Forms {

    // A managed version of the AppView class.
    public ref class AppViewImpl : public BoxImpl
    {
    private:
      TabDocument^ _host; // The document we dock our content to.
      mforms::AppView* _appView;
    protected:
      static bool create(::mforms::AppView *self, bool horizontal);

      void setup();

      void ContentPanelPaint(System::Object^ sender, PaintEventArgs^ e);
      void MenuPanelPaint(System::Object^ sender, PaintEventArgs^ e);
    public:
      AppViewImpl(::mforms::AppView* app);

      mforms::AppView *get_unmanaged_object() { return _appView; }

      TabDocument^ GetHost();
      MenuStrip^ GetMenuBar();
      ToolStrip^ GetToolBar();

      bool DocumentClosing();

      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, ::mforms::AppView*, bool, mgr, f->_app_view_impl, AppViewImpl, create);
      }
    };

    // Make an own class for the dock content, so we can later check for it.
    public ref class AppViewDockContent : public TabDocument
    {
    private:
      AppViewImpl^ _appview;

    public:
      AppViewDockContent(AppViewImpl^ appview);
      ~AppViewDockContent();

      AppViewImpl^ GetAppView();
      String^ GetAppViewIdentifier();
      mforms::AppView *get_unmanaged_object();

    };

  };
};

#endif
