#include <qvbox.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qvaluelist.h>
#include <qpixmap.h>
#include <qstatusbar.h>
#include <qscrollview.h>
#include <qlineedit.h>

#include "mainwindow.h"
#include "mdiwindow.h"
#include "include/resource.h"
#include "x.xpm"
#include "gear.xpm"
#include "open.xpm"
#include "quit.xpm"

void MainWindow::make_layout()
{	
	make_menubar();

	make_central_widget();

	make_toolbar();

	make_statusbar();
}

void MainWindow::make_central_widget()
{
	QSplitter *s = new QSplitter(Qt::Vertical  , this);

	workspace = new XWorkspace(s);
	log = new LogListView(s);
	log->setSorting(-1);
	log->hide();

	/*
	QVBox *s = new QVBox(this);
	s->setFrameStyle(QFrame::StyledPanel | QFrame::Sunken);

	QListView *log = new QListView(s);
	log->setFixedHeight(100);

	workspace = new XWorkspace(s);
	*/

  setCentralWidget(s);


	statusBar()->message(tr("Ready..."), 3000);
	
	setIcon(QPixmap(x_xpm));
}

void MainWindow::make_statusbar()
{
	statusBar();

	statusBar()->message(tr("Ready..."), 3000);
}

void MainWindow::make_toolbar()
{
	QToolBar *z;
	
	/*
	z = new QToolBar(this,"");
	addToolBar(z, QMainWindow::Top, TRUE);

	QLabel *s;
	s = new QLabel(z); s->setText(tr("Host: "));
	host1 = new QComboBox(TRUE, z, "");
	s = new QLabel(z); s->setText(tr(" : "));
	port1 = new QComboBox(TRUE, z, "");
	port1->insertItem("3306");
	s = new QLabel(z); s->setText(tr(" User: "));
	user1 = new QComboBox(TRUE, z, "");
	s = new QLabel(z); s->setText(tr(" Password: "));
	password1 = new QLineEdit(z);
	password1->setEchoMode(QLineEdit::Password);

	QToolTip::add(host1, tr("Please enter host"));
	QToolTip::add(port1, tr("Please enter port"));
	QToolTip::add(user1, tr("Please enter user"));
	QToolTip::add(password1, tr("Please enter password"));

	new QToolButton(QPixmap(open_xpm), tr("Open"), tr("Open"), this, SLOT(slot_open2()), z);
	new QToolButton(QPixmap(quit_xpm), tr("Quit"), tr("Quit"), this, SLOT(slot_quit()), z);
	*/

	z = new QToolBar(this,"");
	addToolBar(z, QMainWindow::Top, TRUE);
	
	database = new XComboBox(z);
	database->setFixedWidth(80);
	
	query = new QComboBox(TRUE, z, "");
	query->setAutoCompletion(TRUE);	
	query->setInsertionPolicy(QComboBox::NoInsertion);
	query->setDuplicatesEnabled(FALSE);

	new QToolButton(QPixmap(gear_xpm), tr("Fire"), tr("Fire"), this, SLOT(slot_query()), z);

	QToolTip::add(database, tr("Please choose database"));
	QToolTip::add(query, tr("Please enter query and press return"));

	z->setStretchableWidget(query);
}

void MainWindow::make_menubar()
{
	QPopupMenu *z;

	z = new QPopupMenu();
	z->setCaption(tr("File"));	
	z->insertTearOffHandle(ID_TEAROFF);	
	z->insertItem(tr("&New..."),this,SLOT(slot_new()), CTRL+Key_N, ID_NEW);
	z->insertItem(tr("&Open..."),this,SLOT(slot_open()), CTRL+Key_O, ID_OPEN);
	z->insertItem(tr("Q&uick Open..."),this,SLOT(slot_open2()), 0, ID_OPEN2);
	z->insertSeparator(); 
	z->insertItem(tr("&Quit"),this,SLOT(slot_quit()), CTRL+Key_Q, ID_QUIT);
	z->insertSeparator(); 
	z->insertItem(tr("E&xit"),this,SLOT(slot_exit()), CTRL+Key_X, ID_EXIT);
	menuBar()->insertItem(tr("&File"), z);

	z = new QPopupMenu();
	z->setCaption(tr("Edit"));	
	z->insertTearOffHandle(ID_TEAROFF);	
	z->insertItem(tr("&Find"),this,SLOT(slot_find()), 0, ID_FIND);
	menuBar()->insertItem(tr("&Edit"), z);

	z =new QPopupMenu();
	z->setCaption(tr("Theme"));	
	z->insertTearOffHandle(ID_TEAROFF);	
	z->insertItem(tr("&Default"),this,SLOT(slot_default_style()),0,ID_DEFAULT_STYLE);
	z->insertSeparator();	
	z->insertItem(tr("&Windows"),this,SLOT(slot_windows()),0,ID_WINDOWS);
	z->insertItem(tr("&CDE"),this,SLOT(slot_cde()),0,ID_CDE);
	z->insertItem(tr("&Motif"),this,SLOT(slot_motif()),0,ID_MOTIF);
	z->insertItem(tr("Motif Plus"),this,SLOT(slot_motif_plus()),0,ID_MOTIF_PLUS);
	z->insertItem(tr("&Platinum"),this,SLOT(slot_platinum()),0,ID_PLATINUM);
	z->insertItem(tr("&SGI"),this,SLOT(slot_sgi()),0,ID_SGI);
	/*
	z->insertSeparator();	
	z->insertItem(tr("&JFC"),this,SLOT(slot_jfc()),0,ID_JFC);
	z->insertItem(tr("&NeXTSTEP"),this,SLOT(slot_nextstep()),0,ID_NEXTSTEP);
	*/
	  menuBar()->insertItem(tr("The&me"), z);

	z = new QPopupMenu();
	z->setCaption(tr("MySQL"));	
	z->insertTearOffHandle(ID_TEAROFF);	
	z->insertItem(tr("&Schema"),this,SLOT(slot_schema2()), 0, ID_SCHEMA);
	z->insertItem(tr("&User"),this,SLOT(slot_user(int)), 0, ID_USER);	
	z->insertItem(tr("&Privilege"),this,SLOT(slot_privilege()), 0, ID_PRIVILEGE);	
	z->insertItem(tr("T&able"),this,SLOT(slot_table()), 0, ID_TABLE);	
	//z->insertItem(tr("&Field"),this,SLOT(slot_create_field()), 0, ID_FIELD);	
	z->insertItem(tr("&Key"),this,SLOT(slot_key(int)), 0, ID_KEY);	
	z->insertItem(tr("&Query"),this,SLOT(slot_query2()), 0, ID_QUERY);
	z->insertItem(tr("&Process"),this,SLOT(slot_process()), 0, ID_PROCESS);
	z->insertItem(tr("&Xport"),this,SLOT(slot_xport()), 0, ID_XPORT);
	z->insertItem(tr("P&assword"),this,SLOT(slot_password()), 0, ID_PASSWORD);
	z->insertItem(tr("&Script"),this,SLOT(slot_script()), 0, ID_SCRIPT);
	z->insertItem(tr("&Edit"),this,SLOT(slot_edit()), 0, ID_EDIT);
	z->insertItem(tr("&Log"),this,SLOT(slot_log()), 0, ID_LOG);
	//z->insertItem(tr("&Flush"), this, SLOT(slot_flush()), 0, ID_FLUSH);
	
	menuBar()->insertItem(tr("M&ySQL"), z);
	
	z = new QPopupMenu();
	z->setCaption(tr("Tools"));	
	z->insertTearOffHandle(ID_TEAROFF);	
	z->insertItem(tr("&Font..."),this,SLOT(slot_font(int)));
	z->insertSeparator();
	z->insertItem(tr("Cl&ose"),this,SLOT(slot_close()), 0, ID_CLOSE);
	z->insertItem(tr("Close Al&l"),this,SLOT(slot_close_all()), 0, ID_CLOSE_ALL);
	z->insertItem(tr("Close All Except Schema"),this,SLOT(slot_close_all_except_schema()), Key_F12, ID_CLOSE_ALL_EXCEPT_SCHEMA);
	z->insertSeparator();
	z->insertItem(tr("&Options..."),this,SLOT(slot_option()), 0, ID_OPTION);
	menuBar()->insertItem(tr("&Tools"), z);
	
	z = new QPopupMenu();	 	
	z->setCaption(tr("Help"));	
	z->insertTearOffHandle(ID_TEAROFF);	
	z->insertItem(tr("&About..."),this,SLOT(about()), Key_F1, ID_ABOUT);
	z->insertItem(tr("About &Qt..."),this,SLOT(aboutQt()), 0, ID_QT);
	menuBar()->insertItem(tr("&Help"), z);
	menuBar()->setDefaultUp(FALSE);
}

