#ifndef SYNCML_CMD_H
#define SYNCML_CMD_H

#include <glib.h>
#include <multisync.h>
#include "syncml_engine.h"

#define SYNCML_CONN_TIMEOUT 30

typedef enum {
  SYNCML_HTTP_CONTINUE = 100,
  SYNCML_HTTP_OK = 200,
  SYNCML_HTTP_CREATED = 201,
  SYNCML_HTTP_ACCEPTED = 202,
  SYNCML_HTTP_NOTFOUND = 404
} syncml_http_code;

void syncml_http_recv(syncml_state *state);
int syncml_conn_recv_line(syncml_state *state, char *line, int len);
int syncml_conn_recv(syncml_state *state, char *data, int len);
int syncml_conn_send(syncml_state *state, char *data, int len);
int syncml_conn_recv_all(syncml_state *state, char **data);
int syncml_http_send_cont(syncml_state *state);
int syncml_http_send_rsp(syncml_state *state, char *data, int len, int code,
			 char *contenttype);
int syncml_http_send_req(syncml_state *state, char *data, int len, char *cmd,
			 char *contenttype);
int syncml_transport_msg_size(syncml_state *state,
			      unsigned char* data, int len);
char *syncml_xml_out_convert(syncml_state *state, char *in, int *outlen);
void syncml_conn_disconnect(syncml_state *state, 
			    syncml_disconnect_reason reason);
int syncml_conn_write(int fd, char *data, int len, int timeout);
int syncml_conn_read(int fd, char *data, int len, int timeout);
gboolean syncml_conn_connect(syncml_state *state);
void syncml_do_cmd(syncml_state *state, syncml_engine_cmd *cmd);
gpointer syncml_main_thread(gpointer statep);
void syncml_init(void);
syncml_state* syncml_create(gboolean isserver, char* uri, 
			    char *optionfilename, gpointer userdata);
void syncml_load_engine_state(syncml_state *state);
void syncml_save_engine_state(syncml_state *state);

void syncml_cmd_send_changes(syncml_state *state, change_info *info);
void syncml_cmd_send_changes_result(syncml_state *state, GList *result);
void syncml_cmd_send_sync_done(syncml_state *state);
void syncml_cmd_send_sync_serverinit(syncml_state *state, 
				     sync_object_type newdbs);
void syncml_cmd_get_devinfo(syncml_state *state);
void syncml_cmd_quit(syncml_state *state);

void syncml_set_login(syncml_state *state, char *login, char *passwd);
void syncml_add_db(syncml_state *state, char* localdb,
		   sync_object_type objtype);
void syncml_add_remote_db(syncml_state *state, char* localdb,
			  char *remotedb);
gboolean syncml_is_partner_multisync(syncml_state *state);


#endif



