/*
 *   Written by Bradley Broom (2002).
 *
 *   Copyright (c) 2002 Bradley Broom
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef _MRI_TYPES_H
#define _MRI_TYPES_H

#include <lcms.h>

/* Values return by MRI_FocusMode
 */
#define MRI_FOCUS_AUTO		0
#define MRI_FOCUS_MANUAL	1

typedef struct {
	unsigned short rgain;
	unsigned short ggain;
	unsigned short bgain;
} MRI_balance;

typedef struct _balmap {
  char	*name;
  MRI_balance bal;
  struct _balmap * next;
} MRI_BalanceMap;

/* Special profile names.
 */
#define	MRI_NATIVE_PROFILE	"__NATIVE__"

typedef struct {
	int radius;
	double	blur, iSharpen, cSharpen;
	int useLab, applyVMF, applyMedianFilter;
	int filterColorOnly;
	char *toneCurveFile;
	double vMedianTolerance;
} MRI_ImproverOptions;

typedef struct {
	double	Lmin, Lmax;
} MRI_ImproverInfo;

typedef struct {
	int useLab;
	int rotate;
	char *imethod;
	double vmedian_tolerance;
	int doInterpolate;
} MRI_InterpolatorOptions;

typedef struct _iterator {
	void *(*next) (struct _iterator *);
	void (*close) (struct _iterator *);
	void *private;
} MRI_Iterator;

typedef struct _MRI {
	struct _MRI_Methods	*methods;
	void		*hdr;		/* subtype private data. */
	int		height;
	int		width;
	int		dFactor;
	MRI_balance	wBalance;
	MRI_BalanceMap	*balanceMap;
	unsigned short  Rmax, Gmax, Bmax;
	double          Ravg, Gavg, Bavg;
	double          scale;
	unsigned short  *data;
	unsigned short  **R, **G, **B;
	char		*colorSpace;	/* Name of color space in which image lives. */
} MRI;

#define LINETYPE_SHORT	0	/* 16 bit unsigned */
#define LINETYPE_LONG	1	/* 32 bit unsigned, despite the name */
#define LINETYPE_FLOAT	2	/* 32 bit float */
#define LINETYPE_DOUBLE	3	/* 64 bit float */

struct MRI_ScanLine {
	int  scanLineType;
	int  sl_NumChannels;
	int  sl_Width;
	void **sl_Channel;
	void *R, *G, *B;	/* Deprecated */
	unsigned long *masks;
};

typedef struct _MRI_Methods {
        char		*(*CameraName) (const struct _MRI *);
	int		 (*Height) (const struct _MRI *);
	int		 (*Width) (const struct _MRI *);
	int	 	 (*GetPresetBalance) (const struct _MRI *, const char *name, MRI_balance *bal);
	void	 	 (*AdjustBalanceLuminance) (const struct _MRI *, MRI_balance *bal, double *lumascale);
	int     	 (*Flash) (const struct _MRI *);
        char		*(*TimeStamp) (const struct _MRI *);
	double     	 (*Shutter) (const struct _MRI *);
	double     	 (*Aperture) (const struct _MRI *);
	double     	 (*ISO) (const struct _MRI *);
	double     	 (*FocalLen) (const struct _MRI *);
	double     	 (*FocusLen) (const struct _MRI *);
	int     	 (*FocusMode) (const struct _MRI *);
	MRI_Iterator	*(*PresetIterator) (const struct _MRI *);
        LPcmsCIEXYZ 	 (*WhitePoint) (const struct _MRI *);
	cmsHPROFILE 	 (*NativeProfile) (const struct _MRI *);
	void		 (*ConvertScanLineToLAB) (const struct _MRI *, struct MRI_ScanLine *);
} MRI_Methods;

typedef struct {
	double r, g, b;
} fpixel;

typedef struct link {
	void (*start) (void *private, int width, int height, int freedata);
	void (*row) (void *private, void *data);
	void (*close) (void *private);
	void *private;
} MRI_Link;

typedef struct {
	int	x, y;
	int	width, height;
} MRI_Region;

#endif
