/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.input;

import base.drawable.Drawable;
import base.drawable.TimeBoundingBox;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TreeMap;
import logformat.slog2.BufForObjects;
import logformat.slog2.input.BufStub;
import logformat.slog2.input.IteratorOfGroupObjects;
import logformat.slog2.input.TreeNode;

public class TreeFloor
extends TreeMap {
    private static final long serialVersionUID = 800L;
    private short depth;
    private TimeBoundingBox timebounds;
    private boolean isIncreTimeOrdered;

    public TreeFloor(short s, BufForObjects.Order order) {
        super(order);
        this.depth = s;
        this.timebounds = new TimeBoundingBox();
        this.isIncreTimeOrdered = order.isIncreasingIndexOrdered();
    }

    public short getDepth() {
        return this.depth;
    }

    public TimeBoundingBox earliestTimeBounds() {
        if (this.isIncreTimeOrdered) {
            return (TimeBoundingBox)super.firstKey();
        }
        return (TimeBoundingBox)super.lastKey();
    }

    public TimeBoundingBox latestTimeBounds() {
        if (this.isIncreTimeOrdered) {
            return (TimeBoundingBox)super.lastKey();
        }
        return (TimeBoundingBox)super.firstKey();
    }

    public TimeBoundingBox getTimeBounds() {
        this.timebounds.setEarliestTime(this.earliestTimeBounds().getEarliestTime());
        this.timebounds.setLatestTime(this.latestTimeBounds().getLatestTime());
        if (!this.timebounds.isTimeOrdered()) {
            System.out.println("slog2.input.TreeFloor.getTimeBounds() returns wrong " + this.timebounds);
        }
        return this.timebounds;
    }

    public boolean coversBarely(TimeBoundingBox timeBoundingBox) {
        return this.earliestTimeBounds().contains(timeBoundingBox.getEarliestTime()) && this.latestTimeBounds().contains(timeBoundingBox.getLatestTime());
    }

    public boolean covers(TimeBoundingBox timeBoundingBox) {
        this.getTimeBounds();
        return this.timebounds.covers(timeBoundingBox);
    }

    public boolean overlaps(TimeBoundingBox timeBoundingBox) {
        this.getTimeBounds();
        return this.timebounds.overlaps(timeBoundingBox);
    }

    public boolean disjoints(TimeBoundingBox timeBoundingBox) {
        this.getTimeBounds();
        return this.timebounds.disjoints(timeBoundingBox);
    }

    public void pruneToBarelyCovering(TimeBoundingBox timeBoundingBox) {
        if (this.covers(timeBoundingBox)) {
            double d = timeBoundingBox.getEarliestTime();
            double d2 = timeBoundingBox.getLatestTime();
            while (!this.coversBarely(timeBoundingBox)) {
                if (!this.earliestTimeBounds().contains(d)) {
                    super.remove(super.firstKey());
                }
                if (this.latestTimeBounds().contains(d2)) continue;
                super.remove(super.lastKey());
            }
        }
    }

    public Iterator iteratorOfDrawables(TimeBoundingBox timeBoundingBox, Drawable.Order order, boolean bl, boolean bl2) {
        return new ItrOfDrawables(timeBoundingBox, order, bl, bl2);
    }

    public Iterator iteratorOfShadows(TimeBoundingBox timeBoundingBox, Drawable.Order order, boolean bl) {
        return new ItrOfShadows(timeBoundingBox, order, bl);
    }

    public String toStubString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            BufStub bufStub = new BufStub((BufForObjects)iterator.next());
            stringBuffer.append(bufStub.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString() + "\n");
        }
        return stringBuffer.toString();
    }

    private class ItrOfShadows
    extends IteratorOfGroupObjects {
        private Drawable.Order dobj_order;
        private boolean isNestable;
        private ListIterator nodes_itr;
        private boolean isSameDir;

        public ItrOfShadows(TimeBoundingBox timeBoundingBox, Drawable.Order order, boolean bl) {
            super(timeBoundingBox);
            this.dobj_order = order;
            this.isNestable = bl;
            this.isSameDir = this.dobj_order.isIncreasingTimeOrdered() == TreeFloor.this.isIncreTimeOrdered;
            ArrayList arrayList = new ArrayList(TreeFloor.super.values());
            this.nodes_itr = this.isSameDir ? arrayList.listIterator(0) : arrayList.listIterator(arrayList.size());
            super.setObjGrpItr(this.nextObjGrpItr(timeBoundingBox));
        }

        @Override
        protected Iterator nextObjGrpItr(TimeBoundingBox timeBoundingBox) {
            if (this.isSameDir) {
                while (this.nodes_itr.hasNext()) {
                    TreeNode treeNode = (TreeNode)this.nodes_itr.next();
                    if (!treeNode.overlaps(timeBoundingBox)) continue;
                    return treeNode.iteratorOfShadows(timeBoundingBox, this.dobj_order, this.isNestable);
                }
            } else {
                while (this.nodes_itr.hasPrevious()) {
                    TreeNode treeNode = (TreeNode)this.nodes_itr.previous();
                    if (!treeNode.overlaps(timeBoundingBox)) continue;
                    return treeNode.iteratorOfShadows(timeBoundingBox, this.dobj_order, this.isNestable);
                }
            }
            return null;
        }
    }

    private class ItrOfDrawables
    extends IteratorOfGroupObjects {
        private Drawable.Order dobj_order;
        private boolean isComposite;
        private boolean isNestable;
        private ListIterator nodes_itr;
        private boolean isSameDir;

        public ItrOfDrawables(TimeBoundingBox timeBoundingBox, Drawable.Order order, boolean bl, boolean bl2) {
            super(timeBoundingBox);
            this.dobj_order = order;
            this.isNestable = bl2;
            this.isComposite = bl;
            this.isSameDir = this.dobj_order.isIncreasingTimeOrdered() == TreeFloor.this.isIncreTimeOrdered;
            ArrayList arrayList = new ArrayList(TreeFloor.super.values());
            this.nodes_itr = this.isSameDir ? arrayList.listIterator(0) : arrayList.listIterator(arrayList.size());
            super.setObjGrpItr(this.nextObjGrpItr(timeBoundingBox));
        }

        @Override
        protected Iterator nextObjGrpItr(TimeBoundingBox timeBoundingBox) {
            if (this.isSameDir) {
                while (this.nodes_itr.hasNext()) {
                    TreeNode treeNode = (TreeNode)this.nodes_itr.next();
                    if (!treeNode.overlaps(timeBoundingBox)) continue;
                    return treeNode.iteratorOfDrawables(timeBoundingBox, this.dobj_order, this.isComposite, this.isNestable);
                }
            } else {
                while (this.nodes_itr.hasPrevious()) {
                    TreeNode treeNode = (TreeNode)this.nodes_itr.previous();
                    if (!treeNode.overlaps(timeBoundingBox)) continue;
                    return treeNode.iteratorOfDrawables(timeBoundingBox, this.dobj_order, this.isComposite, this.isNestable);
                }
            }
            return null;
        }
    }
}

