/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.TimeBoundingBox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import viewer.common.Const;
import viewer.common.Routines;
import viewer.zoomable.Debug;
import viewer.zoomable.InfoDialog;
import viewer.zoomable.ModelTime;
import viewer.zoomable.ScrollableObject;

public class RulerTime
extends ScrollableObject {
    private static final long serialVersionUID = 4500L;
    private static final Font FONT = Const.FONT;
    private static final int FONT_SIZE = FONT.getSize();
    private static final int TICKMARK_HEIGHT = 10;
    private static final int I_FONT_BASELINE = 10 + FONT_SIZE + 5;
    private static final int VIEW_HEIGHT = I_FONT_BASELINE + 5;
    private double tRange = 0.0;
    private double tIncrement = 0.0;
    private DecimalFormat fmt = (DecimalFormat)NumberFormat.getInstance();

    public RulerTime(ModelTime modelTime) {
        super(modelTime);
        this.fmt.applyPattern("#,##0.00######");
    }

    @Override
    public Dimension getMinimumSize() {
        if (Debug.isActive()) {
            Debug.println("RulerTime: min_size = (0," + VIEW_HEIGHT + ")");
        }
        return new Dimension(0, VIEW_HEIGHT);
    }

    @Override
    public Dimension getMaximumSize() {
        if (Debug.isActive()) {
            Debug.println("RulerTime: max_size = (32767," + VIEW_HEIGHT + ")");
        }
        return new Dimension(Short.MAX_VALUE, VIEW_HEIGHT);
    }

    @Override
    public int getJComponentHeight() {
        return VIEW_HEIGHT;
    }

    @Override
    protected void initializeAllOffImages(TimeBoundingBox timeBoundingBox) {
    }

    @Override
    protected void finalizeAllOffImages(TimeBoundingBox timeBoundingBox) {
    }

    @Override
    protected void drawOneOffImage(Image image, TimeBoundingBox timeBoundingBox) {
        if (Debug.isActive()) {
            Debug.println("RulerTime: drawOneOffImage()'s offImage = " + image);
        }
        if (image != null) {
            int n = image.getWidth(this);
            int n2 = image.getHeight(this);
            Graphics graphics = image.getGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n, n2);
            graphics.setFont(FONT);
            graphics.setColor(Color.black);
            if (timeBoundingBox.getDuration() != this.tRange) {
                this.tRange = timeBoundingBox.getDuration();
                this.tIncrement = this.tRange / 20.0;
                this.tIncrement = Routines.getTimeRulerIncrement(this.tIncrement);
            }
            String string = null;
            if (Debug.isActive()) {
                Debug.print("RulerTime.drawOffImage at : ");
            }
            double d = timeBoundingBox.getEarliestTime();
            int n3 = super.time2pixel(d);
            double d2 = Routines.getTimeRulerFirstMark(d, this.tIncrement);
            double d3 = timeBoundingBox.getLatestTime() + this.tIncrement;
            for (double d4 = d2; d4 < d3; d4 += this.tIncrement) {
                int n4 = super.time2pixel(d4) - n3;
                graphics.drawLine(n4, 1, n4, 10);
                string = this.fmt.format(d4);
                graphics.drawString(string, n4 - 3, I_FONT_BASELINE);
                if (!Debug.isActive()) continue;
                Debug.print(d4 + ":" + n4 + ", ");
            }
            if (Debug.isActive()) {
                Debug.println("|");
            }
            graphics.dispose();
        }
    }

    @Override
    public InfoDialog getPropertyAt(Point point, TimeBoundingBox timeBoundingBox) {
        return super.getTimePropertyAt(point);
    }
}

