/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gestures (Window Handler (MWH)).
 *
 * The Initial Developer of the Original Code is Jochen.
 * Portions created by the Initial Developer are Copyright (C) 2009
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Jochen <bugs@krickelkrackel.de>
 *
 * ***** END LICENSE BLOCK ***** */

const MWH_contractID = "@mousegestures.org/mgWindowHandler;1";

const MWH_CID = Components.ID("{FFA481E3-698F-49cb-B8A2-6778F3654B7C}");
const MWH_obS = Components.classes["@mozilla.org/observer-service;1"]
                .getService(Components.interfaces.nsIObserverService);
const MWH_jsL = Components.classes["@mozilla.org/moz/jssubscript-loader;1"]
                .getService(Components.interfaces.mozIJSSubScriptLoader);
const MWH_prS = Components.classes["@mozilla.org/preferences-service;1"]
                .getService(Components.interfaces.nsIPrefService);
const MWH_prB = MWH_prS.getBranch("mozgest.");
const MWH_dir = Components.classes['@mozilla.org/file/directory_service;1']
               .getService(Components.interfaces.nsIProperties);

MWH_jsL.loadSubScript('chrome://mozgest/content/windowTypes.js');
const MWH_wTypes = mgWindowTypes.wTypes;

var MWH_excludeDefault = new Array();
MWH_excludeDefault["chrome://global/content/commonDialog.xul"] = true;

var MWH_excludeAlways = new Array();
MWH_excludeAlways["chrome://mozgest/content/pref/edit-mapping.xul"] = true;

var MWH_init = false;

var MWH_ww = {
  observe : function(subject, topic, data) {
    if (topic == "domwindowopened") {
      try {
        subject.addEventListener("load", MWH_loadHandler, false);
      }
      catch (e) {}
    }

    if (topic == "quit-application") {
      MWH_obS.removeObserver(MWH_ww, "quit-application");
      MWH_obS.removeObserver(MWH_ww, "domwindowopened");

      var collectorFile = MWH_getCollectorFile(true);

      if (collectorFile.exists())
        MWH_writeToFile();
    }
  }
}

MWH_obS.addObserver(MWH_ww, "quit-application", false);
MWH_obS.addObserver(MWH_ww, "domwindowopened", false);

function MWH_loadHandler(e) {
  try {
    var doc = e.target;

    if (doc.location.protocol == "chrome:") {
      if (!MWH_init)
        MWH_getCollection();

      MWH_init = true;
      var enabled = false;

      try {
        enabled = MWH_prB.getBoolPref("window.unknownWindow");
      }
      catch (err1) {}

      var isExcluded = ((doc.location in MWH_wTypes) || (doc.location in MWH_exclude)) ? true : false;

      if (!isExcluded)
        MWH_collect[doc.location] = true;

      if (doc.location == "chrome://mozgest/content/pref/permissions.xul")
        doc.defaultView._MWH = MWH_wrapper;

      if (enabled && !isExcluded) {
        var win = doc.defaultView;
        win.setTimeout("try {document.loadOverlay('chrome://mozgest/content/unknownWindow.xul', null);} catch(err){}", 0);
      }
    }
  }
  catch (err) {}
}

function MWH_getCollectorFile(isShutDown) {
    var collectorFile = MWH_dir.get('ProfD', Components.interfaces.nsILocalFile);
    collectorFile.append("mozgest3")

    if (!isShutDown) {
      try {
        collectorFile.create(1, 0755);
      }
      catch (e) {}
    }

    collectorFile.append("collector3.js");
    return collectorFile;
}

function MWH_getCollection() {
  var collectorFile = MWH_getCollectorFile(false);

  if (!collectorFile.exists())
    MWH_writeToFile(true);

  var ioService  = Components.classes["@mozilla.org/network/io-service;1"]
                   .getService(Components.interfaces.nsIIOService);
  var mgFileSpec = ioService.newFileURI(collectorFile).spec;

  try {
    MWH_jsL.loadSubScript(mgFileSpec);
  }
  catch (err) {
    MWH_writeToFile(true);
    MWH_jsL.loadSubScript(mgFileSpec);
  }
}

function MWH_writeToFile(newFile) {
  var txt = '//MozGestWindowCollector\n//Do not change!\n\n';
  txt = txt + 'var MWH_exclude = new Array();\n'

  for (win in MWH_excludeAlways)
    txt = txt + 'MWH_exclude["' + win + '"] = true;\n';

  if (newFile) {
    for (win in MWH_excludeDefault)
      txt = txt + 'MWH_exclude["' + win + '"] = true;\n';
  }
  else {
    for (win in MWH_exclude) {
      if (!(win in MWH_excludeAlways))
        txt = txt + 'MWH_exclude["' + win + '"] = true;\n';
    }
  }

  txt = txt + '\nvar MWH_collect = new Array();\n'

  try {
    for (win in MWH_collect)
      txt = txt + 'MWH_collect["' + win + '"] = true;\n';
  }
  catch (err) {}

  var collectorFile = MWH_getCollectorFile(false);

  var stream = Components.classes["@mozilla.org/network/file-output-stream;1"]
               .createInstance(Components.interfaces.nsIFileOutputStream);

  stream.init(collectorFile, 0x02 | 0x08 | 0x20, 0644, 0);
  stream.write(txt, txt.length);
  stream.close();
}

var MWH_wrapper = {
  get : function() {
    this.exclude = MWH_exclude;
    this.excludeAlways = MWH_excludeAlways;
    this.collect = MWH_collect;
  },

  reset : function() {
    MWH_writeToFile(true);
    MWH_getCollection();
  },

  set : function() {
    MWH_exclude = this.exclude;
    MWH_writeToFile();
    MWH_getCollection();
  },

  writeToFile : MWH_writeToFile
}


var mgWindowHandler = {
  QueryInterface: function(iid) {
    if (!iid.equals(Components.interfaces.nsIModule) &&
        !iid.equals(Components.interfaces.nsIFactory) &&
        !iid.equals(Components.interfaces.nsISupports))
      throw Components.results.NS_ERROR_NO_INTERFACE;

    return this;
  },

  getClassObject: function(compMgr, cid, iid) {
    if (!cid.equals(MWH_CID))
       throw Components.results.NS_ERROR_NO_INTERFACE;

    return this.QueryInterface(iid);
  },

  registerSelf: function(compMgr, fileSpec, location, type) {
    var compR = compMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);

    compR.registerFactoryLocation(MWH_CID, "MozgestWindowHandler",
                                  MWH_contractID, fileSpec, location, type);

    var catM = Components.classes["@mozilla.org/categorymanager;1"]
               .getService(Components.interfaces.nsICategoryManager);

    catM.addCategoryEntry("app-startup", "m-MozgestWindowHandler", MWH_contractID, true, true);
  },

  unregisterSelf : function(compMgr, location, type) {
    var catM = Components.classes["@mozilla.org/categorymanager;1"]
               .getService(Components.interfaces.nsICategoryManager);

    catM.deleteCategoryEntry("app-startup", "m-MozgestWindowHandler", true);
  },

  canUnload: function(a) {return true;},

  createInstance: function(outer, iid) {
    if (outer != null)
       throw Components.results.NS_ERROR_NO_AGGREGATION;

    return this;
  },

  lockFactory : function(a) {},
  observe : function(a,b,c) {}
}

function NSGetModule(compMgr, fileSpec) {
  return mgWindowHandler;
}