/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef P2KPROC_H
#define P2KPROC_H


#include <inttypes.h>
#include <qthread.h>


// ========= Default Phone Config ================
// Command to switch phone to P2k Mode
//#define DEF_SWITCH_TO_P2K_CMD "echo \"AT+MODE=8\" > /dev/usb/acm/0"

// Phone AT Vendor/Product ID
#define DEF_PHONE_AT_VENDOR 0x22b8
#define DEF_PHONE_AT_PRODUCT 0x4902

// Phone P2K Vendor/Product ID
#define DEF_PHONE_P2K_VENDOR 0x22b8
#define DEF_PHONE_P2K_PRODUCT 0x4901

// ========================================================


#define TASK_NONE 0
#define TASK_CONNECT 1
#define TASK_DISCONNECT 2
#define TASK_REBOOT 3
#define TASK_SUSPEND 5
#define TASK_GETINFO 6
#define TASK_FILELIST 7
#define TASK_DOWNLOADFILES 8
#define TASK_UPLOADFILES 9
#define TASK_DELETEFILES 10
#define TASK_CHANGEATTR 11
#define TASK_READSEEM 12
#define TASK_WRITESEEM 13
#define TASK_BACKUP 14
#define TASK_CREATEDIRECTORY 15
#define TASK_REMOVEDIRECTORY 16
#define TASK_SEARCH 17


#define PHONE_NONE 0
#define PHONE_AT 1
#define PHONE_P2K 2

#include <usb.h>
#include <qevent.h>
// #include <qstring.h>

#include "custmsg.h"

class QMutex;
class QObject;
class QString;

/*
union mWord
{
	unsigned short wordId;
	char id[2];
};

union mLong
{
	unsigned int longId;
	char id[4];
};
*/


#define INT16 uint16_t
#define INT32 uint32_t

typedef struct myDev
{
	unsigned int vendor;	// Vendor ID
	unsigned int product;	// Product ID
	char name[150];			// Name
}
myDev;

typedef struct
{
	unsigned int vendor;
	unsigned int product;
	char manufacturerStr[256];
	char productStr[256];
}
devInfo;

/**
@author Dmitry Nezhevenko
*/
class P2kProc : public QThread
{
public:
	P2kProc(QObject *);
	virtual void run();
	void stopThread();
	int getState();
	void phConnect();
	void phDisconnect();
	void phReboot();
	void phSuspend();
	void phGetInfo(int what);
	void phGetFileList();
	void phDownloadFiles(P2kFile * lst, int cnt, const char * dir);
	void phUploadFiles(P2kFile * lst, int cnt, const char * dirLocal, const char * dirPhone);
	void phDeleteFiles(P2kFile * lst, int cnt);
	void phChangeAttr(P2kFile * lst, int cnt);
	void phReadSeem(int x, int y, unsigned char * buf, int *size);
	void phWriteSeem(int x, int y, unsigned char * buf, int size);
	void phBackup(int x1, int y1, int x2, int y2, unsigned char * dir);
	void phCreateDirectory(const char *dir);
	void phRemoveDirectory(const char *dir);
	void phSearch(const char *request);
	
	
	
	void setATconfig (unsigned int vendor, unsigned int product);
	void setP2kconfig (unsigned int vendor, unsigned int product);
	void setDevice(char * cmd);
	int phGetDevList(devInfo * lst, int cnt);
	int drv_switchP2K(char * st = NULL);
private:
	myDev devlst[3];
	char ACMdev[1024];
	QString lastStr;
	QObject * parent;
	int isRunning;
	QMutex mtxInUse;
	struct usb_device *phone;
	usb_dev_handle *phoneHandle;
	int task;
	int phoneMode;
	INT16 freeID;
	int state;
	unsigned char packetCount[16*2+2];

	P2kFile * memLst;
	int memCnt;
	char memDir[1024];
	char memDir2[1024];
	int * memSize;
	unsigned char * memBuf;
	int memX;
	int memY;
	int memX1;
	int memY1;
	int isFirstRead;
	int lastControlStatus;
	int lastCnt;

	void postMessage(int style, const QString &msg);
	void postProgress(int pg);
	int isBusy();
	void setState(int st);

	void doUpdateMode();
	void doConnect();
	void doDisconnect();
	void doReboot();
	void doSuspend();
	void doGetInfo();
	void doGetDriveName();
	void doGetPhoneModel();
	void doGetFreeSpace();
	void doGetFileCount();
	void doGetFileList();
	void doDownloadFiles();
	void doUploadFiles();
	void doDeleteFiles();
	void doChangeAttr();
	void doReadSeem();
	void doWriteSeem();
	void doBackup();
	void doCreateDirectory();
	void doRemoveDirectory();
	void doSearch();

	void showArr(unsigned char *bytes, int size);

	int sendControl(int dir, usb_dev_handle *dev, int requesttype, int request, int value,
	                int index, char *bytes, int size, int timeout);
	int outData(unsigned char * data, unsigned int size);
	int inpSize(unsigned char * cmd, int size);
	int inpData(unsigned char * data, unsigned int count, unsigned int size);
	void drv_initUsb();
	int get_cmd_size(unsigned char * packetCount);
	int check_packet_header(unsigned char * buf, int bufsize, int adr, char needdata=1, char checky=1);
// 	void swapLong(INT32 * nm);
// 	void swapWord(INT16 * nm);


	struct usb_device * drv_findDevice(int vendor, int product);
	int drv_findPhone();
	int drv_openPhone();
	int drv_closePhone();
	int drv_connect();
	int drv_reboot();
	int drv_suspend();
	int drv_getDriveName(unsigned char * buf);
	int drv_getPhoneModel(unsigned char * buf);
	int drv_freeSpace(unsigned char * dev);
	int drv_fileCount();
	int drv_fileList();
	int drv_downloadOneFile(char * fn, char attr, unsigned long fsize, unsigned char * tbuf,
	                        unsigned long curSize, unsigned long allSize);
	int drv_downloadFiles(P2kFile * lst, int cnt, char * dir);
	int drv_uploadOneFile(char * phoneFn, unsigned char attr, unsigned long fsize, unsigned char * tbuf,
	unsigned long curSize, unsigned long allSize);
	int drv_uploadFiles(P2kFile * lst, int cnt, const char * dirLocal, const char * dirPhone);
	int drv_deleteFiles(P2kFile * lst, int cnt);
	int drv_changeAttr(P2kFile * lst, int cnt);
	int drv_read_seem(int x, int y, unsigned char * seemBuf, int seemBufSize);
	int drv_write_seem(int x, int y, unsigned char * seemBuf, int seemSize);
	int drv_backup(int x1, int y1, int x2, int y2, unsigned char * dir);
	int drv_search(char *request);
	int drv_getFullFileList();
	
	int FSAC_Delete(char * fname);
	int FSAC_Open(char * fname, unsigned char attr);
	int FSAC_Close();
	int FSAC_Seek(unsigned long offset, char dir);
	int FSAC_Read(unsigned char * buf, unsigned short size);
	int FSAC_Write(unsigned char * tbuf, int size);
	int FSAC_CreateDirectory(char * dirname);
	int FSAC_RemoveDirectory(char * dirname);

	// 	int downloadFile(char * fn, char attr, unsigned long fsize, unsigned char * tbuf);
	// 	int uploadFile(char * localFn, char * phoneFn, unsigned char attr);
};


#endif
