#include "bson/stringdata.h"
namespace mongo {
struct JSFile{ const char* name; const StringData& source; };
namespace JSFiles{
const StringData _jscode_raw_utils = 
"__quiet = false;\n" 
"__magicNoPrint = { __magicNoPrint : 1111 }\n" 
"\n" 
"chatty = function(s){\n" 
"if ( ! __quiet )\n" 
"print( s );\n" 
"}\n" 
"\n" 
"friendlyEqual = function( a , b ){\n" 
"if ( a == b )\n" 
"return true;\n" 
"\n" 
"a = tojson(a,false,true);\n" 
"b = tojson(b,false,true);\n" 
"\n" 
"if ( a == b )\n" 
"return true;\n" 
"\n" 
"var clean = function( s ){\n" 
"s = s.replace( /NumberInt\\((\\-?\\d+)\\)/g , \"$1\" );\n" 
"return s;\n" 
"}\n" 
"\n" 
"a = clean(a);\n" 
"b = clean(b);\n" 
"\n" 
"if ( a == b )\n" 
"return true;\n" 
"\n" 
"return false;\n" 
"}\n" 
"\n" 
"printStackTrace = function(){\n" 
"try{\n" 
"throw new Error(\"Printing Stack Trace\");\n" 
"} catch (e) {\n" 
"print(e.stack);\n" 
"}\n" 
"}\n" 
"\n" 
"doassert = function (msg) {\n" 
"if (msg.indexOf(\"assert\") == 0)\n" 
"print(msg);\n" 
"else\n" 
"print(\"assert: \" + msg);\n" 
"printStackTrace();\n" 
"throw msg;\n" 
"}\n" 
"\n" 
"assert = function( b , msg ){\n" 
"if ( assert._debug && msg ) print( \"in assert for: \" + msg );\n" 
"if ( b )\n" 
"return;\n" 
"doassert( msg == undefined ? \"assert failed\" : \"assert failed : \" + msg );\n" 
"}\n" 
"\n" 
"assert.automsg = function( b ) {\n" 
"assert( eval( b ), b );\n" 
"}\n" 
"\n" 
"assert._debug = false;\n" 
"\n" 
"assert.eq = function( a , b , msg ){\n" 
"if ( assert._debug && msg ) print( \"in assert for: \" + msg );\n" 
"\n" 
"if ( a == b )\n" 
"return;\n" 
"\n" 
"if ( ( a != null && b != null ) && friendlyEqual( a , b ) )\n" 
"return;\n" 
"\n" 
"doassert( \"[\" + tojson( a ) + \"] != [\" + tojson( b ) + \"] are not equal : \" + msg );\n" 
"}\n" 
"\n" 
"assert.eq.automsg = function( a, b ) {\n" 
"assert.eq( eval( a ), eval( b ), \"[\" + a + \"] != [\" + b + \"]\" );\n" 
"}\n" 
"\n" 
"assert.neq = function( a , b , msg ){\n" 
"if ( assert._debug && msg ) print( \"in assert for: \" + msg );\n" 
"if ( a != b )\n" 
"return;\n" 
"\n" 
"doassert( \"[\" + a + \"] != [\" + b + \"] are equal : \" + msg );\n" 
"}\n" 
"\n" 
"assert.contains = function( o, arr, msg ){\n" 
"var wasIn = false\n" 
"\n" 
"if( ! arr.length ){\n" 
"for( i in arr ){\n" 
"wasIn = arr[i] == o || ( ( arr[i] != null && o != null ) && friendlyEqual( arr[i] , o ) )\n" 
"return;\n" 
"if( wasIn ) break\n" 
"}\n" 
"}\n" 
"else {\n" 
"for( var i = 0; i < arr.length; i++ ){\n" 
"wasIn = arr[i] == o || ( ( arr[i] != null && o != null ) && friendlyEqual( arr[i] , o ) )\n" 
"if( wasIn ) break\n" 
"}\n" 
"}\n" 
"\n" 
"if( ! wasIn ) doassert( tojson( o ) + \" was not in \" + tojson( arr ) + \" : \" + msg )\n" 
"}\n" 
"\n" 
"assert.repeat = function( f, msg, timeout, interval ) {\n" 
"if ( assert._debug && msg ) print( \"in assert for: \" + msg );\n" 
"\n" 
"var start = new Date();\n" 
"timeout = timeout || 30000;\n" 
"interval = interval || 200;\n" 
"var last;\n" 
"while( 1 ) {\n" 
"\n" 
"if ( typeof( f ) == \"string\" ){\n" 
"if ( eval( f ) )\n" 
"return;\n" 
"}\n" 
"else {\n" 
"if ( f() )\n" 
"return;\n" 
"}\n" 
"\n" 
"if ( ( new Date() ).getTime() - start.getTime() > timeout )\n" 
"break;\n" 
"sleep( interval );\n" 
"}\n" 
"}\n" 
"\n" 
"assert.soon = function( f, msg, timeout /*ms*/, interval ) {\n" 
"if ( assert._debug && msg ) print( \"in assert for: \" + msg );\n" 
"\n" 
"var start = new Date();\n" 
"timeout = timeout || 30000;\n" 
"interval = interval || 200;\n" 
"var last;\n" 
"while( 1 ) {\n" 
"\n" 
"if ( typeof( f ) == \"string\" ){\n" 
"if ( eval( f ) )\n" 
"return;\n" 
"}\n" 
"else {\n" 
"if ( f() )\n" 
"return;\n" 
"}\n" 
"\n" 
"if ( ( new Date() ).getTime() - start.getTime() > timeout )\n" 
"doassert( \"assert.soon failed: \" + f + \", msg:\" + msg );\n" 
"sleep( interval );\n" 
"}\n" 
"}\n" 
"\n" 
"assert.throws = function( func , params , msg ){\n" 
"if ( assert._debug && msg ) print( \"in assert for: \" + msg );\n" 
"\n" 
"if ( params && typeof( params ) == \"string\" )\n" 
"throw \"2nd argument to assert.throws has to be an array\"\n" 
"\n" 
"try {\n" 
"func.apply( null , params );\n" 
"}\n" 
"catch ( e ){\n" 
"return e;\n" 
"}\n" 
"\n" 
"doassert( \"did not throw exception: \" + msg );\n" 
"}\n" 
"\n" 
"assert.throws.automsg = function( func, params ) {\n" 
"assert.throws( func, params, func.toString() );\n" 
"}\n" 
"\n" 
"assert.commandWorked = function( res , msg ){\n" 
"if ( assert._debug && msg ) print( \"in assert for: \" + msg );\n" 
"\n" 
"if ( res.ok == 1 )\n" 
"return;\n" 
"\n" 
"doassert( \"command failed: \" + tojson( res ) + \" : \" + msg );\n" 
"}\n" 
"\n" 
"assert.commandFailed = function( res , msg ){\n" 
"if ( assert._debug && msg ) print( \"in assert for: \" + msg );\n" 
"\n" 
"if ( res.ok == 0 )\n" 
"return;\n" 
"\n" 
"doassert( \"command worked when it should have failed: \" + tojson( res ) + \" : \" + msg );\n" 
"}\n" 
"\n" 
"assert.isnull = function( what , msg ){\n" 
"if ( assert._debug && msg ) print( \"in assert for: \" + msg );\n" 
"\n" 
"if ( what == null )\n" 
"return;\n" 
"\n" 
"doassert( \"supposed to null (\" + ( msg || \"\" ) + \") was: \" + tojson( what ) );\n" 
"}\n" 
"\n" 
"assert.lt = function( a , b , msg ){\n" 
"if ( assert._debug && msg ) print( \"in assert for: \" + msg );\n" 
"\n" 
"if ( a < b )\n" 
"return;\n" 
"doassert( a + \" is not less than \" + b + \" : \" + msg );\n" 
"}\n" 
"\n" 
"assert.gt = function( a , b , msg ){\n" 
"if ( assert._debug && msg ) print( \"in assert for: \" + msg );\n" 
"\n" 
"if ( a > b )\n" 
"return;\n" 
"doassert( a + \" is not greater than \" + b + \" : \" + msg );\n" 
"}\n" 
"\n" 
"assert.lte = function( a , b , msg ){\n" 
"if ( assert._debug && msg ) print( \"in assert for: \" + msg );\n" 
"\n" 
"if ( a <= b )\n" 
"return;\n" 
"doassert( a + \" is not less than or eq \" + b + \" : \" + msg );\n" 
"}\n" 
"\n" 
"assert.gte = function( a , b , msg ){\n" 
"if ( assert._debug && msg ) print( \"in assert for: \" + msg );\n" 
"\n" 
"if ( a >= b )\n" 
"return;\n" 
"doassert( a + \" is not greater than or eq \" + b + \" : \" + msg );\n" 
"}\n" 
"\n" 
"assert.between = function( a, b, c, msg, inclusive ){\n" 
"if ( assert._debug && msg ) print( \"in assert for: \" + msg );\n" 
"\n" 
"if( ( inclusive == undefined || inclusive == true ) &&\n" 
"a <= b && b <= c ) return;\n" 
"else if( a < b && b < c ) return;\n" 
"\n" 
"doassert( b + \" is not between \" + a + \" and \" + c + \" : \" + msg );\n" 
"}\n" 
"\n" 
"assert.betweenIn = function( a, b, c, msg ){ assert.between( a, b, c, msg, true ) }\n" 
"assert.betweenEx = function( a, b, c, msg ){ assert.between( a, b, c, msg, false ) }\n" 
"\n" 
"assert.close = function( a , b , msg , places ){\n" 
"if (places === undefined) {\n" 
"places = 4;\n" 
"}\n" 
"if (Math.round((a - b) * Math.pow(10, places)) === 0) {\n" 
"return;\n" 
"}\n" 
"doassert( a + \" is not equal to \" + b + \" within \" + places +\n" 
"\" places, diff: \" + (a-b) + \" : \" + msg );\n" 
"};\n" 
"\n" 
"Object.extend = function( dst , src , deep ){\n" 
"for ( var k in src ){\n" 
"var v = src[k];\n" 
"if ( deep && typeof(v) == \"object\" ){\n" 
"if ( \"floatApprox\" in v ) { // convert NumberLong properly\n" 
"eval( \"v = \" + tojson( v ) );\n" 
"} else {\n" 
"v = Object.extend( typeof ( v.length ) == \"number\" ? [] : {} , v , true );\n" 
"}\n" 
"}\n" 
"dst[k] = v;\n" 
"}\n" 
"return dst;\n" 
"}\n" 
"\n" 
"Object.merge = function( dst, src, deep ){\n" 
"var clone = Object.extend( {}, dst, deep )\n" 
"return Object.extend( clone, src, deep )\n" 
"}\n" 
"\n" 
"argumentsToArray = function( a ){\n" 
"var arr = [];\n" 
"for ( var i=0; i<a.length; i++ )\n" 
"arr[i] = a[i];\n" 
"return arr;\n" 
"}\n" 
"\n" 
"isString = function( x ){\n" 
"return typeof( x ) == \"string\";\n" 
"}\n" 
"\n" 
"isNumber = function(x){\n" 
"return typeof( x ) == \"number\";\n" 
"}\n" 
"\n" 
"isObject = function( x ){\n" 
"return typeof( x ) == \"object\";\n" 
"}\n" 
"\n" 
"String.prototype.trim = function() {\n" 
"return this.replace(/^\\s+|\\s+$/g,\"\");\n" 
"}\n" 
"String.prototype.ltrim = function() {\n" 
"return this.replace(/^\\s+/,\"\");\n" 
"}\n" 
"String.prototype.rtrim = function() {\n" 
"return this.replace(/\\s+$/,\"\");\n" 
"}\n" 
"\n" 
"Number.prototype.zeroPad = function(width) {\n" 
"var str = this + '';\n" 
"while (str.length < width)\n" 
"str = '0' + str;\n" 
"return str;\n" 
"}\n" 
"\n" 
"Date.timeFunc = function( theFunc , numTimes ){\n" 
"\n" 
"var start = new Date();\n" 
"\n" 
"numTimes = numTimes || 1;\n" 
"for ( var i=0; i<numTimes; i++ ){\n" 
"theFunc.apply( null , argumentsToArray( arguments ).slice( 2 ) );\n" 
"}\n" 
"\n" 
"return (new Date()).getTime() - start.getTime();\n" 
"}\n" 
"\n" 
"Date.prototype.tojson = function(){\n" 
"\n" 
"var UTC = Date.printAsUTC ? 'UTC' : '';\n" 
"\n" 
"var year = this['get'+UTC+'FullYear']().zeroPad(4);\n" 
"var month = (this['get'+UTC+'Month']() + 1).zeroPad(2);\n" 
"var date = this['get'+UTC+'Date']().zeroPad(2);\n" 
"var hour = this['get'+UTC+'Hours']().zeroPad(2);\n" 
"var minute = this['get'+UTC+'Minutes']().zeroPad(2);\n" 
"var sec = this['get'+UTC+'Seconds']().zeroPad(2)\n" 
"\n" 
"if (this['get'+UTC+'Milliseconds']())\n" 
"sec += '.' + this['get'+UTC+'Milliseconds']().zeroPad(3)\n" 
"\n" 
"var ofs = 'Z';\n" 
"if (!Date.printAsUTC){\n" 
"var ofsmin = this.getTimezoneOffset();\n" 
"if (ofsmin != 0){\n" 
"ofs = ofsmin > 0 ? '-' : '+'; // This is correct\n" 
"ofs += (ofsmin/60).zeroPad(2)\n" 
"ofs += (ofsmin%60).zeroPad(2)\n" 
"}\n" 
"}\n" 
"\n" 
"return 'ISODate(\"'+year+'-'+month+'-'+date+'T'+hour+':'+minute+':'+sec+ofs+'\")';\n" 
"}\n" 
"\n" 
"Date.printAsUTC = true;\n" 
"\n" 
"\n" 
"ISODate = function(isoDateStr){\n" 
"if (!isoDateStr)\n" 
"return new Date();\n" 
"\n" 
"var isoDateRegex = /(\\d{4})-?(\\d{2})-?(\\d{2})([T ](\\d{2})(:?(\\d{2})(:?(\\d{2}(\\.\\d+)?))?)?(Z|([+-])(\\d{2}):?(\\d{2})?)?)?/;\n" 
"var res = isoDateRegex.exec(isoDateStr);\n" 
"\n" 
"if (!res)\n" 
"throw \"invalid ISO date\";\n" 
"\n" 
"var year = parseInt(res[1],10) || 1970; // this should always be present\n" 
"var month = (parseInt(res[2],10) || 1) - 1;\n" 
"var date = parseInt(res[3],10) || 0;\n" 
"var hour = parseInt(res[5],10) || 0;\n" 
"var min = parseInt(res[7],10) || 0;\n" 
"var sec = parseFloat(res[9]) || 0;\n" 
"var ms = Math.round((sec%1) * 1000)\n" 
"sec -= ms/1000\n" 
"\n" 
"var time = Date.UTC(year, month, date, hour, min, sec, ms);\n" 
"\n" 
"if (res[11] && res[11] != 'Z'){\n" 
"var ofs = 0;\n" 
"ofs += (parseInt(res[13],10) || 0) * 60*60*1000; // hours\n" 
"ofs += (parseInt(res[14],10) || 0) *    60*1000; // mins\n" 
"if (res[12] == '+') // if ahead subtract\n" 
"ofs *= -1;\n" 
"\n" 
"time += ofs\n" 
"}\n" 
"\n" 
"return new Date(time);\n" 
"}\n" 
"\n" 
"RegExp.prototype.tojson = RegExp.prototype.toString;\n" 
"\n" 
"Array.contains = function( a  , x ){\n" 
"for ( var i=0; i<a.length; i++ ){\n" 
"if ( a[i] == x )\n" 
"return true;\n" 
"}\n" 
"return false;\n" 
"}\n" 
"\n" 
"Array.unique = function( a ){\n" 
"var u = [];\n" 
"for ( var i=0; i<a.length; i++){\n" 
"var o = a[i];\n" 
"if ( ! Array.contains( u , o ) ){\n" 
"u.push( o );\n" 
"}\n" 
"}\n" 
"return u;\n" 
"}\n" 
"\n" 
"Array.shuffle = function( arr ){\n" 
"for ( var i=0; i<arr.length-1; i++ ){\n" 
"var pos = i+Random.randInt(arr.length-i);\n" 
"var save = arr[i];\n" 
"arr[i] = arr[pos];\n" 
"arr[pos] = save;\n" 
"}\n" 
"return arr;\n" 
"}\n" 
"\n" 
"\n" 
"Array.tojson = function( a , indent , nolint ){\n" 
"var lineEnding = nolint ? \" \" : \"\\n\";\n" 
"\n" 
"if (!indent)\n" 
"indent = \"\";\n" 
"\n" 
"if ( nolint )\n" 
"indent = \"\";\n" 
"\n" 
"if (a.length == 0) {\n" 
"return \"[ ]\";\n" 
"}\n" 
"\n" 
"var s = \"[\" + lineEnding;\n" 
"indent += \"\\t\";\n" 
"for ( var i=0; i<a.length; i++){\n" 
"s += indent + tojson( a[i], indent , nolint );\n" 
"if ( i < a.length - 1 ){\n" 
"s += \",\" + lineEnding;\n" 
"}\n" 
"}\n" 
"if ( a.length == 0 ) {\n" 
"s += indent;\n" 
"}\n" 
"\n" 
"indent = indent.substring(1);\n" 
"s += lineEnding+indent+\"]\";\n" 
"return s;\n" 
"}\n" 
"\n" 
"Array.fetchRefs = function( arr , coll ){\n" 
"var n = [];\n" 
"for ( var i=0; i<arr.length; i ++){\n" 
"var z = arr[i];\n" 
"if ( coll && coll != z.getCollection() )\n" 
"continue;\n" 
"n.push( z.fetch() );\n" 
"}\n" 
"\n" 
"return n;\n" 
"}\n" 
"\n" 
"Array.sum = function( arr ){\n" 
"if ( arr.length == 0 )\n" 
"return null;\n" 
"var s = arr[0];\n" 
"for ( var i=1; i<arr.length; i++ )\n" 
"s += arr[i];\n" 
"return s;\n" 
"}\n" 
"\n" 
"Array.avg = function( arr ){\n" 
"if ( arr.length == 0 )\n" 
"return null;\n" 
"return Array.sum( arr ) / arr.length;\n" 
"}\n" 
"\n" 
"Array.stdDev = function( arr ){\n" 
"var avg = Array.avg( arr );\n" 
"var sum = 0;\n" 
"\n" 
"for ( var i=0; i<arr.length; i++ ){\n" 
"sum += Math.pow( arr[i] - avg , 2 );\n" 
"}\n" 
"\n" 
"return Math.sqrt( sum / arr.length );\n" 
"}\n" 
"\n" 
"//these two are helpers for Array.sort(func)\n" 
"compare = function(l, r){ return (l == r ? 0 : (l < r ? -1 : 1)); }\n" 
"\n" 
"// arr.sort(compareOn('name'))\n" 
"compareOn = function(field){\n" 
"return function(l, r) { return compare(l[field], r[field]); }\n" 
"}\n" 
"\n" 
"Object.keySet = function( o ) {\n" 
"var ret = new Array();\n" 
"for( i in o ) {\n" 
"if ( !( i in o.__proto__ && o[ i ] === o.__proto__[ i ] ) ) {\n" 
"ret.push( i );\n" 
"}\n" 
"}\n" 
"return ret;\n" 
"}\n" 
"\n" 
"if ( ! NumberLong.prototype ) {\n" 
"NumberLong.prototype = {}\n" 
"}\n" 
"\n" 
"NumberLong.prototype.tojson = function() {\n" 
"return this.toString();\n" 
"}\n" 
"\n" 
"if ( ! NumberInt.prototype ) {\n" 
"NumberInt.prototype = {}\n" 
"}\n" 
"\n" 
"NumberInt.prototype.tojson = function() {\n" 
"return this.toString();\n" 
"}\n" 
"\n" 
"if ( ! ObjectId.prototype )\n" 
"ObjectId.prototype = {}\n" 
"\n" 
"ObjectId.prototype.toString = function(){\n" 
"return this.str;\n" 
"}\n" 
"\n" 
"ObjectId.prototype.tojson = function(){\n" 
"return \"ObjectId(\\\"\" + this.str + \"\\\")\";\n" 
"}\n" 
"\n" 
"ObjectId.prototype.isObjectId = true;\n" 
"\n" 
"ObjectId.prototype.getTimestamp = function(){\n" 
"return new Date(parseInt(this.toString().slice(0,8), 16)*1000);\n" 
"}\n" 
"\n" 
"ObjectId.prototype.equals = function( other){\n" 
"return this.str == other.str;\n" 
"}\n" 
"\n" 
"if ( typeof( DBPointer ) != \"undefined\" ){\n" 
"DBPointer.prototype.fetch = function(){\n" 
"assert( this.ns , \"need a ns\" );\n" 
"assert( this.id , \"need an id\" );\n" 
"\n" 
"return db[ this.ns ].findOne( { _id : this.id } );\n" 
"}\n" 
"\n" 
"DBPointer.prototype.tojson = function(indent){\n" 
"return tojson({\"ns\" : this.ns, \"id\" : this.id}, indent);\n" 
"}\n" 
"\n" 
"DBPointer.prototype.getCollection = function(){\n" 
"return this.ns;\n" 
"}\n" 
"\n" 
"DBPointer.prototype.toString = function(){\n" 
"return \"DBPointer \" + this.ns + \":\" + this.id;\n" 
"}\n" 
"}\n" 
"else {\n" 
"print( \"warning: no DBPointer\" );\n" 
"}\n" 
"\n" 
"if ( typeof( DBRef ) != \"undefined\" ){\n" 
"DBRef.prototype.fetch = function(){\n" 
"assert( this.$ref , \"need a ns\" );\n" 
"assert( this.$id , \"need an id\" );\n" 
"\n" 
"return db[ this.$ref ].findOne( { _id : this.$id } );\n" 
"}\n" 
"\n" 
"DBRef.prototype.tojson = function(indent){\n" 
"return tojson({\"$ref\" : this.$ref, \"$id\" : this.$id}, indent);\n" 
"}\n" 
"\n" 
"DBRef.prototype.getCollection = function(){\n" 
"return this.$ref;\n" 
"}\n" 
"\n" 
"DBRef.prototype.toString = function(){\n" 
"return this.tojson();\n" 
"}\n" 
"}\n" 
"else {\n" 
"print( \"warning: no DBRef\" );\n" 
"}\n" 
"\n" 
"if ( typeof( BinData ) != \"undefined\" ){\n" 
"BinData.prototype.tojson = function () {\n" 
"//return \"BinData type: \" + this.type + \" len: \" + this.len;\n" 
"return this.toString();\n" 
"}\n" 
"\n" 
"BinData.prototype.subtype = function () {\n" 
"return this.type;\n" 
"}\n" 
"\n" 
"BinData.prototype.length = function () {\n" 
"return this.len;\n" 
"}\n" 
"}\n" 
"else {\n" 
"print( \"warning: no BinData class\" );\n" 
"}\n" 
"\n" 
"/*if ( typeof( UUID ) != \"undefined\" ){\n" 
"UUID.prototype.tojson = function () {\n" 
"return this.toString();\n" 
"}\n" 
"}*/\n" 
"\n" 
"if ( typeof _threadInject != \"undefined\" ){\n" 
"print( \"fork() available!\" );\n" 
"\n" 
"Thread = function(){\n" 
"this.init.apply( this, arguments );\n" 
"}\n" 
"_threadInject( Thread.prototype );\n" 
"\n" 
"ScopedThread = function() {\n" 
"this.init.apply( this, arguments );\n" 
"}\n" 
"ScopedThread.prototype = new Thread( function() {} );\n" 
"_scopedThreadInject( ScopedThread.prototype );\n" 
"\n" 
"fork = function() {\n" 
"var t = new Thread( function() {} );\n" 
"Thread.apply( t, arguments );\n" 
"return t;\n" 
"}\n" 
"\n" 
"// Helper class to generate a list of events which may be executed by a ParallelTester\n" 
"EventGenerator = function( me, collectionName, mean ) {\n" 
"this.mean = mean;\n" 
"this.events = new Array( me, collectionName );\n" 
"}\n" 
"\n" 
"EventGenerator.prototype._add = function( action ) {\n" 
"this.events.push( [ Random.genExp( this.mean ), action ] );\n" 
"}\n" 
"\n" 
"EventGenerator.prototype.addInsert = function( obj ) {\n" 
"this._add( \"t.insert( \" + tojson( obj ) + \" )\" );\n" 
"}\n" 
"\n" 
"EventGenerator.prototype.addRemove = function( obj ) {\n" 
"this._add( \"t.remove( \" + tojson( obj ) + \" )\" );\n" 
"}\n" 
"\n" 
"EventGenerator.prototype.addUpdate = function( objOld, objNew ) {\n" 
"this._add( \"t.update( \" + tojson( objOld ) + \", \" + tojson( objNew ) + \" )\" );\n" 
"}\n" 
"\n" 
"EventGenerator.prototype.addCheckCount = function( count, query, shouldPrint, checkQuery ) {\n" 
"query = query || {};\n" 
"shouldPrint = shouldPrint || false;\n" 
"checkQuery = checkQuery || false;\n" 
"var action = \"assert.eq( \" + count + \", t.count( \" + tojson( query ) + \" ) );\"\n" 
"if ( checkQuery ) {\n" 
"action += \" assert.eq( \" + count + \", t.find( \" + tojson( query ) + \" ).toArray().length );\"\n" 
"}\n" 
"if ( shouldPrint ) {\n" 
"action += \" print( me + ' ' + \" + count + \" );\";\n" 
"}\n" 
"this._add( action );\n" 
"}\n" 
"\n" 
"EventGenerator.prototype.getEvents = function() {\n" 
"return this.events;\n" 
"}\n" 
"\n" 
"EventGenerator.dispatch = function() {\n" 
"var args = argumentsToArray( arguments );\n" 
"var me = args.shift();\n" 
"var collectionName = args.shift();\n" 
"var m = new Mongo( db.getMongo().host );\n" 
"var t = m.getDB( \"test\" )[ collectionName ];\n" 
"for( var i in args ) {\n" 
"sleep( args[ i ][ 0 ] );\n" 
"eval( args[ i ][ 1 ] );\n" 
"}\n" 
"}\n" 
"\n" 
"// Helper class for running tests in parallel.  It assembles a set of tests\n" 
"// and then calls assert.parallelests to run them.\n" 
"ParallelTester = function() {\n" 
"this.params = new Array();\n" 
"}\n" 
"\n" 
"ParallelTester.prototype.add = function( fun, args ) {\n" 
"args = args || [];\n" 
"args.unshift( fun );\n" 
"this.params.push( args );\n" 
"}\n" 
"\n" 
"ParallelTester.prototype.run = function( msg, newScopes ) {\n" 
"newScopes = newScopes || false;\n" 
"assert.parallelTests( this.params, msg, newScopes );\n" 
"}\n" 
"\n" 
"// creates lists of tests from jstests dir in a format suitable for use by\n" 
"// ParallelTester.fileTester.  The lists will be in random order.\n" 
"// n: number of lists to split these tests into\n" 
"ParallelTester.createJstestsLists = function( n ) {\n" 
"var params = new Array();\n" 
"for( var i = 0; i < n; ++i ) {\n" 
"params.push( [] );\n" 
"}\n" 
"\n" 
"var makeKeys = function( a ) {\n" 
"var ret = {};\n" 
"for( var i in a ) {\n" 
"ret[ a[ i ] ] = 1;\n" 
"}\n" 
"return ret;\n" 
"}\n" 
"\n" 
"// some tests can't run in parallel with most others\n" 
"var skipTests = makeKeys( [ \"jstests/dbadmin.js\",\n" 
"\"jstests/repair.js\",\n" 
"\"jstests/cursor8.js\",\n" 
"\"jstests/recstore.js\",\n" 
"\"jstests/extent.js\",\n" 
"\"jstests/indexb.js\",\n" 
"\"jstests/profile1.js\",\n" 
"\"jstests/mr3.js\",\n" 
"\"jstests/indexh.js\",\n" 
"\"jstests/apitest_db.js\",\n" 
"\"jstests/evalb.js\",\n" 
"\"jstests/evald.js\",\n" 
"\"jstests/evalf.js\",\n" 
"\"jstests/killop.js\",\n" 
"\"jstests/run_program1.js\",\n" 
"\"jstests/notablescan.js\",\n" 
"\"jstests/drop2.js\",\n" 
"\"jstests/dropdb_race.js\",\n" 
"\"jstests/bench_test1.js\"] );\n" 
"\n" 
"// some tests can't be run in parallel with each other\n" 
"var serialTestsArr = [ \"jstests/fsync.js\",\n" 
"\"jstests/fsync2.js\" ];\n" 
"var serialTests = makeKeys( serialTestsArr );\n" 
"\n" 
"params[ 0 ] = serialTestsArr;\n" 
"\n" 
"var files = listFiles(\"jstests\");\n" 
"files = Array.shuffle( files );\n" 
"\n" 
"var i = 0;\n" 
"files.forEach(\n" 
"function(x) {\n" 
"\n" 
"if ( ( /[\\/\\\\]_/.test(x.name) ) ||\n" 
"( ! /\\.js$/.test(x.name ) ) ||\n" 
"( x.name in skipTests ) ||\n" 
"( x.name in serialTests ) ||\n" 
"! /\\.js$/.test(x.name ) ){\n" 
"print(\" >>>>>>>>>>>>>>> skipping \" + x.name);\n" 
"return;\n" 
"}\n" 
"\n" 
"params[ i % n ].push( x.name );\n" 
"++i;\n" 
"}\n" 
");\n" 
"\n" 
"// randomize ordering of the serialTests\n" 
"params[ 0 ] = Array.shuffle( params[ 0 ] );\n" 
"\n" 
"for( var i in params ) {\n" 
"params[ i ].unshift( i );\n" 
"}\n" 
"\n" 
"return params;\n" 
"}\n" 
"\n" 
"// runs a set of test files\n" 
"// first argument is an identifier for this tester, remaining arguments are file names\n" 
"ParallelTester.fileTester = function() {\n" 
"var args = argumentsToArray( arguments );\n" 
"var suite = args.shift();\n" 
"args.forEach(\n" 
"function( x ) {\n" 
"print(\"         S\" + suite + \" Test : \" + x + \" ...\");\n" 
"var time = Date.timeFunc( function() { load(x); }, 1);\n" 
"print(\"         S\" + suite + \" Test : \" + x + \" \" + time + \"ms\" );\n" 
"}\n" 
");\n" 
"}\n" 
"\n" 
"// params: array of arrays, each element of which consists of a function followed\n" 
"// by zero or more arguments to that function.  Each function and its arguments will\n" 
"// be called in a separate thread.\n" 
"// msg: failure message\n" 
"// newScopes: if true, each thread starts in a fresh scope\n" 
"assert.parallelTests = function( params, msg, newScopes ) {\n" 
"newScopes = newScopes || false;\n" 
"var wrapper = function( fun, argv ) {\n" 
"eval (\n" 
"\"var z = function() {\" +\n" 
"\"var __parallelTests__fun = \" + fun.toString() + \";\" +\n" 
"\"var __parallelTests__argv = \" + tojson( argv ) + \";\" +\n" 
"\"var __parallelTests__passed = false;\" +\n" 
"\"try {\" +\n" 
"\"__parallelTests__fun.apply( 0, __parallelTests__argv );\" +\n" 
"\"__parallelTests__passed = true;\" +\n" 
"\"} catch ( e ) {\" +\n" 
"\"print( '********** Parallel Test FAILED: ' + tojson(e) );\" +\n" 
"\"}\" +\n" 
"\"return __parallelTests__passed;\" +\n" 
"\"}\"\n" 
");\n" 
"return z;\n" 
"}\n" 
"var runners = new Array();\n" 
"for( var i in params ) {\n" 
"var param = params[ i ];\n" 
"var test = param.shift();\n" 
"var t;\n" 
"if ( newScopes )\n" 
"t = new ScopedThread( wrapper( test, param ) );\n" 
"else\n" 
"t = new Thread( wrapper( test, param ) );\n" 
"runners.push( t );\n" 
"}\n" 
"\n" 
"runners.forEach( function( x ) { x.start(); } );\n" 
"var nFailed = 0;\n" 
"// v8 doesn't like it if we exit before all threads are joined (SERVER-529)\n" 
"runners.forEach( function( x ) { if( !x.returnData() ) { ++nFailed; } } );\n" 
"assert.eq( 0, nFailed, msg );\n" 
"}\n" 
"}\n" 
"\n" 
"tojsononeline = function( x ){\n" 
"return tojson( x , \" \" , true );\n" 
"}\n" 
"\n" 
"tojson = function( x, indent , nolint ){\n" 
"if ( x === null )\n" 
"return \"null\";\n" 
"\n" 
"if ( x === undefined )\n" 
"return \"undefined\";\n" 
"\n" 
"if (!indent)\n" 
"indent = \"\";\n" 
"\n" 
"switch ( typeof x ) {\n" 
"case \"string\": {\n" 
"var s = \"\\\"\";\n" 
"for ( var i=0; i<x.length; i++ ){\n" 
"switch (x[i]){\n" 
"case '\"': s += '\\\\\"'; break;\n" 
"case '\\\\': s += '\\\\\\\\'; break;\n" 
"case '\\b': s += '\\\\b'; break;\n" 
"case '\\f': s += '\\\\f'; break;\n" 
"case '\\n': s += '\\\\n'; break;\n" 
"case '\\r': s += '\\\\r'; break;\n" 
"case '\\t': s += '\\\\t'; break;\n" 
"\n" 
"default: {\n" 
"var code = x.charCodeAt(i);\n" 
"if (code < 0x20){\n" 
"s += (code < 0x10 ? '\\\\u000' : '\\\\u00') + code.toString(16);\n" 
"} else {\n" 
"s += x[i];\n" 
"}\n" 
"}\n" 
"}\n" 
"}\n" 
"return s + \"\\\"\";\n" 
"}\n" 
"case \"number\":\n" 
"case \"boolean\":\n" 
"return \"\" + x;\n" 
"case \"object\":{\n" 
"var s = tojsonObject( x, indent , nolint );\n" 
"if ( ( nolint == null || nolint == true ) && s.length < 80 && ( indent == null || indent.length == 0 ) ){\n" 
"s = s.replace( /[\\s\\r\\n ]+/gm , \" \" );\n" 
"}\n" 
"return s;\n" 
"}\n" 
"case \"function\":\n" 
"return x.toString();\n" 
"default:\n" 
"throw \"tojson can't handle type \" + ( typeof x );\n" 
"}\n" 
"\n" 
"}\n" 
"\n" 
"tojsonObject = function( x, indent , nolint ){\n" 
"var lineEnding = nolint ? \" \" : \"\\n\";\n" 
"var tabSpace = nolint ? \"\" : \"\\t\";\n" 
"\n" 
"assert.eq( ( typeof x ) , \"object\" , \"tojsonObject needs object, not [\" + ( typeof x ) + \"]\" );\n" 
"\n" 
"if (!indent)\n" 
"indent = \"\";\n" 
"\n" 
"if ( typeof( x.tojson ) == \"function\" && x.tojson != tojson ) {\n" 
"return x.tojson(indent,nolint);\n" 
"}\n" 
"\n" 
"if ( x.constructor && typeof( x.constructor.tojson ) == \"function\" && x.constructor.tojson != tojson ) {\n" 
"return x.constructor.tojson( x, indent , nolint );\n" 
"}\n" 
"\n" 
"if ( x.toString() == \"[object MaxKey]\" )\n" 
"return \"{ $maxKey : 1 }\";\n" 
"if ( x.toString() == \"[object MinKey]\" )\n" 
"return \"{ $minKey : 1 }\";\n" 
"\n" 
"var s = \"{\" + lineEnding;\n" 
"\n" 
"// push one level of indent\n" 
"indent += tabSpace;\n" 
"\n" 
"var total = 0;\n" 
"for ( var k in x ) total++;\n" 
"if ( total == 0 ) {\n" 
"s += indent + lineEnding;\n" 
"}\n" 
"\n" 
"var keys = x;\n" 
"if ( typeof( x._simpleKeys ) == \"function\" )\n" 
"keys = x._simpleKeys();\n" 
"var num = 1;\n" 
"for ( var k in keys ){\n" 
"\n" 
"var val = x[k];\n" 
"if ( val == DB.prototype || val == DBCollection.prototype )\n" 
"continue;\n" 
"\n" 
"s += indent + \"\\\"\" + k + \"\\\" : \" + tojson( val, indent , nolint );\n" 
"if (num != total) {\n" 
"s += \",\";\n" 
"num++;\n" 
"}\n" 
"s += lineEnding;\n" 
"}\n" 
"\n" 
"// pop one level of indent\n" 
"indent = indent.substring(1);\n" 
"return s + indent + \"}\";\n" 
"}\n" 
"\n" 
"shellPrint = function( x ){\n" 
"it = x;\n" 
"if ( x != undefined )\n" 
"shellPrintHelper( x );\n" 
"\n" 
"if ( db ){\n" 
"var e = db.getPrevError();\n" 
"if ( e.err ) {\n" 
"if( e.nPrev <= 1 )\n" 
"print( \"error on last call: \" + tojson( e.err ) );\n" 
"else\n" 
"print( \"an error \" + tojson(e.err) + \" occurred \" + e.nPrev + \" operations back in the command invocation\" );\n" 
"}\n" 
"db.resetError();\n" 
"}\n" 
"}\n" 
"\n" 
"printjson = function(x){\n" 
"print( tojson( x ) );\n" 
"}\n" 
"\n" 
"printjsononeline = function(x){\n" 
"print( tojsononeline( x ) );\n" 
"}\n" 
"\n" 
"if ( typeof TestData == \"undefined\" ){\n" 
"TestData = undefined\n" 
"}\n" 
"\n" 
"jsTestName = function(){\n" 
"if( TestData ) return TestData.testName\n" 
"return \"__unknown_name__\"\n" 
"}\n" 
"\n" 
"jsTestFile = function(){\n" 
"if( TestData ) return TestData.testFile\n" 
"return \"__unknown_file__\"\n" 
"}\n" 
"\n" 
"jsTestPath = function(){\n" 
"if( TestData ) return TestData.testPath\n" 
"return \"__unknown_path__\"\n" 
"}\n" 
"\n" 
"jsTestOptions = function(){\n" 
"if( TestData ) return { noJournal : TestData.noJournal,\n" 
"noJournalPrealloc : TestData.noJournalPrealloc }\n" 
"return {}\n" 
"}\n" 
"\n" 
"jsTestLog = function(msg){\n" 
"print( \"\\n\\n----\\n\" + msg + \"\\n----\\n\\n\" )\n" 
"}\n" 
"\n" 
"shellPrintHelper = function (x) {\n" 
"\n" 
"if (typeof (x) == \"undefined\") {\n" 
"\n" 
"if (typeof (db) != \"undefined\" && db.getLastError) {\n" 
"// explicit w:1 so that replset getLastErrorDefaults aren't used here which would be bad.\n" 
"var e = db.getLastError(1);\n" 
"if (e != null)\n" 
"print(e);\n" 
"}\n" 
"\n" 
"return;\n" 
"}\n" 
"\n" 
"if (x == __magicNoPrint)\n" 
"return;\n" 
"\n" 
"if (x == null) {\n" 
"print(\"null\");\n" 
"return;\n" 
"}\n" 
"\n" 
"if (typeof x != \"object\")\n" 
"return print(x);\n" 
"\n" 
"var p = x.shellPrint;\n" 
"if (typeof p == \"function\")\n" 
"return x.shellPrint();\n" 
"\n" 
"var p = x.tojson;\n" 
"if (typeof p == \"function\")\n" 
"print(x.tojson());\n" 
"else\n" 
"print(tojson(x));\n" 
"}\n" 
"\n" 
"shellAutocomplete = function (/*prefix*/){ // outer scope function called on init. Actual function at end\n" 
"\n" 
"var universalMethods = \"constructor prototype toString valueOf toLocaleString hasOwnProperty propertyIsEnumerable\".split(' ');\n" 
"\n" 
"var builtinMethods = {}; // uses constructor objects as keys\n" 
"builtinMethods[Array] = \"length concat join pop push reverse shift slice sort splice unshift indexOf lastIndexOf every filter forEach map some\".split(' ');\n" 
"builtinMethods[Boolean] = \"\".split(' '); // nothing more than universal methods\n" 
"builtinMethods[Date] = \"getDate getDay getFullYear getHours getMilliseconds getMinutes getMonth getSeconds getTime getTimezoneOffset getUTCDate getUTCDay getUTCFullYear getUTCHours getUTCMilliseconds getUTCMinutes getUTCMonth getUTCSeconds getYear parse setDate setFullYear setHours setMilliseconds setMinutes setMonth setSeconds setTime setUTCDate setUTCFullYear setUTCHours setUTCMilliseconds setUTCMinutes setUTCMonth setUTCSeconds setYear toDateString toGMTString toLocaleDateString toLocaleTimeString toTimeString toUTCString UTC\".split(' ');\n" 
"builtinMethods[Math] = \"E LN2 LN10 LOG2E LOG10E PI SQRT1_2 SQRT2 abs acos asin atan atan2 ceil cos exp floor log max min pow random round sin sqrt tan\".split(' ');\n" 
"builtinMethods[Number] = \"MAX_VALUE MIN_VALUE NEGATIVE_INFINITY POSITIVE_INFINITY toExponential toFixed toPrecision\".split(' ');\n" 
"builtinMethods[RegExp] = \"global ignoreCase lastIndex multiline source compile exec test\".split(' ');\n" 
"builtinMethods[String] = \"length charAt charCodeAt concat fromCharCode indexOf lastIndexOf match replace search slice split substr substring toLowerCase toUpperCase\".split(' ');\n" 
"builtinMethods[Function] = \"call apply\".split(' ');\n" 
"builtinMethods[Object] = \"bsonsize\".split(' ');\n" 
"\n" 
"builtinMethods[Mongo] = \"find update insert remove\".split(' ');\n" 
"builtinMethods[BinData] = \"hex base64 length subtype\".split(' ');\n" 
"\n" 
"var extraGlobals = \"Infinity NaN undefined null true false decodeURI decodeURIComponent encodeURI encodeURIComponent escape eval isFinite isNaN parseFloat parseInt unescape Array Boolean Date Math Number RegExp String print load gc MinKey MaxKey Mongo NumberLong ObjectId DBPointer UUID BinData Map\".split(' ');\n" 
"\n" 
"var isPrivate = function(name){\n" 
"if (shellAutocomplete.showPrivate) return false;\n" 
"if (name == '_id') return false;\n" 
"if (name[0] == '_') return true;\n" 
"if (name[name.length-1] == '_') return true; // some native functions have an extra name_ method\n" 
"return false;\n" 
"}\n" 
"\n" 
"var customComplete = function(obj){\n" 
"try {\n" 
"if(obj.__proto__.constructor.autocomplete){\n" 
"var ret = obj.constructor.autocomplete(obj);\n" 
"if (ret.constructor != Array){\n" 
"print(\"\\nautocompleters must return real Arrays\");\n" 
"return [];\n" 
"}\n" 
"return ret;\n" 
"} else {\n" 
"return [];\n" 
"}\n" 
"} catch (e) {\n" 
"// print(e); // uncomment if debugging custom completers\n" 
"return [];\n" 
"}\n" 
"}\n" 
"\n" 
"var worker = function( prefix ){\n" 
"var global = (function(){return this;}).call(); // trick to get global object\n" 
"\n" 
"var curObj = global;\n" 
"var parts = prefix.split('.');\n" 
"for (var p=0; p < parts.length - 1; p++){ // doesn't include last part\n" 
"curObj = curObj[parts[p]];\n" 
"if (curObj == null)\n" 
"return [];\n" 
"}\n" 
"\n" 
"var lastPrefix = parts[parts.length-1] || '';\n" 
"var begining = parts.slice(0, parts.length-1).join('.');\n" 
"if (begining.length)\n" 
"begining += '.';\n" 
"\n" 
"var possibilities = new Array().concat(\n" 
"universalMethods,\n" 
"Object.keySet(curObj),\n" 
"Object.keySet(curObj.__proto__),\n" 
"builtinMethods[curObj] || [], // curObj is a builtin constructor\n" 
"builtinMethods[curObj.__proto__.constructor] || [], // curObj is made from a builtin constructor\n" 
"curObj == global ? extraGlobals : [],\n" 
"customComplete(curObj)\n" 
");\n" 
"\n" 
"var ret = [];\n" 
"for (var i=0; i < possibilities.length; i++){\n" 
"var p = possibilities[i];\n" 
"if (typeof(curObj[p]) == \"undefined\" && curObj != global) continue; // extraGlobals aren't in the global object\n" 
"if (p.length == 0 || p.length < lastPrefix.length) continue;\n" 
"if (lastPrefix[0] != '_' && isPrivate(p)) continue;\n" 
"if (p.match(/^[0-9]+$/)) continue; // don't array number indexes\n" 
"if (p.substr(0, lastPrefix.length) != lastPrefix) continue;\n" 
"\n" 
"var completion = begining + p;\n" 
"if(curObj[p] && curObj[p].constructor == Function && p != 'constructor')\n" 
"completion += '(';\n" 
"\n" 
"ret.push(completion);\n" 
"}\n" 
"\n" 
"return ret;\n" 
"}\n" 
"\n" 
"// this is the actual function that gets assigned to shellAutocomplete\n" 
"return function( prefix ){\n" 
"try {\n" 
"__autocomplete__ = worker(prefix).sort();\n" 
"}catch (e){\n" 
"print(\"exception durring autocomplete: \" + tojson(e.message));\n" 
"__autocomplete__ = [];\n" 
"}\n" 
"}\n" 
"}();\n" 
"\n" 
"shellAutocomplete.showPrivate = false; // toggle to show (useful when working on internals)\n" 
"\n" 
"shellHelper = function( command , rest , shouldPrint ){\n" 
"command = command.trim();\n" 
"var args = rest.trim().replace(/\\s*;$/,\"\").split( \"\\s+\" );\n" 
"\n" 
"if ( ! shellHelper[command] )\n" 
"throw \"no command [\" + command + \"]\";\n" 
"\n" 
"var res = shellHelper[command].apply( null , args );\n" 
"if ( shouldPrint ){\n" 
"shellPrintHelper( res );\n" 
"}\n" 
"return res;\n" 
"}\n" 
"\n" 
"shellHelper.use = function (dbname) {\n" 
"var s = \"\" + dbname;\n" 
"if (s == \"\") {\n" 
"print(\"bad use parameter\");\n" 
"return;\n" 
"}\n" 
"db = db.getMongo().getDB(dbname);\n" 
"print(\"switched to db \" + db.getName());\n" 
"}\n" 
"\n" 
"shellHelper.it = function(){\n" 
"if ( typeof( ___it___ ) == \"undefined\" || ___it___ == null ){\n" 
"print( \"no cursor\" );\n" 
"return;\n" 
"}\n" 
"shellPrintHelper( ___it___ );\n" 
"}\n" 
"\n" 
"shellHelper.show = function (what) {\n" 
"assert(typeof what == \"string\");\n" 
"\n" 
"var args = what.split( /\\s+/ );\n" 
"what = args[0]\n" 
"args = args.splice(1)\n" 
"\n" 
"if (what == \"profile\") {\n" 
"if (db.system.profile.count() == 0) {\n" 
"print(\"db.system.profile is empty\");\n" 
"print(\"Use db.setProfilingLevel(2) will enable profiling\");\n" 
"print(\"Use db.system.profile.find() to show raw profile entries\");\n" 
"}\n" 
"else {\n" 
"print();\n" 
"db.system.profile.find({ millis: { $gt: 0} }).sort({ $natural: -1 }).limit(5).forEach(\n" 
"function (x) {\n" 
"print(\"\" + x.op + \"\\t\" + x.ns + \" \" + x.millis + \"ms \" + String(x.ts).substring(0, 24));\n" 
"var l = \"\";\n" 
"for ( var z in x ){\n" 
"if ( z == \"op\" || z == \"ns\" || z == \"millis\" || z == \"ts\" )\n" 
"continue;\n" 
"\n" 
"var val = x[z];\n" 
"var mytype = typeof(val);\n" 
"\n" 
"if ( mytype == \"string\" ||\n" 
"mytype == \"number\" )\n" 
"l += z + \":\" + val + \" \";\n" 
"else if ( mytype == \"object\" )\n" 
"l += z + \":\" + tojson(val ) + \" \";\n" 
"else if ( mytype == \"boolean\" )\n" 
"l += z + \" \";\n" 
"else\n" 
"l += z + \":\" + val + \" \";\n" 
"\n" 
"}\n" 
"print( l );\n" 
"print(\"\\n\");\n" 
"}\n" 
")\n" 
"}\n" 
"return \"\";\n" 
"}\n" 
"\n" 
"if (what == \"users\") {\n" 
"db.system.users.find().forEach(printjson);\n" 
"return \"\";\n" 
"}\n" 
"\n" 
"if (what == \"collections\" || what == \"tables\") {\n" 
"db.getCollectionNames().forEach(function (x) { print(x) });\n" 
"return \"\";\n" 
"}\n" 
"\n" 
"if (what == \"dbs\") {\n" 
"var dbs = db.getMongo().getDBs();\n" 
"var size = {};\n" 
"dbs.databases.forEach(function (x) { size[x.name] = x.sizeOnDisk; });\n" 
"var names = dbs.databases.map(function (z) { return z.name; }).sort();\n" 
"names.forEach(function (n) {\n" 
"if (size[n] > 1) {\n" 
"print(n + \"\\t\" + size[n] / 1024 / 1024 / 1024 + \"GB\");\n" 
"} else {\n" 
"print(n + \"\\t(empty)\");\n" 
"}\n" 
"});\n" 
"//db.getMongo().getDBNames().sort().forEach(function (x) { print(x) });\n" 
"return \"\";\n" 
"}\n" 
"\n" 
"if (what == \"log\" ) {\n" 
"var n = \"global\";\n" 
"if ( args.length > 0 )\n" 
"n = args[0]\n" 
"\n" 
"var res = db.adminCommand( { getLog : n } )\n" 
"for ( var i=0; i<res.log.length; i++){\n" 
"print( res.log[i] )\n" 
"}\n" 
"return \"\"\n" 
"}\n" 
"\n" 
"if (what == \"logs\" ) {\n" 
"var res = db.adminCommand( { getLog : \"*\" } )\n" 
"for ( var i=0; i<res.names.length; i++){\n" 
"print( res.names[i] )\n" 
"}\n" 
"return \"\"\n" 
"}\n" 
"\n" 
"\n" 
"throw \"don't know how to show [\" + what + \"]\";\n" 
"\n" 
"}\n" 
"\n" 
"if ( typeof( Map ) == \"undefined\" ){\n" 
"Map = function(){\n" 
"this._data = {};\n" 
"}\n" 
"}\n" 
"\n" 
"Map.hash = function( val ){\n" 
"if ( ! val )\n" 
"return val;\n" 
"\n" 
"switch ( typeof( val ) ){\n" 
"case 'string':\n" 
"case 'number':\n" 
"case 'date':\n" 
"return val.toString();\n" 
"case 'object':\n" 
"case 'array':\n" 
"var s = \"\";\n" 
"for ( var k in val ){\n" 
"s += k + val[k];\n" 
"}\n" 
"return s;\n" 
"}\n" 
"\n" 
"throw \"can't hash : \" + typeof( val );\n" 
"}\n" 
"\n" 
"Map.prototype.put = function( key , value ){\n" 
"var o = this._get( key );\n" 
"var old = o.value;\n" 
"o.value = value;\n" 
"return old;\n" 
"}\n" 
"\n" 
"Map.prototype.get = function( key ){\n" 
"return this._get( key ).value;\n" 
"}\n" 
"\n" 
"Map.prototype._get = function( key ){\n" 
"var h = Map.hash( key );\n" 
"var a = this._data[h];\n" 
"if ( ! a ){\n" 
"a = [];\n" 
"this._data[h] = a;\n" 
"}\n" 
"\n" 
"for ( var i=0; i<a.length; i++ ){\n" 
"if ( friendlyEqual( key , a[i].key ) ){\n" 
"return a[i];\n" 
"}\n" 
"}\n" 
"var o = { key : key , value : null };\n" 
"a.push( o );\n" 
"return o;\n" 
"}\n" 
"\n" 
"Map.prototype.values = function(){\n" 
"var all = [];\n" 
"for ( var k in this._data ){\n" 
"this._data[k].forEach( function(z){ all.push( z.value ); } );\n" 
"}\n" 
"return all;\n" 
"}\n" 
"\n" 
"if ( typeof( gc ) == \"undefined\" ){\n" 
"gc = function(){\n" 
"print( \"warning: using noop gc()\" );\n" 
"}\n" 
"}\n" 
"\n" 
"\n" 
"Math.sigFig = function( x , N ){\n" 
"if ( ! N ){\n" 
"N = 3;\n" 
"}\n" 
"var p = Math.pow( 10, N - Math.ceil( Math.log( Math.abs(x) ) / Math.log( 10 )) );\n" 
"return Math.round(x*p)/p;\n" 
"}\n" 
"\n" 
"Random = function() {}\n" 
"\n" 
"// set random seed\n" 
"Random.srand = function( s ) { _srand( s ); }\n" 
"\n" 
"// random number 0 <= r < 1\n" 
"Random.rand = function() { return _rand(); }\n" 
"\n" 
"// random integer 0 <= r < n\n" 
"Random.randInt = function( n ) { return Math.floor( Random.rand() * n ); }\n" 
"\n" 
"Random.setRandomSeed = function( s ) {\n" 
"s = s || new Date().getTime();\n" 
"print( \"setting random seed: \" + s );\n" 
"Random.srand( s );\n" 
"}\n" 
"\n" 
"// generate a random value from the exponential distribution with the specified mean\n" 
"Random.genExp = function( mean ) {\n" 
"return -Math.log( Random.rand() ) * mean;\n" 
"}\n" 
"\n" 
"Geo = {};\n" 
"Geo.distance = function( a , b ){\n" 
"var ax = null;\n" 
"var ay = null;\n" 
"var bx = null;\n" 
"var by = null;\n" 
"\n" 
"for ( var key in a ){\n" 
"if ( ax == null )\n" 
"ax = a[key];\n" 
"else if ( ay == null )\n" 
"ay = a[key];\n" 
"}\n" 
"\n" 
"for ( var key in b ){\n" 
"if ( bx == null )\n" 
"bx = b[key];\n" 
"else if ( by == null )\n" 
"by = b[key];\n" 
"}\n" 
"\n" 
"return Math.sqrt( Math.pow( by - ay , 2 ) +\n" 
"Math.pow( bx - ax , 2 ) );\n" 
"}\n" 
"\n" 
"Geo.sphereDistance = function( a , b ){\n" 
"var ax = null;\n" 
"var ay = null;\n" 
"var bx = null;\n" 
"var by = null;\n" 
"\n" 
"// TODO swap order of x and y when done on server\n" 
"for ( var key in a ){\n" 
"if ( ax == null )\n" 
"ax = a[key] * (Math.PI/180);\n" 
"else if ( ay == null )\n" 
"ay = a[key] * (Math.PI/180);\n" 
"}\n" 
"\n" 
"for ( var key in b ){\n" 
"if ( bx == null )\n" 
"bx = b[key] * (Math.PI/180);\n" 
"else if ( by == null )\n" 
"by = b[key] * (Math.PI/180);\n" 
"}\n" 
"\n" 
"var sin_x1=Math.sin(ax), cos_x1=Math.cos(ax);\n" 
"var sin_y1=Math.sin(ay), cos_y1=Math.cos(ay);\n" 
"var sin_x2=Math.sin(bx), cos_x2=Math.cos(bx);\n" 
"var sin_y2=Math.sin(by), cos_y2=Math.cos(by);\n" 
"\n" 
"var cross_prod =\n" 
"(cos_y1*cos_x1 * cos_y2*cos_x2) +\n" 
"(cos_y1*sin_x1 * cos_y2*sin_x2) +\n" 
"(sin_y1        * sin_y2);\n" 
"\n" 
"if (cross_prod >= 1 || cross_prod <= -1){\n" 
"// fun with floats\n" 
"assert( Math.abs(cross_prod)-1 < 1e-6 );\n" 
"return cross_prod > 0 ? 0 : Math.PI;\n" 
"}\n" 
"\n" 
"return Math.acos(cross_prod);\n" 
"}\n" 
"\n" 
"rs = function () { return \"try rs.help()\"; }\n" 
"\n" 
"rs.help = function () {\n" 
"print(\"\\trs.status()                     { replSetGetStatus : 1 } checks repl set status\");\n" 
"print(\"\\trs.initiate()                   { replSetInitiate : null } initiates set with default settings\");\n" 
"print(\"\\trs.initiate(cfg)                { replSetInitiate : cfg } initiates set with configuration cfg\");\n" 
"print(\"\\trs.conf()                       get the current configuration object from local.system.replset\");\n" 
"print(\"\\trs.reconfig(cfg)                updates the configuration of a running replica set with cfg (disconnects)\");\n" 
"print(\"\\trs.add(hostportstr)             add a new member to the set with default attributes (disconnects)\");\n" 
"print(\"\\trs.add(membercfgobj)            add a new member to the set with extra attributes (disconnects)\");\n" 
"print(\"\\trs.addArb(hostportstr)          add a new member which is arbiterOnly:true (disconnects)\");\n" 
"print(\"\\trs.stepDown([secs])             step down as primary (momentarily) (disconnects)\");\n" 
"print(\"\\trs.freeze(secs)                 make a node ineligible to become primary for the time specified\");\n" 
"print(\"\\trs.remove(hostportstr)          remove a host from the replica set (disconnects)\");\n" 
"print(\"\\trs.slaveOk()                    shorthand for db.getMongo().setSlaveOk()\");\n" 
"print();\n" 
"print(\"\\tdb.isMaster()                   check who is primary\");\n" 
"print();\n" 
"print(\"\\treconfiguration helpers disconnect from the database so the shell will display\");\n" 
"print(\"\\tan error, even if the command succeeds.\");\n" 
"print(\"\\tsee also http://<mongod_host>:28017/_replSet for additional diagnostic info\");\n" 
"}\n" 
"rs.slaveOk = function () { return db.getMongo().setSlaveOk(); }\n" 
"rs.status = function () { return db._adminCommand(\"replSetGetStatus\"); }\n" 
"rs.isMaster = function () { return db.isMaster(); }\n" 
"rs.initiate = function (c) { return db._adminCommand({ replSetInitiate: c }); }\n" 
"rs._runCmd = function (c) {\n" 
"// after the command, catch the disconnect and reconnect if necessary\n" 
"var res = null;\n" 
"try {\n" 
"res = db.adminCommand(c);\n" 
"}\n" 
"catch (e) {\n" 
"if ((\"\" + e).indexOf(\"error doing query\") >= 0) {\n" 
"// closed connection.  reconnect.\n" 
"db.getLastErrorObj();\n" 
"var o = db.getLastErrorObj();\n" 
"if (o.ok) {\n" 
"print(\"reconnected to server after rs command (which is normal)\");\n" 
"}\n" 
"else {\n" 
"printjson(o);\n" 
"}\n" 
"}\n" 
"else {\n" 
"print(\"shell got exception during repl set operation: \" + e);\n" 
"print(\"in some circumstances, the primary steps down and closes connections on a reconfig\");\n" 
"}\n" 
"return \"\";\n" 
"}\n" 
"return res;\n" 
"}\n" 
"rs.reconfig = function (cfg, options) {\n" 
"cfg.version = rs.conf().version + 1;\n" 
"cmd = { replSetReconfig: cfg };\n" 
"for (var i in options) {\n" 
"cmd[i] = options[i];\n" 
"}\n" 
"return this._runCmd(cmd);\n" 
"}\n" 
"rs.add = function (hostport, arb) {\n" 
"var cfg = hostport;\n" 
"\n" 
"var local = db.getSisterDB(\"local\");\n" 
"assert(local.system.replset.count() <= 1, \"error: local.system.replset has unexpected contents\");\n" 
"var c = local.system.replset.findOne();\n" 
"assert(c, \"no config object retrievable from local.system.replset\");\n" 
"\n" 
"c.version++;\n" 
"\n" 
"var max = 0;\n" 
"for (var i in c.members)\n" 
"if (c.members[i]._id > max) max = c.members[i]._id;\n" 
"if (isString(hostport)) {\n" 
"cfg = { _id: max + 1, host: hostport };\n" 
"if (arb)\n" 
"cfg.arbiterOnly = true;\n" 
"}\n" 
"c.members.push(cfg);\n" 
"return this._runCmd({ replSetReconfig: c });\n" 
"}\n" 
"rs.stepDown = function (secs) { return db._adminCommand({ replSetStepDown:(secs === undefined) ? 60:secs}); }\n" 
"rs.freeze = function (secs) { return db._adminCommand({replSetFreeze:secs}); }\n" 
"rs.addArb = function (hn) { return this.add(hn, true); }\n" 
"rs.conf = function () { return db.getSisterDB(\"local\").system.replset.findOne(); }\n" 
"rs.config = function () { return rs.conf(); }\n" 
"\n" 
"rs.remove = function (hn) {\n" 
"var local = db.getSisterDB(\"local\");\n" 
"assert(local.system.replset.count() <= 1, \"error: local.system.replset has unexpected contents\");\n" 
"var c = local.system.replset.findOne();\n" 
"assert(c, \"no config object retrievable from local.system.replset\");\n" 
"c.version++;\n" 
"\n" 
"for (var i in c.members) {\n" 
"if (c.members[i].host == hn) {\n" 
"c.members.splice(i, 1);\n" 
"return db._adminCommand({ replSetReconfig : c});\n" 
"}\n" 
"}\n" 
"\n" 
"return \"error: couldn't find \"+hn+\" in \"+tojson(c.members);\n" 
"};\n" 
"\n" 
"rs.debug = {};\n" 
"\n" 
"rs.debug.nullLastOpWritten = function(primary, secondary) {\n" 
"var p = connect(primary+\"/local\");\n" 
"var s = connect(secondary+\"/local\");\n" 
"s.getMongo().setSlaveOk();\n" 
"\n" 
"var secondToLast = s.oplog.rs.find().sort({$natural : -1}).limit(1).next();\n" 
"var last = p.runCommand({findAndModify : \"oplog.rs\",\n" 
"query : {ts : {$gt : secondToLast.ts}},\n" 
"sort : {$natural : 1},\n" 
"update : {$set : {op : \"n\"}}});\n" 
"\n" 
"if (!last.value.o || !last.value.o._id) {\n" 
"print(\"couldn't find an _id?\");\n" 
"}\n" 
"else {\n" 
"last.value.o = {_id : last.value.o._id};\n" 
"}\n" 
"\n" 
"print(\"nulling out this op:\");\n" 
"printjson(last);\n" 
"};\n" 
"\n" 
"rs.debug.getLastOpWritten = function(server) {\n" 
"var s = db.getSisterDB(\"local\");\n" 
"if (server) {\n" 
"s = connect(server+\"/local\");\n" 
"}\n" 
"s.getMongo().setSlaveOk();\n" 
"\n" 
"return s.oplog.rs.find().sort({$natural : -1}).limit(1).next();\n" 
"};\n" 
"\n" 
"\n" 
"help = shellHelper.help = function (x) {\n" 
"if (x == \"mr\") {\n" 
"print(\"\\nSee also http://www.mongodb.org/display/DOCS/MapReduce\");\n" 
"print(\"\\nfunction mapf() {\");\n" 
"print(\"  // 'this' holds current document to inspect\");\n" 
"print(\"  emit(key, value);\");\n" 
"print(\"}\");\n" 
"print(\"\\nfunction reducef(key,value_array) {\");\n" 
"print(\"  return reduced_value;\");\n" 
"print(\"}\");\n" 
"print(\"\\ndb.mycollection.mapReduce(mapf, reducef[, options])\");\n" 
"print(\"\\noptions\");\n" 
"print(\"{[query : <query filter object>]\");\n" 
"print(\" [, sort : <sort the query.  useful for optimization>]\");\n" 
"print(\" [, limit : <number of objects to return from collection>]\");\n" 
"print(\" [, out : <output-collection name>]\");\n" 
"print(\" [, keeptemp: <true|false>]\");\n" 
"print(\" [, finalize : <finalizefunction>]\");\n" 
"print(\" [, scope : <object where fields go into javascript global scope >]\");\n" 
"print(\" [, verbose : true]}\\n\");\n" 
"return;\n" 
"} else if (x == \"connect\") {\n" 
"print(\"\\nNormally one specifies the server on the mongo shell command line.  Run mongo --help to see those options.\");\n" 
"print(\"Additional connections may be opened:\\n\");\n" 
"print(\"    var x = new Mongo('host[:port]');\");\n" 
"print(\"    var mydb = x.getDB('mydb');\");\n" 
"print(\"  or\");\n" 
"print(\"    var mydb = connect('host[:port]/mydb');\");\n" 
"print(\"\\nNote: the REPL prompt only auto-reports getLastError() for the shell command line connection.\\n\");\n" 
"return;\n" 
"}\n" 
"else if (x == \"keys\") {\n" 
"print(\"Tab completion and command history is available at the command prompt.\\n\");\n" 
"print(\"Some emacs keystrokes are available too:\");\n" 
"print(\"  Ctrl-A start of line\");\n" 
"print(\"  Ctrl-E end of line\");\n" 
"print(\"  Ctrl-K del to end of line\");\n" 
"print(\"\\nMulti-line commands\");\n" 
"print(\"You can enter a multi line javascript expression.  If parens, braces, etc. are not closed, you will see a new line \");\n" 
"print(\"beginning with '...' characters.  Type the rest of your expression.  Press Ctrl-C to abort the data entry if you\");\n" 
"print(\"get stuck.\\n\");\n" 
"}\n" 
"else if (x == \"misc\") {\n" 
"print(\"\\tb = new BinData(subtype,base64str)  create a BSON BinData value\");\n" 
"print(\"\\tb.subtype()                         the BinData subtype (0..255)\");\n" 
"print(\"\\tb.length()                          length of the BinData data in bytes\");\n" 
"print(\"\\tb.hex()                             the data as a hex encoded string\");\n" 
"print(\"\\tb.base64()                          the data as a base 64 encoded string\");\n" 
"print(\"\\tb.toString()\");\n" 
"print();\n" 
"print(\"\\tb = HexData(subtype,hexstr)         create a BSON BinData value from a hex string\");\n" 
"print(\"\\tb = UUID(hexstr)                    create a BSON BinData value of UUID subtype\");\n" 
"print(\"\\tb = MD5(hexstr)                     create a BSON BinData value of MD5 subtype\");\n" 
"print();\n" 
"print(\"\\to = new ObjectId()                  create a new ObjectId\");\n" 
"print(\"\\to.getTimestamp()                    return timestamp derived from first 32 bits of the OID\");\n" 
"print(\"\\to.isObjectId()\");\n" 
"print(\"\\to.toString()\");\n" 
"print(\"\\to.equals(otherid)\");\n" 
"return;\n" 
"}\n" 
"else if (x == \"admin\") {\n" 
"print(\"\\tls([path])                      list files\");\n" 
"print(\"\\tpwd()                           returns current directory\");\n" 
"print(\"\\tlistFiles([path])               returns file list\");\n" 
"print(\"\\thostname()                      returns name of this host\");\n" 
"print(\"\\tcat(fname)                      returns contents of text file as a string\");\n" 
"print(\"\\tremoveFile(f)                   delete a file or directory\");\n" 
"print(\"\\tload(jsfilename)                load and execute a .js file\");\n" 
"print(\"\\trun(program[, args...])         spawn a program and wait for its completion\");\n" 
"print(\"\\trunProgram(program[, args...])  same as run(), above\");\n" 
"print(\"\\tsleep(m)                        sleep m milliseconds\");\n" 
"print(\"\\tgetMemInfo()                    diagnostic\");\n" 
"return;\n" 
"}\n" 
"else if (x == \"test\") {\n" 
"print(\"\\tstartMongodEmpty(args)        DELETES DATA DIR and then starts mongod\");\n" 
"print(\"\\t                              returns a connection to the new server\");\n" 
"print(\"\\tstartMongodTest(port,dir,options)\");\n" 
"print(\"\\t                              DELETES DATA DIR\");\n" 
"print(\"\\t                              automatically picks port #s starting at 27000 and increasing\");\n" 
"print(\"\\t                              or you can specify the port as the first arg\");\n" 
"print(\"\\t                              dir is /data/db/<port>/ if not specified as the 2nd arg\");\n" 
"print(\"\\t                              returns a connection to the new server\");\n" 
"print(\"\\tresetDbpath(dirpathstr)       deletes everything under the dir specified including subdirs\");\n" 
"print(\"\\tstopMongoProgram(port[, signal])\");\n" 
"return;\n" 
"}\n" 
"else if (x == \"\") {\n" 
"print(\"\\t\" + \"db.help()                    help on db methods\");\n" 
"print(\"\\t\" + \"db.mycoll.help()             help on collection methods\");\n" 
"print(\"\\t\" + \"rs.help()                    help on replica set methods\");\n" 
"print(\"\\t\" + \"help admin                   administrative help\");\n" 
"print(\"\\t\" + \"help connect                 connecting to a db help\");\n" 
"print(\"\\t\" + \"help keys                    key shortcuts\");\n" 
"print(\"\\t\" + \"help misc                    misc things to know\");\n" 
"print(\"\\t\" + \"help mr                      mapreduce\");\n" 
"print();\n" 
"print(\"\\t\" + \"show dbs                     show database names\");\n" 
"print(\"\\t\" + \"show collections             show collections in current database\");\n" 
"print(\"\\t\" + \"show users                   show users in current database\");\n" 
"print(\"\\t\" + \"show profile                 show most recent system.profile entries with time >= 1ms\");\n" 
"print(\"\\t\" + \"show logs                    show the accessible logger names\");\n" 
"print(\"\\t\" + \"show log [name]              prints out the last segment of log in memory, 'global' is default\");\n" 
"print(\"\\t\" + \"use <db_name>                set current database\");\n" 
"print(\"\\t\" + \"db.foo.find()                list objects in collection foo\");\n" 
"print(\"\\t\" + \"db.foo.find( { a : 1 } )     list objects in foo where a == 1\");\n" 
"print(\"\\t\" + \"it                           result of the last line evaluated; use to further iterate\");\n" 
"print(\"\\t\" + \"DBQuery.shellBatchSize = x   set default number of items to display on shell\");\n" 
"print(\"\\t\" + \"exit                         quit the mongo shell\");\n" 
"}\n" 
"else\n" 
"print(\"unknown help option\");\n" 
"}\n" 
;
extern const JSFile utils;
const JSFile utils = { "shell/utils.js" , _jscode_raw_utils };
const StringData _jscode_raw_utils_sh = 
"sh = function() { return \"try sh.help();\" }\n" 
"\n" 
"\n" 
"sh._checkMongos = function() {\n" 
"var x = db.runCommand( \"ismaster\" );\n" 
"if ( x.msg != \"isdbgrid\" )\n" 
"throw \"not connected to a mongos\"\n" 
"}\n" 
"\n" 
"sh._checkFullName = function( fullName ) {\n" 
"assert( fullName , \"neeed a full name\" )\n" 
"assert( fullName.indexOf( \".\" ) > 0 , \"name needs to be fully qualified <db>.<collection>'\" )\n" 
"}\n" 
"\n" 
"sh._adminCommand = function( cmd , skipCheck ) {\n" 
"if ( ! skipCheck ) sh._checkMongos();\n" 
"var res = db.getSisterDB( \"admin\" ).runCommand( cmd );\n" 
"\n" 
"if ( res == null || ! res.ok ) {\n" 
"print( \"command failed: \" + tojson( res ) )\n" 
"}\n" 
"\n" 
"return res;\n" 
"}\n" 
"\n" 
"sh.help = function() {\n" 
"print( \"\\tsh.addShard( host )                       server:port OR setname/server:port\" )\n" 
"print( \"\\tsh.enableSharding(dbname)                 enables sharding on the database dbname\" )\n" 
"print( \"\\tsh.shardCollection(fullName,key,unique)   shards the collection\" );\n" 
"\n" 
"print( \"\\tsh.splitFind(fullName,find)               splits the chunk that find is in at the median\" );\n" 
"print( \"\\tsh.splitAt(fullName,middle)               splits the chunk that middle is in at middle\" );\n" 
"print( \"\\tsh.moveChunk(fullName,find,to)            move the chunk where 'find' is to 'to' (name of shard)\");\n" 
"\n" 
"print( \"\\tsh.setBalancerState( <bool on or not> )   turns the balancer on or off true=on, false=off\" );\n" 
"print( \"\\tsh.getBalancerState()                     return true if on, off if not\" );\n" 
"print( \"\\tsh.isBalancerRunning()                    return true if the balancer is running on any mongos\" );\n" 
"\n" 
"print( \"\\tsh.status()                               prints a general overview of the cluster\" )\n" 
"}\n" 
"\n" 
"sh.status = function( verbose , configDB ) {\n" 
"// TODO: move the actual commadn here\n" 
"printShardingStatus( configDB , verbose );\n" 
"}\n" 
"\n" 
"sh.addShard = function( url ){\n" 
"sh._adminCommand( { addShard : url } , true )\n" 
"}\n" 
"\n" 
"sh.enableSharding = function( dbname ) {\n" 
"assert( dbname , \"need a valid dbname\" )\n" 
"sh._adminCommand( { enableSharding : dbname } )\n" 
"}\n" 
"\n" 
"sh.shardCollection = function( fullName , key , unique ) {\n" 
"sh._checkFullName( fullName )\n" 
"assert( key , \"need a key\" )\n" 
"assert( typeof( key ) == \"object\" , \"key needs to be an object\" )\n" 
"\n" 
"var cmd = { shardCollection : fullName , key : key }\n" 
"if ( unique )\n" 
"cmd.unique = true;\n" 
"\n" 
"sh._adminCommand( cmd )\n" 
"}\n" 
"\n" 
"\n" 
"sh.splitFind = function( fullName , find ) {\n" 
"sh._checkFullName( fullName )\n" 
"sh._adminCommand( { split : fullName , find : find } )\n" 
"}\n" 
"\n" 
"sh.splitAt = function( fullName , middle ) {\n" 
"sh._checkFullName( fullName )\n" 
"sh._adminCommand( { split : fullName , middle : middle } )\n" 
"}\n" 
"\n" 
"sh.moveChunk = function( fullName , find , to ) {\n" 
"sh._checkFullName( fullName );\n" 
"sh._adminCommand( { moveChunk : fullName , find : find , to : to } )\n" 
"}\n" 
"\n" 
"sh.setBalancerState = function( onOrNot ) {\n" 
"db.getSisterDB( \"config\" ).settings.update({ _id: \"balancer\" }, { $set : { stopped: onOrNot ? false : true } }, true );\n" 
"}\n" 
"\n" 
"sh.getBalancerState = function() {\n" 
"var x = db.getSisterDB( \"config\" ).settings.findOne({ _id: \"balancer\" } )\n" 
"if ( x == null )\n" 
"return true;\n" 
"return ! x.stopped;\n" 
"}\n" 
"\n" 
"sh.isBalancerRunning = function() {\n" 
"var x = db.getSisterDB( \"config\" ).locks.findOne( { _id : \"balancer\" } );\n" 
"return x.state > 0;\n" 
"}\n" 
;
extern const JSFile utils_sh;
const JSFile utils_sh = { "shell/utils_sh.js" , _jscode_raw_utils_sh };
const StringData _jscode_raw_db = 
"// db.js\n" 
"\n" 
"if ( typeof DB == \"undefined\" ){\n" 
"DB = function( mongo , name ){\n" 
"this._mongo = mongo;\n" 
"this._name = name;\n" 
"}\n" 
"}\n" 
"\n" 
"DB.prototype.getMongo = function(){\n" 
"assert( this._mongo , \"why no mongo!\" );\n" 
"return this._mongo;\n" 
"}\n" 
"\n" 
"DB.prototype.getSiblingDB = function( name ){\n" 
"return this.getMongo().getDB( name );\n" 
"}\n" 
"\n" 
"DB.prototype.getSisterDB = DB.prototype.getSiblingDB;\n" 
"\n" 
"DB.prototype.getName = function(){\n" 
"return this._name;\n" 
"}\n" 
"\n" 
"DB.prototype.stats = function(scale){\n" 
"return this.runCommand( { dbstats : 1 , scale : scale } );\n" 
"}\n" 
"\n" 
"DB.prototype.getCollection = function( name ){\n" 
"return new DBCollection( this._mongo , this , name , this._name + \".\" + name );\n" 
"}\n" 
"\n" 
"DB.prototype.commandHelp = function( name ){\n" 
"var c = {};\n" 
"c[name] = 1;\n" 
"c.help = true;\n" 
"var res = this.runCommand( c );\n" 
"if ( ! res.ok )\n" 
"throw res.errmsg;\n" 
"return res.help;\n" 
"}\n" 
"\n" 
"DB.prototype.runCommand = function( obj ){\n" 
"if ( typeof( obj ) == \"string\" ){\n" 
"var n = {};\n" 
"n[obj] = 1;\n" 
"obj = n;\n" 
"}\n" 
"return this.getCollection( \"$cmd\" ).findOne( obj );\n" 
"}\n" 
"\n" 
"DB.prototype._dbCommand = DB.prototype.runCommand;\n" 
"\n" 
"DB.prototype.adminCommand = function( obj ){\n" 
"if ( this._name == \"admin\" )\n" 
"return this.runCommand( obj );\n" 
"return this.getSiblingDB( \"admin\" ).runCommand( obj );\n" 
"}\n" 
"\n" 
"DB.prototype._adminCommand = DB.prototype.adminCommand; // alias old name\n" 
"\n" 
"DB.prototype.addUser = function( username , pass, readOnly ){\n" 
"if ( pass == null || pass.length == 0 )\n" 
"throw \"password can't be empty\";\n" 
"\n" 
"readOnly = readOnly || false;\n" 
"var c = this.getCollection( \"system.users\" );\n" 
"\n" 
"var u = c.findOne( { user : username } ) || { user : username };\n" 
"u.readOnly = readOnly;\n" 
"u.pwd = hex_md5( username + \":mongo:\" + pass );\n" 
"\n" 
"c.save( u );\n" 
"var le = this.getLastErrorObj();\n" 
"printjson( le )\n" 
"if ( le.err )\n" 
"throw \"couldn't add user: \" + le.err\n" 
"print( tojson( u ) );\n" 
"}\n" 
"\n" 
"DB.prototype.logout = function(){\n" 
"return this.runCommand({logout : 1});\n" 
"}\n" 
"\n" 
"DB.prototype.removeUser = function( username ){\n" 
"this.getCollection( \"system.users\" ).remove( { user : username } );\n" 
"}\n" 
"\n" 
"DB.prototype.__pwHash = function( nonce, username, pass ) {\n" 
"return hex_md5( nonce + username + hex_md5( username + \":mongo:\" + pass ) );\n" 
"}\n" 
"\n" 
"DB.prototype.auth = function( username , pass ){\n" 
"var n = this.runCommand( { getnonce : 1 } );\n" 
"\n" 
"var a = this.runCommand(\n" 
"{\n" 
"authenticate : 1 ,\n" 
"user : username ,\n" 
"nonce : n.nonce ,\n" 
"key : this.__pwHash( n.nonce, username, pass )\n" 
"}\n" 
");\n" 
"\n" 
"return a.ok;\n" 
"}\n" 
"\n" 
"/**\n" 
"Create a new collection in the database.  Normally, collection creation is automatic.  You would\n" 
"use this function if you wish to specify special options on creation.\n" 
"\n" 
"If the collection already exists, no action occurs.\n" 
"\n" 
"<p>Options:</p>\n" 
"<ul>\n" 
"<li>\n" 
"size: desired initial extent size for the collection.  Must be <= 1000000000.\n" 
"for fixed size (capped) collections, this size is the total/max size of the\n" 
"collection.\n" 
"</li>\n" 
"<li>\n" 
"capped: if true, this is a capped collection (where old data rolls out).\n" 
"</li>\n" 
"<li> max: maximum number of objects if capped (optional).</li>\n" 
"</ul>\n" 
"\n" 
"<p>Example: </p>\n" 
"\n" 
"<code>db.createCollection(\"movies\", { size: 10 * 1024 * 1024, capped:true } );</code>\n" 
"\n" 
"* @param {String} name Name of new collection to create\n" 
"* @param {Object} options Object with options for call.  Options are listed above.\n" 
"* @return SOMETHING_FIXME\n" 
"*/\n" 
"DB.prototype.createCollection = function(name, opt) {\n" 
"var options = opt || {};\n" 
"var cmd = { create: name, capped: options.capped, size: options.size, max: options.max };\n" 
"if (options.autoIndexId != undefined)\n" 
"cmd.autoIndexId = options.autoIndexId;\n" 
"var res = this._dbCommand(cmd);\n" 
"return res;\n" 
"}\n" 
"\n" 
"/**\n" 
"* @deprecated use getProfilingStatus\n" 
"*  Returns the current profiling level of this database\n" 
"*  @return SOMETHING_FIXME or null on error\n" 
"*/\n" 
"DB.prototype.getProfilingLevel  = function() {\n" 
"var res = this._dbCommand( { profile: -1 } );\n" 
"return res ? res.was : null;\n" 
"}\n" 
"\n" 
"/**\n" 
"*  @return the current profiling status\n" 
"*  example { was : 0, slowms : 100 }\n" 
"*  @return SOMETHING_FIXME or null on error\n" 
"*/\n" 
"DB.prototype.getProfilingStatus  = function() {\n" 
"var res = this._dbCommand( { profile: -1 } );\n" 
"if ( ! res.ok )\n" 
"throw \"profile command failed: \" + tojson( res );\n" 
"delete res.ok\n" 
"return res;\n" 
"}\n" 
"\n" 
"\n" 
"/**\n" 
"Erase the entire database.  (!)\n" 
"\n" 
"* @return Object returned has member ok set to true if operation succeeds, false otherwise.\n" 
"*/\n" 
"DB.prototype.dropDatabase = function() {\n" 
"if ( arguments.length )\n" 
"throw \"dropDatabase doesn't take arguments\";\n" 
"return this._dbCommand( { dropDatabase: 1 } );\n" 
"}\n" 
"\n" 
"/**\n" 
"* Shuts down the database.  Must be run while using the admin database.\n" 
"* @param opts Options for shutdown. Possible options are:\n" 
"*   - force: (boolean) if the server should shut down, even if there is no\n" 
"*     up-to-date slave\n" 
"*   - timeoutSecs: (number) the server will continue checking over timeoutSecs\n" 
"*     if any other servers have caught up enough for it to shut down.\n" 
"*/\n" 
"DB.prototype.shutdownServer = function(opts) {\n" 
"if( \"admin\" != this._name ){\n" 
"return \"shutdown command only works with the admin database; try 'use admin'\";\n" 
"}\n" 
"\n" 
"cmd = {\"shutdown\" : 1};\n" 
"opts = opts || {};\n" 
"for (var o in opts) {\n" 
"cmd[o] = opts[o];\n" 
"}\n" 
"\n" 
"try {\n" 
"var res = this.runCommand(cmd);\n" 
"if( res )\n" 
"throw \"shutdownServer failed: \" + res.errmsg;\n" 
"throw \"shutdownServer failed\";\n" 
"}\n" 
"catch ( e ){\n" 
"assert( tojson( e ).indexOf( \"error doing query: failed\" ) >= 0 , \"unexpected error: \" + tojson( e ) );\n" 
"print( \"server should be down...\" );\n" 
"}\n" 
"}\n" 
"\n" 
"/**\n" 
"Clone database on another server to here.\n" 
"<p>\n" 
"Generally, you should dropDatabase() first as otherwise the cloned information will MERGE\n" 
"into whatever data is already present in this database.  (That is however a valid way to use\n" 
"clone if you are trying to do something intentionally, such as union three non-overlapping\n" 
"databases into one.)\n" 
"<p>\n" 
"This is a low level administrative function will is not typically used.\n" 
"\n" 
"* @param {String} from Where to clone from (dbhostname[:port]).  May not be this database\n" 
"(self) as you cannot clone to yourself.\n" 
"* @return Object returned has member ok set to true if operation succeeds, false otherwise.\n" 
"* See also: db.copyDatabase()\n" 
"*/\n" 
"DB.prototype.cloneDatabase = function(from) {\n" 
"assert( isString(from) && from.length );\n" 
"//this.resetIndexCache();\n" 
"return this._dbCommand( { clone: from } );\n" 
"}\n" 
"\n" 
"\n" 
"/**\n" 
"Clone collection on another server to here.\n" 
"<p>\n" 
"Generally, you should drop() first as otherwise the cloned information will MERGE\n" 
"into whatever data is already present in this collection.  (That is however a valid way to use\n" 
"clone if you are trying to do something intentionally, such as union three non-overlapping\n" 
"collections into one.)\n" 
"<p>\n" 
"This is a low level administrative function is not typically used.\n" 
"\n" 
"* @param {String} from mongod instance from which to clnoe (dbhostname:port).  May\n" 
"not be this mongod instance, as clone from self is not allowed.\n" 
"* @param {String} collection name of collection to clone.\n" 
"* @param {Object} query query specifying which elements of collection are to be cloned.\n" 
"* @return Object returned has member ok set to true if operation succeeds, false otherwise.\n" 
"* See also: db.cloneDatabase()\n" 
"*/\n" 
"DB.prototype.cloneCollection = function(from, collection, query) {\n" 
"assert( isString(from) && from.length );\n" 
"assert( isString(collection) && collection.length );\n" 
"collection = this._name + \".\" + collection;\n" 
"query = query || {};\n" 
"//this.resetIndexCache();\n" 
"return this._dbCommand( { cloneCollection:collection, from:from, query:query } );\n" 
"}\n" 
"\n" 
"\n" 
"/**\n" 
"Copy database from one server or name to another server or name.\n" 
"\n" 
"Generally, you should dropDatabase() first as otherwise the copied information will MERGE\n" 
"into whatever data is already present in this database (and you will get duplicate objects\n" 
"in collections potentially.)\n" 
"\n" 
"For security reasons this function only works when executed on the \"admin\" db.  However,\n" 
"if you have access to said db, you can copy any database from one place to another.\n" 
"\n" 
"This method provides a way to \"rename\" a database by copying it to a new db name and\n" 
"location.  Additionally, it effectively provides a repair facility.\n" 
"\n" 
"* @param {String} fromdb database name from which to copy.\n" 
"* @param {String} todb database name to copy to.\n" 
"* @param {String} fromhost hostname of the database (and optionally, \":port\") from which to\n" 
"copy the data.  default if unspecified is to copy from self.\n" 
"* @return Object returned has member ok set to true if operation succeeds, false otherwise.\n" 
"* See also: db.clone()\n" 
"*/\n" 
"DB.prototype.copyDatabase = function(fromdb, todb, fromhost, username, password) {\n" 
"assert( isString(fromdb) && fromdb.length );\n" 
"assert( isString(todb) && todb.length );\n" 
"fromhost = fromhost || \"\";\n" 
"if ( username && password ) {\n" 
"var n = this._adminCommand( { copydbgetnonce : 1, fromhost:fromhost } );\n" 
"return this._adminCommand( { copydb:1, fromhost:fromhost, fromdb:fromdb, todb:todb, username:username, nonce:n.nonce, key:this.__pwHash( n.nonce, username, password ) } );\n" 
"} else {\n" 
"return this._adminCommand( { copydb:1, fromhost:fromhost, fromdb:fromdb, todb:todb } );\n" 
"}\n" 
"}\n" 
"\n" 
"/**\n" 
"Repair database.\n" 
"\n" 
"* @return Object returned has member ok set to true if operation succeeds, false otherwise.\n" 
"*/\n" 
"DB.prototype.repairDatabase = function() {\n" 
"return this._dbCommand( { repairDatabase: 1 } );\n" 
"}\n" 
"\n" 
"\n" 
"DB.prototype.help = function() {\n" 
"print(\"DB methods:\");\n" 
"print(\"\\tdb.addUser(username, password[, readOnly=false])\");\n" 
"print(\"\\tdb.auth(username, password)\");\n" 
"print(\"\\tdb.cloneDatabase(fromhost)\");\n" 
"print(\"\\tdb.commandHelp(name) returns the help for the command\");\n" 
"print(\"\\tdb.copyDatabase(fromdb, todb, fromhost)\");\n" 
"print(\"\\tdb.createCollection(name, { size : ..., capped : ..., max : ... } )\");\n" 
"print(\"\\tdb.currentOp() displays the current operation in the db\");\n" 
"print(\"\\tdb.dropDatabase()\");\n" 
"print(\"\\tdb.eval(func, args) run code server-side\");\n" 
"print(\"\\tdb.getCollection(cname) same as db['cname'] or db.cname\");\n" 
"print(\"\\tdb.getCollectionNames()\");\n" 
"print(\"\\tdb.getLastError() - just returns the err msg string\");\n" 
"print(\"\\tdb.getLastErrorObj() - return full status object\");\n" 
"print(\"\\tdb.getMongo() get the server connection object\");\n" 
"print(\"\\tdb.getMongo().setSlaveOk() allow this connection to read from the nonmaster member of a replica pair\");\n" 
"print(\"\\tdb.getName()\");\n" 
"print(\"\\tdb.getPrevError()\");\n" 
"print(\"\\tdb.getProfilingLevel() - deprecated\");\n" 
"print(\"\\tdb.getProfilingStatus() - returns if profiling is on and slow threshold \");\n" 
"print(\"\\tdb.getReplicationInfo()\");\n" 
"print(\"\\tdb.getSiblingDB(name) get the db at the same server as this one\");\n" 
"print(\"\\tdb.isMaster() check replica primary status\");\n" 
"print(\"\\tdb.killOp(opid) kills the current operation in the db\");\n" 
"print(\"\\tdb.listCommands() lists all the db commands\");\n" 
"print(\"\\tdb.logout()\");\n" 
"print(\"\\tdb.printCollectionStats()\");\n" 
"print(\"\\tdb.printReplicationInfo()\");\n" 
"print(\"\\tdb.printSlaveReplicationInfo()\");\n" 
"print(\"\\tdb.printShardingStatus()\");\n" 
"print(\"\\tdb.removeUser(username)\");\n" 
"print(\"\\tdb.repairDatabase()\");\n" 
"print(\"\\tdb.resetError()\");\n" 
"print(\"\\tdb.runCommand(cmdObj) run a database command.  if cmdObj is a string, turns it into { cmdObj : 1 }\");\n" 
"print(\"\\tdb.serverStatus()\");\n" 
"print(\"\\tdb.setProfilingLevel(level,<slowms>) 0=off 1=slow 2=all\");\n" 
"print(\"\\tdb.shutdownServer()\");\n" 
"print(\"\\tdb.stats()\");\n" 
"print(\"\\tdb.version() current version of the server\");\n" 
"print(\"\\tdb.getMongo().setSlaveOk() allow queries on a replication slave server\");\n" 
"print(\"\\tdb.fsyncLock() flush data to disk and lock server for backups\");\n" 
"print(\"\\tdb.fsyncUnock() unlocks server following a db.fsyncLock()\");\n" 
"\n" 
"return __magicNoPrint;\n" 
"}\n" 
"\n" 
"DB.prototype.printCollectionStats = function(){\n" 
"var mydb = this;\n" 
"this.getCollectionNames().forEach(\n" 
"function(z){\n" 
"print( z );\n" 
"printjson( mydb.getCollection(z).stats() );\n" 
"print( \"---\" );\n" 
"}\n" 
");\n" 
"}\n" 
"\n" 
"/**\n" 
"* <p> Set profiling level for your db.  Profiling gathers stats on query performance. </p>\n" 
"*\n" 
"* <p>Default is off, and resets to off on a database restart -- so if you want it on,\n" 
"*    turn it on periodically. </p>\n" 
"*\n" 
"*  <p>Levels :</p>\n" 
"*   <ul>\n" 
"*    <li>0=off</li>\n" 
"*    <li>1=log very slow operations; optional argument slowms specifies slowness threshold</li>\n" 
"*    <li>2=log all</li>\n" 
"*  @param {String} level Desired level of profiling\n" 
"*  @param {String} slowms For slow logging, query duration that counts as slow (default 100ms)\n" 
"*  @return SOMETHING_FIXME or null on error\n" 
"*/\n" 
"DB.prototype.setProfilingLevel = function(level,slowms) {\n" 
"\n" 
"if (level < 0 || level > 2) {\n" 
"throw { dbSetProfilingException : \"input level \" + level + \" is out of range [0..2]\" };\n" 
"}\n" 
"\n" 
"var cmd = { profile: level };\n" 
"if ( slowms )\n" 
"cmd[\"slowms\"] = slowms;\n" 
"return this._dbCommand( cmd );\n" 
"}\n" 
"\n" 
"\n" 
"/**\n" 
"*  <p> Evaluate a js expression at the database server.</p>\n" 
"*\n" 
"* <p>Useful if you need to touch a lot of data lightly; in such a scenario\n" 
"*  the network transfer of the data could be a bottleneck.  A good example\n" 
"*  is \"select count(*)\" -- can be done server side via this mechanism.\n" 
"* </p>\n" 
"*\n" 
"* <p>\n" 
"* If the eval fails, an exception is thrown of the form:\n" 
"* </p>\n" 
"* <code>{ dbEvalException: { retval: functionReturnValue, ok: num [, errno: num] [, errmsg: str] } }</code>\n" 
"*\n" 
"* <p>Example: </p>\n" 
"* <code>print( \"mycount: \" + db.eval( function(){db.mycoll.find({},{_id:ObjId()}).length();} );</code>\n" 
"*\n" 
"* @param {Function} jsfunction Javascript function to run on server.  Note this it not a closure, but rather just \"code\".\n" 
"* @return result of your function, or null if error\n" 
"*\n" 
"*/\n" 
"DB.prototype.eval = function(jsfunction) {\n" 
"var cmd = { $eval : jsfunction };\n" 
"if ( arguments.length > 1 ) {\n" 
"cmd.args = argumentsToArray( arguments ).slice(1);\n" 
"}\n" 
"\n" 
"var res = this._dbCommand( cmd );\n" 
"\n" 
"if (!res.ok)\n" 
"throw tojson( res );\n" 
"\n" 
"return res.retval;\n" 
"}\n" 
"\n" 
"DB.prototype.dbEval = DB.prototype.eval;\n" 
"\n" 
"\n" 
"/**\n" 
"*\n" 
"*  <p>\n" 
"*   Similar to SQL group by.  For example: </p>\n" 
"*\n" 
"*  <code>select a,b,sum(c) csum from coll where active=1 group by a,b</code>\n" 
"*\n" 
"*  <p>\n" 
"*    corresponds to the following in 10gen:\n" 
"*  </p>\n" 
"*\n" 
"*  <code>\n" 
"db.group(\n" 
"{\n" 
"ns: \"coll\",\n" 
"key: { a:true, b:true },\n" 
"// keyf: ...,\n" 
"cond: { active:1 },\n" 
"reduce: function(obj,prev) { prev.csum += obj.c; } ,\n" 
"initial: { csum: 0 }\n" 
"});\n" 
"</code>\n" 
"*\n" 
"*\n" 
"* <p>\n" 
"*  An array of grouped items is returned.  The array must fit in RAM, thus this function is not\n" 
"* suitable when the return set is extremely large.\n" 
"* </p>\n" 
"* <p>\n" 
"* To order the grouped data, simply sort it client side upon return.\n" 
"* <p>\n" 
"Defaults\n" 
"cond may be null if you want to run against all rows in the collection\n" 
"keyf is a function which takes an object and returns the desired key.  set either key or keyf (not both).\n" 
"* </p>\n" 
"*/\n" 
"DB.prototype.groupeval = function(parmsObj) {\n" 
"\n" 
"var groupFunction = function() {\n" 
"var parms = args[0];\n" 
"var c = db[parms.ns].find(parms.cond||{});\n" 
"var map = new Map();\n" 
"var pks = parms.key ? Object.keySet( parms.key ) : null;\n" 
"var pkl = pks ? pks.length : 0;\n" 
"var key = {};\n" 
"\n" 
"while( c.hasNext() ) {\n" 
"var obj = c.next();\n" 
"if ( pks ) {\n" 
"for( var i=0; i<pkl; i++ ){\n" 
"var k = pks[i];\n" 
"key[k] = obj[k];\n" 
"}\n" 
"}\n" 
"else {\n" 
"key = parms.$keyf(obj);\n" 
"}\n" 
"\n" 
"var aggObj = map.get(key);\n" 
"if( aggObj == null ) {\n" 
"var newObj = Object.extend({}, key); // clone\n" 
"aggObj = Object.extend(newObj, parms.initial)\n" 
"map.put( key , aggObj );\n" 
"}\n" 
"parms.$reduce(obj, aggObj);\n" 
"}\n" 
"\n" 
"return map.values();\n" 
"}\n" 
"\n" 
"return this.eval(groupFunction, this._groupFixParms( parmsObj ));\n" 
"}\n" 
"\n" 
"DB.prototype.groupcmd = function( parmsObj ){\n" 
"var ret = this.runCommand( { \"group\" : this._groupFixParms( parmsObj ) } );\n" 
"if ( ! ret.ok ){\n" 
"throw \"group command failed: \" + tojson( ret );\n" 
"}\n" 
"return ret.retval;\n" 
"}\n" 
"\n" 
"DB.prototype.group = DB.prototype.groupcmd;\n" 
"\n" 
"DB.prototype._groupFixParms = function( parmsObj ){\n" 
"var parms = Object.extend({}, parmsObj);\n" 
"\n" 
"if( parms.reduce ) {\n" 
"parms.$reduce = parms.reduce; // must have $ to pass to db\n" 
"delete parms.reduce;\n" 
"}\n" 
"\n" 
"if( parms.keyf ) {\n" 
"parms.$keyf = parms.keyf;\n" 
"delete parms.keyf;\n" 
"}\n" 
"\n" 
"return parms;\n" 
"}\n" 
"\n" 
"DB.prototype.resetError = function(){\n" 
"return this.runCommand( { reseterror : 1 } );\n" 
"}\n" 
"\n" 
"DB.prototype.forceError = function(){\n" 
"return this.runCommand( { forceerror : 1 } );\n" 
"}\n" 
"\n" 
"DB.prototype.getLastError = function( w , wtimeout ){\n" 
"var res = this.getLastErrorObj( w , wtimeout );\n" 
"if ( ! res.ok )\n" 
"throw \"getlasterror failed: \" + tojson( res );\n" 
"return res.err;\n" 
"}\n" 
"DB.prototype.getLastErrorObj = function( w , wtimeout ){\n" 
"var cmd = { getlasterror : 1 };\n" 
"if ( w ){\n" 
"cmd.w = w;\n" 
"if ( wtimeout )\n" 
"cmd.wtimeout = wtimeout;\n" 
"}\n" 
"var res = this.runCommand( cmd );\n" 
"\n" 
"if ( ! res.ok )\n" 
"throw \"getlasterror failed: \" + tojson( res );\n" 
"return res;\n" 
"}\n" 
"DB.prototype.getLastErrorCmd = DB.prototype.getLastErrorObj;\n" 
"\n" 
"\n" 
"/* Return the last error which has occurred, even if not the very last error.\n" 
"\n" 
"Returns:\n" 
"{ err : <error message>, nPrev : <how_many_ops_back_occurred>, ok : 1 }\n" 
"\n" 
"result.err will be null if no error has occurred.\n" 
"*/\n" 
"DB.prototype.getPrevError = function(){\n" 
"return this.runCommand( { getpreverror : 1 } );\n" 
"}\n" 
"\n" 
"DB.prototype.getCollectionNames = function(){\n" 
"var all = [];\n" 
"\n" 
"var nsLength = this._name.length + 1;\n" 
"\n" 
"var c = this.getCollection( \"system.namespaces\" ).find();\n" 
"while ( c.hasNext() ){\n" 
"var name = c.next().name;\n" 
"\n" 
"if ( name.indexOf( \"$\" ) >= 0 && name.indexOf( \".oplog.$\" ) < 0 )\n" 
"continue;\n" 
"\n" 
"all.push( name.substring( nsLength ) );\n" 
"}\n" 
"\n" 
"return all.sort();\n" 
"}\n" 
"\n" 
"DB.prototype.tojson = function(){\n" 
"return this._name;\n" 
"}\n" 
"\n" 
"DB.prototype.toString = function(){\n" 
"return this._name;\n" 
"}\n" 
"\n" 
"DB.prototype.isMaster = function () { return this.runCommand(\"isMaster\"); }\n" 
"\n" 
"DB.prototype.currentOp = function( arg ){\n" 
"var q = {}\n" 
"if ( arg ) {\n" 
"if ( typeof( arg ) == \"object\" )\n" 
"Object.extend( q , arg );\n" 
"else if ( arg )\n" 
"q[\"$all\"] = true;\n" 
"}\n" 
"return db.$cmd.sys.inprog.findOne( q );\n" 
"}\n" 
"DB.prototype.currentOP = DB.prototype.currentOp;\n" 
"\n" 
"DB.prototype.killOp = function(op) {\n" 
"if( !op )\n" 
"throw \"no opNum to kill specified\";\n" 
"return db.$cmd.sys.killop.findOne({'op':op});\n" 
"}\n" 
"DB.prototype.killOP = DB.prototype.killOp;\n" 
"\n" 
"DB.tsToSeconds = function(x){\n" 
"if ( x.t && x.i )\n" 
"return x.t / 1000;\n" 
"return x / 4294967296; // low 32 bits are ordinal #s within a second\n" 
"}\n" 
"\n" 
"/**\n" 
"Get a replication log information summary.\n" 
"<p>\n" 
"This command is for the database/cloud administer and not applicable to most databases.\n" 
"It is only used with the local database.  One might invoke from the JS shell:\n" 
"<pre>\n" 
"use local\n" 
"db.getReplicationInfo();\n" 
"</pre>\n" 
"It is assumed that this database is a replication master -- the information returned is\n" 
"about the operation log stored at local.oplog.$main on the replication master.  (It also\n" 
"works on a machine in a replica pair: for replica pairs, both machines are \"masters\" from\n" 
"an internal database perspective.\n" 
"<p>\n" 
"* @return Object timeSpan: time span of the oplog from start to end  if slave is more out\n" 
"*                          of date than that, it can't recover without a complete resync\n" 
"*/\n" 
"DB.prototype.getReplicationInfo = function() {\n" 
"var db = this.getSiblingDB(\"local\");\n" 
"\n" 
"var result = { };\n" 
"var oplog;\n" 
"if (db.system.namespaces.findOne({name:\"local.oplog.rs\"}) != null) {\n" 
"oplog = 'oplog.rs';\n" 
"}\n" 
"else if (db.system.namespaces.findOne({name:\"local.oplog.$main\"}) != null) {\n" 
"oplog = 'oplog.$main';\n" 
"}\n" 
"else {\n" 
"result.errmsg = \"neither master/slave nor replica set replication detected\";\n" 
"return result;\n" 
"}\n" 
"\n" 
"var ol_entry = db.system.namespaces.findOne({name:\"local.\"+oplog});\n" 
"if( ol_entry && ol_entry.options ) {\n" 
"result.logSizeMB = ol_entry.options.size / ( 1024 * 1024 );\n" 
"} else {\n" 
"result.errmsg  = \"local.\"+oplog+\", or its options, not found in system.namespaces collection\";\n" 
"return result;\n" 
"}\n" 
"ol = db.getCollection(oplog);\n" 
"\n" 
"result.usedMB = ol.stats().size / ( 1024 * 1024 );\n" 
"result.usedMB = Math.ceil( result.usedMB * 100 ) / 100;\n" 
"\n" 
"var firstc = ol.find().sort({$natural:1}).limit(1);\n" 
"var lastc = ol.find().sort({$natural:-1}).limit(1);\n" 
"if( !firstc.hasNext() || !lastc.hasNext() ) {\n" 
"result.errmsg = \"objects not found in local.oplog.$main -- is this a new and empty db instance?\";\n" 
"result.oplogMainRowCount = ol.count();\n" 
"return result;\n" 
"}\n" 
"\n" 
"var first = firstc.next();\n" 
"var last = lastc.next();\n" 
"{\n" 
"var tfirst = first.ts;\n" 
"var tlast = last.ts;\n" 
"\n" 
"if( tfirst && tlast ) {\n" 
"tfirst = DB.tsToSeconds( tfirst );\n" 
"tlast = DB.tsToSeconds( tlast );\n" 
"result.timeDiff = tlast - tfirst;\n" 
"result.timeDiffHours = Math.round(result.timeDiff / 36)/100;\n" 
"result.tFirst = (new Date(tfirst*1000)).toString();\n" 
"result.tLast  = (new Date(tlast*1000)).toString();\n" 
"result.now = Date();\n" 
"}\n" 
"else {\n" 
"result.errmsg = \"ts element not found in oplog objects\";\n" 
"}\n" 
"}\n" 
"\n" 
"return result;\n" 
"};\n" 
"\n" 
"DB.prototype.printReplicationInfo = function() {\n" 
"var result = this.getReplicationInfo();\n" 
"if( result.errmsg ) {\n" 
"if (!this.isMaster().ismaster) {\n" 
"print(\"this is a slave, printing slave replication info.\");\n" 
"this.printSlaveReplicationInfo();\n" 
"return;\n" 
"}\n" 
"print(tojson(result));\n" 
"return;\n" 
"}\n" 
"print(\"configured oplog size:   \" + result.logSizeMB + \"MB\");\n" 
"print(\"log length start to end: \" + result.timeDiff + \"secs (\" + result.timeDiffHours + \"hrs)\");\n" 
"print(\"oplog first event time:  \" + result.tFirst);\n" 
"print(\"oplog last event time:   \" + result.tLast);\n" 
"print(\"now:                     \" + result.now);\n" 
"}\n" 
"\n" 
"DB.prototype.printSlaveReplicationInfo = function() {\n" 
"function getReplLag(st) {\n" 
"var now = new Date();\n" 
"print(\"\\t syncedTo: \" + st.toString() );\n" 
"var ago = (now-st)/1000;\n" 
"var hrs = Math.round(ago/36)/100;\n" 
"print(\"\\t\\t = \" + Math.round(ago) + \" secs ago (\" + hrs + \"hrs)\");\n" 
"};\n" 
"\n" 
"function g(x) {\n" 
"assert( x , \"how could this be null (printSlaveReplicationInfo gx)\" )\n" 
"print(\"source:   \" + x.host);\n" 
"if ( x.syncedTo ){\n" 
"var st = new Date( DB.tsToSeconds( x.syncedTo ) * 1000 );\n" 
"getReplLag(st);\n" 
"}\n" 
"else {\n" 
"print( \"\\t doing initial sync\" );\n" 
"}\n" 
"};\n" 
"\n" 
"function r(x) {\n" 
"assert( x , \"how could this be null (printSlaveReplicationInfo rx)\" );\n" 
"if ( x.state == 1 ) {\n" 
"return;\n" 
"}\n" 
"\n" 
"print(\"source:   \" + x.name);\n" 
"if ( x.optime ) {\n" 
"getReplLag(x.optimeDate);\n" 
"}\n" 
"else {\n" 
"print( \"\\t no replication info, yet.  State: \" + x.stateStr );\n" 
"}\n" 
"};\n" 
"\n" 
"var L = this.getSiblingDB(\"local\");\n" 
"\n" 
"if (L.system.replset.count() != 0) {\n" 
"var status = this.adminCommand({'replSetGetStatus' : 1});\n" 
"status.members.forEach(r);\n" 
"}\n" 
"else if( L.sources.count() != 0 ) {\n" 
"L.sources.find().forEach(g);\n" 
"}\n" 
"else {\n" 
"print(\"local.sources is empty; is this db a --slave?\");\n" 
"return;\n" 
"}\n" 
"}\n" 
"\n" 
"DB.prototype.serverBuildInfo = function(){\n" 
"return this._adminCommand( \"buildinfo\" );\n" 
"}\n" 
"\n" 
"DB.prototype.serverStatus = function(){\n" 
"return this._adminCommand( \"serverStatus\" );\n" 
"}\n" 
"\n" 
"DB.prototype.serverCmdLineOpts = function(){\n" 
"return this._adminCommand( \"getCmdLineOpts\" );\n" 
"}\n" 
"\n" 
"DB.prototype.version = function(){\n" 
"return this.serverBuildInfo().version;\n" 
"}\n" 
"\n" 
"DB.prototype.serverBits = function(){\n" 
"return this.serverBuildInfo().bits;\n" 
"}\n" 
"\n" 
"DB.prototype.listCommands = function(){\n" 
"var x = this.runCommand( \"listCommands\" );\n" 
"for ( var name in x.commands ){\n" 
"var c = x.commands[name];\n" 
"\n" 
"var s = name + \": \";\n" 
"\n" 
"switch ( c.lockType ){\n" 
"case -1: s += \"read-lock\"; break;\n" 
"case  0: s += \"no-lock\"; break;\n" 
"case  1: s += \"write-lock\"; break;\n" 
"default: s += c.lockType;\n" 
"}\n" 
"\n" 
"if (c.adminOnly) s += \" adminOnly \";\n" 
"if (c.adminOnly) s += \" slaveOk \";\n" 
"\n" 
"s += \"\\n  \";\n" 
"s += c.help.replace(/\\n/g, '\\n  ');\n" 
"s += \"\\n\";\n" 
"\n" 
"print( s );\n" 
"}\n" 
"}\n" 
"\n" 
"DB.prototype.printShardingStatus = function( verbose ){\n" 
"printShardingStatus( this.getSiblingDB( \"config\" ) , verbose );\n" 
"}\n" 
"\n" 
"DB.prototype.fsyncLock = function() {\n" 
"return db.adminCommand({fsync:1, lock:true});\n" 
"}\n" 
"\n" 
"DB.prototype.fsyncUnlock = function() {\n" 
"return db.getSiblingDB(\"admin\").$cmd.sys.unlock.findOne()\n" 
"}\n" 
"\n" 
"DB.autocomplete = function(obj){\n" 
"var colls = obj.getCollectionNames();\n" 
"var ret=[];\n" 
"for (var i=0; i<colls.length; i++){\n" 
"if (colls[i].match(/^[a-zA-Z0-9_.\\$]+$/))\n" 
"ret.push(colls[i]);\n" 
"}\n" 
"return ret;\n" 
"}\n" 
;
extern const JSFile db;
const JSFile db = { "shell/db.js" , _jscode_raw_db };
const StringData _jscode_raw_mongo = 
"// mongo.js\n" 
"\n" 
"// NOTE 'Mongo' may be defined here or in MongoJS.cpp.  Add code to init, not to this constructor.\n" 
"if ( typeof Mongo == \"undefined\" ){\n" 
"Mongo = function( host ){\n" 
"this.init( host );\n" 
"}\n" 
"}\n" 
"\n" 
"if ( ! Mongo.prototype ){\n" 
"throw \"Mongo.prototype not defined\";\n" 
"}\n" 
"\n" 
"if ( ! Mongo.prototype.find )\n" 
"Mongo.prototype.find = function( ns , query , fields , limit , skip , batchSize , options ){ throw \"find not implemented\"; }\n" 
"if ( ! Mongo.prototype.insert )\n" 
"Mongo.prototype.insert = function( ns , obj ){ throw \"insert not implemented\"; }\n" 
"if ( ! Mongo.prototype.remove )\n" 
"Mongo.prototype.remove = function( ns , pattern ){ throw \"remove not implemented;\" }\n" 
"if ( ! Mongo.prototype.update )\n" 
"Mongo.prototype.update = function( ns , query , obj , upsert ){ throw \"update not implemented;\" }\n" 
"\n" 
"if ( typeof mongoInject == \"function\" ){\n" 
"mongoInject( Mongo.prototype );\n" 
"}\n" 
"\n" 
"Mongo.prototype.setSlaveOk = function( value ) {\n" 
"if( value == undefined ) value = true\n" 
"this.slaveOk = value\n" 
"}\n" 
"\n" 
"Mongo.prototype.getDB = function( name ){\n" 
"return new DB( this , name );\n" 
"}\n" 
"\n" 
"Mongo.prototype.getDBs = function(){\n" 
"var res = this.getDB( \"admin\" ).runCommand( { \"listDatabases\" : 1 } );\n" 
"if ( ! res.ok )\n" 
"throw \"listDatabases failed:\" + tojson( res );\n" 
"return res;\n" 
"}\n" 
"\n" 
"Mongo.prototype.adminCommand = function( cmd ){\n" 
"return this.getDB( \"admin\" ).runCommand( cmd );\n" 
"}\n" 
"\n" 
"Mongo.prototype.setLogLevel = function( logLevel ){\n" 
"return this.adminCommand({ setParameter : 1, logLevel : logLevel })\n" 
"}\n" 
"\n" 
"Mongo.prototype.getDBNames = function(){\n" 
"return this.getDBs().databases.map(\n" 
"function(z){\n" 
"return z.name;\n" 
"}\n" 
");\n" 
"}\n" 
"\n" 
"Mongo.prototype.getCollection = function(ns){\n" 
"var idx = ns.indexOf( \".\" );\n" 
"if ( idx < 0 )\n" 
"throw \"need . in ns\";\n" 
"var db = ns.substring( 0 , idx );\n" 
"var c = ns.substring( idx + 1 );\n" 
"return this.getDB( db ).getCollection( c );\n" 
"}\n" 
"\n" 
"Mongo.prototype.toString = function(){\n" 
"return \"connection to \" + this.host;\n" 
"}\n" 
"Mongo.prototype.tojson = Mongo.prototype.toString;\n" 
"\n" 
"connect = function( url , user , pass ){\n" 
"chatty( \"connecting to: \" + url )\n" 
"\n" 
"if ( user && ! pass )\n" 
"throw \"you specified a user and not a password.  either you need a password, or you're using the old connect api\";\n" 
"\n" 
"var idx = url.lastIndexOf( \"/\" );\n" 
"\n" 
"var db;\n" 
"\n" 
"if ( idx < 0 )\n" 
"db = new Mongo().getDB( url );\n" 
"else\n" 
"db = new Mongo( url.substring( 0 , idx ) ).getDB( url.substring( idx + 1 ) );\n" 
"\n" 
"if ( user && pass ){\n" 
"if ( ! db.auth( user , pass ) ){\n" 
"throw \"couldn't login\";\n" 
"}\n" 
"}\n" 
"\n" 
"return db;\n" 
"}\n" 
;
extern const JSFile mongo;
const JSFile mongo = { "shell/mongo.js" , _jscode_raw_mongo };
const StringData _jscode_raw_mr = 
"// mr.js\n" 
"\n" 
"MR = {};\n" 
"\n" 
"MR.init = function(){\n" 
"$max = 0;\n" 
"$arr = [];\n" 
"emit = MR.emit;\n" 
"$numEmits = 0;\n" 
"$numReduces = 0;\n" 
"$numReducesToDB = 0;\n" 
"gc(); // this is just so that keep memory size sane\n" 
"}\n" 
"\n" 
"MR.cleanup = function(){\n" 
"MR.init();\n" 
"gc();\n" 
"}\n" 
"\n" 
"MR.emit = function(k,v){\n" 
"$numEmits++;\n" 
"var num = nativeHelper.apply( get_num_ , [ k ] );\n" 
"var data = $arr[num];\n" 
"if ( ! data ){\n" 
"data = { key : k , values : new Array(1000) , count : 0 };\n" 
"$arr[num] = data;\n" 
"}\n" 
"data.values[data.count++] = v;\n" 
"$max = Math.max( $max , data.count );\n" 
"}\n" 
"\n" 
"MR.doReduce = function( useDB ){\n" 
"$numReduces++;\n" 
"if ( useDB )\n" 
"$numReducesToDB++;\n" 
"$max = 0;\n" 
"for ( var i=0; i<$arr.length; i++){\n" 
"var data = $arr[i];\n" 
"if ( ! data )\n" 
"continue;\n" 
"\n" 
"if ( useDB ){\n" 
"var x = tempcoll.findOne( { _id : data.key } );\n" 
"if ( x ){\n" 
"data.values[data.count++] = x.value;\n" 
"}\n" 
"}\n" 
"\n" 
"var r = $reduce( data.key , data.values.slice( 0 , data.count ) );\n" 
"if ( r && r.length && r[0] ){\n" 
"data.values = r;\n" 
"data.count = r.length;\n" 
"}\n" 
"else{\n" 
"data.values[0] = r;\n" 
"data.count = 1;\n" 
"}\n" 
"\n" 
"$max = Math.max( $max , data.count );\n" 
"\n" 
"if ( useDB ){\n" 
"if ( data.count == 1 ){\n" 
"tempcoll.save( { _id : data.key , value : data.values[0] } );\n" 
"}\n" 
"else {\n" 
"tempcoll.save( { _id : data.key , value : data.values.slice( 0 , data.count ) } );\n" 
"}\n" 
"}\n" 
"}\n" 
"}\n" 
"\n" 
"MR.check = function(){\n" 
"if ( $max < 2000 && $arr.length < 1000 ){\n" 
"return 0;\n" 
"}\n" 
"MR.doReduce();\n" 
"if ( $max < 2000 && $arr.length < 1000 ){\n" 
"return 1;\n" 
"}\n" 
"MR.doReduce( true );\n" 
"$arr = [];\n" 
"$max = 0;\n" 
"reset_num();\n" 
"gc();\n" 
"return 2;\n" 
"}\n" 
"\n" 
"MR.finalize = function(){\n" 
"tempcoll.find().forEach(\n" 
"function(z){\n" 
"z.value = $finalize( z._id , z.value );\n" 
"tempcoll.save( z );\n" 
"}\n" 
");\n" 
"}\n" 
;
extern const JSFile mr;
const JSFile mr = { "shell/mr.js" , _jscode_raw_mr };
const StringData _jscode_raw_query = 
"// query.js\n" 
"\n" 
"if ( typeof DBQuery == \"undefined\" ){\n" 
"DBQuery = function( mongo , db , collection , ns , query , fields , limit , skip , batchSize , options ){\n" 
"\n" 
"this._mongo = mongo; // 0\n" 
"this._db = db; // 1\n" 
"this._collection = collection; // 2\n" 
"this._ns = ns; // 3\n" 
"\n" 
"this._query = query || {}; // 4\n" 
"this._fields = fields; // 5\n" 
"this._limit = limit || 0; // 6\n" 
"this._skip = skip || 0; // 7\n" 
"this._batchSize = batchSize || 0;\n" 
"this._options = options || 0;\n" 
"\n" 
"this._cursor = null;\n" 
"this._numReturned = 0;\n" 
"this._special = false;\n" 
"this._prettyShell = false;\n" 
"}\n" 
"print( \"DBQuery probably won't have array access \" );\n" 
"}\n" 
"\n" 
"DBQuery.prototype.help = function () {\n" 
"print(\"find() modifiers\")\n" 
"print(\"\\t.sort( {...} )\")\n" 
"print(\"\\t.limit( n )\")\n" 
"print(\"\\t.skip( n )\")\n" 
"print(\"\\t.count() - total # of objects matching query, ignores skip,limit\")\n" 
"print(\"\\t.size() - total # of objects cursor would return, honors skip,limit\")\n" 
"print(\"\\t.explain([verbose])\")\n" 
"print(\"\\t.hint(...)\")\n" 
"print(\"\\t.showDiskLoc() - adds a $diskLoc field to each returned object\")\n" 
"print(\"\\nCursor methods\");\n" 
"print(\"\\t.forEach( func )\")\n" 
"print(\"\\t.map( func )\")\n" 
"print(\"\\t.hasNext()\")\n" 
"print(\"\\t.next()\")\n" 
"}\n" 
"\n" 
"DBQuery.prototype.clone = function(){\n" 
"var q =  new DBQuery( this._mongo , this._db , this._collection , this._ns ,\n" 
"this._query , this._fields ,\n" 
"this._limit , this._skip , this._batchSize , this._options );\n" 
"q._special = this._special;\n" 
"return q;\n" 
"}\n" 
"\n" 
"DBQuery.prototype._ensureSpecial = function(){\n" 
"if ( this._special )\n" 
"return;\n" 
"\n" 
"var n = { query : this._query };\n" 
"this._query = n;\n" 
"this._special = true;\n" 
"}\n" 
"\n" 
"DBQuery.prototype._checkModify = function(){\n" 
"if ( this._cursor )\n" 
"throw \"query already executed\";\n" 
"}\n" 
"\n" 
"DBQuery.prototype._exec = function(){\n" 
"if ( ! this._cursor ){\n" 
"assert.eq( 0 , this._numReturned );\n" 
"this._cursor = this._mongo.find( this._ns , this._query , this._fields , this._limit , this._skip , this._batchSize , this._options );\n" 
"this._cursorSeen = 0;\n" 
"}\n" 
"return this._cursor;\n" 
"}\n" 
"\n" 
"DBQuery.prototype.limit = function( limit ){\n" 
"this._checkModify();\n" 
"this._limit = limit;\n" 
"return this;\n" 
"}\n" 
"\n" 
"DBQuery.prototype.batchSize = function( batchSize ){\n" 
"this._checkModify();\n" 
"this._batchSize = batchSize;\n" 
"return this;\n" 
"}\n" 
"\n" 
"\n" 
"DBQuery.prototype.addOption = function( option ){\n" 
"this._options |= option;\n" 
"return this;\n" 
"}\n" 
"\n" 
"DBQuery.prototype.skip = function( skip ){\n" 
"this._checkModify();\n" 
"this._skip = skip;\n" 
"return this;\n" 
"}\n" 
"\n" 
"DBQuery.prototype.hasNext = function(){\n" 
"this._exec();\n" 
"\n" 
"if ( this._limit > 0 && this._cursorSeen >= this._limit )\n" 
"return false;\n" 
"var o = this._cursor.hasNext();\n" 
"return o;\n" 
"}\n" 
"\n" 
"DBQuery.prototype.next = function(){\n" 
"this._exec();\n" 
"\n" 
"var o = this._cursor.hasNext();\n" 
"if ( o )\n" 
"this._cursorSeen++;\n" 
"else\n" 
"throw \"error hasNext: \" + o;\n" 
"\n" 
"var ret = this._cursor.next();\n" 
"if ( ret.$err && this._numReturned == 0 && ! this.hasNext() )\n" 
"throw \"error: \" + tojson( ret );\n" 
"\n" 
"this._numReturned++;\n" 
"return ret;\n" 
"}\n" 
"\n" 
"DBQuery.prototype.objsLeftInBatch = function(){\n" 
"this._exec();\n" 
"\n" 
"var ret = this._cursor.objsLeftInBatch();\n" 
"if ( ret.$err )\n" 
"throw \"error: \" + tojson( ret );\n" 
"\n" 
"return ret;\n" 
"}\n" 
"\n" 
"DBQuery.prototype.toArray = function(){\n" 
"if ( this._arr )\n" 
"return this._arr;\n" 
"\n" 
"var a = [];\n" 
"while ( this.hasNext() )\n" 
"a.push( this.next() );\n" 
"this._arr = a;\n" 
"return a;\n" 
"}\n" 
"\n" 
"DBQuery.prototype.count = function( applySkipLimit ){\n" 
"var cmd = { count: this._collection.getName() };\n" 
"if ( this._query ){\n" 
"if ( this._special )\n" 
"cmd.query = this._query.query;\n" 
"else\n" 
"cmd.query = this._query;\n" 
"}\n" 
"cmd.fields = this._fields || {};\n" 
"\n" 
"if ( applySkipLimit ){\n" 
"if ( this._limit )\n" 
"cmd.limit = this._limit;\n" 
"if ( this._skip )\n" 
"cmd.skip = this._skip;\n" 
"}\n" 
"\n" 
"var res = this._db.runCommand( cmd );\n" 
"if( res && res.n != null ) return res.n;\n" 
"throw \"count failed: \" + tojson( res );\n" 
"}\n" 
"\n" 
"DBQuery.prototype.size = function(){\n" 
"return this.count( true );\n" 
"}\n" 
"\n" 
"DBQuery.prototype.countReturn = function(){\n" 
"var c = this.count();\n" 
"\n" 
"if ( this._skip )\n" 
"c = c - this._skip;\n" 
"\n" 
"if ( this._limit > 0 && this._limit < c )\n" 
"return this._limit;\n" 
"\n" 
"return c;\n" 
"}\n" 
"\n" 
"/**\n" 
"* iterative count - only for testing\n" 
"*/\n" 
"DBQuery.prototype.itcount = function(){\n" 
"var num = 0;\n" 
"while ( this.hasNext() ){\n" 
"num++;\n" 
"this.next();\n" 
"}\n" 
"return num;\n" 
"}\n" 
"\n" 
"DBQuery.prototype.length = function(){\n" 
"return this.toArray().length;\n" 
"}\n" 
"\n" 
"DBQuery.prototype._addSpecial = function( name , value ){\n" 
"this._ensureSpecial();\n" 
"this._query[name] = value;\n" 
"return this;\n" 
"}\n" 
"\n" 
"DBQuery.prototype.sort = function( sortBy ){\n" 
"return this._addSpecial( \"orderby\" , sortBy );\n" 
"}\n" 
"\n" 
"DBQuery.prototype.hint = function( hint ){\n" 
"return this._addSpecial( \"$hint\" , hint );\n" 
"}\n" 
"\n" 
"DBQuery.prototype.min = function( min ) {\n" 
"return this._addSpecial( \"$min\" , min );\n" 
"}\n" 
"\n" 
"DBQuery.prototype.max = function( max ) {\n" 
"return this._addSpecial( \"$max\" , max );\n" 
"}\n" 
"\n" 
"DBQuery.prototype.showDiskLoc = function() {\n" 
"return this._addSpecial( \"$showDiskLoc\" , true);\n" 
"}\n" 
"\n" 
"DBQuery.prototype.forEach = function( func ){\n" 
"while ( this.hasNext() )\n" 
"func( this.next() );\n" 
"}\n" 
"\n" 
"DBQuery.prototype.map = function( func ){\n" 
"var a = [];\n" 
"while ( this.hasNext() )\n" 
"a.push( func( this.next() ) );\n" 
"return a;\n" 
"}\n" 
"\n" 
"DBQuery.prototype.arrayAccess = function( idx ){\n" 
"return this.toArray()[idx];\n" 
"}\n" 
"\n" 
"DBQuery.prototype.explain = function (verbose) {\n" 
"/* verbose=true --> include allPlans, oldPlan fields */\n" 
"var n = this.clone();\n" 
"n._ensureSpecial();\n" 
"n._query.$explain = true;\n" 
"n._limit = Math.abs(n._limit) * -1;\n" 
"var e = n.next();\n" 
"\n" 
"function cleanup(obj){\n" 
"if (typeof(obj) != 'object'){\n" 
"return;\n" 
"}\n" 
"\n" 
"delete obj.allPlans;\n" 
"delete obj.oldPlan;\n" 
"\n" 
"if (typeof(obj.length) == 'number'){\n" 
"for (var i=0; i < obj.length; i++){\n" 
"cleanup(obj[i]);\n" 
"}\n" 
"}\n" 
"\n" 
"if (obj.shards){\n" 
"for (var key in obj.shards){\n" 
"cleanup(obj.shards[key]);\n" 
"}\n" 
"}\n" 
"\n" 
"if (obj.clauses){\n" 
"cleanup(obj.clauses);\n" 
"}\n" 
"}\n" 
"\n" 
"if (!verbose)\n" 
"cleanup(e);\n" 
"\n" 
"return e;\n" 
"}\n" 
"\n" 
"DBQuery.prototype.snapshot = function(){\n" 
"this._ensureSpecial();\n" 
"this._query.$snapshot = true;\n" 
"return this;\n" 
"}\n" 
"\n" 
"DBQuery.prototype.pretty = function(){\n" 
"this._prettyShell = true;\n" 
"return this;\n" 
"}\n" 
"\n" 
"DBQuery.prototype.shellPrint = function(){\n" 
"try {\n" 
"var n = 0;\n" 
"while ( this.hasNext() && n < DBQuery.shellBatchSize ){\n" 
"var s = this._prettyShell ? tojson( this.next() ) : tojson( this.next() , \"\" , true );\n" 
"print( s );\n" 
"n++;\n" 
"}\n" 
"if ( this.hasNext() ){\n" 
"print( \"has more\" );\n" 
"___it___  = this;\n" 
"}\n" 
"else {\n" 
"___it___  = null;\n" 
"}\n" 
"}\n" 
"catch ( e ){\n" 
"print( e );\n" 
"}\n" 
"\n" 
"}\n" 
"\n" 
"DBQuery.prototype.toString = function(){\n" 
"return \"DBQuery: \" + this._ns + \" -> \" + tojson( this.query );\n" 
"}\n" 
"\n" 
"DBQuery.shellBatchSize = 20;\n" 
;
extern const JSFile query;
const JSFile query = { "shell/query.js" , _jscode_raw_query };
const StringData _jscode_raw_collection = 
"// @file collection.js - DBCollection support in the mongo shell\n" 
"// db.colName is a DBCollection object\n" 
"// or db[\"colName\"]\n" 
"\n" 
"if ( ( typeof  DBCollection ) == \"undefined\" ){\n" 
"DBCollection = function( mongo , db , shortName , fullName ){\n" 
"this._mongo = mongo;\n" 
"this._db = db;\n" 
"this._shortName = shortName;\n" 
"this._fullName = fullName;\n" 
"\n" 
"this.verify();\n" 
"}\n" 
"}\n" 
"\n" 
"DBCollection.prototype.verify = function(){\n" 
"assert( this._fullName , \"no fullName\" );\n" 
"assert( this._shortName , \"no shortName\" );\n" 
"assert( this._db , \"no db\" );\n" 
"\n" 
"assert.eq( this._fullName , this._db._name + \".\" + this._shortName , \"name mismatch\" );\n" 
"\n" 
"assert( this._mongo , \"no mongo in DBCollection\" );\n" 
"}\n" 
"\n" 
"DBCollection.prototype.getName = function(){\n" 
"return this._shortName;\n" 
"}\n" 
"\n" 
"DBCollection.prototype.help = function () {\n" 
"var shortName = this.getName();\n" 
"print(\"DBCollection help\");\n" 
"print(\"\\tdb.\" + shortName + \".find().help() - show DBCursor help\");\n" 
"print(\"\\tdb.\" + shortName + \".count()\");\n" 
"print(\"\\tdb.\" + shortName + \".dataSize()\");\n" 
"print(\"\\tdb.\" + shortName + \".distinct( key ) - eg. db.\" + shortName + \".distinct( 'x' )\");\n" 
"print(\"\\tdb.\" + shortName + \".drop() drop the collection\");\n" 
"print(\"\\tdb.\" + shortName + \".dropIndex(name)\");\n" 
"print(\"\\tdb.\" + shortName + \".dropIndexes()\");\n" 
"print(\"\\tdb.\" + shortName + \".ensureIndex(keypattern[,options]) - options is an object with these possible fields: name, unique, dropDups\");\n" 
"print(\"\\tdb.\" + shortName + \".reIndex()\");\n" 
"print(\"\\tdb.\" + shortName + \".find([query],[fields]) - query is an optional query filter. fields is optional set of fields to return.\");\n" 
"print(\"\\t                                              e.g. db.\" + shortName + \".find( {x:77} , {name:1, x:1} )\");\n" 
"print(\"\\tdb.\" + shortName + \".find(...).count()\");\n" 
"print(\"\\tdb.\" + shortName + \".find(...).limit(n)\");\n" 
"print(\"\\tdb.\" + shortName + \".find(...).skip(n)\");\n" 
"print(\"\\tdb.\" + shortName + \".find(...).sort(...)\");\n" 
"print(\"\\tdb.\" + shortName + \".findOne([query])\");\n" 
"print(\"\\tdb.\" + shortName + \".findAndModify( { update : ... , remove : bool [, query: {}, sort: {}, 'new': false] } )\");\n" 
"print(\"\\tdb.\" + shortName + \".getDB() get DB object associated with collection\");\n" 
"print(\"\\tdb.\" + shortName + \".getIndexes()\");\n" 
"print(\"\\tdb.\" + shortName + \".group( { key : ..., initial: ..., reduce : ...[, cond: ...] } )\");\n" 
"print(\"\\tdb.\" + shortName + \".mapReduce( mapFunction , reduceFunction , <optional params> )\");\n" 
"print(\"\\tdb.\" + shortName + \".remove(query)\");\n" 
"print(\"\\tdb.\" + shortName + \".renameCollection( newName , <dropTarget> ) renames the collection.\");\n" 
"print(\"\\tdb.\" + shortName + \".runCommand( name , <options> ) runs a db command with the given name where the first param is the collection name\");\n" 
"print(\"\\tdb.\" + shortName + \".save(obj)\");\n" 
"print(\"\\tdb.\" + shortName + \".stats()\");\n" 
"print(\"\\tdb.\" + shortName + \".storageSize() - includes free space allocated to this collection\");\n" 
"print(\"\\tdb.\" + shortName + \".totalIndexSize() - size in bytes of all the indexes\");\n" 
"print(\"\\tdb.\" + shortName + \".totalSize() - storage allocated for all data and indexes\");\n" 
"print(\"\\tdb.\" + shortName + \".update(query, object[, upsert_bool, multi_bool])\");\n" 
"print(\"\\tdb.\" + shortName + \".validate( <full> ) - SLOW\");;\n" 
"print(\"\\tdb.\" + shortName + \".getShardVersion() - only for use with sharding\");\n" 
"return __magicNoPrint;\n" 
"}\n" 
"\n" 
"DBCollection.prototype.getFullName = function(){\n" 
"return this._fullName;\n" 
"}\n" 
"DBCollection.prototype.getMongo = function(){\n" 
"return this._db.getMongo();\n" 
"}\n" 
"DBCollection.prototype.getDB = function(){\n" 
"return this._db;\n" 
"}\n" 
"\n" 
"DBCollection.prototype._dbCommand = function( cmd , params ){\n" 
"if ( typeof( cmd ) == \"object\" )\n" 
"return this._db._dbCommand( cmd );\n" 
"\n" 
"var c = {};\n" 
"c[cmd] = this.getName();\n" 
"if ( params )\n" 
"Object.extend( c , params );\n" 
"return this._db._dbCommand( c );\n" 
"}\n" 
"\n" 
"DBCollection.prototype.runCommand = DBCollection.prototype._dbCommand;\n" 
"\n" 
"DBCollection.prototype._massageObject = function( q ){\n" 
"if ( ! q )\n" 
"return {};\n" 
"\n" 
"var type = typeof q;\n" 
"\n" 
"if ( type == \"function\" )\n" 
"return { $where : q };\n" 
"\n" 
"if ( q.isObjectId )\n" 
"return { _id : q };\n" 
"\n" 
"if ( type == \"object\" )\n" 
"return q;\n" 
"\n" 
"if ( type == \"string\" ){\n" 
"if ( q.length == 24 )\n" 
"return { _id : q };\n" 
"\n" 
"return { $where : q };\n" 
"}\n" 
"\n" 
"throw \"don't know how to massage : \" + type;\n" 
"\n" 
"}\n" 
"\n" 
"\n" 
"DBCollection.prototype._validateObject = function( o ){\n" 
"if ( o._ensureSpecial && o._checkModify )\n" 
"throw \"can't save a DBQuery object\";\n" 
"}\n" 
"\n" 
"DBCollection._allowedFields = { $id : 1 , $ref : 1 , $db : 1 , $MinKey : 1, $MaxKey : 1 };\n" 
"\n" 
"DBCollection.prototype._validateForStorage = function( o ){\n" 
"this._validateObject( o );\n" 
"for ( var k in o ){\n" 
"if ( k.indexOf( \".\" ) >= 0 ) {\n" 
"throw \"can't have . in field names [\" + k + \"]\" ;\n" 
"}\n" 
"\n" 
"if ( k.indexOf( \"$\" ) == 0 && ! DBCollection._allowedFields[k] ) {\n" 
"throw \"field names cannot start with $ [\" + k + \"]\";\n" 
"}\n" 
"\n" 
"if ( o[k] !== null && typeof( o[k] ) === \"object\" ) {\n" 
"this._validateForStorage( o[k] );\n" 
"}\n" 
"}\n" 
"};\n" 
"\n" 
"\n" 
"DBCollection.prototype.find = function( query , fields , limit , skip ){\n" 
"return new DBQuery( this._mongo , this._db , this ,\n" 
"this._fullName , this._massageObject( query ) , fields , limit , skip );\n" 
"}\n" 
"\n" 
"DBCollection.prototype.findOne = function( query , fields ){\n" 
"var cursor = this._mongo.find( this._fullName , this._massageObject( query ) || {} , fields ,\n" 
"-1 /* limit */ , 0 /* skip*/, 0 /* batchSize */ , 0 /* options */ );\n" 
"if ( ! cursor.hasNext() )\n" 
"return null;\n" 
"var ret = cursor.next();\n" 
"if ( cursor.hasNext() ) throw \"findOne has more than 1 result!\";\n" 
"if ( ret.$err )\n" 
"throw \"error \" + tojson( ret );\n" 
"return ret;\n" 
"}\n" 
"\n" 
"DBCollection.prototype.insert = function( obj , _allow_dot ){\n" 
"if ( ! obj )\n" 
"throw \"no object passed to insert!\";\n" 
"if ( ! _allow_dot ) {\n" 
"this._validateForStorage( obj );\n" 
"}\n" 
"if ( typeof( obj._id ) == \"undefined\" ){\n" 
"var tmp = obj; // don't want to modify input\n" 
"obj = {_id: new ObjectId()};\n" 
"for (var key in tmp){\n" 
"obj[key] = tmp[key];\n" 
"}\n" 
"}\n" 
"this._mongo.insert( this._fullName , obj );\n" 
"this._lastID = obj._id;\n" 
"}\n" 
"\n" 
"DBCollection.prototype.remove = function( t , justOne ){\n" 
"for ( var k in t ){\n" 
"if ( k == \"_id\" && typeof( t[k] ) == \"undefined\" ){\n" 
"throw \"can't have _id set to undefined in a remove expression\"\n" 
"}\n" 
"}\n" 
"this._mongo.remove( this._fullName , this._massageObject( t ) , justOne ? true : false );\n" 
"}\n" 
"\n" 
"DBCollection.prototype.update = function( query , obj , upsert , multi ){\n" 
"assert( query , \"need a query\" );\n" 
"assert( obj , \"need an object\" );\n" 
"\n" 
"var firstKey = null;\n" 
"for (var k in obj) { firstKey = k; break; }\n" 
"\n" 
"if (firstKey != null && firstKey[0] == '$') {\n" 
"// for mods we only validate partially, for example keys may have dots\n" 
"this._validateObject( obj );\n" 
"} else {\n" 
"// we're basically inserting a brand new object, do full validation\n" 
"this._validateForStorage( obj );\n" 
"}\n" 
"this._mongo.update( this._fullName , query , obj , upsert ? true : false , multi ? true : false );\n" 
"}\n" 
"\n" 
"DBCollection.prototype.save = function( obj ){\n" 
"if ( obj == null || typeof( obj ) == \"undefined\" )\n" 
"throw \"can't save a null\";\n" 
"\n" 
"if ( typeof( obj ) == \"number\" || typeof( obj) == \"string\" )\n" 
"throw \"can't save a number or string\"\n" 
"\n" 
"if ( typeof( obj._id ) == \"undefined\" ){\n" 
"obj._id = new ObjectId();\n" 
"return this.insert( obj );\n" 
"}\n" 
"else {\n" 
"return this.update( { _id : obj._id } , obj , true );\n" 
"}\n" 
"}\n" 
"\n" 
"DBCollection.prototype._genIndexName = function( keys ){\n" 
"var name = \"\";\n" 
"for ( var k in keys ){\n" 
"var v = keys[k];\n" 
"if ( typeof v == \"function\" )\n" 
"continue;\n" 
"\n" 
"if ( name.length > 0 )\n" 
"name += \"_\";\n" 
"name += k + \"_\";\n" 
"\n" 
"if ( typeof v == \"number\" )\n" 
"name += v;\n" 
"}\n" 
"return name;\n" 
"}\n" 
"\n" 
"DBCollection.prototype._indexSpec = function( keys, options ) {\n" 
"var ret = { ns : this._fullName , key : keys , name : this._genIndexName( keys ) };\n" 
"\n" 
"if ( ! options ){\n" 
"}\n" 
"else if ( typeof ( options ) == \"string\" )\n" 
"ret.name = options;\n" 
"else if ( typeof ( options ) == \"boolean\" )\n" 
"ret.unique = true;\n" 
"else if ( typeof ( options ) == \"object\" ){\n" 
"if ( options.length ){\n" 
"var nb = 0;\n" 
"for ( var i=0; i<options.length; i++ ){\n" 
"if ( typeof ( options[i] ) == \"string\" )\n" 
"ret.name = options[i];\n" 
"else if ( typeof( options[i] ) == \"boolean\" ){\n" 
"if ( options[i] ){\n" 
"if ( nb == 0 )\n" 
"ret.unique = true;\n" 
"if ( nb == 1 )\n" 
"ret.dropDups = true;\n" 
"}\n" 
"nb++;\n" 
"}\n" 
"}\n" 
"}\n" 
"else {\n" 
"Object.extend( ret , options );\n" 
"}\n" 
"}\n" 
"else {\n" 
"throw \"can't handle: \" + typeof( options );\n" 
"}\n" 
"/*\n" 
"return ret;\n" 
"\n" 
"var name;\n" 
"var nTrue = 0;\n" 
"\n" 
"if ( ! isObject( options ) ) {\n" 
"options = [ options ];\n" 
"}\n" 
"\n" 
"if ( options.length ){\n" 
"for( var i = 0; i < options.length; ++i ) {\n" 
"var o = options[ i ];\n" 
"if ( isString( o ) ) {\n" 
"ret.name = o;\n" 
"} else if ( typeof( o ) == \"boolean\" ) {\n" 
"if ( o ) {\n" 
"++nTrue;\n" 
"}\n" 
"}\n" 
"}\n" 
"if ( nTrue > 0 ) {\n" 
"ret.unique = true;\n" 
"}\n" 
"if ( nTrue > 1 ) {\n" 
"ret.dropDups = true;\n" 
"}\n" 
"}\n" 
"*/\n" 
"return ret;\n" 
"}\n" 
"\n" 
"DBCollection.prototype.createIndex = function( keys , options ){\n" 
"var o = this._indexSpec( keys, options );\n" 
"this._db.getCollection( \"system.indexes\" ).insert( o , true );\n" 
"}\n" 
"\n" 
"DBCollection.prototype.ensureIndex = function( keys , options ){\n" 
"var name = this._indexSpec( keys, options ).name;\n" 
"this._indexCache = this._indexCache || {};\n" 
"if ( this._indexCache[ name ] ){\n" 
"return;\n" 
"}\n" 
"\n" 
"this.createIndex( keys , options );\n" 
"if ( this.getDB().getLastError() == \"\" ) {\n" 
"this._indexCache[name] = true;\n" 
"}\n" 
"}\n" 
"\n" 
"DBCollection.prototype.resetIndexCache = function(){\n" 
"this._indexCache = {};\n" 
"}\n" 
"\n" 
"DBCollection.prototype.reIndex = function() {\n" 
"return this._db.runCommand({ reIndex: this.getName() });\n" 
"}\n" 
"\n" 
"DBCollection.prototype.dropIndexes = function(){\n" 
"this.resetIndexCache();\n" 
"\n" 
"var res = this._db.runCommand( { deleteIndexes: this.getName(), index: \"*\" } );\n" 
"assert( res , \"no result from dropIndex result\" );\n" 
"if ( res.ok )\n" 
"return res;\n" 
"\n" 
"if ( res.errmsg.match( /not found/ ) )\n" 
"return res;\n" 
"\n" 
"throw \"error dropping indexes : \" + tojson( res );\n" 
"}\n" 
"\n" 
"\n" 
"DBCollection.prototype.drop = function(){\n" 
"if ( arguments.length > 0 )\n" 
"throw \"drop takes no argument\";\n" 
"this.resetIndexCache();\n" 
"var ret = this._db.runCommand( { drop: this.getName() } );\n" 
"if ( ! ret.ok ){\n" 
"if ( ret.errmsg == \"ns not found\" )\n" 
"return false;\n" 
"throw \"drop failed: \" + tojson( ret );\n" 
"}\n" 
"return true;\n" 
"}\n" 
"\n" 
"DBCollection.prototype.findAndModify = function(args){\n" 
"var cmd = { findandmodify: this.getName() };\n" 
"for (var key in args){\n" 
"cmd[key] = args[key];\n" 
"}\n" 
"\n" 
"var ret = this._db.runCommand( cmd );\n" 
"if ( ! ret.ok ){\n" 
"if (ret.errmsg == \"No matching object found\"){\n" 
"return null;\n" 
"}\n" 
"throw \"findAndModifyFailed failed: \" + tojson( ret.errmsg );\n" 
"}\n" 
"return ret.value;\n" 
"}\n" 
"\n" 
"DBCollection.prototype.renameCollection = function( newName , dropTarget ){\n" 
"return this._db._adminCommand( { renameCollection : this._fullName ,\n" 
"to : this._db._name + \".\" + newName ,\n" 
"dropTarget : dropTarget } )\n" 
"}\n" 
"\n" 
"DBCollection.prototype.validate = function(full) {\n" 
"var cmd = { validate: this.getName() };\n" 
"\n" 
"if (typeof(full) == 'object') // support arbitrary options here\n" 
"Object.extend(cmd, full);\n" 
"else\n" 
"cmd.full = full;\n" 
"\n" 
"var res = this._db.runCommand( cmd );\n" 
"\n" 
"if (typeof(res.valid) == 'undefined') {\n" 
"// old-style format just put everything in a string. Now using proper fields\n" 
"\n" 
"res.valid = false;\n" 
"\n" 
"var raw = res.result || res.raw;\n" 
"\n" 
"if ( raw ){\n" 
"var str = \"-\" + tojson( raw );\n" 
"res.valid = ! ( str.match( /exception/ ) || str.match( /corrupt/ ) );\n" 
"\n" 
"var p = /lastExtentSize:(\\d+)/;\n" 
"var r = p.exec( str );\n" 
"if ( r ){\n" 
"res.lastExtentSize = Number( r[1] );\n" 
"}\n" 
"}\n" 
"}\n" 
"\n" 
"return res;\n" 
"}\n" 
"\n" 
"DBCollection.prototype.getShardVersion = function(){\n" 
"return this._db._adminCommand( { getShardVersion : this._fullName } );\n" 
"}\n" 
"\n" 
"DBCollection.prototype.getIndexes = function(){\n" 
"return this.getDB().getCollection( \"system.indexes\" ).find( { ns : this.getFullName() } ).toArray();\n" 
"}\n" 
"\n" 
"DBCollection.prototype.getIndices = DBCollection.prototype.getIndexes;\n" 
"DBCollection.prototype.getIndexSpecs = DBCollection.prototype.getIndexes;\n" 
"\n" 
"DBCollection.prototype.getIndexKeys = function(){\n" 
"return this.getIndexes().map(\n" 
"function(i){\n" 
"return i.key;\n" 
"}\n" 
");\n" 
"}\n" 
"\n" 
"\n" 
"DBCollection.prototype.count = function( x ){\n" 
"return this.find( x ).count();\n" 
"}\n" 
"\n" 
"/**\n" 
"*  Drop free lists. Normally not used.\n" 
"*  Note this only does the collection itself, not the namespaces of its indexes (see cleanAll).\n" 
"*/\n" 
"DBCollection.prototype.clean = function() {\n" 
"return this._dbCommand( { clean: this.getName() } );\n" 
"}\n" 
"\n" 
"\n" 
"\n" 
"/**\n" 
"* <p>Drop a specified index.</p>\n" 
"*\n" 
"* <p>\n" 
"* Name is the name of the index in the system.indexes name field. (Run db.system.indexes.find() to\n" 
"*  see example data.)\n" 
"* </p>\n" 
"*\n" 
"* <p>Note :  alpha: space is not reclaimed </p>\n" 
"* @param {String} name of index to delete.\n" 
"* @return A result object.  result.ok will be true if successful.\n" 
"*/\n" 
"DBCollection.prototype.dropIndex =  function(index) {\n" 
"assert(index , \"need to specify index to dropIndex\" );\n" 
"\n" 
"if ( ! isString( index ) && isObject( index ) )\n" 
"index = this._genIndexName( index );\n" 
"\n" 
"var res = this._dbCommand( \"deleteIndexes\" ,{ index: index } );\n" 
"this.resetIndexCache();\n" 
"return res;\n" 
"}\n" 
"\n" 
"DBCollection.prototype.copyTo = function( newName ){\n" 
"return this.getDB().eval(\n" 
"function( collName , newName ){\n" 
"var from = db[collName];\n" 
"var to = db[newName];\n" 
"to.ensureIndex( { _id : 1 } );\n" 
"var count = 0;\n" 
"\n" 
"var cursor = from.find();\n" 
"while ( cursor.hasNext() ){\n" 
"var o = cursor.next();\n" 
"count++;\n" 
"to.save( o );\n" 
"}\n" 
"\n" 
"return count;\n" 
"} , this.getName() , newName\n" 
");\n" 
"}\n" 
"\n" 
"DBCollection.prototype.getCollection = function( subName ){\n" 
"return this._db.getCollection( this._shortName + \".\" + subName );\n" 
"}\n" 
"\n" 
"DBCollection.prototype.stats = function( scale ){\n" 
"return this._db.runCommand( { collstats : this._shortName , scale : scale } );\n" 
"}\n" 
"\n" 
"DBCollection.prototype.dataSize = function(){\n" 
"return this.stats().size;\n" 
"}\n" 
"\n" 
"DBCollection.prototype.storageSize = function(){\n" 
"return this.stats().storageSize;\n" 
"}\n" 
"\n" 
"DBCollection.prototype.totalIndexSize = function( verbose ){\n" 
"var stats = this.stats();\n" 
"if (verbose){\n" 
"for (var ns in stats.indexSizes){\n" 
"print( ns + \"\\t\" + stats.indexSizes[ns] );\n" 
"}\n" 
"}\n" 
"return stats.totalIndexSize;\n" 
"}\n" 
"\n" 
"\n" 
"DBCollection.prototype.totalSize = function(){\n" 
"var total = this.storageSize();\n" 
"var mydb = this._db;\n" 
"var shortName = this._shortName;\n" 
"this.getIndexes().forEach(\n" 
"function( spec ){\n" 
"var coll = mydb.getCollection( shortName + \".$\" + spec.name );\n" 
"var mysize = coll.storageSize();\n" 
"//print( coll + \"\\t\" + mysize + \"\\t\" + tojson( coll.validate() ) );\n" 
"total += coll.dataSize();\n" 
"}\n" 
");\n" 
"return total;\n" 
"}\n" 
"\n" 
"\n" 
"DBCollection.prototype.convertToCapped = function( bytes ){\n" 
"if ( ! bytes )\n" 
"throw \"have to specify # of bytes\";\n" 
"return this._dbCommand( { convertToCapped : this._shortName , size : bytes } )\n" 
"}\n" 
"\n" 
"DBCollection.prototype.exists = function(){\n" 
"return this._db.system.namespaces.findOne( { name : this._fullName } );\n" 
"}\n" 
"\n" 
"DBCollection.prototype.isCapped = function(){\n" 
"var e = this.exists();\n" 
"return ( e && e.options && e.options.capped ) ? true : false;\n" 
"}\n" 
"\n" 
"DBCollection.prototype._distinct = function( keyString , query ){\n" 
"return this._dbCommand( { distinct : this._shortName , key : keyString , query : query || {} } );\n" 
"if ( ! res.ok )\n" 
"throw \"distinct failed: \" + tojson( res );\n" 
"return res.values;\n" 
"}\n" 
"\n" 
"DBCollection.prototype.distinct = function( keyString , query ){\n" 
"var res = this._distinct( keyString , query );\n" 
"if ( ! res.ok )\n" 
"throw \"distinct failed: \" + tojson( res );\n" 
"return res.values;\n" 
"}\n" 
"\n" 
"\n" 
"DBCollection.prototype.group = function( params ){\n" 
"params.ns = this._shortName;\n" 
"return this._db.group( params );\n" 
"}\n" 
"\n" 
"DBCollection.prototype.groupcmd = function( params ){\n" 
"params.ns = this._shortName;\n" 
"return this._db.groupcmd( params );\n" 
"}\n" 
"\n" 
"MapReduceResult = function( db , o ){\n" 
"Object.extend( this , o );\n" 
"this._o = o;\n" 
"this._keys = Object.keySet( o );\n" 
"this._db = db;\n" 
"if ( this.result != null ) {\n" 
"this._coll = this._db.getCollection( this.result );\n" 
"}\n" 
"}\n" 
"\n" 
"MapReduceResult.prototype._simpleKeys = function(){\n" 
"return this._o;\n" 
"}\n" 
"\n" 
"MapReduceResult.prototype.find = function(){\n" 
"if ( this.results )\n" 
"return this.results;\n" 
"return DBCollection.prototype.find.apply( this._coll , arguments );\n" 
"}\n" 
"\n" 
"MapReduceResult.prototype.drop = function(){\n" 
"if ( this._coll ) {\n" 
"return this._coll.drop();\n" 
"}\n" 
"}\n" 
"\n" 
"/**\n" 
"* just for debugging really\n" 
"*/\n" 
"MapReduceResult.prototype.convertToSingleObject = function(){\n" 
"var z = {};\n" 
"var it = this.results != null ? this.results : this._coll.find();\n" 
"it.forEach( function(a){ z[a._id] = a.value; } );\n" 
"return z;\n" 
"}\n" 
"\n" 
"DBCollection.prototype.convertToSingleObject = function(valueField){\n" 
"var z = {};\n" 
"this.find().forEach( function(a){ z[a._id] = a[valueField]; } );\n" 
"return z;\n" 
"}\n" 
"\n" 
"/**\n" 
"* @param optional object of optional fields;\n" 
"*/\n" 
"DBCollection.prototype.mapReduce = function( map , reduce , optionsOrOutString ){\n" 
"var c = { mapreduce : this._shortName , map : map , reduce : reduce };\n" 
"assert( optionsOrOutString , \"need to supply an optionsOrOutString\" )\n" 
"\n" 
"if ( typeof( optionsOrOutString ) == \"string\" )\n" 
"c[\"out\"] = optionsOrOutString;\n" 
"else\n" 
"Object.extend( c , optionsOrOutString );\n" 
"\n" 
"var raw = this._db.runCommand( c );\n" 
"if ( ! raw.ok ){\n" 
"__mrerror__ = raw;\n" 
"throw \"map reduce failed:\" + tojson(raw);\n" 
"}\n" 
"return new MapReduceResult( this._db , raw );\n" 
"\n" 
"}\n" 
"\n" 
"DBCollection.prototype.toString = function(){\n" 
"return this.getFullName();\n" 
"}\n" 
"\n" 
"DBCollection.prototype.toString = function(){\n" 
"return this.getFullName();\n" 
"}\n" 
"\n" 
"\n" 
"DBCollection.prototype.tojson = DBCollection.prototype.toString;\n" 
"\n" 
"DBCollection.prototype.shellPrint = DBCollection.prototype.toString;\n" 
"\n" 
"DBCollection.autocomplete = function(obj){\n" 
"var colls = DB.autocomplete(obj.getDB());\n" 
"var ret = [];\n" 
"for (var i=0; i<colls.length; i++){\n" 
"var c = colls[i];\n" 
"if (c.length <= obj.getName().length) continue;\n" 
"if (c.slice(0,obj.getName().length+1) != obj.getName()+'.') continue;\n" 
"\n" 
"ret.push(c.slice(obj.getName().length+1));\n" 
"}\n" 
"return ret;\n" 
"}\n" 
;
extern const JSFile collection;
const JSFile collection = { "shell/collection.js" , _jscode_raw_collection };
} // namespace JSFiles
} // namespace mongo
