# -------------------------------------------------------------------------
#     This file is part of mMass - the spectrum analysis tool for MS.
#     Copyright (C) 2005-07 Martin Strohalm <mmass@biographics.cz>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE in the
#     main directory of the program
# -------------------------------------------------------------------------

# Function: Export peaklist to ASCII file.

# load libs
import wx
import os.path

# load modules
import peaklist_ascii_xy


class mPeaklistExporter:
    """ Export peaklist data to ASCII file. """

    # ----
    def __init__(self, parent, config):
        self.parent = parent
        self.config = config
    # ----


    # ----
    def exportData(self, document, lastDir=''):
        """ Show export dialog and export data. """

        # get path from document
        path = document.getPath()

        # get file name
        if path:
            fileName = os.path.basename(path)
            fileName = os.path.splitext(fileName)
            fileName = fileName[0]
            if document.getScanID():
                fileName += '_scan' + document.getScanID()
            fileName += '.txt'
        else:
            fileName = 'spectrum.txt'

        # get dir name
        if path:
            path = os.path.dirname(path)
        else:
            path = lastDir

        # available formats
        wildcard = "ASCII XY (*.txt)|*.txt"

        # raise export dialog
        dlg = wx.FileDialog(self.parent, "Export Peaklist", path, fileName, wildcard, wx.SAVE|wx.OVERWRITE_PROMPT)
        if dlg.ShowModal() == wx.ID_OK:
            path = dlg.GetPath()
            choice = dlg.GetFilterIndex()
            dlg.Destroy()
        else:
            dlg.Destroy()
            return

        # get and format data
        peaklist = document.getPeaks()
        if choice == 0:
            data = peaklist_ascii_xy.formatData(peaklist, self.config)
        else:
            return False

        # check data
        if not data:
            dlg = wx.MessageDialog(self.parent, "Current document has no data to save in the selected format!", "No Data", wx.OK|wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
            return False

        # save file
        try:
            save = file(path, 'w')
            save.write(data.encode("utf-8"))
            save.close()
        except IOError:
            dlg = wx.MessageDialog(self.parent, "File cannot be saved! Check permissions please.", "Save Error", wx.OK|wx.ICON_ERROR)
            dlg.ShowModal()
            dlg.Destroy()
    # ----
