/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ODBFunctionsDrawer_H
#include "ODBFunctionsDrawer.h"
#endif

#ifndef EditorDrawerFactory_H
#include "EditorDrawerFactory.h"
#endif

#ifndef ODBEditor_H
#include "ODBEditor.h"
#endif

#ifndef XMList_H
#include "XMList.h"
#endif

#ifndef XMLabel_H
#include "XMLabel.h"
#endif


static request* sql_funcs = 0;
static map<string,string> help;

ODBFunctionsDrawer::ODBFunctionsDrawer(ODBEditor& e):
	XEditorDrawer<UIODBFunctionsDrawer_c>(e),
	editor_(e)
{
	e.constants(contants_);

	if(sql_funcs == 0)
	{
		char buffer[1024];
		sprintf(buffer,"%s/etc/ODB.sql",getenv("METVIEW_DIR_SHARE"));
		sql_funcs = read_request_file(buffer);
		print_all_requests(sql_funcs);
	}

	request *r = sql_funcs;
	XMList f(functions_);
	XMList o(operators_);
	while(r)
	{
		const char *n = get_value(r,"name",0);
		const char *d = get_value(r,"description",0);
		if(n) {
			string z = no_quotes(n);
			help[z] = (d ? no_quotes(d) : "no description available");
			if(EQ(r->name,"function"))
				f.add(z);
			else
				o.add(z);
		}

		r = r->next;
	}

	f.sort();
	o.sort();
}

ODBFunctionsDrawer::~ODBFunctionsDrawer()
{
}

void ODBFunctionsDrawer::doubleClickCB(Widget w,XtPointer)
{
	XMList l(w);
	vector<string> s = l.selection();
	editor_.insert(s[0]);
}

void ODBFunctionsDrawer::browseCB(Widget w,XtPointer)
{
	XMList l(w);
	vector<string> s = l.selection();

	XMLabel h(help_);

	string x = s[0];

	if(help.find(x) != help.end())
		x = help[x];

	map<string,string>& parms = editor_.params();
	if(parms.find(x) != parms.end())
		x = x + " = " + parms[x];

	h.set(x + " - Double-click to insert.");
}


static EditorDrawerMaker<ODBFunctionsDrawer,ODBEditor> maker(9);
