/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file MgQLayoutNode.cc
    \brief Definition of MgQLayoutNode
    \author Graphics Section, ECMWF

    Started: February 2010
*/

#include "MgQLayoutNode.h"

#include "Transformation.h"

using namespace magics;


MgQLayoutNode::MgQLayoutNode(QString name,const Layout &l) : MgQBaseNode(name), layout_(l)
{
}

/*MgQLayoutNode::MgQLayoutNode(const MgQLayoutNode ori&) :
	coordRatioX_(ori.coordRatioX_),
	coordRatioY_(ori.coordRatioY_),
	dimensionX_(ori.dimensionX_),
	dimensionY_(ori.dimensionY_),
	projectedMinX_(ori.projectedMinX_),
	projectedMinY_(ori.projectedMinY_),
	
{	
	coordRatioX_()=;
	float coordRatioY_;
	
	float dimensionX_;	
	float dimensionY_;

	float projectedMinX_;
	float projectedMinY_;
	float projectedMaxX_;
	float projectedMaxY_;

	MgQBaseNode *parentItemInMainScene_;

}*/


QRectF MgQLayoutNode::boundingRect() const
{
	return QRectF(projectedMinX_,projectedMinY_,
			projectedMaxX_-projectedMinX_,
			projectedMaxY_-projectedMinY_);

}

void MgQLayoutNode::mapFromSceneToGeoCoords(QPointF& scenePoint,QPointF& geoPoint) 
{
	const Transformation& transformation = layout_.transformation();

	QPointF ppLocal=mapFromScene(scenePoint);
	PaperPoint ppLayout(ppLocal.x()/coordRatioX_,ppLocal.y()/coordRatioY_);

	GeoPoint gp;
	
	transformation.revert(ppLayout, gp);

	geoPoint.setX(gp.x());
	geoPoint.setY(gp.y());

}

void MgQLayoutNode::mapFromSceneToGeoCoords(QRectF& rect,QList<QPointF>& corners) 
{	
	const Transformation& transformation = layout_.transformation();

	QPointF pp=mapFromScene(rect.topLeft());
	PaperPoint pp_ll(pp.x()/coordRatioX_,pp.y()/coordRatioY_);

	pp=mapFromScene(rect.bottomRight());
	PaperPoint pp_ur(pp.x()/coordRatioX_,pp.y()/coordRatioY_);

	GeoPoint ll, ur;
	
	transformation.revert(pp_ll, ll);
	transformation.revert(pp_ur, ur);

	corners <<  QPointF(ll.x(),ll.y());
	corners <<  QPointF(ur.x(),ur.y());

}
void MgQLayoutNode::addToMainScene()
{
	setParentItem(parentItemInMainScene_);
}

QRectF MgQMagnifierLayoutNode::boundingRect() const
{
	return QRectF();
}

void MgQMagnifierLayoutNode::clearPlotContents()
{	
	foreach(QGraphicsItem *item,childItems())
	{
		delete item;
	}	
}