/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file MgQLayerNode.cc
    \brief Implementation of the MgQLayerNode class.
    \author Graphics Section, ECMWF

    Started: February 2010
*/

#include <QDebug>
#include <QImage>
#include <QPainter>

#include "MgQLayerNode.h"

#include "MgQLayoutNode.h"

using namespace magics;

MgQLayerNode::MgQLayerNode(QString name,const Layer &layer,MgQLayoutNode *layout) : 
	   MgQBaseNode(name), layer_(layer), layout_(layout)
{
	rootNode_=new MgQBaseNode("LayerRootNode");
	rootNode_->setParentItem(this);
	rootNodeIsChild_=true;

	alphaScene_=0;
	//rootNode_->setTransform(layout->sceneTransform());
}

bool MgQLayerNode::layerVisibility() const
{
	return LayerManager::get(name_.toStdString()).visibility();		
}

void MgQLayerNode::setLayerVisibility(bool b)
{	
	LayerManager::get(name_.toStdString()).visibility(b);
	setVisible(b);	
}

float MgQLayerNode::layerAlpha() const
{
	int tr=LayerManager::get(name_.toStdString()).transparency();
	return (100-tr)/100.;
}

void MgQLayerNode::setLayerAlpha(float alpha) 
{
	float oriAlpha=layerAlpha();
	LayerManager::get(name_.toStdString()).transparency((1.-alpha)*100.);

//	if(fabs(alpha-oriAlpha) > 0.05)
//		update();
}

void MgQLayerNode::updateLayer(const MgQLayerNode *node)
{
	if(node->name() != name_)
		return;

	setLayerVisibility(node->layerVisibility());
	setLayerAlpha(node->layerAlpha());
}

void MgQLayerNode::paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
                QWidget *widget)
{
	//Non-trasparent 
	if(layerAlpha() >= 0.99)
	{
		//Normal mode
		if(rootNodeIsChild_ == false)
		{
			addContentsBackToScene();
		}
	}
	//Transparent
	else
	{
		//Normal mode
		if(rootNodeIsChild_)
		{
			addContentsToAlphaScene();
		}

		//
		QRectF layoutRect=layout_->boundingRect();
		QRectF targetRect((layout_->mapToScene( layoutRect).boundingRect()));
		QRectF painterRect=painter->transform().mapRect(layout_->boundingRect());
			
		
		


		float dx=painter->transform().dx();
		float dy=painter->transform().dy();
		float sx=painter->transform().m11();
		float sy=painter->transform().m22();
	
		qDebug() << dx << dy << sx << sy;

		//
		/*if(targetRect.size() != painterRect.size())
		{
			float sx=painterRect.width()/targetRect.width();
			float sy=painterRect.height()/targetRect.height();
		*/	
			

qDebug() <<  "LAYER" << layout_->boundingRect()  <<  painter->transform().mapRect(layout_->boundingRect());

		float r=100.;
		targetRect=QRectF((layout_->mapToScene(layout_->boundingRect()).boundingRect()));
		QRectF sourceRect=targetRect;
		
		alphaDevice_->fill(qRgba(0,0,0,0));

		alphaScene_->render(alphaPainter_,targetRect,sourceRect);

		QRect targetRectInt(targetRect.x(),targetRect.y(),targetRect.width(),targetRect.height());
		painter->setOpacity(layerAlpha());
		painter->drawImage(layout_->boundingRect(),
			      alphaDevice_->copy(targetRectInt));
	}
}		

void MgQLayerNode::addContentsToAlphaScene()
{
	scene()->removeItem(rootNode_);
	rootNode_->setTransform(layout_->sceneTransform());

	if(!alphaScene_)
	{
		alphaScene_=new QGraphicsScene;
		alphaDevice_=new QImage(823,630,QImage::Format_ARGB32);
		alphaPainter_=new QPainter(alphaDevice_);
 	}

	alphaScene_->addItem(rootNode_);
	rootNodeIsChild_=false;
}

void MgQLayerNode::addContentsBackToScene()
{
	if(!alphaScene_)
		return;

	alphaScene_->removeItem(rootNode_);
	rootNode_->setTransform(QTransform());
	rootNode_->setParentItem(this);
	rootNodeIsChild_=true;
}
