.\" zip_source_zip.mdoc \-- create data source from zip file
.\" Copyright (C) 2004, 2005, 2008 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_SOURCE_ZIP 3 "June 4, 2008" NiH
.SH "NAME"
zip_source_zip \- create data source from zip file
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
struct zip_source *
zip_source_zip(struct zip *archive, struct zip *srcarchive); \
"int srcidx" "int flags" "off_t start" "off_t len"
.SH "DESCRIPTION"
The function
zip_source_zip
creates a zip source from a file in a zip archive.
The
\fBsrcarchive\fR
argument is the (open) zip archive containing the source zip file
at index
\fBsrcidx.\fR
\fBlen\fR
bytes from offset
\fBstart\fR
will be used in the zip_source.
If
\fBlen\fR
is 0 or \-1, the rest of the file, starting from
\fBstart,\fR
is used.
If
\fBstart\fR
is zero and
\fBlen\fR
is \-1, the whole file will be copied without decompressing it.
.PP
Supported flags are:
.RS
.TP 23
\fBZIP_FL_UNCHANGED\fR
Try to get the original data without any changes that may have been
made to
\fBsrcarchive\fR
after opening it.
.TP 23
\fBZIP_FL_RECOMPRESS\fR
When adding the data from
\fBsrcarchive,\fR
re-compress it using the current settings instead of copying the
compressed data.
.RE
.SH "RETURN VALUES"
Upon successful completion, the created source is returned.
Otherwise,
\fBNULL\fR
is returned and the error code in
\fBarchive\fR
is set to indicate the error.
.SH "ERRORS"
zip_source_zip
fails if:
.RS
.TP 4
[ZIP_ER_CHANGED]
Unchanged data was requested, but it is not available.
.TP 4
[ZIP_ER_INVAL]
\fBsrcarchive,\fR
\fBsrcidx,\fR
\fBstart,\fR
or
\fBlen\fR
are invalid.
.TP 4
[ZIP_ER_MEMORY]
Required memory could not be allocated.
.RE
Additionally, it can return all error codes from
zip_stat_index
and
zip_fopen_index.
.SH "SEE ALSO"
libzip(3),
zip_add(3),
zip_replace(3),
zip_source_buffer(3),
zip_source_file(3),
zip_source_filep(3),
zip_source_free(3),
zip_source_function(3)
.SH "AUTHORS"

Dieter Baron <dillo@giga.or.at>
and
Thomas Klausner <tk@giga.or.at>
