/**
 * =========================================
 * LibXML : a free Java layouting library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libxml/
 *
 * (C) Copyright 2006-2008, by Object Refinery Ltd, Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * LibXmlInfo.java
 * ------------
 */

package org.pentaho.reporting.libraries.xmlns;

import org.pentaho.reporting.libraries.resourceloader.LibLoaderInfo;
import org.pentaho.reporting.libraries.base.LibBaseInfo;
import org.pentaho.reporting.libraries.base.versioning.ProjectInformation;

/**
 * The LibXmlInfo class contains all dependency information and some
 * common information like version, license and contributors about the
 * library itself.
 *
 * @author Thomas Morgner
 */
public class LibXmlInfo extends ProjectInformation
{
  /**
   * The XML-Namespace is used for the 'id' attribute.
   */
  public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";

  /**
   * The XML-Namespace is used for the 'id' attribute.
   */
  public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";

  private static LibXmlInfo info;

  /**
   * Constructs an empty project info object.
   */
  private LibXmlInfo()
  {
    super("libxml", "LibXML");
  }

  /**
   * Initialized the project info object.
   */
  private void initialize()
  {
    setInfo("http://reporting.pentaho.org/libxml/");
    setCopyright("(C)opyright 2007, by Object Refinery Limited, Pentaho Corporation and Contributors");
    setLicenseName("LGPL");
    
    addLibrary(LibBaseInfo.getInstance());
    addLibrary(LibLoaderInfo.getInstance());

    setBootClass(LibXmlBoot.class.getName());
  }

  /**
   * Returns the singleton instance of the info-class.
   *
   * @return the singleton info.
   */
  public static synchronized ProjectInformation getInstance()
  {
    if (info == null)
    {
      info = new LibXmlInfo();
      info.initialize();
    }
    return info;
  }
}
