//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qcolor_c.h"

QColorH QColor_create()
{
	return (QColorH) new QColor();
}

void QColor_destroy(QColorH handle)
{
	delete (QColor *)handle;
}

QColorH QColor_create2(Qt::GlobalColor color)
{
	return (QColorH) new QColor(color);
}

QColorH QColor_create3(int r, int g, int b, int a)
{
	return (QColorH) new QColor(r, g, b, a);
}

QColorH QColor_create4(QRgb rgb)
{
	return (QColorH) new QColor(rgb);
}

QColorH QColor_create5(PWideString name)
{
	QString t_name;
	copyPWideStringToQString(name, t_name);
	return (QColorH) new QColor(t_name);
}

QColorH QColor_create6(const char* name)
{
	return (QColorH) new QColor(name);
}

QColorH QColor_create7(const QColorH color)
{
	return (QColorH) new QColor(*(const QColor*)color);
}

QColorH QColor_create8(QColor::Spec spec)
{
	return (QColorH) new QColor(spec);
}

bool QColor_isValid(QColorH handle)
{
	return (bool) ((QColor *)handle)->isValid();
}

void QColor_name(QColorH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QColor *)handle)->name();
	copyQStringToPWideString(t_retval, retval);
}

void QColor_setNamedColor(QColorH handle, PWideString name)
{
	QString t_name;
	copyPWideStringToQString(name, t_name);
	((QColor *)handle)->setNamedColor(t_name);
}

void QColor_colorNames(QStringListH retval)
{
	*(QStringList *)retval = QColor::colorNames();
}

QColor::Spec QColor_spec(QColorH handle)
{
	return (QColor::Spec) ((QColor *)handle)->spec();
}

int QColor_alpha(QColorH handle)
{
	return (int) ((QColor *)handle)->alpha();
}

void QColor_setAlpha(QColorH handle, int alpha)
{
	((QColor *)handle)->setAlpha(alpha);
}

qreal QColor_alphaF(QColorH handle)
{
	return (qreal) ((QColor *)handle)->alphaF();
}

void QColor_setAlphaF(QColorH handle, qreal alpha)
{
	((QColor *)handle)->setAlphaF(alpha);
}

int QColor_red(QColorH handle)
{
	return (int) ((QColor *)handle)->red();
}

int QColor_green(QColorH handle)
{
	return (int) ((QColor *)handle)->green();
}

int QColor_blue(QColorH handle)
{
	return (int) ((QColor *)handle)->blue();
}

void QColor_setRed(QColorH handle, int red)
{
	((QColor *)handle)->setRed(red);
}

void QColor_setGreen(QColorH handle, int green)
{
	((QColor *)handle)->setGreen(green);
}

void QColor_setBlue(QColorH handle, int blue)
{
	((QColor *)handle)->setBlue(blue);
}

qreal QColor_redF(QColorH handle)
{
	return (qreal) ((QColor *)handle)->redF();
}

qreal QColor_greenF(QColorH handle)
{
	return (qreal) ((QColor *)handle)->greenF();
}

qreal QColor_blueF(QColorH handle)
{
	return (qreal) ((QColor *)handle)->blueF();
}

void QColor_setRedF(QColorH handle, qreal red)
{
	((QColor *)handle)->setRedF(red);
}

void QColor_setGreenF(QColorH handle, qreal green)
{
	((QColor *)handle)->setGreenF(green);
}

void QColor_setBlueF(QColorH handle, qreal blue)
{
	((QColor *)handle)->setBlueF(blue);
}

void QColor_getRgb(QColorH handle, int* r, int* g, int* b, int* a)
{
	((QColor *)handle)->getRgb(r, g, b, a);
}

void QColor_setRgb(QColorH handle, int r, int g, int b, int a)
{
	((QColor *)handle)->setRgb(r, g, b, a);
}

void QColor_getRgbF(QColorH handle, qreal* r, qreal* g, qreal* b, qreal* a)
{
	((QColor *)handle)->getRgbF(r, g, b, a);
}

void QColor_setRgbF(QColorH handle, qreal r, qreal g, qreal b, qreal a)
{
	((QColor *)handle)->setRgbF(r, g, b, a);
}

QRgb QColor_rgba(QColorH handle)
{
	return (QRgb) ((QColor *)handle)->rgba();
}

void QColor_setRgba(QColorH handle, QRgb rgba)
{
	((QColor *)handle)->setRgba(rgba);
}

QRgb QColor_rgb(QColorH handle)
{
	return (QRgb) ((QColor *)handle)->rgb();
}

void QColor_setRgb2(QColorH handle, QRgb rgb)
{
	((QColor *)handle)->setRgb(rgb);
}

int QColor_hue(QColorH handle)
{
	return (int) ((QColor *)handle)->hue();
}

int QColor_saturation(QColorH handle)
{
	return (int) ((QColor *)handle)->saturation();
}

int QColor_value(QColorH handle)
{
	return (int) ((QColor *)handle)->value();
}

qreal QColor_hueF(QColorH handle)
{
	return (qreal) ((QColor *)handle)->hueF();
}

qreal QColor_saturationF(QColorH handle)
{
	return (qreal) ((QColor *)handle)->saturationF();
}

qreal QColor_valueF(QColorH handle)
{
	return (qreal) ((QColor *)handle)->valueF();
}

void QColor_getHsv(QColorH handle, int* h, int* s, int* v, int* a)
{
	((QColor *)handle)->getHsv(h, s, v, a);
}

void QColor_setHsv(QColorH handle, int h, int s, int v, int a)
{
	((QColor *)handle)->setHsv(h, s, v, a);
}

void QColor_getHsvF(QColorH handle, qreal* h, qreal* s, qreal* v, qreal* a)
{
	((QColor *)handle)->getHsvF(h, s, v, a);
}

void QColor_setHsvF(QColorH handle, qreal h, qreal s, qreal v, qreal a)
{
	((QColor *)handle)->setHsvF(h, s, v, a);
}

int QColor_cyan(QColorH handle)
{
	return (int) ((QColor *)handle)->cyan();
}

int QColor_magenta(QColorH handle)
{
	return (int) ((QColor *)handle)->magenta();
}

int QColor_yellow(QColorH handle)
{
	return (int) ((QColor *)handle)->yellow();
}

int QColor_black(QColorH handle)
{
	return (int) ((QColor *)handle)->black();
}

qreal QColor_cyanF(QColorH handle)
{
	return (qreal) ((QColor *)handle)->cyanF();
}

qreal QColor_magentaF(QColorH handle)
{
	return (qreal) ((QColor *)handle)->magentaF();
}

qreal QColor_yellowF(QColorH handle)
{
	return (qreal) ((QColor *)handle)->yellowF();
}

qreal QColor_blackF(QColorH handle)
{
	return (qreal) ((QColor *)handle)->blackF();
}

void QColor_getCmyk(QColorH handle, int* c, int* m, int* y, int* k, int* a)
{
	((QColor *)handle)->getCmyk(c, m, y, k, a);
}

void QColor_setCmyk(QColorH handle, int c, int m, int y, int k, int a)
{
	((QColor *)handle)->setCmyk(c, m, y, k, a);
}

void QColor_getCmykF(QColorH handle, qreal* c, qreal* m, qreal* y, qreal* k, qreal* a)
{
	((QColor *)handle)->getCmykF(c, m, y, k, a);
}

void QColor_setCmykF(QColorH handle, qreal c, qreal m, qreal y, qreal k, qreal a)
{
	((QColor *)handle)->setCmykF(c, m, y, k, a);
}

void QColor_toRgb(QColorH handle, PQColor retval)
{
	*(QColor *)retval = ((QColor *)handle)->toRgb();
}

void QColor_toHsv(QColorH handle, PQColor retval)
{
	*(QColor *)retval = ((QColor *)handle)->toHsv();
}

void QColor_toCmyk(QColorH handle, PQColor retval)
{
	*(QColor *)retval = ((QColor *)handle)->toCmyk();
}

void QColor_convertTo(QColorH handle, PQColor retval, QColor::Spec colorSpec)
{
	*(QColor *)retval = ((QColor *)handle)->convertTo(colorSpec);
}

void QColor_fromRgb(PQColor retval, QRgb rgb)
{
	*(QColor *)retval = QColor::fromRgb(rgb);
}

void QColor_fromRgba(PQColor retval, QRgb rgba)
{
	*(QColor *)retval = QColor::fromRgba(rgba);
}

void QColor_fromRgb2(PQColor retval, int r, int g, int b, int a)
{
	*(QColor *)retval = QColor::fromRgb(r, g, b, a);
}

void QColor_fromRgbF(PQColor retval, qreal r, qreal g, qreal b, qreal a)
{
	*(QColor *)retval = QColor::fromRgbF(r, g, b, a);
}

void QColor_fromHsv(PQColor retval, int h, int s, int v, int a)
{
	*(QColor *)retval = QColor::fromHsv(h, s, v, a);
}

void QColor_fromHsvF(PQColor retval, qreal h, qreal s, qreal v, qreal a)
{
	*(QColor *)retval = QColor::fromHsvF(h, s, v, a);
}

void QColor_fromCmyk(PQColor retval, int c, int m, int y, int k, int a)
{
	*(QColor *)retval = QColor::fromCmyk(c, m, y, k, a);
}

void QColor_fromCmykF(PQColor retval, qreal c, qreal m, qreal y, qreal k, qreal a)
{
	*(QColor *)retval = QColor::fromCmykF(c, m, y, k, a);
}

void QColor_light(QColorH handle, PQColor retval, int f)
{
	*(QColor *)retval = ((QColor *)handle)->light(f);
}

void QColor_lighter(QColorH handle, PQColor retval, int f)
{
	*(QColor *)retval = ((QColor *)handle)->lighter(f);
}

void QColor_dark(QColorH handle, PQColor retval, int f)
{
	*(QColor *)retval = ((QColor *)handle)->dark(f);
}

void QColor_darker(QColorH handle, PQColor retval, int f)
{
	*(QColor *)retval = ((QColor *)handle)->darker(f);
}

#if defined BINUX
bool QColor_allowX11ColorNames()
{
	return (bool) QColor::allowX11ColorNames();
}

void QColor_setAllowX11ColorNames(bool enabled)
{
	QColor::setAllowX11ColorNames(enabled);
}

#endif
