#include "osl/search/shouldPromoteCut.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::search;

class ShouldPromoteCutTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(ShouldPromoteCutTest);
  CPPUNIT_TEST(testPlayer);
  CPPUNIT_TEST_SUITE_END();
public:
  void testPlayer() {
    const Position p39(3,9);
    const Position p66(6,6);

    // WHITE
    const Move w3966ump(p39,p66,PBISHOP,PTYPE_EMPTY,true,WHITE);
    CPPUNIT_ASSERT(! ShouldPromoteCut::canIgnoreAndNotDrop(w3966ump));

    const Move w3966um(p39,p66,PBISHOP,PTYPE_EMPTY,false,WHITE);
    CPPUNIT_ASSERT(! ShouldPromoteCut::canIgnoreAndNotDrop(w3966um));

    const Move w3966ka(p39,p66,BISHOP,PTYPE_EMPTY,false,WHITE);
    CPPUNIT_ASSERT(ShouldPromoteCut::canIgnoreAndNotDrop(w3966ka));

    // BLACK
    const Move b3966um(p39,p66,PBISHOP,PTYPE_EMPTY,false,BLACK);
    CPPUNIT_ASSERT(! ShouldPromoteCut::canIgnoreAndNotDrop(b3966um));

    const Move b3966ka(p39,p66,BISHOP,PTYPE_EMPTY,false,BLACK);
    CPPUNIT_ASSERT(! ShouldPromoteCut::canIgnoreAndNotDrop(b3966ka));
  }
};

CPPUNIT_TEST_SUITE_REGISTRATION(ShouldPromoteCutTest);

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
