#include "osl/record/miniBoardChar50.h"
#include "osl/record/compactBoard.h"
#include "osl/record/csaRecord.h"
#include "osl/apply_move/applyMove.h"
#include "osl/oslConfig.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class MiniBoardChar50Test : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE( MiniBoardChar50Test );
  CPPUNIT_TEST( testConstruct );
  CPPUNIT_TEST( testFile );
  CPPUNIT_TEST_SUITE_END();
 public:
  void testConstruct();
  void testFile();
};

CPPUNIT_TEST_SUITE_REGISTRATION( MiniBoardChar50Test );

using namespace osl;
using namespace osl::record;
extern bool isShortTest;

void MiniBoardChar50Test::testConstruct()
{
  const SimpleState state(HIRATE);
  MiniBoardChar50 mb(state);
  const SimpleState retb(mb.toSimpleState(BLACK)), retw(mb.toSimpleState(WHITE));
  CPPUNIT_ASSERT(retb.isConsistent());
  CPPUNIT_ASSERT(retw.isConsistent());

  CPPUNIT_ASSERT_EQUAL(CompactBoard(state), CompactBoard(retb));
  CPPUNIT_ASSERT_EQUAL(CompactBoard(state.rotate180()), CompactBoard(retw));
}

void MiniBoardChar50Test::testFile()
{
  std::ifstream ifs(OslConfig::testCsaFile("FILES"));
  CPPUNIT_ASSERT(ifs);
  std::string filename;
  for (int i=0; i<(isShortTest ? 10 : 900) && (ifs >> filename); ++i)
  {
    if ((i % 100) == 0)
      std::cerr << '.';
    if (filename == "") 
      break;
    filename = OslConfig::testCsaFile(filename);

    const Record record=CsaFile(filename).getRecord();
    const vector<osl::Move> moves=record.getMoves();

    SimpleState state(record.getInitialState());
    for (size_t i=0; i<moves.size(); ++i) 
    {
      ApplyMoveOfTurn::doMove(state, moves[i]);
      MiniBoardChar50 mb(state);
      CPPUNIT_ASSERT_EQUAL(state, mb.toSimpleState(state.getTurn()));
    }
  }
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:

