#include "osl/record/ki2.h"
#include "osl/record/kanjiCode.h"
#include "osl/record/csaString.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

#include <iostream>
#include <iterator>

class Ki2Test : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE( Ki2Test );
  CPPUNIT_TEST( testShow );
  CPPUNIT_TEST_SUITE_END();
public:
  void testShow();
};

CPPUNIT_TEST_SUITE_REGISTRATION( Ki2Test );

using namespace osl;
using namespace osl::record;
extern bool isShortTest;

// reference: http://www.shogi.or.jp/faq/kihuhyouki.html

void Ki2Test::testShow()
{
  {
    const NumEffectState state;
    const Move move(Position(7,7), Position(7,6), PAWN, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R7+K_K6+K_PAWN, 
			 record::ki2::show(move, state));
  }
  {
    NumEffectState state(CsaString(
			   "P1 *  *  *  * +TO *  * -OU * \n"
			   "P2 *  * +KI *  *  *  *  *  * \n"
			   "P3+KI *  * +TO *  *  * +OU * \n"
			   "P4 *  *  *  * +TO *  *  *  * \n"
			   "P5 *  *  * +GI *  *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  * +GI *  * +GI *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9 *  *  *  *  *  *  *  *  * \n"
			   "P+00AL\n"
			   "-\n").getInitialState());
    const Move m82u(Position(9,3), Position(8,2), GOLD, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m82y(Position(7,2), Position(8,2), GOLD, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K2+K_GOLD+K_UE, 
			 record::ki2::show(m82u, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K2+K_GOLD+K_YORU, 
			 record::ki2::show(m82y, state));
    const Move m52h(Position(5,1), Position(5,2), PPAWN, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m52u(Position(6,3), Position(5,2), PPAWN, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R5+K_K2+K_PPAWN+K_HIKU, 
			 record::ki2::show(m52h, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R5+K_K2+K_PPAWN+K_UE, 
			 record::ki2::show(m52u, state));
    const Move m53y(Position(6,3), Position(5,3), PPAWN, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m53u(Position(5,4), Position(5,3), PPAWN, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R5+K_K3+K_PPAWN+K_YORU, 
			 record::ki2::show(m53y, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R5+K_K3+K_PPAWN+K_UE, 
			 record::ki2::show(m53u, state));
    const Move m76h(Position(6,5), Position(7,6), SILVER, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m76u(Position(7,7), Position(7,6), SILVER, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R7+K_K6+K_SILVER+K_HIKU, 
			 record::ki2::show(m76h, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R7+K_K6+K_SILVER+K_UE, 
			 record::ki2::show(m76u, state));
    const Move m56h(Position(6,5), Position(5,6), SILVER, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m56u(Position(4,7), Position(5,6), SILVER, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R5+K_K6+K_SILVER+K_HIKU, 
			 record::ki2::show(m56h, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R5+K_K6+K_SILVER+K_UE, 
			 record::ki2::show(m56u, state));
  }
  {
    NumEffectState state(CsaString(
			   "P1 *  *  *  *  *  *  * -OU * \n"
			   "P2+KI * +KI *  *  *  *  *  * \n"
			   "P3 *  *  *  *  *  *  * +OU * \n"
			   "P4 *  *  *  *  *  *  *  *  * \n"
			   "P5 *  *  * +GI * +GI *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  *  *  *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9 * +KI+KI *  *  * +GI+GI * \n"
			   "P+00AL\n"
			   "-\n").getInitialState());
    const Move m81l(Position(9,2), Position(8,1), GOLD, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m81r(Position(7,2), Position(8,1), GOLD, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K1+K_GOLD+K_HIDARI, 
			 record::ki2::show(m81l, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K1+K_GOLD+K_MIGI, 
			 record::ki2::show(m81r, state));
    const Move m82l(Position(9,2), Position(8,2), GOLD, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m82r(Position(7,2), Position(8,2), GOLD, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K2+K_GOLD+K_HIDARI, 
			 record::ki2::show(m82l, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K2+K_GOLD+K_MIGI, 
			 record::ki2::show(m82r, state));
    const Move m56l(Position(6,5), Position(5,6), SILVER, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m56r(Position(4,5), Position(5,6), SILVER, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R5+K_K6+K_SILVER+K_HIDARI, 
			 record::ki2::show(m56l, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R5+K_K6+K_SILVER+K_MIGI, 
			 record::ki2::show(m56r, state));
    const Move m78l(Position(8,9), Position(7,8), GOLD, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m78s(Position(7,9), Position(7,8), GOLD, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R7+K_K8+K_GOLD+K_HIDARI, 
			 record::ki2::show(m78l, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R7+K_K8+K_GOLD+K_SUGU, 
			 record::ki2::show(m78s, state));
    const Move m38s(Position(3,9), Position(3,8), SILVER, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m38r(Position(2,9), Position(3,8), SILVER, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R3+K_K8+K_SILVER+K_SUGU, 
			 record::ki2::show(m38s, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R3+K_K8+K_SILVER+K_MIGI, 
			 record::ki2::show(m38r, state));
  }
  {
    NumEffectState state(CsaString(
			   "P1 *  *  *  *  *  *  * -OU * \n"
			   "P2 *  *  *  *  *  *  *  *  * \n"
			   "P3 *  *  * +KI+KI+KI * +OU * \n"
			   "P4 *  *  *  *  *  *  *  *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 * +TO *  *  *  * +GI * +GI\n"
			   "P8+TO *  *  *  *  *  *  *  * \n"
			   "P9+TO+TO+TO *  *  * +GI+GI * \n"
			   "P+00AL\n"
			   "-\n").getInitialState());
    const Move m52l(Position(6,3), Position(5,2), GOLD, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m52s(Position(5,3), Position(5,2), GOLD, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m52r(Position(4,3), Position(5,2), GOLD, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R5+K_K2+K_GOLD+K_HIDARI, 
			 record::ki2::show(m52l, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R5+K_K2+K_GOLD+K_SUGU, 
			 record::ki2::show(m52s, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R5+K_K2+K_GOLD+K_MIGI, 
			 record::ki2::show(m52r, state));
    const Move m88r(Position(7,9), Position(8,8), PPAWN, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m88s(Position(8,9), Position(8,8), PPAWN, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m88y(Position(9,8), Position(8,8), PPAWN, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m88h(Position(8,7), Position(8,8), PPAWN, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m88lu(Position(9,9), Position(8,8), PPAWN, 
		     PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K8+K_PPAWN+K_MIGI, 
			 record::ki2::show(m88r, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K8+K_PPAWN+K_SUGU, 
			 record::ki2::show(m88s, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K8+K_PPAWN+K_YORU, 
			 record::ki2::show(m88y, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K8+K_PPAWN+K_HIKU, 
			 record::ki2::show(m88h, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K8+K_PPAWN+K_HIDARI+K_UE, 
			 record::ki2::show(m88lu, state));
    const Move m28s(Position(2,9), Position(2,8), SILVER, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m28r(Position(1,7), Position(2,8), SILVER, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m28lu(Position(3,9), Position(2,8), SILVER, 
		     PTYPE_EMPTY, false, BLACK);
    const Move m28lh(Position(3,7), Position(2,8), SILVER, 
		     PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R2+K_K8+K_SILVER+K_SUGU, 
			 record::ki2::show(m28s, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R2+K_K8+K_SILVER+K_MIGI, 
			 record::ki2::show(m28r, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R2+K_K8+K_SILVER+K_HIDARI+K_UE, 
			 record::ki2::show(m28lu, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R2+K_K8+K_SILVER+K_HIDARI+K_HIKU, 
			 record::ki2::show(m28lh, state));
  }
  {
    NumEffectState state(CsaString(
			   "P1+RY *  *  *  *  *  *  *  * \n"
			   "P2 *  *  *  *  *  * -OU *  * \n"
			   "P3 *  *  *  *  *  *  *  *  * \n"
			   "P4 * +RY *  *  *  * +OU *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  *  *  *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9 *  *  *  *  *  *  *  *  * \n"
			   "P+00AL\n"
			   "-\n").getInitialState());
    const Move m82h(Position(9,1), Position(8,2), PROOK, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m82u(Position(8,4), Position(8,2), PROOK, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K2+K_PROOK+K_HIKU, 
			 record::ki2::show(m82h, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K2+K_PROOK+K_UE, 
			 record::ki2::show(m82u, state));
  }
  {
    NumEffectState state(CsaString(
			   "P1 *  *  *  *  *  *  *  *  * \n"
			   "P2 *  *  *  * +RY *  *  *  * \n"
			   "P3 *  *  *  *  *  *  * +RY * \n"
			   "P4 *  *  *  *  *  * +OU *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  *  *  *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9 *  *  *  *  *  * -OU *  * \n"
			   "P+00AL\n"
			   "-\n").getInitialState());
    const Move m43y(Position(2,3), Position(4,3), PROOK, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m43h(Position(5,2), Position(4,3), PROOK, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R4+K_K3+K_PROOK+K_YORU, 
			 record::ki2::show(m43y, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R4+K_K3+K_PROOK+K_HIKU, 
			 record::ki2::show(m43h, state));
  }
  {
    NumEffectState state(CsaString(
			   "P1 *  *  *  *  *  *  *  *  * \n"
			   "P2 *  *  *  *  *  *  *  *  * \n"
			   "P3 *  *  *  * +RY *  * +RY * \n"
			   "P4 *  *  *  *  *  * +OU *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  *  *  *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9 *  *  *  *  *  * -OU *  * \n"
			   "P+00AL\n"
			   "-\n").getInitialState());
    const Move m43r(Position(2,3), Position(4,3), PROOK, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m43l(Position(5,3), Position(4,3), PROOK, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R4+K_K3+K_PROOK+K_MIGI, 
			 record::ki2::show(m43r, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R4+K_K3+K_PROOK+K_HIDARI, 
			 record::ki2::show(m43l, state));
  }
  {
    NumEffectState state(CsaString(
			   "P1 *  *  *  *  *  *  *  *  * \n"
			   "P2 *  *  *  *  *  *  *  *  * \n"
			   "P3 *  *  *  *  *  *  *  *  * \n"
			   "P4 *  *  *  *  *  * +OU *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  *  *  *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9+RY+RY *  *  *  * -OU *  * \n"
			   "P+00AL\n"
			   "-\n").getInitialState());
    const Move m88l(Position(9,9), Position(8,8), PROOK, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m88r(Position(8,9), Position(8,8), PROOK, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K8+K_PROOK+K_HIDARI, 
			 record::ki2::show(m88l, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K8+K_PROOK+K_MIGI, 
			 record::ki2::show(m88r, state));
  }
  {
    NumEffectState state(CsaString(
			   "P1+UM+UM *  *  *  *  *  *  * \n"
			   "P2 *  *  *  *  *  *  *  *  * \n"
			   "P3 *  *  *  *  *  *  *  *  * \n"
			   "P4 *  *  *  *  *  * +OU *  * \n"
			   "P5 *  *  *  * -OU *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  *  *  *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  * +RY * \n"
			   "P9 *  *  *  *  *  *  *  * +RY\n"
			   "P+00AL\n"
			   "-\n").getInitialState());
    const Move m17l(Position(2,8), Position(1,7), PROOK, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m17r(Position(1,9), Position(1,7), PROOK, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R1+K_K7+K_PROOK+K_HIDARI, 
			 record::ki2::show(m17l, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R1+K_K7+K_PROOK+K_MIGI, 
			 record::ki2::show(m17r, state));
    const Move m82l(Position(9,1), Position(8,2), PBISHOP, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m82r(Position(8,1), Position(8,2), PBISHOP, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K2+K_PBISHOP+K_HIDARI, 
			 record::ki2::show(m82l, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K2+K_PBISHOP+K_MIGI, 
			 record::ki2::show(m82r, state));
  }
  {
    NumEffectState state(CsaString(
			   "P1 *  *  *  *  *  *  *  *  * \n"
			   "P2 *  *  *  *  *  *  *  *  * \n"
			   "P3 *  *  * +UM *  *  *  *  * \n"
			   "P4 *  *  *  *  *  * +OU *  * \n"
			   "P5+UM *  *  * -OU *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  *  *  *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9 *  *  *  *  *  *  *  *  * \n"
			   "P+00AL\n"
			   "-\n").getInitialState());
    const Move m85y(Position(9,5), Position(8,5), PBISHOP, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m85h(Position(6,3), Position(8,5), PBISHOP, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K5+K_PBISHOP+K_YORU, 
			 record::ki2::show(m85y, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R8+K_K5+K_PBISHOP+K_HIKU, 
			 record::ki2::show(m85h, state));
  }
  {
    NumEffectState state(CsaString(
			   "P1 *  *  *  *  *  *  *  * +UM\n"
			   "P2 *  *  *  *  *  *  *  *  * \n"
			   "P3 *  *  *  *  *  *  *  *  * \n"
			   "P4 *  *  *  *  *  * +UM *  * \n"
			   "P5+OU *  *  * -OU *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  *  *  *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9 *  *  *  *  *  *  *  *  * \n"
			   "P+00AL\n"
			   "-\n").getInitialState());
    const Move m12h(Position(1,1), Position(1,2), PBISHOP, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m12u(Position(3,4), Position(1,2), PBISHOP, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R1+K_K2+K_PBISHOP+K_HIKU, 
			 record::ki2::show(m12h, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R1+K_K2+K_PBISHOP+K_UE, 
			 record::ki2::show(m12u, state));
  }
  {
    NumEffectState state(CsaString(
			   "P1 *  *  *  *  *  *  *  *  * \n"
			   "P2 *  *  *  *  *  *  *  *  * \n"
			   "P3 *  *  *  *  *  *  *  *  * \n"
			   "P4 *  *  *  *  *  *  *  *  * \n"
			   "P5+OU *  *  * -OU *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  *  *  *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9+UM *  *  * +UM *  *  *  * \n"
			   "P+00AL\n"
			   "-\n").getInitialState());
    const Move m77l(Position(9,9), Position(7,7), PBISHOP, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m77r(Position(5,9), Position(7,7), PBISHOP, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R7+K_K7+K_PBISHOP+K_HIDARI, 
			 record::ki2::show(m77l, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R7+K_K7+K_PBISHOP+K_MIGI, 
			 record::ki2::show(m77r, state));
  }
  {
    NumEffectState state(CsaString(
			   "P1 *  *  *  *  *  *  *  *  * \n"
			   "P2 *  *  *  *  *  *  *  *  * \n"
			   "P3 *  *  *  *  *  *  *  *  * \n"
			   "P4 *  *  *  *  *  *  *  *  * \n"
			   "P5+OU *  *  * -OU *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  *  *  *  * +UM *  *  * \n"
			   "P8 *  *  *  *  *  *  *  * +UM\n"
			   "P9 *  *  *  *  *  *  *  *  * \n"
			   "P+00AL\n"
			   "-\n").getInitialState());
    const Move m29l(Position(4,7), Position(2,9), PBISHOP, 
		    PTYPE_EMPTY, false, BLACK);
    const Move m29r(Position(1,8), Position(2,9), PBISHOP, 
		    PTYPE_EMPTY, false, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R2+K_K9+K_PBISHOP+K_HIDARI, 
			 record::ki2::show(m29l, state));
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R2+K_K9+K_PBISHOP+K_MIGI, 
			 record::ki2::show(m29r, state));
  }
  {
    NumEffectState state(CsaString(
			   "P1 *  *  *  * -OU *  *  *  * \n"
			   "P2 *  *  *  *  *  * +NK *  * \n"
			   "P3 *  *  *  *  *  *  *  *  * \n"
			   "P4 *  *  *  *  *  *  *  *  * \n"
			   "P5 *  *  *  *  *  *  *  *  * \n"
			   "P6 *  *  *  *  *  *  *  *  * \n"
			   "P7 *  *  *  *  *  *  *  *  * \n"
			   "P8 *  *  *  *  *  *  *  *  * \n"
			   "P9 *  *  *  * +OU *  *  *  * \n"
			   "P+00AL\n"
			   "-\n").getInitialState());
    const Move m33ke(Position(3,3), KNIGHT, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R3+K_K3+K_KNIGHT, 
			 record::ki2::show(m33ke, state));
  }
  {
    NumEffectState state(CsaString(
			   "P1+NK * +HI *  *  * -KI-OU-KY\n"
			   "P2 * +FU *  *  *  * -KI-GI * \n"
			   "P3-FU * -GI+UM-FU-FU *  * -FU\n"
			   "P4 *  *  *  *  *  *  *  *  * \n"
			   "P5 *  *  * -KE * -KE *  *  * \n"
			   "P6 *  *  *  * +FU *  *  *  * \n"
			   "P7+FU * +KI+FU * +FU+FU+FU+FU\n"
			   "P8 *  *  *  * +OU+KI * +GI * \n"
			   "P9+KY-HI+GI *  *  *  * +KE+KY\n"
			   "P+00KA00KY00FU00FU\n"
			   "P-00FU00FU00FU00FU\n"
			   "-\n").getInitialState());
    const Move m57kn(Position(4,5), Position(5,7), 
		     PKNIGHT, PTYPE_EMPTY, true, WHITE);
    CPPUNIT_ASSERT_EQUAL(K_WHITE_SIGN+K_R5+K_K7+K_KNIGHT+K_HIDARI+K_NARU, 
			 record::ki2::show(m57kn, state));
  }
  {
    NumEffectState state(CsaString(
			   "P1-KY-KE *  *  *  *  *  * -KY\n"
			   "P2 * -HI *  *  * -KI-OU *  * \n"
			   "P3-FU *  * +TO+FU-KI *  *  * \n"
			   "P4 *  * -FU * -FU-GI * -FU-FU\n"
			   "P5 * -FU *  * -GI-KE-FU *  * \n"
			   "P6 *  * +FU *  * -FU *  * +FU\n"
			   "P7+FU+FU+KE *  *  * +FU+FU * \n"
			   "P8 *  * +KI * +GI * +KI+OU * \n"
			   "P9+KY *  *  * +HI *  * +KE+KY\n"
			   "P+00KA00KA00FU\n"
			   "P-00GI00FU\n"
			   "+\n").getInitialState());
    const Move m52funari(Position(5,3), Position(5,2), 
		     PPAWN, PTYPE_EMPTY, true, BLACK);
    CPPUNIT_ASSERT_EQUAL(K_BLACK_SIGN+K_R5+K_K2+K_PAWN+K_NARU, 
			 record::ki2::show(m52funari, state));
  }
}


/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
