#include "osl/record/kanjiPrint.h"
#include "osl/record/csaString.h"
#include "osl/state/simpleState.h"
#include "boost/shared_ptr.hpp"
#include <iostream>

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class KanjiPrintTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(KanjiPrintTest);
  CPPUNIT_TEST(testShow);
  CPPUNIT_TEST(testShowVKanji);
  CPPUNIT_TEST(testShowVKanjiColor);
  CPPUNIT_TEST(testColor);
  CPPUNIT_TEST_SUITE_END();
 public:
  void testShow();
  void testShowVKanji();
  void testShowVKanjiColor();
  void testColor();
};

CPPUNIT_TEST_SUITE_REGISTRATION(KanjiPrintTest);

using namespace osl;
using namespace osl::record;
extern bool isShortTest;

void KanjiPrintTest::testShow(){
  SimpleState state=CsaString(
"P1+NY+TO *  *  *  * -OU-KE-KY\n"
"P2 *  *  *  *  * -GI-KI *  *\n"
"P3 * +RY *  * +UM * -KI-FU-FU\n"
"P4 *  * +FU-FU *  *  *  *  *\n"
"P5 *  * -KE * +FU *  * +FU *\n"
"P6-KE *  * +FU+GI-FU *  * +FU\n"
"P7 *  * -UM *  *  *  *  *  *\n"
"P8 *  *  *  *  *  *  *  *  * \n"
"P9 * +OU * -GI *  *  *  * -NG\n"
"P+00HI00KI00KE00KY00FU00FU00FU00FU00FU00FU\n"
"P-00KI00KY00FU00FU\n"
"P-00AL\n"
"+\n").getInitialState();

  KanjiPrint printer(std::cerr);
  if (! isShortTest)
    printer.print(state);
  SimpleState state1(HIRATE);
  if (! isShortTest)
    printer.print(state1);
}

void KanjiPrintTest::testShowVKanji(){
  SimpleState state=CsaString(
"P1+NY+TO *  *  *  * -OU-KE-KY\n"
"P2 *  *  *  *  * -GI-KI *  *\n"
"P3 * +RY *  * +UM * -KI-FU-FU\n"
"P4 *  * +FU-FU *  *  *  *  *\n"
"P5 *  * -KE * +FU *  * +FU *\n"
"P6-KE *  * +FU+GI-FU *  * +FU\n"
"P7 *  * -UM *  *  *  *  *  *\n"
"P8 *  *  *  *  *  *  *  *  * \n"
"P9 * +OU * -GI *  *  *  * -NG\n"
"P+00HI00KI00KE00KY00FU00FU00FU00FU00FU00FU\n"
"P-00KI00KY00FU00FU\n"
"P-00AL\n"
"+\n").getInitialState();

  KanjiPrint printer(std::cerr, 
                     boost::shared_ptr<KIFCharacters>(new KIFCharacters()));
  if (! isShortTest)
    printer.print(state);
  SimpleState state1(HIRATE);
  if (! isShortTest)
    printer.print(state1);
}

void KanjiPrintTest::testShowVKanjiColor(){
  SimpleState state=CsaString(
"P1+NY+TO *  *  *  * -OU-KE-KY\n"
"P2 *  *  *  *  * -GI-KI *  *\n"
"P3 * +RY *  * +UM * -KI-FU-FU\n"
"P4 *  * +FU-FU *  *  *  *  *\n"
"P5 *  * -KE * +FU *  * +FU *\n"
"P6-KE *  * +FU+GI-FU *  * +FU\n"
"P7 *  * -UM *  *  *  *  *  *\n"
"P8 *  *  *  *  *  *  *  *  * \n"
"P9 * +OU * -GI *  *  *  * -NG\n"
"P+00HI00KI00KE00KY00FU00FU00FU00FU00FU00FU\n"
"P-00KI00KY00FU00FU\n"
"P-00AL\n"
"+\n").getInitialState();

  KanjiPrint printer(std::cerr, 
                     boost::shared_ptr<KIFCharacters>(new KIFCharacters()));
  printer.setBlackColor(Color::Yellow);
  printer.setWhiteColor(Color::Blue);
  printer.setLastMoveColor(Color::Red);
  if (! isShortTest)
    printer.print(state);
  SimpleState state1(HIRATE);
  if (! isShortTest)
    printer.print(state1);
}

void KanjiPrintTest::testColor(){
    CPPUNIT_ASSERT_EQUAL(Color::NONE, Color::colorFor("None"));
    CPPUNIT_ASSERT_EQUAL(Color::Black, Color::colorFor("Black"));
    CPPUNIT_ASSERT_EQUAL(Color::Red, Color::colorFor("Red"));
    CPPUNIT_ASSERT_EQUAL(Color::Green, Color::colorFor("Green"));
    CPPUNIT_ASSERT_EQUAL(Color::Brown, Color::colorFor("Brown"));
    CPPUNIT_ASSERT_EQUAL(Color::Blue, Color::colorFor("Blue"));
    CPPUNIT_ASSERT_EQUAL(Color::Purple, Color::colorFor("Purple"));
    CPPUNIT_ASSERT_EQUAL(Color::Cyan, Color::colorFor("Cyan"));
    CPPUNIT_ASSERT_EQUAL(Color::LightGray, Color::colorFor("LightGray"));
    CPPUNIT_ASSERT_EQUAL(Color::DarkGray, Color::colorFor("DarkGray"));
    CPPUNIT_ASSERT_EQUAL(Color::LightRed, Color::colorFor("LightRed"));
    CPPUNIT_ASSERT_EQUAL(Color::LightGreen, Color::colorFor("LightGreen"));
    CPPUNIT_ASSERT_EQUAL(Color::Yellow, Color::colorFor("Yellow"));
    CPPUNIT_ASSERT_EQUAL(Color::LightBlue, Color::colorFor("LIghtBlue"));
    CPPUNIT_ASSERT_EQUAL(Color::LightPurple, Color::colorFor("LightPurple"));
    CPPUNIT_ASSERT_EQUAL(Color::LightCyan, Color::colorFor("LightCyan"));
    CPPUNIT_ASSERT_EQUAL(Color::White, Color::colorFor("White"));

    CPPUNIT_ASSERT_EQUAL(Color::Blue, Color::colorFor("BLUE"));
    CPPUNIT_ASSERT_EQUAL(Color::Blue, Color::colorFor("blue"));
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
