#include "osl/ptypeList.h"
#include "osl/ptypeList.tcc"
#include "osl/misc/loki.h"
#include <iostream>
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;

class ptypeListTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE( ptypeListTest );
  CPPUNIT_TEST( testShow );
  CPPUNIT_TEST( testFilter );
  CPPUNIT_TEST_SUITE_END();
 public:
  void testShow();
  void testFilter();
};


CPPUNIT_TEST_SUITE_REGISTRATION(ptypeListTest);

using namespace osl::ptl;

typedef Filter<PtypeListAll,CheckHasMoveMask<DirectionTraits<U>::mask> >::Result PtypeListHasShortUpMove;

void ptypeListTest::testShow(){
  extern bool isShortTest;
  if(!isShortTest){
    {
      PtypeListAll::show(std::cout); 
      std::cout << std::endl;
    }
    {
      PtypeListIsBasic::show(std::cout);
      std::cout << std::endl;
    }
    {
      PtypeListHasShortUpMove::show(std::cout);
      std::cout << std::endl;
    }
#if 0
    {
      typedef PtypeList<PAWN,int> ptype_list_t;
      // compile error
      std::cout << sizeof(ptype_list_t) << std::endl;
    }
#endif
  }
}
template<int b>
bool retBool(Int2Type<b>){
  return b;
}

void ptypeListTest::testFilter(){
#if 0
  CPPUNIT_ASSERT_EQUAL(false,(IsMember<PtypeListHasShortUpMove,PTYPE_EMPTY>::value));
  CPPUNIT_ASSERT_EQUAL(false,(IsMember<PtypeListHasShortUpMove,PTYPE_EDGE>::value));
  CPPUNIT_ASSERT_EQUAL(true,(IsMember<PtypeListHasShortUpMove,PAWN>::value));
  CPPUNIT_ASSERT_EQUAL(true,(IsMember<PtypeListHasShortUpMove,PPAWN>::value));
  CPPUNIT_ASSERT_EQUAL(false,(IsMember<PtypeListHasShortUpMove,LANCE>::value));
  CPPUNIT_ASSERT_EQUAL(true,(IsMember<PtypeListHasShortUpMove,PLANCE>::value));
  CPPUNIT_ASSERT_EQUAL(false,(IsMember<PtypeListHasShortUpMove,KNIGHT>::value));
  CPPUNIT_ASSERT_EQUAL(true,(IsMember<PtypeListHasShortUpMove,PKNIGHT>::value));
  CPPUNIT_ASSERT_EQUAL(true,(IsMember<PtypeListHasShortUpMove,SILVER>::value));
  CPPUNIT_ASSERT_EQUAL(true,(IsMember<PtypeListHasShortUpMove,PSILVER>::value));
  CPPUNIT_ASSERT_EQUAL(true,(IsMember<PtypeListHasShortUpMove,GOLD>::value));
  CPPUNIT_ASSERT_EQUAL(false,(IsMember<PtypeListHasShortUpMove,BISHOP>::value));
  CPPUNIT_ASSERT_EQUAL(true,(IsMember<PtypeListHasShortUpMove,PBISHOP>::value));
  CPPUNIT_ASSERT_EQUAL(false,(IsMember<PtypeListHasShortUpMove,ROOK>::value));
  CPPUNIT_ASSERT_EQUAL(false,(IsMember<PtypeListHasShortUpMove,PROOK>::value));
  CPPUNIT_ASSERT_EQUAL(true,(IsMember<PtypeListHasShortUpMove,KING>::value));
#else
  CPPUNIT_ASSERT_EQUAL(false,retBool(Int2Type<IsMember<PtypeListHasShortUpMove,PTYPE_EMPTY>::value>()));
  CPPUNIT_ASSERT_EQUAL(false,(retBool(Int2Type<IsMember<PtypeListHasShortUpMove,PTYPE_EDGE>::value>())));
  CPPUNIT_ASSERT_EQUAL(true,(retBool(Int2Type<IsMember<PtypeListHasShortUpMove,PAWN>::value>())));
  CPPUNIT_ASSERT_EQUAL(true,(retBool(Int2Type<IsMember<PtypeListHasShortUpMove,PPAWN>::value>())));
  CPPUNIT_ASSERT_EQUAL(false,(retBool(Int2Type<IsMember<PtypeListHasShortUpMove,LANCE>::value>())));
  CPPUNIT_ASSERT_EQUAL(true,(retBool(Int2Type<IsMember<PtypeListHasShortUpMove,PLANCE>::value>())));
  CPPUNIT_ASSERT_EQUAL(false,(retBool(Int2Type<IsMember<PtypeListHasShortUpMove,KNIGHT>::value>())));
  CPPUNIT_ASSERT_EQUAL(true,(retBool(Int2Type<IsMember<PtypeListHasShortUpMove,PKNIGHT>::value>())));
  CPPUNIT_ASSERT_EQUAL(true,(retBool(Int2Type<IsMember<PtypeListHasShortUpMove,SILVER>::value>())));
  CPPUNIT_ASSERT_EQUAL(true,(retBool(Int2Type<IsMember<PtypeListHasShortUpMove,PSILVER>::value>())));
  CPPUNIT_ASSERT_EQUAL(true,(retBool(Int2Type<IsMember<PtypeListHasShortUpMove,GOLD>::value>())));
  CPPUNIT_ASSERT_EQUAL(false,(retBool(Int2Type<IsMember<PtypeListHasShortUpMove,BISHOP>::value>())));
  CPPUNIT_ASSERT_EQUAL(true,(retBool(Int2Type<IsMember<PtypeListHasShortUpMove,PBISHOP>::value>())));
  CPPUNIT_ASSERT_EQUAL(false,(retBool(Int2Type<IsMember<PtypeListHasShortUpMove,ROOK>::value>())));
  CPPUNIT_ASSERT_EQUAL(false,(retBool(Int2Type<IsMember<PtypeListHasShortUpMove,PROOK>::value>())));
  CPPUNIT_ASSERT_EQUAL(true,(retBool(Int2Type<IsMember<PtypeListHasShortUpMove,KING>::value>())));
#endif
}
